/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.IntPtr;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptoConfig;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X500DistinguishedName;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509BasicConstraintsExtension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2Collection;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509ChainElement;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509ChainElementCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509ChainPolicy;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509ChainStatus;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Extension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509KeyUsageExtension;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Store;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509SubjectKeyIdentifierExtension;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.a;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.j;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public class X509Chain {
    private int b;
    private X509ChainElementCollection c;
    private X509ChainPolicy d;
    private X509ChainStatus[] e;
    static X509ChainStatus[] a = (X509ChainStatus[])Array.unboxing(Array.createInstance(Operators.typeOf(X509ChainStatus.class), 0));
    private int f;
    private X500DistinguishedName g;
    private AsymmetricAlgorithm h;
    private X509ChainElement i;
    private X509Certificate2Collection j;
    private X509Certificate2Collection k;
    private X509Store l;
    private X509Store m;
    private X509Store n;
    private X509Store o;
    private X509Certificate2Collection p;
    private static final StringSwitchMap q = new StringSwitchMap("2.5.29.15", "2.5.29.19", "2.5.29.20", "2.5.29.35", "2.5.29.21");

    public X509Chain() {
        this(false);
    }

    public X509Chain(boolean useMachineContext) {
        this.b = useMachineContext ? 2 : 1;
        this.c = new X509ChainElementCollection();
        this.d = new X509ChainPolicy();
    }

    public X509Chain(IntPtr chainContext) {
        throw new NotSupportedException();
    }

    public IntPtr getChainContext() {
        return IntPtr.Zero;
    }

    public X509ChainElementCollection getChainElements() {
        return this.c;
    }

    public X509ChainPolicy getChainPolicy() {
        return this.d;
    }

    public void setChainPolicy(X509ChainPolicy value) {
        this.d = value;
    }

    public X509ChainStatus[] getChainStatus() {
        if (this.e == null) {
            return a;
        }
        return this.e;
    }

    public boolean build(X509Certificate2 certificate) {
        int n2;
        if (certificate == null) {
            throw new ArgumentException("certificate");
        }
        this.reset();
        try {
            n2 = this.b(certificate);
            this.a(n2);
        }
        catch (CryptographicException cryptographicException) {
            throw new ArgumentException("certificate", cryptographicException);
        }
        int n3 = 0;
        ArrayList arrayList = new ArrayList();
        for (X509ChainStatus[] x509ChainStatusArray : this.c) {
            X509ChainStatus[] x509ChainStatusArray2 = x509ChainStatusArray.getChainElementStatus();
            int n4 = x509ChainStatusArray2.length;
            for (int i2 = 0; i2 < n4; ++i2) {
                X509ChainStatus x509ChainStatus = x509ChainStatusArray2[i2];
                if ((n3 & x509ChainStatus.getStatus()) == x509ChainStatus.getStatus()) continue;
                arrayList.addItem(Operators.boxing(x509ChainStatus));
                n3 |= x509ChainStatus.getStatus();
            }
        }
        if (n2 != 0) {
            arrayList.insertItem(0, Operators.boxing(new X509ChainStatus(n2)));
        }
        this.e = Operators.cast(arrayList.toArray(Operators.typeOf(X509ChainStatus.class)), X509ChainStatus[].class);
        if (this.e.length == 0 || this.getChainPolicy().getVerificationFlags() == 4095) {
            return true;
        }
        boolean bl2 = true;
        for (X509ChainStatus x509ChainStatus : this.e) {
            switch (x509ChainStatus.getStatus()) {
                case 32: 
                case 65536: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 0x10) != 0;
                    break;
                }
                case 1: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 1) != 0;
                    break;
                }
                case 2: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 4) != 0;
                    break;
                }
                case 1024: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 8) != 0;
                    break;
                }
                case 512: 
                case 0x2000000: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 0x80) != 0;
                    break;
                }
                case 2048: 
                case 4096: 
                case 16384: 
                case 32768: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 0x40) != 0;
                    break;
                }
                case 256: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 0x20) != 0;
                    break;
                }
                case 131072: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 2) != 0;
                    break;
                }
                case 262144: {
                    break;
                }
                case 524288: {
                    bl2 &= (this.getChainPolicy().getVerificationFlags() & 0x20) != 0;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        if (this.e != null && this.e.length != 0) {
            this.e = null;
        }
        if (this.c.size() > 0) {
            this.c.clear();
        }
        if (this.n != null) {
            this.n.close();
            this.n = null;
        }
        if (this.l != null) {
            this.l.close();
            this.l = null;
        }
        if (this.o != null) {
            this.o.close();
            this.o = null;
        }
        if (this.m != null) {
            this.m.close();
            this.m = null;
        }
        this.j = null;
        this.k = null;
        this.p = null;
        this.i = null;
        this.h = null;
    }

    public static X509Chain create() {
        return (X509Chain)CryptoConfig.createFromName("X509Chain");
    }

    private X509Certificate2Collection a() {
        if (this.j == null) {
            X509Certificate2Collection x509Certificate2Collection = new X509Certificate2Collection();
            X509Store x509Store = this.c();
            if (this.b == 1) {
                x509Certificate2Collection.addRange(this.d().getCertificates());
            }
            x509Certificate2Collection.addRange(x509Store.getCertificates());
            this.j = x509Certificate2Collection;
        }
        return this.j;
    }

    private X509Certificate2Collection b() {
        if (this.k == null) {
            X509Certificate2Collection x509Certificate2Collection = new X509Certificate2Collection();
            X509Store x509Store = this.e();
            if (this.b == 1) {
                x509Certificate2Collection.addRange(this.f().getCertificates());
            }
            x509Certificate2Collection.addRange(x509Store.getCertificates());
            this.k = x509Certificate2Collection;
        }
        return this.k;
    }

    private X509Store c() {
        if (this.l == null) {
            this.l = new X509Store(6, 2);
            try {
                this.l.open(4);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.l;
    }

    private X509Store d() {
        if (this.n == null) {
            this.n = new X509Store(6, 1);
            try {
                this.n.open(4);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.n;
    }

    private X509Store e() {
        if (this.m == null) {
            this.m = new X509Store(3, 2);
            try {
                this.m.open(4);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.m;
    }

    private X509Store f() {
        if (this.o == null) {
            this.o = new X509Store(3, 1);
            try {
                this.o.open(4);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.o;
    }

    private X509Certificate2Collection g() {
        if (this.p == null) {
            this.p = new X509Certificate2Collection(this.getChainPolicy().getExtraStore());
            this.p.addRange(this.a());
            this.p.addRange(this.b());
        }
        return this.p;
    }

    private int b(X509Certificate2 x509Certificate2) {
        this.c.add(x509Certificate2);
        while (!this.d(x509Certificate2)) {
            if ((x509Certificate2 = this.c(x509Certificate2)) == null) {
                return 65536;
            }
            if (this.c.contains(x509Certificate2)) {
                return 128;
            }
            this.c.add(x509Certificate2);
        }
        if (!this.a().contains(x509Certificate2)) {
            this.c.get_Item(this.c.size() - 1).setStatusFlags(this.c.get_Item(this.c.size() - 1).getStatusFlags() | 0x20);
        }
        return 0;
    }

    private X509Certificate2 a(X509Certificate2 x509Certificate2, X509Certificate2Collection x509Certificate2Collection) {
        switch (x509Certificate2Collection.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return x509Certificate2Collection.get_Item(0);
            }
        }
        X509Certificate2Collection x509Certificate2Collection2 = x509Certificate2Collection.find(6, Operators.boxing(this.getChainPolicy().getVerificationTime()), false);
        switch (x509Certificate2Collection2.size()) {
            case 0: {
                x509Certificate2Collection2 = x509Certificate2Collection;
                break;
            }
            case 1: {
                return x509Certificate2Collection2.get_Item(0);
            }
        }
        String string = X509Chain.a(x509Certificate2);
        if (StringExtensions.isNullOrEmpty(string)) {
            return x509Certificate2Collection2.get_Item(0);
        }
        for (X509Certificate2 x509Certificate22 : x509Certificate2Collection2) {
            String string2 = this.f(x509Certificate22);
            if (!StringExtensions.equals(string, string2)) continue;
            return x509Certificate22;
        }
        return x509Certificate2Collection2.get_Item(0);
    }

    private X509Certificate2 c(X509Certificate2 x509Certificate2) {
        X509Certificate2 x509Certificate22;
        X509Certificate2Collection x509Certificate2Collection = this.g().find(2, x509Certificate2.getIssuer(), false);
        String string = X509Chain.a(x509Certificate2);
        if (string != null && string.length() > 0) {
            x509Certificate2Collection.addRange(this.g().find(14, string, false));
        }
        return x509Certificate2.equals(x509Certificate22 = this.a(x509Certificate2, x509Certificate2Collection)) ? null : x509Certificate22;
    }

    private boolean d(X509Certificate2 x509Certificate2) {
        if (!this.e(x509Certificate2)) {
            return false;
        }
        if (x509Certificate2.getVersion() < 3) {
            return true;
        }
        String string = this.f(x509Certificate2);
        if (StringExtensions.isNullOrEmpty(string)) {
            return true;
        }
        String string2 = X509Chain.a(x509Certificate2);
        if (StringExtensions.isNullOrEmpty(string2)) {
            return true;
        }
        return StringExtensions.equals(string2, string);
    }

    private boolean e(X509Certificate2 x509Certificate2) {
        return StringExtensions.equals(x509Certificate2.getIssuer(), x509Certificate2.getSubject());
    }

    private void a(int n2) {
        int n3 = this.c.size() - 1;
        X509Certificate2 x509Certificate2 = this.c.get_Item(n3).getCertificate();
        if ((n2 & 0x10000) == 0) {
            this.b(n3);
            if (n3 == 0) {
                this.c.get_Item(0).uncompressFlags();
                return;
            }
            --n3;
        }
        this.h = x509Certificate2.get_PublicKey().getKey();
        this.g = x509Certificate2.get_IssuerName();
        this.f = n3;
        for (int i2 = n3; i2 > 0; --i2) {
            this.b(i2);
            this.c(i2);
        }
        this.b(0);
        this.d(n2);
        this.h();
    }

    private void b(int n2) {
        boolean bl2;
        X509ChainElement x509ChainElement = this.c.get_Item(n2);
        X509Certificate2 x509Certificate2 = x509ChainElement.getCertificate();
        if (n2 != this.c.size() - 1 && "1.2.840.10040.4.1".equals(x509Certificate2.getInternalCertificate().getKeyAlgorithm()) && x509Certificate2.getInternalCertificate().getKeyAlgorithmParameters() == null) {
            X509Certificate2 x509Certificate22 = this.c.get_Item(n2 + 1).getCertificate();
            x509Certificate2.getInternalCertificate().setKeyAlgorithmParameters(x509Certificate22.getInternalCertificate().getKeyAlgorithmParameters());
        }
        if (!this.a(x509Certificate2, (bl2 = this.h == null) ? x509Certificate2.get_PublicKey().getKey() : this.h) && (bl2 || n2 != this.c.size() - 1 || this.e(x509Certificate2))) {
            x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 8);
        }
        if (DateTime.op_LessThan(this.getChainPolicy().getVerificationTime(), x509Certificate2.getNotBefore()) || DateTime.op_GreaterThan(this.getChainPolicy().getVerificationTime(), x509Certificate2.getNotAfter())) {
            x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 1);
        }
        if (bl2) {
            return;
        }
        if (!X500DistinguishedName.areEqual(x509Certificate2.get_IssuerName(), this.g)) {
            x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 0x800);
        }
        if (this.e(x509Certificate2) || n2 != 0) {
            // empty if block
        }
    }

    private void c(int n2) {
        X509KeyUsageExtension x509KeyUsageExtension;
        X509ChainElement x509ChainElement = this.c.get_Item(n2);
        X509Certificate2 x509Certificate2 = x509ChainElement.getCertificate();
        this.g = x509Certificate2.getSubjectName();
        this.h = x509Certificate2.get_PublicKey().getKey();
        X509BasicConstraintsExtension x509BasicConstraintsExtension = Operators.as(x509Certificate2.getExtensions().get_Item("2.5.29.19"), X509BasicConstraintsExtension.class);
        if (x509BasicConstraintsExtension != null) {
            if (!x509BasicConstraintsExtension.getCertificateAuthority()) {
                x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 0x400);
            }
        } else if (x509Certificate2.getVersion() >= 3) {
            x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 0x400);
        }
        if (!this.e(x509Certificate2)) {
            if (this.f > 0) {
                --this.f;
            } else if (this.i != null) {
                this.i.setStatusFlags(this.i.getStatusFlags() | 0x400);
            }
        }
        if (x509BasicConstraintsExtension != null && x509BasicConstraintsExtension.hasPathLengthConstraint() && x509BasicConstraintsExtension.getPathLengthConstraint() < this.f) {
            this.f = x509BasicConstraintsExtension.getPathLengthConstraint();
            this.i = x509ChainElement;
        }
        if ((x509KeyUsageExtension = Operators.as(x509Certificate2.getExtensions().get_Item("2.5.29.15"), X509KeyUsageExtension.class)) != null) {
            int n3 = 4;
            if ((x509KeyUsageExtension.getKeyUsages() & n3) != n3) {
                x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 0x10);
            }
        }
        this.a(x509ChainElement);
    }

    private void h() {
        X509ChainElement x509ChainElement = this.c.get_Item(0);
        X509Certificate2 x509Certificate2 = x509ChainElement.getCertificate();
        if (this.e(x509Certificate2)) {
            // empty if block
        }
        this.a(x509ChainElement);
        for (int i2 = this.c.size() - 1; i2 >= 0; --i2) {
            this.c.get_Item(i2).uncompressFlags();
        }
    }

    private void a(X509ChainElement x509ChainElement) {
        block3: for (X509Extension x509Extension : x509ChainElement.getCertificate().getExtensions()) {
            if (!x509Extension.getCritical()) continue;
            switch (q.of(x509Extension.getOid().getValue())) {
                case 0: 
                case 1: {
                    continue block3;
                }
            }
            x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 0x100);
        }
    }

    private boolean a(X509Certificate2 x509Certificate2, AsymmetricAlgorithm asymmetricAlgorithm) {
        if (asymmetricAlgorithm == null) {
            return false;
        }
        X509Certificate x509Certificate = x509Certificate2.getInternalCertificate();
        return x509Certificate.verifySignature(asymmetricAlgorithm);
    }

    private String f(X509Certificate2 x509Certificate2) {
        X509SubjectKeyIdentifierExtension x509SubjectKeyIdentifierExtension = Operators.as(x509Certificate2.getExtensions().get_Item("2.5.29.14"), X509SubjectKeyIdentifierExtension.class);
        return x509SubjectKeyIdentifierExtension == null ? StringExtensions.Empty : x509SubjectKeyIdentifierExtension.getSubjectKeyIdentifier();
    }

    static String a(X509Certificate2 x509Certificate2) {
        return X509Chain.a(x509Certificate2.getInternalCertificate().getExtensions().get_Item("2.5.29.35"));
    }

    static String a(j j2) {
        return X509Chain.a(j2.b().get_Item("2.5.29.35"));
    }

    static String a(com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Extension x509Extension) {
        if (x509Extension == null) {
            return StringExtensions.Empty;
        }
        a a2 = new a(x509Extension);
        byte[] byArray = a2.a();
        if (byArray == null) {
            return StringExtensions.Empty;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        for (byte by2 : byArray) {
            msStringBuilder2.append(ByteExtensions.toString(by2, "X02"));
        }
        return msStringBuilder2.toString();
    }

    private void d(int n2) {
        boolean bl2;
        boolean bl3 = (n2 & 0x10000) != 0;
        switch (this.getChainPolicy().getRevocationMode()) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: {
                bl2 = false;
                break;
            }
            case 0: {
                return;
            }
            default: {
                throw new InvalidOperationException(StringExtensions.format("Invalid revocation mode.", new Object[0]));
            }
        }
        boolean bl4 = bl3;
        for (int i2 = this.c.size() - 1; i2 >= 0; --i2) {
            boolean bl5 = true;
            switch (this.getChainPolicy().getRevocationFlag()) {
                case 0: {
                    bl5 = i2 == 0;
                    break;
                }
                case 1: {
                    bl5 = true;
                    break;
                }
                case 2: {
                    bl5 = i2 != this.c.size() - 1;
                }
            }
            X509ChainElement x509ChainElement = this.c.get_Item(i2);
            if (!bl4) {
                bl4 |= (x509ChainElement.getStatusFlags() & 8) != 0;
            }
            if (bl4) {
                x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 0x40);
                x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | 0x1000000);
                continue;
            }
            if (!bl5 || bl3 || this.e(x509ChainElement.getCertificate())) continue;
            x509ChainElement.setStatusFlags(x509ChainElement.getStatusFlags() | this.a(x509ChainElement.getCertificate(), i2 + 1, bl2));
            bl4 |= (x509ChainElement.getStatusFlags() & 4) != 0;
        }
    }

    private int a(X509Certificate2 x509Certificate2, int n2, boolean bl2) {
        int n3 = 64;
        X509ChainElement x509ChainElement = this.c.get_Item(n2);
        X509Certificate2 x509Certificate22 = x509ChainElement.getCertificate();
        while (this.e(x509Certificate22) && n2 < this.c.size() - 1 && (n3 = this.a(x509Certificate2, x509Certificate22, bl2)) == 64) {
            x509ChainElement = this.c.get_Item(++n2);
            x509Certificate22 = x509ChainElement.getCertificate();
        }
        if (n3 == 64) {
            n3 = this.a(x509Certificate2, x509Certificate22, bl2);
        }
        return n3;
    }

    private int a(X509Certificate2 x509Certificate2, X509Certificate2 x509Certificate22, boolean bl2) {
        j j2;
        X509KeyUsageExtension x509KeyUsageExtension = Operators.as(x509Certificate22.getExtensions().get_Item("2.5.29.15"), X509KeyUsageExtension.class);
        if (x509KeyUsageExtension != null) {
            int n2 = 2;
            if ((x509KeyUsageExtension.getKeyUsages() & n2) != n2) {
                return 64;
            }
        }
        if ((j2 = this.g(x509Certificate22)) != null || bl2) {
            // empty if block
        }
        if (j2 != null) {
            if (!j2.a(x509Certificate22.get_PublicKey().getKey())) {
                return 64;
            }
            j.a a2 = j2.a(x509Certificate2.getInternalCertificate());
            if (a2 != null) {
                if (!this.a(a2)) {
                    return 4;
                }
                if (DateTime.op_LessThanOrEqual(a2.b(), this.getChainPolicy().getVerificationTime())) {
                    return 4;
                }
            }
            if (DateTime.op_LessThan(j2.e(), this.getChainPolicy().getVerificationTime())) {
                return 0x1000040;
            }
            if (!this.b(j2)) {
                return 64;
            }
        } else {
            return 64;
        }
        return 0;
    }

    static j a(String string, String string2, ArrayList arrayList) {
        for (j j2 : arrayList) {
            if (!StringExtensions.equals(j2.d(), string) || string2.length() != 0 && !StringExtensions.equals(string2, X509Chain.a(j2))) continue;
            return j2;
        }
        return null;
    }

    private j g(X509Certificate2 x509Certificate2) {
        j j2;
        String string = x509Certificate2.getSubjectName().decode(0);
        String string2 = this.f(x509Certificate2);
        j j3 = j2 = this.e().getStore() == null ? null : X509Chain.a(string, string2, this.e().getStore().b());
        if (j2 != null) {
            return j2;
        }
        if (this.b == 1 && (j2 = X509Chain.a(string, string2, this.f().getStore().b())) != null) {
            return j2;
        }
        j j4 = j2 = this.c().getStore() == null ? null : X509Chain.a(string, string2, this.c().getStore().b());
        if (j2 != null) {
            return j2;
        }
        if (this.b == 1 && (j2 = X509Chain.a(string, string2, this.d().getStore().b())) != null) {
            return j2;
        }
        return null;
    }

    private boolean b(j j2) {
        block3: for (com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Extension x509Extension : j2.b()) {
            if (!x509Extension.getCritical()) continue;
            switch (q.of(x509Extension.getOid())) {
                case 2: 
                case 3: {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }

    private boolean a(j.a a2) {
        block3: for (com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Extension x509Extension : a2.c()) {
            if (!x509Extension.getCritical()) continue;
            switch (q.of(x509Extension.getOid())) {
                case 4: {
                    continue block3;
                }
            }
            return false;
        }
        return true;
    }
}

