/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsnEncodedData;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.CryptographicException;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSACryptoServiceProvider;
import com.aspose.html.internal.ms.System.Security.Cryptography.DSAParameters;
import com.aspose.html.internal.ms.System.Security.Cryptography.Oid;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSA;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSACryptoServiceProvider;
import com.aspose.html.internal.ms.System.Security.Cryptography.RSAParameters;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.ASN1;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.RSAManaged;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;

public final class PublicKey {
    private static final String b = "1.2.840.113549.1.1.1";
    private static final String c = "1.2.840.10040.4.1";
    private AsymmetricAlgorithm d;
    private AsnEncodedData e;
    private AsnEncodedData f;
    private Oid g;
    static byte[] a = new byte[0];
    private static final StringSwitchMap h = new StringSwitchMap("1.2.840.113549.1.1.1", "1.2.840.10040.4.1");

    public PublicKey(Oid oid, AsnEncodedData parameters, AsnEncodedData keyValue) {
        if (oid == null) {
            throw new ArgumentNullException("oid");
        }
        if (parameters == null) {
            throw new ArgumentNullException("parameters");
        }
        if (keyValue == null) {
            throw new ArgumentNullException("keyValue");
        }
        this.g = new Oid(oid);
        this.f = new AsnEncodedData(parameters);
        this.e = new AsnEncodedData(keyValue);
    }

    public PublicKey(X509Certificate certificate) {
        Object object;
        boolean bl2 = true;
        if (b.equals(certificate.getKeyAlgorithm())) {
            Object object2;
            object = Operators.as(certificate.getRSA(), RSACryptoServiceProvider.class);
            if (object != null && ((RSACryptoServiceProvider)object).getPublicOnly()) {
                this.d = certificate.getRSA();
                bl2 = false;
            } else {
                object2 = Operators.as(certificate.getRSA(), RSAManaged.class);
                if (object2 != null && ((RSAManaged)object2).getPublicOnly()) {
                    this.d = certificate.getRSA();
                    bl2 = false;
                }
            }
            if (bl2) {
                object2 = certificate.getRSA().exportParameters(false).Clone();
                this.d = RSA.create();
                Operators.as(this.d, RSA.class).importParameters(((RSAParameters)object2).Clone());
            }
        } else {
            object = Operators.as(certificate.getDSA(), DSACryptoServiceProvider.class);
            if (object != null && ((DSACryptoServiceProvider)object).getPublicOnly()) {
                this.d = certificate.getDSA();
                bl2 = false;
            }
            if (bl2) {
                DSAParameters dSAParameters = certificate.getDSA().exportParameters(false).Clone();
                this.d = DSA.create();
                Operators.as(this.d, DSA.class).importParameters(dSAParameters.Clone());
            }
        }
        this.g = new Oid(certificate.getKeyAlgorithm());
        this.e = new AsnEncodedData(this.g, certificate.getPublicKey());
        object = certificate.getKeyAlgorithmParameters();
        if (object == null) {
            object = a;
        }
        this.f = new AsnEncodedData(this.g, (byte[])object);
    }

    public AsnEncodedData getEncodedKeyValue() {
        return this.e;
    }

    public AsnEncodedData getEncodedParameters() {
        return this.f;
    }

    public AsymmetricAlgorithm getKey() {
        if (this.d == null) {
            switch (h.of(this.g.getValue())) {
                case 0: {
                    this.d = PublicKey.decodeRSA(this.e.getRawData());
                    break;
                }
                case 1: {
                    this.d = PublicKey.decodeDSA(this.e.getRawData(), this.f.getRawData());
                    break;
                }
                default: {
                    String string = StringExtensions.format("Cannot decode public key from unknown OID '{0}'.", this.g.getValue());
                    throw new NotSupportedException(string);
                }
            }
        }
        return this.d;
    }

    public Oid getOid() {
        return this.g;
    }

    private static byte[] a(byte[] byArray) {
        if (Operators.castToInt32(byArray[0], 6) != 0) {
            return byArray;
        }
        int n2 = byArray.length - 1;
        byte[] byArray2 = new byte[n2];
        Buffer.blockCopy(Array.boxing(byArray), 1, Array.boxing(byArray2), 0, n2);
        return byArray2;
    }

    public static DSA decodeDSA(byte[] rawPublicKey, byte[] rawParameters) {
        Object object;
        DSAParameters dSAParameters = new DSAParameters();
        try {
            object = new ASN1(rawPublicKey);
            if (Operators.castToInt32(((ASN1)object).getTag(), 6) != 2) {
                throw new CryptographicException(StringExtensions.format("Missing DSA Y integer.", new Object[0]));
            }
            dSAParameters.Y = PublicKey.a(((ASN1)object).getValue());
            ASN1 aSN1 = new ASN1(rawParameters);
            if (aSN1 == null || Operators.castToInt32(aSN1.getTag(), 6) != 48 || aSN1.getCount() < 3) {
                throw new CryptographicException(StringExtensions.format("Missing DSA parameters.", new Object[0]));
            }
            if (Operators.castToInt32(aSN1.get_Item(0).getTag(), 6) != 2 || Operators.castToInt32(aSN1.get_Item(1).getTag(), 6) != 2 || Operators.castToInt32(aSN1.get_Item(2).getTag(), 6) != 2) {
                throw new CryptographicException(StringExtensions.format("Invalid DSA parameters.", new Object[0]));
            }
            dSAParameters.P = PublicKey.a(aSN1.get_Item(0).getValue());
            dSAParameters.Q = PublicKey.a(aSN1.get_Item(1).getValue());
            dSAParameters.G = PublicKey.a(aSN1.get_Item(2).getValue());
        }
        catch (RuntimeException runtimeException) {
            String string = StringExtensions.format("Error decoding the ASN.1 structure.", new Object[0]);
            throw new CryptographicException(string, runtimeException);
        }
        object = new DSACryptoServiceProvider(dSAParameters.Y.length << 3);
        ((DSA)object).importParameters(dSAParameters.Clone());
        return object;
    }

    public static RSA decodeRSA(byte[] rawPublicKey) {
        Object object;
        RSAParameters rSAParameters = new RSAParameters();
        try {
            ASN1 aSN1 = new ASN1(rawPublicKey);
            if (aSN1.getCount() == 0) {
                throw new CryptographicException(StringExtensions.format("Missing RSA modulus and exponent.", new Object[0]));
            }
            object = aSN1.get_Item(0);
            if (object == null || Operators.castToInt32(((ASN1)object).getTag(), 6) != 2) {
                throw new CryptographicException(StringExtensions.format("Missing RSA modulus.", new Object[0]));
            }
            ASN1 aSN12 = aSN1.get_Item(1);
            if (Operators.castToInt32(aSN12.getTag(), 6) != 2) {
                throw new CryptographicException(StringExtensions.format("Missing RSA public exponent.", new Object[0]));
            }
            rSAParameters.Modulus = PublicKey.a(((ASN1)object).getValue());
            rSAParameters.Exponent = aSN12.getValue();
        }
        catch (RuntimeException runtimeException) {
            String string = StringExtensions.format("Error decoding the ASN.1 structure.", new Object[0]);
            throw new CryptographicException(string, runtimeException);
        }
        int n2 = rSAParameters.Modulus.length << 3;
        object = new RSACryptoServiceProvider(n2);
        ((RSA)object).importParameters(rSAParameters.Clone());
        return object;
    }
}

