/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Security.Cryptography;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Buffer;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.InAttribute;
import com.aspose.html.internal.ms.System.Runtime.InteropServices.OutAttribute;
import com.aspose.html.internal.ms.System.Security.Cryptography.ICryptoTransform;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.core.System.Security.Cryptography.n;

public class CryptoStream
extends Stream {
    private Stream a;
    private ICryptoTransform b;
    private int c;
    private byte[] d;
    private boolean e;
    private boolean f;
    private int g;
    private boolean h;
    private byte[] i;
    private int j;
    private byte[] k;
    private int l;
    private int m;
    private byte[] n;
    private int o;

    public CryptoStream(Stream stream, ICryptoTransform transform, int mode) {
        if (mode == 0) {
            if (!stream.canRead()) {
                throw new ArgumentException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("Can't read on stream"));
            }
        } else if (mode == 1) {
            if (!stream.canWrite()) {
                throw new ArgumentException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("Can't write on stream"));
            }
        } else {
            throw new ArgumentException("ArgumentException", "mode");
        }
        this.a = stream;
        this.b = transform;
        this.c = mode;
        this.e = false;
        if (transform != null) {
            this.n = new byte[transform.getInputBlockSize()];
        }
    }

    @Override
    public boolean canRead() {
        return this.c == 0;
    }

    @Override
    public boolean canSeek() {
        return false;
    }

    @Override
    public boolean canWrite() {
        return this.c == 1;
    }

    @Override
    public long getLength() {
        throw new NotSupportedException("Length");
    }

    @Override
    public long getPosition() {
        throw new NotSupportedException("Position");
    }

    @Override
    public void setPosition(long value) {
        throw new NotSupportedException("Position");
    }

    public void clear() {
        this.close();
    }

    @Override
    public int read(@InAttribute @OutAttribute byte[] buffer, int offset, int count) {
        if (this.c != 0) {
            throw new NotSupportedException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("not in Read mode"));
        }
        if (offset < 0) {
            throw new ArgumentException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("negative"), "offset");
        }
        if (count < 0) {
            throw new ArgumentException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("negative"), "count");
        }
        if (offset > buffer.length - count) {
            throw new ArgumentException("(offset+count)\r\nParameter name: " + com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("buffer overflow"));
        }
        if (this.n == null) {
            return 0;
        }
        int n2 = 0;
        if (count == 0 || this.l == this.m && this.h) {
            return n2;
        }
        if (this.i == null) {
            this.k = new byte[this.b.getOutputBlockSize() << 2];
            this.l = 0;
            this.m = 0;
            this.i = new byte[this.b.getInputBlockSize()];
            this.j = this.a.read(this.i, 0, this.i.length);
        }
        while (count > 0) {
            int n3 = this.m - this.l;
            if (n3 < this.b.getInputBlockSize()) {
                int n4 = 0;
                this.o = this.a.read(this.n, 0, this.b.getInputBlockSize());
                boolean bl2 = this.h = this.o < this.b.getInputBlockSize();
                if (!this.h) {
                    n4 = this.b.transformBlock(this.i, 0, this.i.length, this.k, this.m);
                    Buffer.blockCopy(Array.boxing(this.n), 0, Array.boxing(this.i), 0, this.o);
                    this.j = this.o;
                } else {
                    if (this.o > 0) {
                        n4 = this.b.transformBlock(this.i, 0, this.i.length, this.k, this.m);
                        Buffer.blockCopy(Array.boxing(this.n), 0, Array.boxing(this.i), 0, this.o);
                        this.j = this.o;
                        n3 += n4;
                        this.m += n4;
                    }
                    if (!this.f) {
                        byte[] byArray = this.b.transformFinalBlock(this.i, 0, this.j);
                        n4 = byArray.length;
                        Buffer.blockCopy(Array.boxing(byArray), 0, Array.boxing(this.k), this.m, byArray.length);
                        msArray.clear(byArray, 0, byArray.length);
                        this.f = true;
                    }
                }
                n3 += n4;
                this.m += n4;
            }
            if (this.l > this.b.getOutputBlockSize()) {
                Buffer.blockCopy(Array.boxing(this.k), this.l, Array.boxing(this.k), 0, n3);
                this.m -= this.l;
                this.l = 0;
            }
            int n5 = n3 = count < n3 ? count : n3;
            if (n3 > 0) {
                Buffer.blockCopy(Array.boxing(this.k), this.l, Array.boxing(buffer), offset, n3);
                this.l += n3;
                n2 += n3;
                offset += n3;
                count -= n3;
            }
            if ((n3 == this.b.getInputBlockSize() || this.j == this.b.getInputBlockSize()) && !this.h) continue;
            count = 0;
        }
        return n2;
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        int n2;
        if (this.c != 1) {
            throw new NotSupportedException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("not in Write mode"));
        }
        if (offset < 0) {
            throw new ArgumentException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("negative"), "offset");
        }
        if (count < 0) {
            throw new ArgumentException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("negative"), "count");
        }
        if (offset > buffer.length - count) {
            throw new ArgumentException("(offset+count)\r\nParameter name: " + com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("buffer overflow"));
        }
        if (this.a == null) {
            throw new ArgumentNullException("inner stream was disposed");
        }
        int n3 = count;
        if (this.g > 0 && this.g != this.b.getInputBlockSize()) {
            n2 = this.b.getInputBlockSize() - this.g;
            n2 = count < n2 ? count : n2;
            Buffer.blockCopy(Array.boxing(buffer), offset, Array.boxing(this.n), this.g, n2);
            this.g += n2;
            offset += n2;
            count -= n2;
        }
        n2 = offset;
        while (count > 0) {
            int n4;
            if (this.g == this.b.getInputBlockSize()) {
                if (this.d == null) {
                    this.d = new byte[this.b.getOutputBlockSize()];
                }
                n4 = this.b.transformBlock(this.n, 0, this.g, this.d, 0);
                this.a.write(this.d, 0, n4);
                this.g = 0;
            }
            if (this.b.canTransformMultipleBlocks()) {
                n4 = count & ~(this.b.getInputBlockSize() - 1);
                int n5 = count & this.b.getInputBlockSize() - 1;
                int n6 = (1 + n4 / this.b.getInputBlockSize()) * this.b.getOutputBlockSize();
                if (this.n.length < n6) {
                    msArray.clear(this.n, 0, this.n.length);
                    this.n = new byte[n6];
                }
                if (n4 > 0) {
                    int n7 = this.b.transformBlock(buffer, offset, n4, this.n, 0);
                    this.a.write(this.n, 0, n7);
                }
                if (n5 > 0) {
                    Buffer.blockCopy(Array.boxing(buffer), n3 - n5, Array.boxing(this.n), 0, n5);
                }
                this.g = n5;
                count = 0;
                continue;
            }
            n4 = Math.min(this.b.getInputBlockSize() - this.g, count);
            Buffer.blockCopy(Array.boxing(buffer), n2, Array.boxing(this.n), this.g, n4);
            n2 += n4;
            this.g += n4;
            count -= n4;
        }
    }

    @Override
    public void flush() {
    }

    public void flushFinalBlock() {
        if (this.f) {
            throw new NotSupportedException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("This method cannot be called twice."));
        }
        if (this.e) {
            throw new NotSupportedException(com.aspose.html.internal.ms.core.System.Security.Cryptography.n.a("CryptoStream was disposed."));
        }
        this.f = true;
        byte[] byArray = this.b.transformFinalBlock(this.n, 0, this.g);
        if (this.a != null && this.c == 1) {
            this.a.write(byArray, 0, byArray.length);
        }
        if (this.a instanceof CryptoStream) {
            ((CryptoStream)this.a).flushFinalBlock();
        } else {
            this.a.flush();
        }
        msArray.clear(byArray, 0, byArray.length);
    }

    @Override
    public long seek(long offset, int origin) {
        throw new NotSupportedException("Seek");
    }

    @Override
    public void setLength(long value) {
        throw new NotSupportedException("SetLength");
    }

    @Override
    protected void dispose(boolean disposing) {
        if (!this.e) {
            if (disposing) {
                if (!this.f) {
                    this.flushFinalBlock();
                }
                if (this.a != null) {
                    this.a.close();
                }
            }
            this.e = true;
            if (this.n != null) {
                msArray.clear(this.n, 0, this.n.length);
            }
            if (this.d != null) {
                msArray.clear(this.d, 0, this.d.length);
            }
            if (disposing) {
                this.a = null;
                this.n = null;
                this.d = null;
            }
        }
    }
}

