/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Net.ICredentials;
import com.aspose.html.internal.ms.System.Net.IPAddress;
import com.aspose.html.internal.ms.System.Net.IWebProxy;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.RegularExpressions.Regex;
import com.aspose.html.internal.ms.System.Uri;

public class WebProxy
implements IWebProxy {
    private Uri a;
    private boolean b;
    private ArrayList c;
    private ICredentials d;
    private boolean e;

    public WebProxy() {
        this((Uri)null, false, null, null);
    }

    public WebProxy(String address) {
        this(WebProxy.a(address), false, null, null);
    }

    public WebProxy(Uri address) {
        this(address, false, null, null);
    }

    public WebProxy(String address, boolean bypassOnLocal) {
        this(WebProxy.a(address), bypassOnLocal, null, null);
    }

    public WebProxy(String host, int port) {
        this(new Uri("http://" + host + ":" + port));
    }

    public WebProxy(Uri address, boolean bypassOnLocal) {
        this(address, bypassOnLocal, null, null);
    }

    public WebProxy(String address, boolean bypassOnLocal, String[] bypassList) {
        this(WebProxy.a(address), bypassOnLocal, bypassList, null);
    }

    public WebProxy(Uri address, boolean bypassOnLocal, String[] bypassList) {
        this(address, bypassOnLocal, bypassList, null);
    }

    public WebProxy(String address, boolean bypassOnLocal, String[] bypassList, ICredentials credentials) {
        this(WebProxy.a(address), bypassOnLocal, bypassList, credentials);
    }

    public WebProxy(Uri address, boolean bypassOnLocal, String[] bypassList, ICredentials credentials) {
        this.a = address;
        this.b = bypassOnLocal;
        if (bypassList != null) {
            ArrayList arrayList = new ArrayList(bypassList.length);
            for (int i2 = 0; i2 < bypassList.length; ++i2) {
                arrayList.set_Item(i2, bypassList[i2]);
            }
            this.c = arrayList;
        }
        this.d = credentials;
        this.a();
    }

    public Uri getAddress() {
        return this.a;
    }

    public void setAddress(Uri value) {
        this.a = value;
    }

    public ArrayList getBypassArrayList() {
        if (this.c == null) {
            this.c = new ArrayList();
        }
        return this.c;
    }

    public String[] getBypassList() {
        return (String[])this.getBypassArrayList().toArray(new String[0]);
    }

    public void setBypassList(String[] value) {
        if (value == null) {
            throw new ArgumentNullException();
        }
        ArrayList arrayList = new ArrayList(value.length);
        for (int i2 = 0; i2 < value.length; ++i2) {
            arrayList.set_Item(i2, value[i2]);
        }
        this.c = arrayList;
        this.a();
    }

    public boolean getBypassProxyOnLocal() {
        return this.b;
    }

    public void setBypassProxyOnLocal(boolean value) {
        this.b = value;
    }

    @Override
    public ICredentials getCredentials() {
        return this.d;
    }

    @Override
    public void setCredentials(ICredentials value) {
        this.d = value;
    }

    public boolean getUseDefaultCredentials() {
        return this.e;
    }

    public void setUseDefaultCredentials(boolean value) {
        this.e = value;
    }

    @Override
    public Uri getProxy(Uri destination) {
        if (this.isBypassed(destination)) {
            return destination;
        }
        return this.a;
    }

    @Override
    public boolean isBypassed(Uri host) {
        Object object;
        if (host == null) {
            throw new ArgumentNullException("host");
        }
        if (host.isLoopback() && this.b) {
            return true;
        }
        if (this.a == null) {
            return true;
        }
        String string = host.getHost();
        if (this.b && string.indexOf(46) == -1) {
            return true;
        }
        if (!this.b) {
            if (StringExtensions.compare(string, "localhost", true, CultureInfo.getInvariantCulture()) == 0) {
                return true;
            }
            if (StringExtensions.compare(string, "loopback", true, CultureInfo.getInvariantCulture()) == 0) {
                return true;
            }
            object = new IPAddress[]{null};
            if (IPAddress.tryParse(string, object) && IPAddress.isLoopback(object[0])) {
                return true;
            }
        }
        if (this.c == null || this.c.size() == 0) {
            return false;
        }
        try {
            Regex regex;
            int n2;
            object = host.getScheme() + "://" + host.getAuthority();
            for (n2 = 0; n2 < this.c.size() && !(regex = new Regex((String)this.c.get_Item(n2), 66)).isMatch((String)object); ++n2) {
            }
            if (n2 == this.c.size()) {
                return false;
            }
            while (n2 < this.c.size()) {
                new Regex((String)this.c.get_Item(n2));
                ++n2;
            }
            return true;
        }
        catch (ArgumentException argumentException) {
            return false;
        }
    }

    void a() {
        if (this.c == null) {
            return;
        }
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            new Regex((String)this.c.get_Item(i2));
        }
    }

    static Uri a(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("://", 4) == -1) {
            string = "http://" + string;
        }
        return new Uri(string);
    }
}

