/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net.Security;

import com.aspose.html.internal.ms.System.AsyncCallback;
import com.aspose.html.internal.ms.System.IAsyncResult;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.Net.Security.AuthenticatedStream;
import com.aspose.html.internal.ms.System.Net.Security.LocalCertificateSelectionCallback;
import com.aspose.html.internal.ms.System.Net.Security.RemoteCertificateValidationCallback;
import com.aspose.html.internal.ms.System.Net.ServicePointManager;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.Security.Cryptography.AsymmetricAlgorithm;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Certificate2;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509CertificateCollection;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509Chain;
import com.aspose.html.internal.ms.System.Security.Cryptography.X509Certificates.X509ChainStatus;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Security.Protocol.Tls.ah;
import com.aspose.html.internal.ms.core.System.Security.Protocol.Tls.au;
import com.aspose.html.internal.ms.core.System.Security.Protocol.Tls.bt;
import com.aspose.html.internal.ms.core.System.Security.Protocol.Tls.cc;
import com.aspose.html.internal.ms.core.System.Security.Protocol.Tls.f;
import com.aspose.html.internal.ms.core.System.Security.Protocol.Tls.h;
import com.aspose.html.internal.ms.lang.Operators;

public class SslStream
extends AuthenticatedStream {
    private cc a;
    private RemoteCertificateValidationCallback b;
    private LocalCertificateSelectionCallback c;

    public SslStream(Stream innerStream) {
        this(innerStream, false);
    }

    public SslStream(Stream innerStream, boolean leaveInnerStreamOpen) {
        super(innerStream, leaveInnerStreamOpen);
    }

    public SslStream(Stream innerStream, boolean leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback) {
        this(innerStream, leaveInnerStreamOpen, userCertificateValidationCallback, null);
    }

    public SslStream(Stream innerStream, boolean leaveInnerStreamOpen, RemoteCertificateValidationCallback userCertificateValidationCallback, LocalCertificateSelectionCallback userCertificateSelectionCallback) {
        super(innerStream, leaveInnerStreamOpen);
        this.b = userCertificateValidationCallback;
        this.c = userCertificateSelectionCallback;
    }

    @Override
    public boolean canRead() {
        return this.getInnerStream().canRead();
    }

    @Override
    public boolean canSeek() {
        return this.getInnerStream().canSeek();
    }

    @Override
    public boolean canTimeout() {
        return this.getInnerStream().canTimeout();
    }

    @Override
    public boolean canWrite() {
        return this.getInnerStream().canWrite();
    }

    @Override
    public long getLength() {
        return this.getInnerStream().getLength();
    }

    @Override
    public long getPosition() {
        return this.getInnerStream().getPosition();
    }

    @Override
    public void setPosition(long value) {
        throw new NotSupportedException("This stream does not support seek operations");
    }

    @Override
    public boolean isAuthenticated() {
        return this.a != null;
    }

    @Override
    public boolean isEncrypted() {
        return this.isAuthenticated();
    }

    @Override
    public boolean isMutuallyAuthenticated() {
        return this.isAuthenticated() && (this.isServer() ? this.getRemoteCertificate() != null : this.getLocalCertificate() != null);
    }

    @Override
    public boolean isServer() {
        return Operators.is(this.a, bt.class);
    }

    @Override
    public boolean isSigned() {
        return this.isAuthenticated();
    }

    @Override
    public int getReadTimeout() {
        return this.getInnerStream().getReadTimeout();
    }

    @Override
    public void setReadTimeout(int value) {
        this.getInnerStream().setReadTimeout(value);
    }

    @Override
    public int getWriteTimeout() {
        return this.getInnerStream().getWriteTimeout();
    }

    @Override
    public void setWriteTimeout(int value) {
        this.getInnerStream().setWriteTimeout(value);
    }

    public boolean getCheckCertRevocationStatus() {
        if (!this.isAuthenticated()) {
            return false;
        }
        return this.a.k();
    }

    public int getCipherAlgorithm() {
        this.a();
        switch (this.a.l()) {
            case 0: {
                return 26113;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 26114;
            }
            case 3: {
                return 26625;
            }
            case 5: {
                break;
            }
            case 6: {
                return 26115;
            }
            case 4: {
                switch (this.a.m()) {
                    case 128: {
                        return 26126;
                    }
                    case 192: {
                        return 26127;
                    }
                    case 256: {
                        return 26128;
                    }
                }
            }
        }
        throw new InvalidOperationException("Not supported cipher algorithm is in use. It is likely a bug in SslStream.");
    }

    public int getCipherStrength() {
        this.a();
        return this.a.m();
    }

    public int getHashAlgorithm() {
        this.a();
        switch (this.a.n()) {
            case 0: {
                return 32771;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 32772;
            }
        }
        throw new InvalidOperationException("Not supported hash algorithm is in use. It is likely a bug in SslStream.");
    }

    public int getHashStrength() {
        this.a();
        return this.a.o();
    }

    public int getKeyExchangeAlgorithm() {
        this.a();
        switch (this.a.q()) {
            case 0: {
                return 43522;
            }
            case 1: {
                break;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 41984;
            }
            case 4: {
                return 9216;
            }
        }
        throw new InvalidOperationException("Not supported exchange algorithm is in use. It is likely a bug in SslStream.");
    }

    public int getKeyExchangeStrength() {
        this.a();
        return this.a.p();
    }

    public X509Certificate getLocalCertificate() {
        this.a();
        return this.isServer() ? this.a.s() : ((au)this.a).d();
    }

    public X509Certificate getRemoteCertificate() {
        this.a();
        return !this.isServer() ? this.a.s() : ((bt)this.a).a();
    }

    public int getSslProtocol() {
        this.a();
        switch (this.a.r()) {
            case -1073741824: {
                return 240;
            }
            case 12: {
                return 12;
            }
            case 48: {
                return 48;
            }
            case 192: {
                return 192;
            }
        }
        throw new InvalidOperationException("Not supported SSL/TLS protocol is in use. It is likely a bug in SslStream.");
    }

    private X509Certificate a(X509CertificateCollection x509CertificateCollection, X509Certificate x509Certificate, String string, X509CertificateCollection x509CertificateCollection2) {
        String[] stringArray = new String[x509CertificateCollection2 != null ? x509CertificateCollection2.size() : 0];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = x509CertificateCollection2.get_Item(i2).getIssuerName();
        }
        return this.c.invoke(this, string, x509CertificateCollection, x509Certificate, stringArray);
    }

    public IAsyncResult beginAuthenticateAsClient(String targetHost, AsyncCallback asyncCallback, Object asyncState) {
        return this.beginAuthenticateAsClient(targetHost, new X509CertificateCollection(), 192, false, asyncCallback, asyncState);
    }

    public IAsyncResult beginAuthenticateAsClient(String targetHost, final X509CertificateCollection clientCertificates, int enabledSslProtocols, boolean checkCertificateRevocation, AsyncCallback asyncCallback, Object asyncState) {
        if (this.isAuthenticated()) {
            throw new InvalidOperationException("This SslStream is already authenticated");
        }
        au au2 = new au(this.getInnerStream(), targetHost, !this.getLeaveInnerStreamOpen(), this.a(enabledSslProtocols), clientCertificates);
        au2.a(checkCertificateRevocation);
        au2.a(new ah(){

            @Override
            public AsymmetricAlgorithm a(X509Certificate x509Certificate, String string) {
                String string2 = x509Certificate.getCertHashString();
                for (Object e2 : clientCertificates) {
                    X509Certificate x509Certificate2 = (X509Certificate)e2;
                    if (!StringExtensions.equals(x509Certificate2.getCertHashString(), string2)) continue;
                    X509Certificate2 x509Certificate22 = Operators.as(x509Certificate2, X509Certificate2.class);
                    X509Certificate2 x509Certificate23 = x509Certificate22;
                    if (x509Certificate23 == null) {
                        x509Certificate23 = new X509Certificate2(x509Certificate2);
                    }
                    x509Certificate22 = x509Certificate23;
                    return x509Certificate22.getPrivateKey();
                }
                return null;
            }
        });
        if (this.b != null) {
            au2.a(new h(){

                @Override
                public boolean a(X509Certificate x509Certificate, int[] nArray) {
                    X509Chain x509Chain = new X509Chain();
                    X509Certificate2 x509Certificate2 = Operators.as(x509Certificate, X509Certificate2.class);
                    if (x509Certificate2 == null) {
                        x509Certificate2 = new X509Certificate2(x509Certificate);
                    }
                    if (!ServicePointManager.getCheckCertificateRevocationList()) {
                        x509Chain.getChainPolicy().setRevocationMode(0);
                    }
                    int n2 = 0;
                    block4: for (int n4 : nArray) {
                        switch (n4) {
                            case -2146762490: {
                                n2 |= 1;
                                continue block4;
                            }
                            case -2146762481: {
                                n2 |= 2;
                                continue block4;
                            }
                            default: {
                                n2 |= 4;
                            }
                        }
                    }
                    x509Chain.build(x509Certificate2);
                    for (X509ChainStatus x509ChainStatus : x509Chain.getChainStatus()) {
                        if (x509ChainStatus.getStatus() == 0) continue;
                        if ((x509ChainStatus.getStatus() & 0x10000) != 0) {
                            n2 |= 1;
                            continue;
                        }
                        n2 |= 4;
                    }
                    return SslStream.this.b.invoke(this, x509Certificate, x509Chain, n2);
                }
            });
        }
        if (this.c != null) {
            au2.a(new f(){

                @Override
                public X509Certificate a(X509CertificateCollection x509CertificateCollection, X509Certificate x509Certificate, String string, X509CertificateCollection x509CertificateCollection2) {
                    return SslStream.this.a(x509CertificateCollection, x509Certificate, string, x509CertificateCollection2);
                }
            });
        }
        this.a = au2;
        return this.beginWrite(new byte[0], 0, 0, asyncCallback, asyncState);
    }

    @Override
    public IAsyncResult beginRead(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, Object asyncState) {
        this.a();
        return this.a.beginRead(buffer, offset, count, asyncCallback, asyncState);
    }

    public IAsyncResult beginAuthenticateAsServer(X509Certificate serverCertificate, AsyncCallback asyncCallback, Object asyncState) {
        return this.beginAuthenticateAsServer(serverCertificate, false, 192, false, asyncCallback, asyncState);
    }

    public IAsyncResult beginAuthenticateAsServer(final X509Certificate serverCertificate, boolean clientCertificateRequired, int enabledSslProtocols, boolean checkCertificateRevocation, AsyncCallback asyncCallback, Object asyncState) {
        if (this.isAuthenticated()) {
            throw new InvalidOperationException("This SslStream is already authenticated");
        }
        bt bt2 = new bt(this.getInnerStream(), serverCertificate, clientCertificateRequired, !this.getLeaveInnerStreamOpen(), this.a(enabledSslProtocols));
        bt2.a(checkCertificateRevocation);
        bt2.a(new ah(){

            @Override
            public AsymmetricAlgorithm a(X509Certificate x509Certificate, String string) {
                X509Certificate2 x509Certificate2;
                X509Certificate2 x509Certificate22 = Operators.as(serverCertificate, X509Certificate2.class);
                if (x509Certificate22 == null) {
                    x509Certificate22 = new X509Certificate2(serverCertificate);
                }
                return (x509Certificate2 = x509Certificate22) != null ? x509Certificate2.getPrivateKey() : null;
            }
        });
        if (this.b != null) {
            bt2.a(new h(){

                @Override
                public boolean a(X509Certificate x509Certificate, int[] nArray) {
                    X509Chain x509Chain = null;
                    if (Operators.is(x509Certificate, X509Certificate2.class)) {
                        x509Chain = new X509Chain();
                        x509Chain.build((X509Certificate2)x509Certificate);
                    }
                    int n2 = nArray.length > 0 ? 4 : 0;
                    return SslStream.this.b.invoke(this, x509Certificate, x509Chain, n2);
                }
            });
        }
        this.a = bt2;
        return this.beginWrite(new byte[0], 0, 0, asyncCallback, asyncState);
    }

    private int a(int n2) {
        switch (n2) {
            case 12: {
                return 12;
            }
            case 48: {
                return 48;
            }
            case 192: {
                return 192;
            }
        }
        return -1073741824;
    }

    @Override
    public IAsyncResult beginWrite(byte[] buffer, int offset, int count, AsyncCallback asyncCallback, Object asyncState) {
        this.a();
        return this.a.beginWrite(buffer, offset, count, asyncCallback, asyncState);
    }

    public void authenticateAsClient(String targetHost) {
        this.authenticateAsClient(targetHost, new X509CertificateCollection(), 192, false);
    }

    public void authenticateAsClient(String targetHost, X509CertificateCollection clientCertificates, int enabledSslProtocols, boolean checkCertificateRevocation) {
        this.endAuthenticateAsClient(this.beginAuthenticateAsClient(targetHost, clientCertificates, enabledSslProtocols, checkCertificateRevocation, null, null));
    }

    public void authenticateAsServer(X509Certificate serverCertificate) {
        this.authenticateAsServer(serverCertificate, false, 192, false);
    }

    public void authenticateAsServer(X509Certificate serverCertificate, boolean clientCertificateRequired, int enabledSslProtocols, boolean checkCertificateRevocation) {
        this.endAuthenticateAsServer(this.beginAuthenticateAsServer(serverCertificate, clientCertificateRequired, enabledSslProtocols, checkCertificateRevocation, null, null));
    }

    @Override
    protected void dispose(boolean disposing) {
        if (disposing) {
            if (this.a != null) {
                this.a.dispose();
            }
            this.a = null;
        }
        super.dispose(disposing);
    }

    public void endAuthenticateAsClient(IAsyncResult asyncResult) {
        this.a();
        if (this.canRead()) {
            this.a.endRead(asyncResult);
        } else {
            this.a.endWrite(asyncResult);
        }
    }

    public void endAuthenticateAsServer(IAsyncResult asyncResult) {
        this.a();
        if (this.canRead()) {
            this.a.endRead(asyncResult);
        } else {
            this.a.endWrite(asyncResult);
        }
    }

    @Override
    public int endRead(IAsyncResult asyncResult) {
        this.a();
        return this.a.endRead(asyncResult);
    }

    @Override
    public void endWrite(IAsyncResult asyncResult) {
        this.a();
        this.a.endWrite(asyncResult);
    }

    @Override
    public void flush() {
        this.a();
        this.getInnerStream().flush();
    }

    @Override
    public int read(byte[] buffer, int offset, int count) {
        return this.endRead(this.beginRead(buffer, offset, count, null, null));
    }

    @Override
    public long seek(long offset, int origin) {
        throw new NotSupportedException("This stream does not support seek operations");
    }

    @Override
    public void setLength(long value) {
        this.getInnerStream().setLength(value);
    }

    @Override
    public void write(byte[] buffer, int offset, int count) {
        this.endWrite(this.beginWrite(buffer, offset, count, null, null));
    }

    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    private void a() {
        if (!this.isAuthenticated()) {
            throw new InvalidOperationException("This operation is invalid until it is successfully authenticated");
        }
    }
}

