/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Net;

import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.CaseInsensitiveHashCodeProvider;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.Net.CookieException;
import com.aspose.html.internal.ms.System.Net.IPAddress;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.System.Uri;
import com.aspose.html.internal.ms.lang.Operators;

@SerializableAttribute
public final class Cookie {
    private String d;
    private Uri e;
    private boolean f;
    private String g;
    private DateTime h = new DateTime();
    private boolean i;
    private String j;
    private String k;
    private String l;
    private int[] m;
    private boolean n;
    private DateTime o = new DateTime();
    private String p;
    private int q;
    static char[] a = new char[]{' ', '=', ';', ',', '\n', '\r', '\t'};
    static char[] b = new char[]{'\"', ','};
    static String c = "()<>@,;:\\\"/[]?={} \t";
    private boolean r;

    public Cookie() {
        DateTime.MinValue.CloneTo(this.h);
        DateTime.getNow().CloneTo(this.o);
        this.g = StringExtensions.Empty;
        this.j = StringExtensions.Empty;
        this.p = StringExtensions.Empty;
        this.d = StringExtensions.Empty;
        this.l = StringExtensions.Empty;
    }

    public Cookie(String name, String value) {
        this();
        this.setName(name);
        this.setValue(value);
    }

    public Cookie(String name, String value, String path) {
        this(name, value);
        this.setPath(path);
    }

    public Cookie(String name, String value, String path, String domain) {
        this(name, value, path);
        this.setDomain(domain);
    }

    public String getComment() {
        return this.d;
    }

    public void setComment(String value) {
        this.d = value == null ? StringExtensions.Empty : value;
    }

    public Uri getCommentUri() {
        return this.e;
    }

    public void setCommentUri(Uri value) {
        this.e = value;
    }

    public boolean getDiscard() {
        return this.f;
    }

    public void setDiscard(boolean value) {
        this.f = value;
    }

    public String getDomain() {
        return this.g;
    }

    public void setDomain(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            this.g = StringExtensions.Empty;
            this.a(false);
        } else {
            this.g = value;
            IPAddress iPAddress = null;
            IPAddress[] iPAddressArray = new IPAddress[]{iPAddress};
            boolean bl2 = IPAddress.tryParse(value, iPAddressArray);
            iPAddress = iPAddressArray[0];
            if (bl2) {
                this.a(false);
            } else {
                this.a(true);
            }
        }
    }

    boolean a() {
        return this.r;
    }

    void a(boolean bl2) {
        this.r = bl2;
    }

    public boolean getExpired() {
        return DateTime.op_LessThanOrEqual(this.h, DateTime.getNow()) && DateTime.op_Inequality(this.h, DateTime.MinValue);
    }

    public void setExpired(boolean value) {
        if (value) {
            DateTime.getNow().CloneTo(this.h);
        }
    }

    public DateTime getExpires() {
        return this.h;
    }

    public void setExpires(DateTime value) {
        value.CloneTo(this.h);
    }

    public boolean getHttpOnly() {
        return this.i;
    }

    public void setHttpOnly(boolean value) {
        this.i = value;
    }

    public String getName() {
        return this.j;
    }

    public void setName(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            throw new CookieException("Name cannot be empty");
        }
        if (value.charAt(0) == '$' || StringExtensions.indexOfAny(value, a) != -1) {
            this.j = StringExtensions.Empty;
            throw new CookieException("Name contains invalid characters");
        }
        this.j = value;
    }

    public String getPath() {
        return this.k == null ? StringExtensions.Empty : this.k;
    }

    public void setPath(String value) {
        this.k = value == null ? StringExtensions.Empty : value;
    }

    public String getPort() {
        return this.l;
    }

    public void setPort(String value) {
        if (StringExtensions.isNullOrEmpty(value)) {
            this.l = StringExtensions.Empty;
            return;
        }
        if (value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\"') {
            throw new CookieException(StringExtensions.concat("The 'Port'='", value, "' part of the cookie is invalid. Port must be enclosed by double quotes."));
        }
        this.l = value;
        String[] stringArray = StringExtensions.split(this.l, b);
        this.m = new int[Array.boxing(stringArray).getLength()];
        for (int i2 = 0; i2 < Array.boxing(this.m).getLength(); ++i2) {
            this.m[i2] = Integer.MIN_VALUE;
            if (stringArray[i2].length() == 0) continue;
            try {
                this.m[i2] = Int32Extensions.parse(stringArray[i2]);
                continue;
            }
            catch (Exception exception) {
                throw new CookieException(StringExtensions.concat("The 'Port'='", value, "' part of the cookie is invalid. Invalid value: ", stringArray[i2]), exception);
            }
        }
        this.setVersion(1);
    }

    int[] b() {
        return this.m;
    }

    void a(int[] nArray) {
        this.m = nArray;
    }

    public boolean getSecure() {
        return this.n;
    }

    public void setSecure(boolean value) {
        this.n = value;
    }

    public DateTime getTimeStamp() {
        return this.o;
    }

    public String getValue() {
        return this.p;
    }

    public void setValue(String value) {
        if (value == null) {
            this.p = StringExtensions.Empty;
            return;
        }
        this.p = value;
    }

    public int getVersion() {
        return this.q;
    }

    public void setVersion(int value) {
        this.q = value < 0 || value > 10 ? 0 : value;
    }

    public boolean equals(Object comparand) {
        Cookie cookie = Operators.as(comparand, Cookie.class);
        return cookie != null && StringExtensions.compare(this.j, cookie.j, true, CultureInfo.getInvariantCulture()) == 0 && StringExtensions.compare(this.p, cookie.p, false, CultureInfo.getInvariantCulture()) == 0 && StringExtensions.compare(this.getPath(), cookie.getPath(), false, CultureInfo.getInvariantCulture()) == 0 && StringExtensions.compare(this.g, cookie.g, true, CultureInfo.getInvariantCulture()) == 0 && this.q == cookie.q;
    }

    public int hashCode() {
        return Cookie.a(CaseInsensitiveHashCodeProvider.getDefaultInvariant().hashCode(this.j), this.p.hashCode(), this.getPath().hashCode(), CaseInsensitiveHashCodeProvider.getDefaultInvariant().hashCode(this.g), this.q);
    }

    private static int a(int n2, int n3, int n4, int n5, int n6) {
        return n2 ^ (n3 << 13 | n3 >> 19) ^ (n4 << 26 | n4 >> 6) ^ (n5 << 7 | n5 >> 25) ^ (n6 << 20 | n6 >> 12);
    }

    public String toString() {
        return this.a((Uri)null);
    }

    String a(Uri uri) {
        boolean bl2;
        if (this.j.length() == 0) {
            return StringExtensions.Empty;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder(64);
        if (this.q > 0) {
            msStringBuilder2.append("$Version=").append(this.q).append("; ");
        }
        msStringBuilder2.append(this.j).append("=").append(this.p);
        if (this.q == 0) {
            return msStringBuilder2.toString();
        }
        if (!StringExtensions.isNullOrEmpty(this.k)) {
            msStringBuilder2.append("; $Path=").append(this.k);
        }
        boolean bl3 = bl2 = uri == null || !StringExtensions.equals(uri.getHost(), this.g);
        if (bl2 && !StringExtensions.isNullOrEmpty(this.g)) {
            msStringBuilder2.append("; $Domain=").append(this.g);
        }
        if (this.l != null && this.l.length() != 0) {
            msStringBuilder2.append("; $Port=").append(this.l);
        }
        return msStringBuilder2.toString();
    }

    String c() {
        if (this.j.length() == 0) {
            return StringExtensions.Empty;
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder(64);
        if (this.q > 0) {
            msStringBuilder2.append("Version=").append(this.q).append(";");
        }
        msStringBuilder2.append(this.j).append("=").append(this.p);
        if (this.k != null && this.k.length() != 0) {
            msStringBuilder2.append(";Path=").append(this.a(this.k));
        }
        if (this.g != null && this.g.length() != 0) {
            msStringBuilder2.append(";Domain=").append(this.a(this.g));
        }
        if (this.l != null && this.l.length() != 0) {
            msStringBuilder2.append(";Port=").append(this.l);
        }
        return msStringBuilder2.toString();
    }

    private String a(String string) {
        if (this.q == 0 || this.b(string)) {
            return string;
        }
        return StringExtensions.concat("\"", StringExtensions.replace(string, "\"", "\\\""), "\"");
    }

    private boolean b(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ' && c2 < '\u007f' && StringExtensions.indexOf(c, c2) == -1) continue;
            return false;
        }
        return true;
    }
}

