/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Environment;
import com.aspose.html.internal.ms.System.GC;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IO.SynchronizedWriter;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import java.math.BigDecimal;

@SerializableAttribute
public abstract class TextWriter
implements IDisposable {
    protected char[] CoreNewLine = StringExtensions.toCharArray(Environment.NewLine);
    IFormatProvider a;
    public static TextWriter Null = new NullTextWriter();

    protected TextWriter() {
    }

    protected TextWriter(IFormatProvider formatProvider) {
        this.a = formatProvider;
    }

    public abstract Encoding getEncoding();

    public IFormatProvider getFormatProvider() {
        return this.a;
    }

    public String getNewLine() {
        return StringExtensions.newString(this.CoreNewLine);
    }

    public void setNewLine(String value) {
        if (value == null) {
            value = Environment.NewLine;
        }
        this.CoreNewLine = StringExtensions.toCharArray(value);
    }

    public void close() {
        this.dispose(true);
    }

    protected void dispose(boolean disposing) {
        if (disposing) {
            GC.suppressFinalize(this);
        }
    }

    @Override
    public void dispose() {
        this.dispose(true);
        GC.suppressFinalize(this);
    }

    public void flush() {
    }

    public static TextWriter _synchronized(TextWriter writer) {
        return TextWriter.a(writer, false);
    }

    static TextWriter a(TextWriter textWriter, boolean bl2) {
        if (textWriter == null) {
            throw new ArgumentNullException("writer is null");
        }
        if (textWriter instanceof SynchronizedWriter) {
            return textWriter;
        }
        return new SynchronizedWriter(textWriter, bl2);
    }

    public void write(boolean value) {
        this.write(Boolean.toString(value));
    }

    public void write(char value) {
    }

    public void write(char[] buffer) {
        if (buffer == null) {
            return;
        }
        this.write(buffer, 0, buffer.length);
    }

    public void write(BigDecimal value) {
        this.write(value.toString());
    }

    public void write(double value) {
        this.write(Double.toString(value));
    }

    public void write(int value) {
        this.write(Integer.toString(value));
    }

    public void write(long value) {
        this.write(Long.toString(value));
    }

    public void write(Object value) {
        if (value != null) {
            this.write(value.toString());
        }
    }

    public void write(float value) {
        this.write(Float.toString(value));
    }

    public void write(String value) {
        if (value != null) {
            this.write(StringExtensions.toCharArray(value));
        }
    }

    public void write(String format, Object arg0) {
        this.write(StringExtensions.format(format, arg0));
    }

    public void write(String format, Object ... arg) {
        this.write(StringExtensions.format(format, arg));
    }

    public void write(char[] buffer, int index, int count) {
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (index < 0 || index > buffer.length) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (count < 0 || index > buffer.length - count) {
            throw new ArgumentOutOfRangeException("count");
        }
        while (count > 0) {
            this.write(buffer[index]);
            --count;
            ++index;
        }
    }

    public void write(String format, Object arg0, Object arg1) {
        this.write(StringExtensions.format(format, arg0, arg1));
    }

    public void write(String format, Object arg0, Object arg1, Object arg2) {
        this.write(StringExtensions.format(format, arg0, arg1, arg2));
    }

    public void writeLine() {
        this.write(this.CoreNewLine);
    }

    public void writeLine(boolean value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(char value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(char[] buffer) {
        this.write(buffer);
        this.writeLine();
    }

    public void writeLine(BigDecimal value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(double value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(int value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(long value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(Object value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(float value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(String value) {
        this.write(value);
        this.writeLine();
    }

    public void writeLine(String format, Object arg0) {
        this.write(format, arg0);
        this.writeLine();
    }

    public void writeLine(String format, Object ... arg) {
        this.write(format, arg);
        this.writeLine();
    }

    public void writeLine(char[] buffer, int index, int count) {
        this.write(buffer, index, count);
        this.writeLine();
    }

    public void writeLine(String format, Object arg0, Object arg1) {
        this.write(format, arg0, arg1);
        this.writeLine();
    }

    public void writeLine(String format, Object arg0, Object arg1, Object arg2) {
        this.write(format, arg0, arg1, arg2);
        this.writeLine();
    }

    static final class NullTextWriter
    extends TextWriter {
        NullTextWriter() {
        }

        @Override
        public Encoding getEncoding() {
            return Encoding.getDefault();
        }

        @Override
        public void write(String s2) {
        }

        @Override
        public void write(char value) {
        }

        @Override
        public void write(char[] value, int index, int count) {
        }
    }
}

