/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.IO.TextWriter;
import com.aspose.html.internal.ms.System.ObjectDisposedException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;

@SerializableAttribute
public class StringWriter
extends TextWriter {
    private msStringBuilder b;
    private boolean c;

    public StringWriter() {
        this(new msStringBuilder());
    }

    public StringWriter(IFormatProvider formatProvider) {
        this(new msStringBuilder(), formatProvider);
    }

    public StringWriter(msStringBuilder sb) {
        this(sb, null);
    }

    public StringWriter(msStringBuilder sb, IFormatProvider formatProvider) {
        if (sb == null) {
            throw new ArgumentNullException("sb");
        }
        this.b = sb;
        this.a = formatProvider;
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.getUnicode();
    }

    @Override
    public void close() {
        this.dispose(true);
        this.c = true;
    }

    @Override
    protected void dispose(boolean disposing) {
        super.dispose(disposing);
        this.c = true;
    }

    public msStringBuilder getStringBuilder() {
        return this.b;
    }

    public String toString() {
        return this.b.toString();
    }

    @Override
    public void write(char value) {
        if (this.c) {
            throw new ObjectDisposedException("StringReader", "Cannot write to a closed StringWriter");
        }
        this.b.append(value);
    }

    @Override
    public void write(String value) {
        if (this.c) {
            throw new ObjectDisposedException("StringReader", "Cannot write to a closed StringWriter");
        }
        this.b.append(value);
    }

    @Override
    public void write(char[] buffer, int index, int count) {
        if (this.c) {
            throw new ObjectDisposedException("StringReader", "Cannot write to a closed StringWriter");
        }
        if (buffer == null) {
            throw new ArgumentNullException("buffer");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "< 0");
        }
        if (count < 0) {
            throw new ArgumentOutOfRangeException("count", "< 0");
        }
        if (index > buffer.length - count) {
            throw new ArgumentException("index + count > buffer.Length");
        }
        this.b.append(buffer, index, count);
    }
}

