/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.DirectoryInfo;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileNotFoundException;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.FileSystemInfo;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.StreamReader;
import com.aspose.html.internal.ms.System.IO.StreamWriter;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;

@SerializableAttribute
public final class FileInfo
extends FileSystemInfo {
    private boolean b;

    public FileInfo(String fileName) {
        if (fileName == null) {
            throw new ArgumentNullException("fileName");
        }
        this.checkPath(fileName);
        this.OriginalPath = fileName;
        this.FullPath = Path.getFullPath(fileName);
    }

    @Override
    public boolean exists() {
        return new java.io.File(this.FullPath).exists();
    }

    @Override
    public String getName() {
        return Path.getFileName(this.FullPath);
    }

    public long getLength() {
        if (!this.exists()) {
            throw new FileNotFoundException(StringExtensions.concat("Could not find file \"", this.OriginalPath, "\"."), this.OriginalPath);
        }
        java.io.File file = new java.io.File(this.FullPath);
        return file.length();
    }

    public String getDirectoryName() {
        return Path.getDirectoryName(this.FullPath);
    }

    public DirectoryInfo getDirectory() {
        return new DirectoryInfo(this.getDirectoryName());
    }

    public StreamReader openText() {
        return new StreamReader(this.open(3, 1));
    }

    public StreamWriter createText() {
        return new StreamWriter(this.open(2, 2));
    }

    public StreamWriter appendText() {
        return new StreamWriter(this.open(6, 2));
    }

    public FileStream create() {
        return File.create(this.FullPath);
    }

    public FileStream openRead() {
        return this.open(3, 1, 1);
    }

    public FileStream openWrite() {
        return this.open(4, 2);
    }

    public FileStream open(int mode) {
        return this.open(mode, 3);
    }

    public FileStream open(int mode, int access) {
        return this.open(mode, access, 0);
    }

    public FileStream open(int mode, int access, int share) {
        java.io.File file = new java.io.File(this.FullPath);
        if (file.exists() && file.isDirectory()) {
            throw new FileNotFoundException(this.FullPath);
        }
        return new FileStream(this.FullPath, mode, access, share);
    }

    @Override
    public void delete() {
        File.delete(this.FullPath);
    }

    public void moveTo(String destFileName) {
        if (destFileName == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (StringExtensions.equals(destFileName, this.getName()) || StringExtensions.equals(destFileName, this.getFullName())) {
            return;
        }
        if (!File.exists(this.FullPath)) {
            throw new FileNotFoundException();
        }
        File.move(this.FullPath, destFileName);
        this.FullPath = Path.getFullPath(destFileName);
    }

    public FileInfo copyTo(String destFileName) {
        return this.copyTo(destFileName, false);
    }

    public FileInfo copyTo(String destFileName, boolean overwrite) {
        if (destFileName == null) {
            throw new ArgumentNullException("destFileName");
        }
        if (destFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destFileName");
        }
        if (StringExtensions.trim(destFileName).length() == 0) {
            throw new ArgumentException("An empty file name is not valid.");
        }
        String string = Path.getFullPath(destFileName);
        if (overwrite && File.exists(string)) {
            File.delete(string);
        }
        File.copy(this.FullPath, string);
        return new FileInfo(string);
    }

    public String toString() {
        return this.OriginalPath;
    }

    public FileInfo replace(String destinationFileName, String destinationBackupFileName) {
        String string = null;
        if (!this.exists()) {
            throw new FileNotFoundException();
        }
        if (destinationFileName == null) {
            throw new ArgumentNullException("destinationFileName");
        }
        if (destinationFileName.length() == 0) {
            throw new ArgumentException("An empty file name is not valid.", "destinationFileName");
        }
        string = Path.getFullPath(destinationFileName);
        if (!File.exists(string)) {
            throw new FileNotFoundException();
        }
        if (destinationBackupFileName != null) {
            if (destinationBackupFileName.length() == 0) {
                throw new ArgumentException("An empty file name is not valid.", "destinationBackupFileName");
            }
            File.copy(string, Path.getFullPath(destinationBackupFileName), true);
        }
        File.copy(this.FullPath, string, true);
        File.delete(this.FullPath);
        return new FileInfo(string);
    }

    public FileInfo replace(String destinationFileName, String destinationBackupFileName, boolean ignoreMetadataErrors) {
        return this.replace(destinationFileName, destinationBackupFileName);
    }
}

