/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.IO;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.IO.DirectoryInfo;
import com.aspose.html.internal.ms.System.IO.DirectoryNotFoundException;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.IOException;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.StringExtensions;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.Vector;
import java.util.regex.Pattern;

public class Directory {
    public static DirectoryInfo createDirectory(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (path.length() == 0) {
            throw new ArgumentException("Path is empty");
        }
        if (StringExtensions.trim(path).length() == 0) {
            throw new ArgumentException("Only blank characters in path");
        }
        java.io.File file = new java.io.File(path);
        if (file.mkdirs() || file.isDirectory() && file.exists()) {
            return new DirectoryInfo(path, true);
        }
        throw new IOException("DirectoryInfo was not created");
    }

    public static void delete(String path) {
        if (path == null || StringExtensions.trim(path).equals(StringExtensions.Empty)) {
            throw new ArgumentNullException("path");
        }
        java.io.File file = new java.io.File(path);
        if (!file.exists()) {
            throw new DirectoryNotFoundException("Directory was not found");
        }
        if (!file.isDirectory()) {
            throw new IOException("Target path is not directory");
        }
        boolean bl2 = file.delete();
        if (!bl2) {
            throw new IOException("Directory was not deleted");
        }
    }

    public static void delete(String path, boolean recursive) {
        java.io.File file = new java.io.File(path);
        if (recursive) {
            Directory.a(file);
        } else {
            Directory.delete(path);
        }
    }

    static void a(java.io.File file) {
        if (file.isDirectory()) {
            for (java.io.File file2 : file.listFiles()) {
                if (file2.isDirectory()) {
                    Directory.a(file2);
                    continue;
                }
                file2.delete();
            }
        }
        file.delete();
    }

    public static boolean exists(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        return new java.io.File(path).isDirectory();
    }

    public static String getCurrentDirectory() {
        java.io.File file = new java.io.File(".");
        java.io.File file2 = new java.io.File(file.getAbsolutePath());
        return file2.getParent();
    }

    public static String[] getDirectories(String path) {
        return Directory.getDirectories(path, "*");
    }

    public static String[] getDirectories(String path, String searchPattern) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        java.io.File file = new java.io.File(path);
        PatternFileFilter patternFileFilter = new PatternFileFilter(searchPattern, false);
        String[] stringArray = new String[]{};
        String[] stringArray2 = file.list(patternFileFilter);
        if (stringArray2 != null) {
            stringArray = new String[stringArray2.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = Path.combine(file.getAbsolutePath(), stringArray2[i2]);
            }
        }
        return stringArray;
    }

    public static String[] getDirectories(String path, String searchPattern, int searchOption) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (searchOption == 0) {
            return Directory.getDirectories(path, searchPattern);
        }
        Vector<String> vector = new Vector<String>();
        Directory.a(path, searchPattern, vector);
        return vector.toArray(new String[vector.size()]);
    }

    static void a(String string, String string2, Collection<String> collection) {
        for (String string3 : Directory.getDirectories(string)) {
            collection.add(string3);
        }
        for (String string3 : Directory.getDirectories(string)) {
            Directory.a(string3, string2, collection);
        }
    }

    public static String[] getFiles(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        return Directory.getFiles(path, "*.*");
    }

    public static String[] getFiles(String path, String searchPattern) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        java.io.File file = new java.io.File(path);
        PatternFileFilter patternFileFilter = new PatternFileFilter(searchPattern, true);
        String[] stringArray = new String[]{};
        String[] stringArray2 = file.list(patternFileFilter);
        if (stringArray2 != null) {
            stringArray = new String[stringArray2.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = Path.combine(file.getAbsolutePath(), stringArray2[i2]);
            }
        }
        return stringArray;
    }

    public static String[] getFiles(String path, String searchPattern, int searchOption) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (searchOption == 0) {
            return Directory.getFiles(path, searchPattern);
        }
        Vector<String> vector = new Vector<String>();
        Directory.b(path, searchPattern, vector);
        return vector.toArray(new String[vector.size()]);
    }

    static void b(String string, String string2, Collection<String> collection) {
        for (String string3 : Directory.getFiles(string, string2)) {
            collection.add(string3);
        }
        for (String string3 : Directory.getDirectories(string)) {
            Directory.b(string3, string2, collection);
        }
    }

    public static String[] getFileSystemEntries(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        return new java.io.File(path).list();
    }

    public static String[] getFileSystemEntries(String path, String searchPattern) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        return Directory.getFileSystemEntries(path);
    }

    static boolean a(String string) {
        if ("/".equals(string)) {
            return true;
        }
        return string.length() == 3 && StringExtensions.endsWith(string, ":\\");
    }

    public static DirectoryInfo getParent(String path) {
        if (path == null) {
            throw new ArgumentNullException("path");
        }
        if (Directory.a(path)) {
            return null;
        }
        String string = Path.getDirectoryName(path);
        if (string == null || string.length() == 0) {
            string = Directory.getCurrentDirectory();
        }
        return new DirectoryInfo(string);
    }

    public static void move(String sourceDirName, String destDirName) {
        if (sourceDirName == null) {
            throw new ArgumentNullException("sourceDirName");
        }
        if (StringExtensions.trim(sourceDirName).equals(StringExtensions.Empty)) {
            throw new ArgumentException("sourceDirName is empty", "sourceDirName");
        }
        if (destDirName == null) {
            throw new ArgumentNullException("destDirName");
        }
        if (StringExtensions.trim(destDirName).equals(StringExtensions.Empty)) {
            throw new ArgumentException("destDirName is empty", "destDirName");
        }
        if (StringExtensions.equals(sourceDirName, destDirName)) {
            throw new IOException("Source and destination path must be different.");
        }
        if (new java.io.File(destDirName).exists()) {
            throw new IOException(StringExtensions.concat(destDirName, " already exists."));
        }
        if (!Directory.exists(sourceDirName) && !File.exists(sourceDirName)) {
            throw new DirectoryNotFoundException(StringExtensions.concat(sourceDirName, " does not exist"));
        }
        java.io.File file = new java.io.File(sourceDirName);
        if (!file.renameTo(new java.io.File(destDirName))) {
            throw new IOException("File can't be moved");
        }
    }

    private static class PatternFileFilter
    implements FilenameFilter {
        private Pattern a;
        private boolean b;

        public PatternFileFilter(String pattern, boolean isFile) {
            if (pattern == "*.*") {
                this.a = Pattern.compile("^.*$");
            } else {
                pattern = pattern.replace(".", "\\.");
                this.a = Pattern.compile("^" + pattern.replace("*", ".*").replace("?", ".") + "$", 2);
            }
            this.b = isFile;
        }

        @Override
        public boolean accept(java.io.File dir, String name) {
            String string = Path.combine(dir.getAbsolutePath(), name);
            java.io.File file = new java.io.File(string);
            if (this.b && file.isFile() || !this.b && file.isDirectory()) {
                if (file.isFile() && !StringExtensions.contains(name, ".")) {
                    String string2 = this.a.pattern();
                    if (string2.endsWith("\\..*$")) {
                        string2 = StringExtensions.replace(string2, "\\..*$", ".*$");
                    }
                    if (string2.endsWith("\\.$")) {
                        string2 = StringExtensions.replace(string2, "\\.$", "$");
                    }
                    Pattern pattern = Pattern.compile(string2);
                    return pattern.matcher(name).find();
                }
                return this.a.matcher(file.getName()).find();
            }
            return false;
        }
    }
}

