/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Globalization;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.core.mscorlib.b.a;

@SerializableAttribute
public abstract class msCalendar
implements ICloneable,
Cloneable {
    public static int CurrentEra = 0;
    private boolean a;
    int f = -1;

    protected msCalendar() {
    }

    public int getAlgorithmType() {
        return 0;
    }

    public abstract int[] getEras();

    public boolean getIsReadOnly() {
        return this.a;
    }

    public DateTime getMaxSupportedDateTime() {
        return DateTime.MaxValue.Clone();
    }

    public DateTime getMinSupportedDateTime() {
        return DateTime.MinValue.Clone();
    }

    public int getTwoDigitYearMax() {
        return this.f;
    }

    public void setTwoDigitYearMax(int value) {
        this.e();
        this.f = value;
    }

    public abstract int get_current_era_internal();

    public DateTime addDays(DateTime time, int days) {
        return this.a(time, days, 86400000);
    }

    public DateTime addHours(DateTime time, int hours) {
        return this.a(time, hours, 3600000);
    }

    public DateTime addMilliseconds(DateTime time, double milliseconds) {
        return this.a(time, milliseconds, 1);
    }

    public DateTime addMinutes(DateTime time, int minutes) {
        return this.a(time, minutes, 60000);
    }

    public abstract DateTime addMonths(DateTime var1, int var2);

    public DateTime addSeconds(DateTime time, int seconds) {
        return this.a(time, seconds, 1000);
    }

    public DateTime addWeeks(DateTime time, int weeks) {
        return this.addDays(time, weeks * 7);
    }

    public abstract DateTime addYears(DateTime var1, int var2);

    public abstract int getDayOfMonth(DateTime var1);

    public abstract int getDayOfWeek(DateTime var1);

    public abstract int getDayOfYear(DateTime var1);

    public int getDaysInMonth(int year, int month) {
        return this.getDaysInMonth(year, month, 0);
    }

    public abstract int getDaysInMonth(int var1, int var2, int var3);

    public int getDaysInYear(int year) {
        return this.getDaysInYear(year, 0);
    }

    public abstract int getDaysInYear(int var1, int var2);

    public abstract int getEra(DateTime var1);

    public int getHour(DateTime time) {
        return (int)(time.getTicks() / 36000000000L % 24L);
    }

    public int getLeapMonth(int year) {
        return this.getLeapMonth(year, 0);
    }

    public int getLeapMonth(int year, int era) {
        if (this.isLeapYear(year, era)) {
            int n2 = this.getMonthsInYear(year, era);
            for (int i2 = 1; i2 <= n2; ++i2) {
                if (!this.isLeapMonth(year, i2, era)) continue;
                return i2;
            }
        }
        return 0;
    }

    public double getMilliseconds(DateTime time) {
        return time.getTicks() / 10000L % 1000L;
    }

    public int getMinute(DateTime time) {
        return (int)(time.getTicks() / 600000000L % 60L);
    }

    public abstract int getMonth(DateTime var1);

    public int getMonthsInYear(int year) {
        return this.getMonthsInYear(year, 0);
    }

    public abstract int getMonthsInYear(int var1, int var2);

    public int getSecond(DateTime time) {
        return (int)(time.getTicks() / 10000000L % 60L);
    }

    public int getWeekOfYear(DateTime time, int rule, int firstDayOfWeek) {
        if (firstDayOfWeek < 0 || firstDayOfWeek > 6) {
            throw new ArgumentOutOfRangeException("firstDayOfWeek");
        }
        switch (rule) {
            case 0: {
                return this.b(time, firstDayOfWeek);
            }
            case 1: {
                return this.a(time, rule, firstDayOfWeek, 7);
            }
            case 2: {
                return this.a(time, rule, firstDayOfWeek, 4);
            }
        }
        throw new ArgumentOutOfRangeException("rule");
    }

    public abstract int getYear(DateTime var1);

    public boolean isLeapDay(int year, int month, int day) {
        return this.isLeapDay(year, month, day, 0);
    }

    public abstract boolean isLeapDay(int var1, int var2, int var3, int var4);

    public boolean isLeapMonth(int year, int month) {
        return this.isLeapMonth(year, month, 0);
    }

    public abstract boolean isLeapMonth(int var1, int var2, int var3);

    public boolean isLeapYear(int year) {
        return this.isLeapYear(year, 0);
    }

    public abstract boolean isLeapYear(int var1, int var2);

    boolean a(int n2, int n3, int n4, int n5) {
        return this.c(n2, n3, n5) && n4 >= 1 && n4 <= this.getDaysInMonth(n2, n3, n5);
    }

    boolean c(int n2, int n3, int n4) {
        return this.a_(n2, n4) && n3 >= 1 && n3 <= this.getMonthsInYear(n2, n4);
    }

    boolean a_(int n2, int n3) {
        return n2 >= this.getYear(this.getMinSupportedDateTime()) && n2 <= this.getYear(this.getMaxSupportedDateTime());
    }

    public Object clone() {
        msCalendar msCalendar2 = (msCalendar)this.deepClone();
        msCalendar2.a(false);
        return msCalendar2;
    }

    public static msCalendar readOnly(msCalendar calendar) {
        if (calendar == null) {
            throw new ArgumentNullException("calendar");
        }
        if (calendar.getIsReadOnly()) {
            return calendar;
        }
        msCalendar msCalendar2 = (msCalendar)calendar.clone();
        msCalendar2.a(true);
        return msCalendar2;
    }

    public DateTime toDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return this.toDateTime(year, month, day, hour, minute, second, millisecond, 0);
    }

    public abstract DateTime toDateTime(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public int toFourDigitYear(int year) {
        if (year < 0) {
            throw new ArgumentOutOfRangeException("year");
        }
        if (year < 100) {
            return (this.getTwoDigitYearMax() / 100 - (year > this.getTwoDigitYearMax() % 100 ? 1 : 0)) * 100 + year;
        }
        return year;
    }

    void a(boolean bl2) {
        this.a = bl2;
    }

    static long b(int n2, int n3, int n4, int n5) {
        if (n2 < 0 || n2 >= 24 || n3 < 0 || n3 >= 60 || n4 < 0 || n4 >= 60) {
            throw new ArgumentOutOfRangeException(null);
        }
        if (n5 < 0 || n5 >= 1000) {
            throw new ArgumentOutOfRangeException("millisecond");
        }
        return msCalendar.d(n2, n3, n4) + (long)n5 * 10000L;
    }

    static long d(int n2, int n3, int n4) {
        long l2 = (long)n2 * 3600L + (long)n3 * 60L + (long)n4;
        if (l2 > 922337203685L || l2 < -922337203685L) {
            throw new ArgumentOutOfRangeException("Overflow_TimeSpanTooLong");
        }
        return l2 * 10000000L;
    }

    DateTime a(DateTime dateTime, double d2, int n2) {
        long l2 = (long)(d2 * (double)n2 + (d2 >= 0.0 ? 0.5 : -0.5));
        if (l2 <= -315537897600000L || l2 >= 315537897600000L) {
            throw new ArgumentOutOfRangeException("value");
        }
        long l3 = dateTime.getTicks() + l2 * 10000L;
        com.aspose.html.internal.ms.core.mscorlib.b.a.a(l3, this.getMinSupportedDateTime(), this.getMaxSupportedDateTime());
        return new DateTime(l3);
    }

    int b(DateTime dateTime, int n2) {
        int n3 = this.getDayOfYear(dateTime) - 1;
        int n4 = n3 % 7;
        int n5 = this.getDayOfWeek(dateTime) - n4;
        int n6 = (n5 - n2 + 14) % 7;
        return (n3 + n6) / 7 + 1;
    }

    void e() {
        if (this.a) {
            throw new InvalidOperationException("InvalidOperation_ReadOnly");
        }
    }

    int a(DateTime dateTime, int n2, int n3, int n4) {
        int n5;
        int n6 = this.getDayOfYear(dateTime) - 1;
        int n7 = this.getDayOfWeek(dateTime) - n6 % 7;
        int n8 = (n3 - n7 + 14) % 7;
        if (n8 != 0 && n8 >= n4) {
            n8 -= 7;
        }
        if ((n5 = n6 - n8) >= 0) {
            return n5 / 7 + 1;
        }
        return this.a(dateTime.addDays(-(n6 + 1)), n2, n3, n4);
    }
}

