/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Globalization;

import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Char;
import com.aspose.html.internal.ms.System.Collections.ArrayList;
import com.aspose.html.internal.ms.System.Globalization.TextElementEnumerator;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;

@SerializableAttribute
public class StringInfo {
    private String a;
    private int b;

    public StringInfo() {
        this(StringExtensions.Empty);
    }

    public StringInfo(String value) {
        this.setString(value);
    }

    public boolean equals(Object value) {
        StringInfo stringInfo = Operators.as(value, StringInfo.class);
        return stringInfo != null && StringExtensions.equals(this.a, stringInfo.a);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public int getLengthInTextElements() {
        if (this.b < 0) {
            this.b = 0;
            int n2 = 0;
            while (n2 < this.a.length()) {
                n2 += StringInfo.a(this.a, n2);
                ++this.b;
            }
        }
        return this.b;
    }

    public String getString() {
        return this.a;
    }

    public void setString(String value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        this.b = -1;
        this.a = value;
    }

    public String substringByTextElements(int startingTextElement) {
        if (startingTextElement < 0 || this.a.length() == 0) {
            throw new ArgumentOutOfRangeException("startingTextElement");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < startingTextElement; ++i2) {
            if (n2 >= this.a.length()) {
                throw new ArgumentOutOfRangeException("startingTextElement");
            }
            n2 += StringInfo.a(this.a, n2);
        }
        return StringExtensions.substring(this.a, n2);
    }

    public String substringByTextElements(int startingTextElement, int lengthInTextElements) {
        int n2;
        if (startingTextElement < 0 || this.a.length() == 0) {
            throw new ArgumentOutOfRangeException("startingTextElement");
        }
        if (lengthInTextElements < 0) {
            throw new ArgumentOutOfRangeException("lengthInTextElements");
        }
        int n3 = 0;
        for (n2 = 0; n2 < startingTextElement; ++n2) {
            if (n3 >= this.a.length()) {
                throw new ArgumentOutOfRangeException("startingTextElement");
            }
            n3 += StringInfo.a(this.a, n3);
        }
        n2 = n3;
        for (int i2 = 0; i2 < lengthInTextElements; ++i2) {
            if (n3 >= this.a.length()) {
                throw new ArgumentOutOfRangeException("lengthInTextElements");
            }
            n3 += StringInfo.a(this.a, n3);
        }
        return StringExtensions.substring(this.a, n2, n3 - n2);
    }

    public static String getNextTextElement(String str) {
        if (str == null || str.length() == 0) {
            throw new ArgumentNullException("string is null");
        }
        return StringInfo.getNextTextElement(str, 0);
    }

    public static String getNextTextElement(String str, int index) {
        int n2 = StringInfo.a(str, index);
        return n2 != 1 ? StringExtensions.substring(str, index, n2) : StringExtensions.newString(str.charAt(index), 1);
    }

    static int a(String string, int n2) {
        if (string == null) {
            throw new ArgumentNullException("string is null");
        }
        if (n2 >= string.length()) {
            return 0;
        }
        if (n2 < 0) {
            throw new ArgumentOutOfRangeException("Index is not valid");
        }
        char c2 = string.charAt(n2);
        int n3 = Char.getUnicodeCategory(c2);
        if (n3 == 16) {
            if (c2 >= '\ud800' && c2 <= '\udbff') {
                if (n2 + 1 < string.length() && string.charAt(n2 + 1) >= '\udc00' && string.charAt(n2 + 1) <= '\udfff') {
                    return 2;
                }
                return 1;
            }
            return 1;
        }
        if (n3 == 5 || n3 == 6 || n3 == 7) {
            return 1;
        }
        int n4 = 1;
        while (n2 + n4 < string.length() && ((n3 = Char.getUnicodeCategory(string.charAt(n2 + n4))) == 5 || n3 == 6 || n3 == 7)) {
            ++n4;
        }
        return n4;
    }

    public static TextElementEnumerator getTextElementEnumerator(String str) {
        if (str == null || str.length() == 0) {
            throw new ArgumentNullException("string is null");
        }
        return new TextElementEnumerator(str, 0);
    }

    public static TextElementEnumerator getTextElementEnumerator(String str, int index) {
        if (str == null) {
            throw new ArgumentNullException("string is null");
        }
        if (index < 0 || index >= str.length()) {
            throw new ArgumentOutOfRangeException("Index is not valid");
        }
        return new TextElementEnumerator(str, index);
    }

    public static int[] parseCombiningCharacters(String str) {
        if (str == null) {
            throw new ArgumentNullException("string is null");
        }
        ArrayList arrayList = new ArrayList(str.length());
        TextElementEnumerator textElementEnumerator = StringInfo.getTextElementEnumerator(str);
        textElementEnumerator.reset();
        while (textElementEnumerator.hasNext()) {
            arrayList.addItem(textElementEnumerator.getElementIndex());
        }
        return (int[])Array.unboxing(arrayList.toArray(Operators.typeOf(Integer.TYPE)));
    }
}

