/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Globalization;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Globalization.msCalendar;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.core.mscorlib.b.a;

@SerializableAttribute
public class PersianCalendar
extends msCalendar {
    public static final int PersianEra = 1;
    static int[] a = new int[]{0, 31, 62, 93, 124, 155, 186, 216, 246, 276, 306, 336};
    static int[] b = new int[]{0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0};
    static DateTime c = new DateTime(622, 3, 21);
    static DateTime d = DateTime.MaxValue.Clone();

    @Override
    public int getAlgorithmType() {
        return 1;
    }

    @Override
    public int[] getEras() {
        return new int[]{1};
    }

    @Override
    public DateTime getMaxSupportedDateTime() {
        return d;
    }

    @Override
    public DateTime getMinSupportedDateTime() {
        return c;
    }

    @Override
    public int getTwoDigitYearMax() {
        if (this.f == -1) {
            this.f = 1410;
        }
        return this.f;
    }

    @Override
    public void setTwoDigitYearMax(int value) {
        super.e();
        if (value < 99 || value > 9378) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.f = value;
    }

    @Override
    public DateTime addMonths(DateTime time, int months) {
        if (months < -120000 || months > 120000) {
            throw new ArgumentOutOfRangeException("months");
        }
        int n2 = this.a(time.getTicks(), 0);
        int n3 = this.a(time.getTicks(), 2);
        int n4 = this.a(time.getTicks(), 3);
        int n5 = n3 - 1 + months;
        if (n5 < 0) {
            n3 = 12 + (n5 + 1) % 12;
            n2 += (n5 - 11) / 12;
        } else {
            n3 = n5 % 12 + 1;
            n2 += n5 / 12;
        }
        int n6 = this.getDaysInMonth(n2, n3);
        if (n4 > n6) {
            n4 = n6;
        }
        long l2 = 864000000000L * this.b(n2, n3, n4) + time.getTicks() % 864000000000L;
        com.aspose.html.internal.ms.core.mscorlib.b.a.a(l2, this.getMinSupportedDateTime(), this.getMaxSupportedDateTime());
        return new DateTime(l2);
    }

    @Override
    public DateTime addYears(DateTime time, int years) {
        return this.addMonths(time, years * 12);
    }

    @Override
    public int getDayOfMonth(DateTime time) {
        return this.a(time.getTicks(), 3);
    }

    @Override
    public int getDayOfWeek(DateTime time) {
        return (int)(1L + time.getTicks() / 864000000000L) % 7;
    }

    @Override
    public int getDayOfYear(DateTime time) {
        return this.a(time.getTicks(), 1);
    }

    @Override
    public int getDaysInMonth(int year, int month, int era) {
        PersianCalendar.a(year, month, era);
        if (year != 9378 || month != 10) {
            if (month != 12) {
                if (month <= 6) {
                    return 31;
                }
                return 30;
            }
            if (this.isLeapYear(year, 0)) {
                return 30;
            }
            return 29;
        }
        return 10;
    }

    @Override
    public int getDaysInYear(int year, int era) {
        PersianCalendar.b(year, era);
        if (year != 9378) {
            if (this.isLeapYear(year, 0)) {
                return 366;
            }
            return 365;
        }
        return a[9] + 10;
    }

    @Override
    public int getEra(DateTime time) {
        PersianCalendar.a(time.getTicks());
        return 1;
    }

    @Override
    public int getLeapMonth(int year, int era) {
        PersianCalendar.b(year, era);
        return 0;
    }

    @Override
    public int getMonth(DateTime time) {
        return this.a(time.getTicks(), 2);
    }

    @Override
    public int getMonthsInYear(int year, int era) {
        PersianCalendar.b(year, era);
        if (year != 9378) {
            return 12;
        }
        return 10;
    }

    @Override
    public int getYear(DateTime time) {
        return this.a(time.getTicks(), 0);
    }

    @Override
    public boolean isLeapDay(int year, int month, int day, int era) {
        int n2 = this.getDaysInMonth(year, month, era);
        if (day > n2 || day < 1) {
            throw new ArgumentOutOfRangeException("day");
        }
        return day == 30 && month == 12 && this.isLeapYear(year, era);
    }

    @Override
    public boolean isLeapMonth(int year, int month, int era) {
        PersianCalendar.a(year, month, era);
        return false;
    }

    @Override
    public boolean isLeapYear(int year, int era) {
        PersianCalendar.b(year, era);
        return b[year % 33] == 1;
    }

    @Override
    public DateTime toDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era) {
        int n2 = this.getDaysInMonth(year, month, era);
        if (day > n2 || day < 1) {
            throw new ArgumentOutOfRangeException("day");
        }
        long l2 = this.b(year, month, day);
        if (l2 >= 0L) {
            return new DateTime(l2 * 864000000000L + msCalendar.b(hour, minute, second, millisecond));
        }
        throw new ArgumentOutOfRangeException(null);
    }

    @Override
    public int toFourDigitYear(int year) {
        if (year < 100) {
            return super.toFourDigitYear(year);
        }
        if (year > 9378) {
            throw new ArgumentOutOfRangeException("year");
        }
        return year;
    }

    @Override
    public int get_current_era_internal() {
        return 1;
    }

    @Override
    public Object deepClone() {
        PersianCalendar persianCalendar = new PersianCalendar();
        persianCalendar.setTwoDigitYearMax(this.getTwoDigitYearMax());
        return persianCalendar;
    }

    static void a(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
    }

    static void a(long l2) {
        if (l2 > d.getTicks() || l2 < c.getTicks()) {
            throw new ArgumentOutOfRangeException("time");
        }
    }

    static void a(int n2, int n3, int n4) {
        PersianCalendar.b(n2, n4);
        if (n2 == 9378 && n3 > 10) {
            throw new ArgumentOutOfRangeException("month");
        }
        if (n3 > 12 || n3 < 1) {
            throw new ArgumentOutOfRangeException("month");
        }
    }

    static void b(int n2, int n3) {
        PersianCalendar.a(n3);
        if (9378 < n2 || n2 < 1) {
            throw new ArgumentOutOfRangeException("year");
        }
    }

    private long b(int n2) {
        int n3 = (n2 - 1) / 33;
        long l2 = (long)n3 * 12053L + 226894L;
        for (int i2 = (n2 - 1) % 33; i2 > 0; --i2) {
            l2 += 365L;
            if (!this.isLeapYear(i2, 0)) continue;
            ++l2;
        }
        return l2;
    }

    private long b(int n2, int n3, int n4) {
        if (n2 < 1 || n2 > 9378 || n3 < 1 || n3 > 12) {
            throw new ArgumentOutOfRangeException(null);
        }
        return this.b(n2) + (long)a[n3 - 1] + (long)n4 - 1L;
    }

    int a(long l2, int n2) {
        int n3;
        PersianCalendar.a(l2);
        long l3 = l2 / 864000000000L + 1L;
        int n4 = (int)(33L * (l3 - 226894L) / 12053L) + 1;
        long l4 = this.b(n4);
        long l5 = this.getDaysInYear(n4, 0);
        if (l3 < l4) {
            l4 -= l5;
            --n4;
        } else if (l3 == l4) {
            l4 -= (long)this.getDaysInYear(--n4, 0);
        } else if (l3 > l4 + l5) {
            l4 += l5;
            ++n4;
        }
        if (n2 == 0) {
            return n4;
        }
        l3 -= l4;
        if (n2 == 1) {
            return (int)l3;
        }
        for (n3 = 0; n3 < 12 && l3 > (long)a[n3]; ++n3) {
        }
        if (n2 != 2) {
            int n5 = (int)l3 - a[n3 - 1];
            if (n2 != 3) {
                throw new InvalidOperationException("InvalidOperation_DateTimeParsing");
            }
            return n5;
        }
        return n3;
    }
}

