/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Globalization;

import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Globalization.msCalendar;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.core.mscorlib.b.a;

@SerializableAttribute
public class GregorianCalendar
extends msCalendar {
    int a;
    public static int ADEra = 1;
    private static msCalendar b;

    public GregorianCalendar() {
        this(1);
    }

    public GregorianCalendar(int type) {
        if (type < 1 || type > 12) {
            throw new ArgumentOutOfRangeException("type");
        }
        this.a = type;
    }

    @Override
    public int getAlgorithmType() {
        return 1;
    }

    public int get_CalendarType() {
        return this.a;
    }

    public void set_CalendarType(int value) {
        super.e();
        switch (value) {
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                this.a = value;
                return;
            }
        }
        throw new ArgumentOutOfRangeException("gregorianCalendarType");
    }

    @Override
    public int[] getEras() {
        return new int[]{1};
    }

    @Override
    public DateTime getMaxSupportedDateTime() {
        return DateTime.MaxValue.Clone();
    }

    @Override
    public DateTime getMinSupportedDateTime() {
        return DateTime.MinValue.Clone();
    }

    @Override
    public int getTwoDigitYearMax() {
        if (this.f == -1) {
            this.f = 2029;
        }
        return this.f;
    }

    @Override
    public void setTwoDigitYearMax(int value) {
        super.e();
        if (value < 99 || value > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        this.f = value;
    }

    @Override
    public DateTime addMonths(DateTime time, int months) {
        if (months < -120000 || months > 120000) {
            throw new ArgumentOutOfRangeException("months");
        }
        int n2 = com.aspose.html.internal.ms.core.mscorlib.b.a.a(time.getTicks(), 0);
        int n3 = com.aspose.html.internal.ms.core.mscorlib.b.a.a(time.getTicks(), 2);
        int n4 = com.aspose.html.internal.ms.core.mscorlib.b.a.a(time.getTicks(), 3);
        int n5 = n3 - 1 + months;
        if (n5 < 0) {
            n3 = 12 + (n5 + 1) % 12;
            n2 += (n5 - 11) / 12;
        } else {
            n3 = n5 % 12 + 1;
            n2 += n5 / 12;
        }
        int[] nArray = n2 % 4 == 0 && (n2 % 100 != 0 || n2 % 400 == 0) ? com.aspose.html.internal.ms.core.mscorlib.b.a.b : com.aspose.html.internal.ms.core.mscorlib.b.a.a;
        int n6 = nArray[n3] - nArray[n3 - 1];
        if (n4 > n6) {
            n4 = n6;
        }
        long l2 = this.a(n2, n3, n4) + time.getTicks() % 864000000000L;
        com.aspose.html.internal.ms.core.mscorlib.b.a.a(l2, this.getMinSupportedDateTime(), this.getMaxSupportedDateTime());
        return new DateTime(l2);
    }

    @Override
    public DateTime addYears(DateTime time, int years) {
        return this.addMonths(time, years * 12);
    }

    @Override
    public int getDayOfMonth(DateTime time) {
        return com.aspose.html.internal.ms.core.mscorlib.b.a.a(time.getTicks(), 3);
    }

    @Override
    public int getDayOfWeek(DateTime time) {
        return (int)(time.getTicks() / 864000000000L + 1L) % 7;
    }

    @Override
    public int getDayOfYear(DateTime time) {
        return com.aspose.html.internal.ms.core.mscorlib.b.a.a(time.getTicks(), 1);
    }

    @Override
    public int getDaysInMonth(int year, int month, int era) {
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        if (month < 1 || month > 12) {
            throw new ArgumentOutOfRangeException("month");
        }
        int[] nArray = year % 4 == 0 && (year % 100 != 0 || year % 400 == 0) ? com.aspose.html.internal.ms.core.mscorlib.b.a.b : com.aspose.html.internal.ms.core.mscorlib.b.a.a;
        return nArray[month] - nArray[month - 1];
    }

    @Override
    public int getDaysInYear(int year, int era) {
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        if (year % 4 != 0 || year % 100 == 0 && year % 400 != 0) {
            return 365;
        }
        return 366;
    }

    public static msCalendar getDefaultInstance() {
        if (b == null) {
            b = new GregorianCalendar();
        }
        return b;
    }

    @Override
    public int getEra(DateTime time) {
        return 1;
    }

    @Override
    public int getLeapMonth(int year, int era) {
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        return 0;
    }

    @Override
    public int getMonth(DateTime time) {
        return com.aspose.html.internal.ms.core.mscorlib.b.a.a(time.getTicks(), 2);
    }

    @Override
    public int getMonthsInYear(int year, int era) {
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        return 12;
    }

    @Override
    public int getWeekOfYear(DateTime time, int rule, int firstDayOfWeek) {
        if (firstDayOfWeek < 0 || firstDayOfWeek > 6) {
            throw new ArgumentOutOfRangeException("firstDayOfWeek");
        }
        switch (rule) {
            case 0: {
                return super.b(time, firstDayOfWeek);
            }
            case 1: {
                return com.aspose.html.internal.ms.core.mscorlib.b.a.a(this, time, firstDayOfWeek, 7, 365);
            }
            case 2: {
                return com.aspose.html.internal.ms.core.mscorlib.b.a.a(this, time, firstDayOfWeek, 4, 365);
            }
        }
        throw new ArgumentOutOfRangeException("rule");
    }

    @Override
    public int getYear(DateTime time) {
        return com.aspose.html.internal.ms.core.mscorlib.b.a.a(time.getTicks(), 0);
    }

    @Override
    public boolean isLeapDay(int year, int month, int day, int era) {
        if (month < 1 || month > 12) {
            throw new ArgumentOutOfRangeException("month");
        }
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        if (day < 1 || day > this.getDaysInMonth(year, month)) {
            throw new ArgumentOutOfRangeException("day");
        }
        if (!this.isLeapYear(year)) {
            return false;
        }
        return month == 2 && day == 29;
    }

    @Override
    public boolean isLeapMonth(int year, int month, int era) {
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        if (month < 1 || month > 12) {
            throw new ArgumentOutOfRangeException("month");
        }
        return false;
    }

    @Override
    public boolean isLeapYear(int year, int era) {
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        if (year < 1 || year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        if (year % 4 != 0) {
            return false;
        }
        return year % 100 != 0 || year % 400 == 0;
    }

    @Override
    public DateTime toDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era) {
        if (era != 0 && era != 1) {
            throw new ArgumentOutOfRangeException("era");
        }
        return new DateTime(year, month, day, hour, minute, second, millisecond);
    }

    @Override
    public int toFourDigitYear(int year) {
        if (year > 9999) {
            throw new ArgumentOutOfRangeException("year");
        }
        return super.toFourDigitYear(year);
    }

    @Override
    public int get_current_era_internal() {
        return 1;
    }

    @Override
    public Object deepClone() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.get_CalendarType());
        gregorianCalendar.setTwoDigitYearMax(this.getTwoDigitYearMax());
        return gregorianCalendar;
    }

    long a(int n2, int n3, int n4) {
        return com.aspose.html.internal.ms.core.mscorlib.b.a.a(n2, n3, n4) * 864000000000L;
    }
}

