/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Int16Extensions;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.Int64Extensions;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.OverflowException;
import com.aspose.html.internal.ms.System.SByteExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.UInt16Extensions;
import com.aspose.html.internal.ms.System.UInt32Extensions;
import com.aspose.html.internal.ms.System.UInt64Extensions;
import com.aspose.html.internal.ms.System.ValueType;
import com.aspose.html.internal.ms.lang.Operators;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class Enum
extends ValueType<Enum> {
    public static final char[] EnumSeparatorCharArray = new char[]{','};
    private static volatile transient EnumMap a = new EnumMap();

    public static void register(AbstractEnum e2) {
        a.put(e2.getEnumClass(), e2);
    }

    private static AbstractEnum a(Class<?> clazz) {
        if (!a.containsKey(clazz)) {
            try {
                Class.forName(clazz.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!a.containsKey(clazz)) {
                throw new IllegalStateException();
            }
        }
        return (AbstractEnum)a.get(clazz);
    }

    private static AbstractEnum.ConstantMap b(Class<?> clazz) {
        AbstractEnum abstractEnum = Enum.a(clazz);
        return abstractEnum.constants;
    }

    public static String getName(Class<?> enumType, long value) {
        return Enum.a(enumType).getName(value);
    }

    public static long getValue(Class<?> enumType, String name) {
        return Enum.a(enumType).getValue(name, false);
    }

    public long get_Value() {
        throw new InvalidOperationException("should be overrided");
    }

    public String get_Caption() {
        throw new InvalidOperationException("should be overrided");
    }

    public static Collection<String> getNames(Class<?> enumType) {
        return Enum.b(enumType).values();
    }

    public static String[] getNames(Type enumType) {
        return Enum.b(enumType.getJavaClass()).values().toArray(new String[0]);
    }

    public static Array getValues(Type enumType) {
        Set set = Enum.b(enumType.getJavaClass()).keySet();
        return Array.boxing(set.toArray(new Long[set.size()]));
    }

    @Deprecated
    public static boolean isDefined(Class<?> enumType, long value) {
        return Enum.b(enumType).containsKey(value);
    }

    public static boolean isDefined(Type enumType, long value) {
        return Enum.isDefined(enumType.getJavaClass(), value);
    }

    public static boolean isDefined(Type enumType, String value) {
        return Enum.b(enumType.getJavaClass()).containsValue(value);
    }

    public static boolean isDefined(Type enumType, Object value) {
        if (value instanceof String) {
            return Enum.isDefined(enumType, (String)value);
        }
        if (value instanceof Long) {
            return Enum.isDefined(enumType, (long)((Long)value));
        }
        if (value instanceof Integer) {
            return Enum.isDefined(enumType, ((Integer)value).longValue());
        }
        if (value instanceof Short) {
            return Enum.isDefined(enumType, ((Short)value).longValue());
        }
        if (value instanceof Byte) {
            return Enum.isDefined(enumType, ((Byte)value).longValue());
        }
        return false;
    }

    public static String format(Class<?> enumType, long value, String format) {
        throw new NotImplementedException();
    }

    public static String format(Type enumType, Object value, String format) {
        if (enumType == null) {
            throw new ArgumentNullException("enumType");
        }
        if (!enumType.isEnum()) {
            throw new ArgumentException("Type provided must be an Enum.", "enumType");
        }
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (format == null) {
            throw new ArgumentNullException("format");
        }
        Type type = Operators.typeOf(value.getClass());
        Type type2 = Enum.getUnderlyingType(enumType);
        long l2 = 0L;
        if (type.isEnum()) {
            if (type != enumType) {
                throw new ArgumentException(StringExtensions.format("Object must be the same type as the enum. The type passed in was '{0}'; the enum type was '{1}'.", type.toString(), enumType.toString()));
            }
            if (type.getBaseType().equals(Operators.typeOf(ObjectEnum.class))) {
                l2 = ((Enum)value).get_Value();
            } else if (type.equals(Operators.typeOf(Long.class)) || type.equals(Operators.typeOf(Long.TYPE))) {
                l2 = (Long)value;
            } else if (type.equals(Operators.typeOf(String.class))) {
                l2 = Enum.getValue(enumType.getJavaClass(), (String)value);
            }
        } else {
            if (type != type2) {
                throw new ArgumentException(StringExtensions.format("Enum underlying type and the object must be same type or object. Type passed in was '{0}'; the enum underlying type was '{1}'.", type.toString(), type2.toString()));
            }
            l2 = Convert.toInt64(value);
        }
        if (format.length() != 1) {
            throw new FormatException("Format String can be only \"G\", \"g\", \"X\", \"x\", \"F\", \"f\", \"D\" or \"d\".");
        }
        char c2 = format.charAt(0);
        switch (c2) {
            case 'D': 
            case 'd': {
                return Int64Extensions.toString(l2);
            }
            case 'X': 
            case 'x': {
                return Enum.a(l2);
            }
            case 'F': 
            case 'G': 
            case 'f': 
            case 'g': {
                return Enum.getName(enumType.getJavaClass(), l2);
            }
        }
        throw new FormatException("Format String can be only \"G\", \"g\", \"X\", \"x\", \"F\", \"f\", \"D\" or \"d\".");
    }

    private static String a(Object object) {
        switch (Type.getTypeCode(Operators.typeOf(object.getClass()))) {
            case 5: {
                byte by2 = (Byte)object;
                return SByteExtensions.toString(by2, "X2", null);
            }
            case 6: {
                byte by3 = (Byte)object;
                return ByteExtensions.toString(by3, "X2", null);
            }
            case 7: {
                short s2 = (Short)object;
                return Int16Extensions.toString(s2, "X4", null);
            }
            case 8: {
                int n2 = (Integer)object;
                return UInt16Extensions.toString(n2, "X4", null);
            }
            case 9: {
                int n3 = (Integer)object;
                return Int32Extensions.toString(n3, "X8", null);
            }
            case 10: {
                long l2 = (Long)object;
                return UInt32Extensions.toString(l2, "X8", null);
            }
            case 11: {
                long l3 = (Long)object;
                return Int64Extensions.toString(l3, "X16", null);
            }
            case 12: {
                long l4 = (Long)object;
                return UInt64Extensions.toString(l4, "X16", null);
            }
        }
        throw new InvalidOperationException("Unknown enum type.");
    }

    public static long parse(Class<?> enumType, String value) {
        return Enum.parse(enumType, value, (Boolean)false);
    }

    public static long parse(Class<?> enumType, String value, Boolean ignoreCase) {
        Object object;
        String[] stringArray = StringExtensions.split(value, EnumSeparatorCharArray);
        if (stringArray.length == 1 && Int64Extensions.tryParse(value, 7, null, (long[])(object = new long[1]))) {
            if (object[0] > Integer.MAX_VALUE || object[0] < Integer.MIN_VALUE) {
                throw new OverflowException();
            }
            return object[0];
        }
        object = Enum.a(enumType);
        long l2 = 0L;
        for (String string : stringArray) {
            l2 += ((AbstractEnum)object).getValue(string.trim(), ignoreCase);
        }
        return l2;
    }

    public static long parse(Type enumType, String value) {
        return Enum.parse(enumType.getJavaClass(), value);
    }

    public static long parse(Type enumType, String value, Boolean ignoreCase) {
        return Enum.parse(enumType.getJavaClass(), value, ignoreCase);
    }

    public static Class<? extends Number> getUnderlyingType(Class<?> enumType) {
        AbstractEnum abstractEnum = Enum.a(enumType);
        return abstractEnum.getUnderlineClass();
    }

    public static Type getUnderlyingType(Type enumType) {
        return Operators.typeOf(Enum.getUnderlyingType(enumType.getJavaClass()));
    }

    public static Object toObject(Type enumType, Object value) {
        throw new NotImplementedException();
    }

    @Override
    public void CloneTo(Enum that) {
    }

    @Override
    public Enum Clone() {
        return this;
    }

    protected static class EnumMap
    extends HashMap<Class<?>, AbstractEnum> {
        protected EnumMap() {
        }
    }

    public static abstract class ObjectEnum
    extends Enum {
        private long a;
        private String b;

        protected ObjectEnum(long value, String caption) {
            this.a = value;
            this.b = caption;
        }

        @Override
        public final long get_Value() {
            return this.a;
        }

        @Override
        public final String get_Caption() {
            return this.b;
        }

        public static <T extends ObjectEnum> T getEnum(Class<T> enumType, long value) {
            String string = ObjectEnum.getName(enumType, value);
            try {
                Constructor<T> constructor = enumType.getConstructor(Long.TYPE, String.class);
                return (T)((ObjectEnum)constructor.newInstance(value, string));
            }
            catch (Exception exception) {
                throw new InvalidOperationException();
            }
        }

        public <T extends ObjectEnum> T OR(T value) {
            return (T)ObjectEnum.getEnum(this.getClass(), this.get_Value() | value.get_Value());
        }

        public <T extends ObjectEnum> T XOR(T value) {
            return (T)ObjectEnum.getEnum(this.getClass(), this.get_Value() ^ value.get_Value());
        }

        public <T extends ObjectEnum> T AND(T value) {
            return (T)ObjectEnum.getEnum(this.getClass(), this.get_Value() & value.get_Value());
        }

        public int hashCode() {
            return (int)this.a;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ObjectEnum) {
                ObjectEnum objectEnum = (ObjectEnum)obj;
                return objectEnum.a == this.a && StringExtensions.equals(objectEnum.b, this.b);
            }
            return false;
        }
    }

    public static abstract class FlaggedEnum
    extends AbstractEnum {
        protected FlaggedEnum(Class<?> enumClass, Class<? extends Number> underlineClass) {
            super(enumClass, underlineClass);
        }

        @Override
        protected String getName(long value) {
            Object object;
            if (value == 0L) {
                return this.constants.containsKey(value) ? (String)this.constants.get(value) : Long.toString(value);
            }
            if (this.constants.containsKey(value)) {
                return (String)this.constants.get(value);
            }
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Map.Entry object22 : this.constants.entrySet()) {
                object = (Long)object22.getKey();
                String string = (String)object22.getValue();
                if ((Long)object == 0L || (value & (Long)object) != (Long)object) continue;
                linkedHashSet.add(string);
                value ^= ((Long)object).longValue();
            }
            if (value != 0L) {
                linkedHashSet.add(Long.toString(value));
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = linkedHashSet.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuilder.append((String)object);
                if (!iterator.hasNext()) break;
                stringBuilder.append(", ");
            }
            return stringBuilder.toString();
        }
    }

    public static abstract class SimpleEnum
    extends AbstractEnum {
        protected SimpleEnum(Class<?> enumClass, Class<? extends Number> underlineClass) {
            super(enumClass, underlineClass);
        }

        @Override
        protected String getName(long value) {
            return this.constants.containsKey(value) ? (String)this.constants.get(value) : Long.toString(value);
        }
    }

    public static abstract class AbstractEnum {
        private final Class<?> a;
        private final Class<? extends Number> b;
        protected final ConstantMap constants;

        protected AbstractEnum(Class<?> enumClass, Class<? extends Number> underlineClass) {
            this.a = enumClass;
            this.b = underlineClass;
            this.constants = new ConstantMap();
        }

        protected final void addConstant(String name, long value) {
            this.constants.put(value, name);
        }

        public final Class<?> getEnumClass() {
            return this.a;
        }

        public final Class<? extends Number> getUnderlineClass() {
            return this.b;
        }

        protected abstract String getName(long var1);

        public final long getValue(String name, boolean ignoreCase) {
            for (Map.Entry entry : this.constants.entrySet()) {
                if (StringExtensions.compare((String)entry.getValue(), name, ignoreCase) != 0) continue;
                return (Long)entry.getKey();
            }
            throw new ArgumentException("Requested value '{0}' was not found.", name);
        }

        protected static class ConstantMap
        extends TreeMap<Long, String> {
            protected ConstantMap() {
            }
        }
    }
}

