/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Text;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.FontFamily;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.StringComparer;
import java.awt.Font;
import java.util.Set;
import java.util.TreeMap;

public abstract class FontCollection
implements IDisposable {
    protected TreeMap<String, Font> _fonts;

    protected FontCollection() {
        this._fonts = new TreeMap(StringComparer.getCurrentCultureIgnoreCase());
    }

    protected FontCollection(TreeMap<String, Font> fonts) {
        this._fonts = fonts;
    }

    public FontFamily[] getFamilies() {
        if (this._fonts == null) {
            throw new ArgumentException("Parameter is not valid");
        }
        TreeMap treeMap = (TreeMap)this._fonts.clone();
        Set set = treeMap.keySet();
        FontFamily[] fontFamilyArray = new FontFamily[set.size()];
        int n2 = 0;
        for (String string : set) {
            fontFamilyArray[n2++] = new FontFamily(string, this);
        }
        return fontFamilyArray;
    }

    public Font getInitialFont(String familyName) {
        return this._fonts.get(familyName);
    }

    public boolean contains(String familyName) {
        return this._fonts.containsKey(familyName);
    }

    protected void addFont(Font font) {
        this._fonts.put(font.getFamily(), font);
    }

    @Override
    public void dispose() {
    }
}

