/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Drawing.Printing;

import com.aspose.html.internal.ms.System.Drawing.Printing.InvalidPrinterException;
import com.aspose.html.internal.ms.System.Drawing.Printing.Margins;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSize;
import com.aspose.html.internal.ms.System.Drawing.Printing.PaperSource;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterResolution;
import com.aspose.html.internal.ms.System.Drawing.Printing.PrinterSettings;
import com.aspose.html.internal.ms.System.Drawing.Rectangle;
import com.aspose.html.internal.ms.System.Drawing.RectangleF;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.core.System.Drawing.Printing.GraphicsContext;

@SerializableAttribute
public class PageSettings
implements ICloneable {
    private boolean a;
    private boolean b;
    private PaperSize c;
    private PaperSource d;
    private PrinterResolution e;
    private Margins f = new Margins(0, 0, 0, 0);
    private float g = 16.0f;
    private float h = 16.0f;
    private RectangleF i;
    private PrinterSettings j;

    public PageSettings() {
        this(new PrinterSettings());
    }

    public PageSettings(PrinterSettings printerSettings) {
        this.j = printerSettings;
        PageSettings pageSettings = printerSettings.getDefaultPageSettings();
        if (pageSettings != null) {
            this.a = printerSettings.getDefaultPageSettings().a;
            this.b = printerSettings.getDefaultPageSettings().b;
            this.c = printerSettings.getDefaultPageSettings().c;
            this.d = printerSettings.getDefaultPageSettings().d;
            this.e = printerSettings.getDefaultPageSettings().e;
            this.i = printerSettings.getDefaultPageSettings().i;
        }
    }

    PageSettings(PrinterSettings printerSettings, boolean color, boolean landscape, PaperSize paperSize, PaperSource paperSource, PrinterResolution printerResolution) {
        this.setPrinterSettings(printerSettings);
        this.a = color;
        this.b = landscape;
        this.c = paperSize;
        this.d = paperSource;
        this.e = printerResolution;
        this.i = this.getPrintableArea();
    }

    public Rectangle getBounds() {
        int n2 = this.c.getWidth();
        int n3 = this.c.getHeight();
        if (this.b) {
            int n4 = n2;
            n2 = n3;
            n3 = n4;
        }
        return new Rectangle(0, 0, n2, n3);
    }

    public boolean getColor() {
        if (!this.j.isValid()) {
            throw new InvalidPrinterException(this.j);
        }
        return this.a;
    }

    public void setColor(boolean value) {
        this.a = value;
    }

    public boolean getLandscape() {
        if (!this.j.isValid()) {
            throw new InvalidPrinterException(this.j);
        }
        return this.b;
    }

    public void setLandscape(boolean value) {
        this.b = value;
    }

    public Margins getMargins() {
        if (!this.j.isValid()) {
            throw new InvalidPrinterException(this.j);
        }
        return this.f;
    }

    public void setMargins(Margins value) {
        this.f = value;
    }

    public PaperSize getPaperSize() {
        if (!this.j.isValid()) {
            throw new InvalidPrinterException(this.j);
        }
        return this.c;
    }

    public void setPaperSize(PaperSize value) {
        if (value != null) {
            this.c = value;
        }
    }

    public PaperSource getPaperSource() {
        if (!this.j.isValid()) {
            throw new InvalidPrinterException(this.j);
        }
        return this.d;
    }

    public void setPaperSource(PaperSource value) {
        if (value != null) {
            this.d = value;
        }
    }

    public PrinterResolution getPrinterResolution() {
        if (!this.j.isValid()) {
            throw new InvalidPrinterException(this.j);
        }
        return this.e;
    }

    public void setPrinterResolution(PrinterResolution value) {
        if (value != null) {
            this.e = value;
        }
    }

    public PrinterSettings getPrinterSettings() {
        return this.j;
    }

    public void setPrinterSettings(PrinterSettings printerSettings) {
        this.j = printerSettings;
    }

    public float getHardMarginX() {
        return this.g;
    }

    public float getHardMarginY() {
        return this.h;
    }

    public RectangleF getPrintableArea() {
        return this.i;
    }

    void a(RectangleF rectangleF) {
        this.i = rectangleF;
    }

    @Override
    public Object deepClone() {
        PrinterResolution printerResolution = null;
        PaperSource paperSource = null;
        PaperSize paperSize = null;
        if (this.e != null) {
            printerResolution = new PrinterResolution(this.e.getX(), this.e.getY(), this.e.getKind());
        }
        if (this.d != null) {
            paperSource = new PaperSource(this.d.getSourceName(), this.d.getKind());
        }
        if (this.c != null) {
            paperSize = new PaperSize(this.c.getPaperName(), this.c.getWidth(), this.c.getHeight());
            paperSize.a(this.c.getKind());
        }
        PageSettings pageSettings = new PageSettings(this.j, this.a, this.b, paperSize, paperSource, printerResolution);
        pageSettings.setMargins((Margins)this.f.deepClone());
        return pageSettings;
    }

    public String toString() {
        String string = "[PageSettings: Color={0}";
        string = StringExtensions.plusEqOperator(string, ", Landscape={1}");
        string = StringExtensions.plusEqOperator(string, ", Margins={2}");
        string = StringExtensions.plusEqOperator(string, ", PaperSize={3}");
        string = StringExtensions.plusEqOperator(string, ", PaperSource={4}");
        string = StringExtensions.plusEqOperator(string, ", PrinterResolution={5}");
        string = StringExtensions.plusEqOperator(string, "]");
        return StringExtensions.format(string, this.a, this.b, this.f, this.c, this.d, this.e);
    }

    Rectangle a(GraphicsContext graphicsContext) {
        return this.getBounds();
    }
}

