/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System.Collections.Generic;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.ArrayTypeMismatchException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericCollection;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.msArray;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.lang.ReservedForInternalUse;
import com.aspose.html.internal.ms.lang.Struct;
import java.util.Arrays;

@SerializableAttribute
public class Queue<T>
implements IGenericEnumerable<T>,
ICollection<T> {
    private Object[] a;
    private int b;
    private int c;
    private int d;
    private int e;
    private Object f;

    public Queue() {
        this.a = new Object[0];
        this.f = this;
    }

    public Queue(int capacity) {
        if (capacity < 0) {
            throw new ArgumentOutOfRangeException("capacity");
        }
        this.a = new Object[capacity];
        this.f = this;
    }

    public Queue(IGenericEnumerable<T> collection) {
        if (collection == null) {
            throw new ArgumentNullException("collection");
        }
        IGenericCollection iGenericCollection = collection instanceof IGenericCollection ? (IGenericCollection)collection : null;
        int n2 = iGenericCollection != null ? iGenericCollection.size() : 0;
        this.a = new Object[n2];
        for (Object t2 : collection) {
            this.enqueue(t2);
        }
        this.f = this;
    }

    public void clear() {
        msArray.clear(this.a, 0, this.a.length);
        this.d = 0;
        this.c = 0;
        this.b = 0;
        ++this.e;
    }

    public boolean contains(T item) {
        if (item == null) {
            for (Object t2 : this) {
                if (t2 != null) continue;
                return true;
            }
        } else {
            for (Object t3 : this) {
                if (!item.equals(t3)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyTo(Array array, int arrayIndex) {
        if (array == null) {
            throw new ArgumentNullException();
        }
        if (((long)arrayIndex & 0xFFFFFFFFL) > ((long)array.getLength() & 0xFFFFFFFFL)) {
            throw new ArgumentOutOfRangeException();
        }
        if (array.getLength() - arrayIndex < this.d) {
            throw new ArgumentException();
        }
        if (this.d == 0) {
            return;
        }
        try {
            int n2 = this.a.length;
            int n3 = n2 - this.b;
            Array.copy(Array.boxing(this.a), this.b, array, arrayIndex, msMath.min(this.d, n3));
            if (this.d > n3) {
                Array.copy(Array.boxing(this.a), 0, array, arrayIndex + n3, this.d - n3);
            }
        }
        catch (ArrayTypeMismatchException arrayTypeMismatchException) {
            throw new ArgumentException();
        }
    }

    public T dequeue() {
        T t2 = this.peek();
        this.a[this.b] = null;
        if (++this.b == this.a.length) {
            this.b = 0;
        }
        --this.d;
        ++this.e;
        return t2;
    }

    public T peek() {
        if (this.d == 0) {
            throw new InvalidOperationException();
        }
        return (T)this.a[this.b];
    }

    public void enqueue(T item) {
        if (this.d == this.a.length || this.c == this.a.length) {
            this.a(msMath.max(msMath.max(this.d, this.c) * 2, 4));
        }
        this.a[this.c] = item;
        if (++this.c == this.a.length) {
            this.c = 0;
        }
        ++this.d;
        ++this.e;
    }

    public T[] toArray(T[] a2) {
        if (a2.length < this.d) {
            return Arrays.copyOf(this.a, this.d, a2.getClass());
        }
        System.arraycopy(this.a, 0, a2, 0, this.d);
        if (a2.length > this.d) {
            a2[this.d] = null;
        }
        return a2;
    }

    public void trimExcess() {
        if ((double)this.d < (double)this.a.length * 0.9) {
            this.a(this.d);
        }
    }

    private void a(int n2) {
        if (n2 == this.a.length) {
            return;
        }
        if (n2 < this.d) {
            throw new InvalidOperationException("shouldnt happen");
        }
        Object[] objectArray = new Object[n2];
        if (this.d > 0) {
            this.copyTo(Array.boxing(objectArray), 0);
        }
        this.a = objectArray;
        this.c = this.d;
        this.b = 0;
        ++this.e;
    }

    @Override
    public int size() {
        return this.d;
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.f;
    }

    public Enumerator iterator() {
        return new Enumerator(this);
    }

    @SerializableAttribute
    public static class Enumerator<T>
    extends Struct<Enumerator>
    implements IGenericEnumerator<T>,
    IDisposable {
        private static final int b = -2;
        private static final int c = -1;
        private Queue<T> d;
        private int e;
        private int f;

        public Enumerator() {
        }

        Enumerator(Queue<T> q2) {
            this.d = q2;
            this.e = -2;
            this.f = ((Queue)q2).e;
        }

        @Override
        public void dispose() {
            this.e = -2;
        }

        @Override
        public boolean hasNext() {
            if (this.f != ((Queue)this.d).e) {
                throw new InvalidOperationException();
            }
            if (this.e == -2) {
                this.e = ((Queue)this.d).d;
            }
            return this.e != -1 && --this.e != -1;
        }

        @Override
        public T next() {
            if (this.e < 0) {
                throw new InvalidOperationException();
            }
            return (T)((Queue)this.d).a[(((Queue)this.d).d - 1 - this.e + ((Queue)this.d).b) % ((Queue)this.d).a.length];
        }

        @Override
        @ReservedForInternalUse
        public void reset() {
            if (this.f != ((Queue)this.d).e) {
                throw new InvalidOperationException();
            }
            this.e = -2;
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }

        @Override
        public void CloneTo(Enumerator that) {
            that.d = this.d;
            that.e = this.e;
            that.f = this.f;
        }

        @Override
        public Enumerator Clone() {
            Enumerator<T> enumerator = new Enumerator<T>();
            this.CloneTo(enumerator);
            return enumerator;
        }

        public Object clone() {
            return this.Clone();
        }

        private boolean a(Enumerator enumerator) {
            return ObjectExtensions.equals(enumerator.d, this.d) && enumerator.e == this.e && enumerator.f == this.f;
        }

        public boolean equals(Object obj) {
            assert (obj != null);
            if (ObjectExtensions.referenceEquals(null, obj)) {
                return false;
            }
            if (ObjectExtensions.referenceEquals(this, obj)) {
                return true;
            }
            if (!(obj instanceof Enumerator)) {
                return false;
            }
            return this.a((Enumerator)obj);
        }

        public static boolean equals(Enumerator obj1, Enumerator obj2) {
            return obj1.equals(obj2);
        }

        public int hashCode() {
            int n2 = this.d != null ? this.d.hashCode() : 0;
            n2 = 31 * n2 + this.e;
            n2 = 31 * n2 + this.f;
            return n2;
        }
    }
}

