/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.Convert;
import com.aspose.html.internal.ms.System.FormatException;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.IFormatProvider;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Extensions;

@Extensions
public final class BooleanExtensions {
    public static final String FalseString = "False";
    public static final String TrueString = "True";

    public static int compareTo(boolean value, boolean b2) {
        if (value == b2) {
            return 0;
        }
        return !value ? -1 : 1;
    }

    public static int compareTo(boolean value, Object obj) {
        if (obj == null) {
            return 1;
        }
        if (obj.getClass() != Boolean.class) {
            throw new ArgumentException("Object is not a Boolean.");
        }
        boolean bl2 = Convert.toBoolean(obj);
        if (value && !bl2) {
            return 1;
        }
        return value == bl2 ? 0 : -1;
    }

    public static boolean equals(boolean value, boolean b2) {
        return value == b2;
    }

    public static boolean equals(boolean value, Object b2) {
        if (b2 == null || b2.getClass() != Boolean.class) {
            return false;
        }
        return Convert.toBoolean(b2) == value;
    }

    public static int getHashCode(boolean value) {
        return value ? 1 : 0;
    }

    public static int getTypeCode() {
        return 3;
    }

    public static boolean parse(String value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (StringExtensions.compare(value = StringExtensions.trim(value), TrueString, true, CultureInfo.getInvariantCulture()) == 0) {
            return true;
        }
        if (StringExtensions.compare(value, FalseString, true, CultureInfo.getInvariantCulture()) == 0) {
            return false;
        }
        throw new FormatException("Value is not equivalent to either TrueString or FalseString.");
    }

    public static boolean tryParse(String value, boolean[] result) {
        result[0] = false;
        if (value == null) {
            return false;
        }
        value = StringExtensions.trim(value);
        try {
            result[0] = BooleanExtensions.parse(value);
            return true;
        }
        catch (FormatException formatException) {
            return false;
        }
    }

    public static String toString(boolean value) {
        if (!value) {
            return FalseString;
        }
        return TrueString;
    }

    public static String toString(boolean value, IFormatProvider provider) {
        return BooleanExtensions.toString(value);
    }
}

