/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.internal.ms.System;

import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.ArgumentNullException;
import com.aspose.html.internal.ms.System.ArgumentOutOfRangeException;
import com.aspose.html.internal.ms.System.ArrayTypeMismatchException;
import com.aspose.html.internal.ms.System.Collections.Comparer;
import com.aspose.html.internal.ms.System.Collections.Generic.EqualityComparer;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.Collections.ICollection;
import com.aspose.html.internal.ms.System.Collections.IEnumerable;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.Collections.IList;
import com.aspose.html.internal.ms.System.Collections.ObjectModel.ReadOnlyCollection;
import com.aspose.html.internal.ms.System.Comparison;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.ICloneable;
import com.aspose.html.internal.ms.System.IndexOutOfRangeException;
import com.aspose.html.internal.ms.System.InvalidCastException;
import com.aspose.html.internal.ms.System.InvalidOperationException;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.RankException;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Type;
import com.aspose.html.internal.ms.System.TypeLoadException;
import com.aspose.html.internal.ms.System.msMath;
import com.aspose.html.internal.ms.core.ConversionUtils;
import com.aspose.html.internal.ms.core.System.a;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.Struct;
import java.util.Comparator;

@SerializableAttribute
public abstract class Array
implements ICollection,
IEnumerable,
IList,
ICloneable {
    private Array() {
    }

    protected abstract Object getInternalObject();

    protected abstract Info getArrayInfo();

    protected abstract a getArrayHelper();

    protected abstract ArrayEnumerator createEnumerator(int var1, int var2);

    public static Array boxing(Object javaArray) {
        return Array.a(javaArray, 1, false);
    }

    public static Array boxing(Object javaArray, int rank) {
        return Array.a(javaArray, rank, false);
    }

    public static Array boxing(Object javaArray, int rank, boolean isJagged) {
        return Array.a(javaArray, rank, isJagged);
    }

    private static Box a(Object object, int n2, boolean bl2) {
        if (object == null) {
            return null;
        }
        if (n2 < 1) {
            throw new ArgumentException("Incorrect dimension of array", "rank");
        }
        switch (n2) {
            case 1: {
                return new OneDimensional(object, bl2);
            }
        }
        return new MultiDimensional(object, n2, bl2);
    }

    public static Object unboxing(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array is null");
        }
        return array.getInternalObject();
    }

    public static <T> IGenericList<T> toGenericList(T[] array) {
        Array array2 = Array.boxing(array);
        if (array2 == null) {
            return null;
        }
        return Array.toGenericList(array2);
    }

    public static <T> IGenericList<T> toGenericList(Array array) {
        return new GenericArray(array);
    }

    public static <T> ReadOnlyCollection<T> asReadOnly(T[] array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return new ReadOnlyCollection<T>(Array.toGenericList(array));
    }

    public static int binarySearch(Array array, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (value == null) {
            return -1;
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (!(value instanceof Comparable)) {
            throw new InvalidOperationException("Failed to compare two elements in the array.");
        }
        return Array.a(array, array.getLowerBound(0), array.getLength(0), value, null);
    }

    public static int binarySearch(Array array, Object value, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (comparer == null && value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return Array.a(array, array.getLowerBound(0), array.getLength(0), value, comparer);
    }

    public static int binarySearch(Array array, int index, int length, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < array.getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (index > array.getLowerBound(0) + array.getLength(0) - length) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("value does not support IComparable");
        }
        return Array.a(array, index, length, value, null);
    }

    public static int binarySearch(Array array, int index, int length, Object value, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < array.getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (index > array.getLowerBound(0) + array.getLength(0) - length) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (comparer == null && value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return Array.a(array, index, length, value, comparer);
    }

    static int a(Array array, int n2, int n3, Object object, Comparator comparator) {
        if (comparator == null) {
            comparator = Comparer.Default;
        }
        int n4 = n2;
        int n5 = n2 + n3 - 1;
        int n6 = 0;
        while (n4 <= n5) {
            int n7 = n4 + (n5 - n4) / 2;
            Object object2 = array.getValueImpl(n7);
            try {
                n6 = comparator.compare(object2, object);
            }
            catch (java.lang.Exception exception) {
                throw new ArgumentException("value is not of the same type", exception);
            }
            if (n6 == 0) {
                return n7;
            }
            if (n6 > 0) {
                n5 = n7 - 1;
                continue;
            }
            n4 = n7 + 1;
        }
        return ~n4;
    }

    public static <T> int binarySearch(T[] array, T value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.binarySearch(array, 0, Array.boxing(array).getLength(), value, null);
    }

    public static <T> int binarySearch(T[] array, T value, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.binarySearch(array, 0, Array.boxing(array).getLength(), value, comparer);
    }

    public static <T> int binarySearch(T[] array, int index, int length, T value) {
        return Array.binarySearch(array, index, length, value, null);
    }

    public static <T> int binarySearch(T[] array, int index, int length, T value, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "Non-negative number required.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (index > Array.boxing(array).getLength() - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (comparer == null) {
            comparer = com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault();
        }
        int n2 = index;
        int n3 = index + length - 1;
        int n4 = 0;
        try {
            while (n2 <= n3) {
                int n5 = n2 + (n3 - n2) / 2;
                n4 = comparer.compare(value, array[n5]);
                if (n4 == 0) {
                    return n5;
                }
                if (n4 < 0) {
                    n3 = n5 - 1;
                    continue;
                }
                n2 = n5 + 1;
            }
        }
        catch (Exception exception) {
            throw new InvalidOperationException("Comparer threw an exception.", exception);
        }
        return ~n2;
    }

    public static void clear(Array array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (length < 0) {
            throw new IndexOutOfRangeException("Non-negative number required.");
        }
        int n2 = array.getLowerBound(0);
        if (index < n2) {
            throw new IndexOutOfRangeException("index < lower bound");
        }
        if ((index -= n2) > array.getLength() - length) {
            throw new IndexOutOfRangeException("index + length > size");
        }
        ArrayEnumerator arrayEnumerator = array.createEnumerator(index, length);
        Class clazz = array.getArrayInfo().b;
        while (arrayEnumerator.hasNext()) {
            arrayEnumerator.a(Operators.defaultValue(clazz));
        }
    }

    @Override
    public Object deepClone() {
        if (this.getRank() > 1) {
            throw new NotImplementedException();
        }
        Info info = this.getArrayInfo();
        Array array = Array.createInstance(Operators.typeOf(info.b), (int)info.e);
        this.copyTo(array, 0);
        return array;
    }

    public static void constrainedCopy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length) {
        Array.copy(sourceArray, sourceIndex, destinationArray, destinationIndex, length);
    }

    public static void copy(Array sourceArray, Array destinationArray, int length) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        Array.copy(sourceArray, sourceArray.getLowerBound(0), destinationArray, destinationArray.getLowerBound(0), length);
    }

    public static void copy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (sourceIndex < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Non-negative number required.");
        }
        if (destinationIndex < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Non-negative number required.");
        }
        if (sourceIndex > sourceArray.getLength() - length) {
            throw new ArgumentException("length");
        }
        if (destinationIndex > destinationArray.getLength() - length) {
            String string = StringExtensions.concat("Destination array was not long enough. Check ", "destIndex and length, and the array's lower bounds");
            throw new ArgumentException(string, StringExtensions.Empty);
        }
        if (sourceArray.getRank() != destinationArray.getRank()) {
            throw new RankException("Arrays must be of same size.");
        }
        Class clazz = sourceArray.getArrayInfo().b;
        Class clazz2 = destinationArray.getArrayInfo().b;
        boolean bl2 = Struct.class.isAssignableFrom(clazz);
        if (!bl2 && sourceArray.getRank() == 1 && Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length)) {
            return;
        }
        if (ObjectExtensions.referenceEquals(Array.unboxing(sourceArray), Array.unboxing(destinationArray)) && Array.a(sourceIndex, destinationIndex, length)) {
            Type type = Operators.typeOf(clazz);
            Array array = Array.createInstance(type, length);
            Array.a(sourceArray, sourceIndex, array, 0, length, bl2);
            Array.a(array, 0, destinationArray, destinationIndex, length, false);
        } else {
            Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length, bl2);
        }
    }

    public static <T> void copyInternal(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length, ElementInitializer<T> elementInitializer) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (sourceIndex < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Non-negative number required.");
        }
        if (destinationIndex < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Non-negative number required.");
        }
        if (sourceIndex > sourceArray.getLength() - length) {
            throw new ArgumentException("length");
        }
        if (destinationIndex > destinationArray.getLength() - length) {
            String string = StringExtensions.concat("Destination array was not long enough. Check ", "destIndex and length, and the array's lower bounds");
            throw new ArgumentException(string, StringExtensions.Empty);
        }
        if (sourceArray.getRank() != destinationArray.getRank()) {
            throw new RankException("Arrays must be of same size.");
        }
        Class clazz = sourceArray.getArrayInfo().b;
        Class clazz2 = destinationArray.getArrayInfo().b;
        boolean bl2 = Struct.class.isAssignableFrom(clazz);
        if (!bl2 && sourceArray.getRank() == 1 && Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length)) {
            return;
        }
        if (ObjectExtensions.referenceEquals(Array.unboxing(sourceArray), Array.unboxing(destinationArray)) && Array.a(sourceIndex, destinationIndex, length)) {
            Type type = Operators.typeOf(clazz);
            Array array = Array.createInstanceInternal(type.getJavaClass(), length, elementInitializer);
            Array.a(sourceArray, sourceIndex, array, 0, length, bl2);
            Array.a(array, 0, destinationArray, destinationIndex, length, false);
        } else {
            Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length, bl2);
        }
    }

    private static boolean a(int n2, int n3, int n4) {
        return n2 < n3 && n2 + n4 > n3 || n3 < n2 && n3 + n4 > n2;
    }

    private static void a(Array array, int n2, Array array2, int n3, int n4, boolean bl2) {
        try {
            if (!bl2) {
                for (int i2 = 0; i2 < n4; ++i2) {
                    Object object = array.getValueImpl(n2 + i2);
                    array2.setValueImpl(object, n3 + i2);
                }
            } else {
                for (int i3 = 0; i3 < n4; ++i3) {
                    Object t2 = ((Struct)array.getValueImpl(n2 + i3)).Clone();
                    array2.setValueImpl(t2, n3 + i3);
                }
            }
        }
        catch (java.lang.Exception exception) {
            Class clazz = array.getArrayInfo().b;
            Class clazz2 = array2.getArrayInfo().b;
            if (clazz.equals(Object.class)) {
                throw new InvalidCastException();
            }
            Type type = Operators.typeOf(clazz);
            Type type2 = Operators.typeOf(clazz2);
            throw new ArrayTypeMismatchException(StringExtensions.format("sourceArray and destinationArray are of incompatible types (Types: source={0};  target={1})", type.getFullName(), type2.getFullName()));
        }
    }

    public static void copy(Array sourceArray, long sourceIndex, Array destinationArray, long destinationIndex, long length) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (sourceIndex < Integer.MIN_VALUE || sourceIndex > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Must be in the Int32 range.");
        }
        if (destinationIndex < Integer.MIN_VALUE || destinationIndex > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Must be in the Int32 range.");
        }
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        Array.copy(sourceArray, (int)sourceIndex, destinationArray, (int)destinationIndex, (int)length);
    }

    public static void copy(Array sourceArray, Array destinationArray, long length) {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        Array.copy(sourceArray, destinationArray, (int)length);
    }

    private static boolean a(Array array, int n2, Array array2, int n3, int n4) {
        if (ConversionUtils.isSame(array.getArrayInfo().b, array2.getArrayInfo().b)) {
            System.arraycopy(Array.unboxing(array), n2, Array.unboxing(array2), n3, n4);
            return true;
        }
        return false;
    }

    @Override
    public void copyTo(Array array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index + this.getLength(0) > array.getLowerBound(0) + array.getLength(0)) {
            throw new ArgumentException(StringExtensions.concat("Destination array was not long ", "enough. Check destIndex and length, and the array's ", "lower bounds."));
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "Non-negative number required.");
        }
        Array.copy(this, this.getLowerBound(0), array, index, this.getLength(0));
    }

    public void copyTo(Array array, long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        this.copyTo(array, (int)index);
    }

    public static int indexOf(Array array, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, 0, array.getLength());
    }

    public static int indexOf(Array array, Object value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, startIndex, array.getLength() - startIndex);
    }

    public static int indexOf(Array array, Object value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (count < 0 || startIndex < array.getLowerBound(0) || startIndex - 1 > array.getUpperBound(0) - count) {
            throw new ArgumentOutOfRangeException(count < 0 ? "count" : "startIndex", count < 0 ? "Count must be positive and count must refer to a location within the string/array/collection." : "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        int n2 = startIndex + count;
        for (int i2 = startIndex; i2 < n2; ++i2) {
            if (!ObjectExtensions.equals(array.getValueImpl(i2), value)) continue;
            return i2;
        }
        return array.getLowerBound(0) - 1;
    }

    public static <T> int indexOf(T[] array, T value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, 0, Array.boxing(array).getLength());
    }

    public static <T> int indexOf(T[] array, T value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, startIndex, Array.boxing(array).getLength() - startIndex);
    }

    public static <T> int indexOf(T[] array, T value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (count < 0 || startIndex < Array.boxing(array).getLowerBound(0) || startIndex - 1 > Array.boxing(array).getUpperBound(0) - count) {
            throw new ArgumentOutOfRangeException(count < 0 ? "count" : "startIndex", count < 0 ? "Count must be positive and count must refer to a location within the string/array/collection." : "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        int n2 = startIndex + count;
        EqualityComparer.DefaultComparer<T> defaultComparer = new EqualityComparer.DefaultComparer<T>();
        for (int i2 = startIndex; i2 < n2; ++i2) {
            if (!((EqualityComparer)defaultComparer).equals(array[i2], value)) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(Array array, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getLength() == 0) {
            return array.getLowerBound(0) - 1;
        }
        return Array.lastIndexOf(array, value, array.getLength() - 1);
    }

    public static int lastIndexOf(Array array, Object value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.lastIndexOf(array, value, startIndex, startIndex - array.getLowerBound(0) + 1);
    }

    public static int lastIndexOf(Array array, Object value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n2 = array.getLowerBound(0);
        if (array.getLength() == 0) {
            return n2 - 1;
        }
        if (startIndex < n2 || startIndex > array.getUpperBound(0)) {
            throw new ArgumentOutOfRangeException("startIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (count < 0 || startIndex - count + 1 < n2) {
            throw new ArgumentOutOfRangeException("count", "Count must be positive and count must refer to a location within the string/array/collection.");
        }
        for (int i2 = startIndex; i2 >= startIndex - count + 1; --i2) {
            if (!ObjectExtensions.equals(array.getValueImpl(i2), value)) continue;
            return i2;
        }
        return n2 - 1;
    }

    public static <T> int lastIndexOf(T[] array, T value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (Array.boxing(array).getLength() == 0) {
            return -1;
        }
        return Array.lastIndexOf(array, value, Array.boxing(array).getLength() - 1);
    }

    public static <T> int lastIndexOf(T[] array, T value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.lastIndexOf(array, value, startIndex, startIndex + 1);
    }

    public static <T> int lastIndexOf(T[] array, T value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (startIndex < Array.boxing(array).getLowerBound(0) || startIndex > Array.boxing(array).getUpperBound(0)) {
            throw new ArgumentOutOfRangeException("startIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (count < 0 || startIndex - count + 1 < Array.boxing(array).getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("count", "Count must be positive and count must refer to a location within the string/array/collection.");
        }
        EqualityComparer.DefaultComparer<T> defaultComparer = new EqualityComparer.DefaultComparer<T>();
        for (int i2 = startIndex; i2 >= startIndex - count + 1; --i2) {
            if (!((EqualityComparer)defaultComparer).equals(array[i2], value)) continue;
            return i2;
        }
        return -1;
    }

    static Swapper a(final Array array) {
        Object object = Array.unboxing(array);
        if (object instanceof Object[]) {
            return new Swapper(){

                @Override
                public void a(int n2, int n3) {
                    array.a(n2, n3);
                }
            };
        }
        return new Swapper(){

            @Override
            public void a(int n2, int n3) {
                array.b(n2, n3);
            }
        };
    }

    private void a(int n2, int n3) {
        Object object = Array.unboxing(this);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : null;
        Object object2 = objectArray[n2];
        objectArray[n2] = objectArray[n3];
        objectArray[n3] = object2;
    }

    private void b(int n2, int n3) {
        Object object = this.getValueImpl(n2);
        this.setValueImpl(this.getValue(n3), n2);
        this.setValueImpl(object, n3);
    }

    public static void reverse(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.reverse(array, array.getLowerBound(0), array.getLength(0));
    }

    public static void reverse(Array array, int index, int length) {
        int n2;
        Object[] objectArray;
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < array.getLowerBound(0) || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length", "Non-negative number required.");
        }
        if (index > array.getUpperBound(0) + 1 - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        Object object = Array.unboxing(array);
        Object[] objectArray2 = objectArray = object instanceof Object[] ? (Object[])object : null;
        if (objectArray != null) {
            for (n2 = index + length - 1; index < n2; ++index, --n2) {
                Object object2 = objectArray[index];
                objectArray[index] = objectArray[n2];
                objectArray[n2] = object2;
            }
            return;
        }
        Swapper swapper = Array.a(array);
        while (index < n2) {
            swapper.a(index, n2);
            ++index;
            --n2;
        }
    }

    public void initialize() {
        ArrayEnumerator arrayEnumerator = this.createEnumerator(0, this.getLength());
        Class clazz = this.getArrayInfo().b;
        Object object = Operators.defaultValue(clazz);
        if (object != null) {
            if (arrayEnumerator.hasNext() && arrayEnumerator.next() == null) {
                arrayEnumerator.a(object);
            }
            while (arrayEnumerator.hasNext()) {
                object = Operators.defaultValue(clazz);
                if (arrayEnumerator.next() != null) continue;
                arrayEnumerator.a(object);
            }
        }
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Object get_Item(int index) {
        if (index >= this.getLength() || index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (this.getRank() > 1) {
            throw new ArgumentException("Only single dimension arrays are supported.");
        }
        return this.getValueImpl(index);
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index >= this.getLength() || index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (this.getRank() > 1) {
            throw new ArgumentException("Only single dimension arrays are supported.");
        }
        this.setValueImpl(value, index);
    }

    @Override
    public int addItem(Object value) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void removeItem(Object value) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void insertItem(int index, Object value) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void removeAt(int index) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void clear() {
        Array.clear(this, this.getLowerBound(0), this.getLength());
    }

    @Override
    public boolean contains(Object value) {
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n2 = this.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ObjectExtensions.equals(this.getValueImpl(i2), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object value) {
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n2 = this.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!ObjectExtensions.equals(this.getValueImpl(i2), value)) continue;
            return i2 + this.getLowerBound(0);
        }
        return this.getLowerBound(0) - 1;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this;
    }

    @Override
    public IEnumerator iterator() {
        return this.createEnumerator(0, this.getLength());
    }

    private static void b(a a2, Object object, int n2, Object object2) {
        try {
            a2.a(object, n2, object2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArgumentOutOfRangeException("index is outside the range of valid indexes for the current Array", arrayIndexOutOfBoundsException);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new InvalidCastException(arrayStoreException.getMessage());
        }
    }

    private static Object b(a a2, Object object, int n2) {
        try {
            return a2.a(object, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array", arrayIndexOutOfBoundsException);
        }
    }

    protected Object getValueImpl(int pos) {
        return Array.b(this.getArrayHelper(), this.getInternalObject(), pos);
    }

    protected void setValueImpl(Object value, int pos) {
        throw new InvalidOperationException("Array was not a one-dimensional array.");
    }

    protected Object getValueImpl(int ... indices) {
        Object object = this.getInternalObject();
        int n2 = indices.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = Array.b(a.a(), object, indices[i2]);
        }
        return Array.b(this.getArrayHelper(), object, indices[n2]);
    }

    protected void setValueImpl(Object value, int ... indices) {
        Class clazz = this.getArrayInfo().b;
        if (value == null && clazz.isPrimitive()) {
            value = Operators.defaultValue(clazz);
        }
        if (value != null && !ConversionUtils.isCompatible(value.getClass(), clazz) && (clazz.isPrimitive() || ConversionUtils.getUnboxedClass(clazz) != null)) {
            throw new ArgumentException("Cannot widen from source type to target type either because the source type is a not a primitive type or the conversion cannot be accomplished");
        }
        Object object = this.getInternalObject();
        int n2 = indices.length - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = Array.b(a.a(), object, indices[i2]);
        }
        try {
            Array.b(this.getArrayHelper(), object, indices[n2], value);
        }
        catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
            throw argumentOutOfRangeException;
        }
        catch (java.lang.Exception exception) {
            throw new InvalidCastException("Cannot save value in this array");
        }
    }

    public Object getValue(int ... indices) {
        if (indices == null) {
            throw new ArgumentNullException("indices");
        }
        if (this.getRank() != indices.length) {
            throw new ArgumentException("The number of dimensions in the current Array is not equal to the number of elements in indices");
        }
        return this.getValueImpl(indices);
    }

    public void setValue(Object value, int ... indices) {
        if (indices == null) {
            throw new ArgumentNullException("indices");
        }
        if (this.getRank() != indices.length) {
            throw new ArgumentException("The number of dimensions in the current Array is not equal to the number of elements in indices");
        }
        this.setValueImpl(value, indices);
    }

    public int getRank() {
        return this.getArrayInfo().a;
    }

    public int getLowerBound(int dimension) {
        if (dimension < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (dimension >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return 0;
    }

    public static <T> Array createInstanceInternal(Class<T> cls, int length, ElementInitializer<T> elementInitializer) {
        Object object = java.lang.reflect.Array.newInstance(cls, length);
        Array array = Array.boxing(object);
        ArrayEnumerator arrayEnumerator = array.createEnumerator(0, length);
        while (arrayEnumerator.hasNext()) {
            if (arrayEnumerator.next() != null) continue;
            arrayEnumerator.a(elementInitializer.createInstance());
        }
        return array;
    }

    public static Array createInstance(Type elementType, int length) {
        int[] nArray = new int[]{length};
        return Array.createInstance(elementType, nArray);
    }

    public static Array createInstance(Type elementType, int length1, int length2) {
        int[] nArray = new int[]{length1, length2};
        return Array.createInstance(elementType, nArray);
    }

    public static Array createInstance(Type elementType, int length1, int length2, int length3) {
        int[] nArray = new int[]{length1, length2, length3};
        return Array.createInstance(elementType, nArray);
    }

    public static Array createInstance(Type elementType, int ... lengths) {
        if (elementType == null) {
            throw new ArgumentNullException("elementType");
        }
        if (lengths == null) {
            throw new ArgumentNullException("lengths");
        }
        if (lengths.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        int[] nArray = null;
        if (elementType.equals(Operators.typeOf(Void.TYPE))) {
            throw new NotSupportedException("Array type can not be void");
        }
        return Array.a(elementType, lengths, nArray);
    }

    public static Array createInstance(Type elementType, int[] lengths, int[] lowerBounds) {
        if (elementType == null) {
            throw new ArgumentNullException("elementType");
        }
        if (lengths == null) {
            throw new ArgumentNullException("lengths");
        }
        if (lowerBounds == null) {
            throw new ArgumentNullException("lowerBounds");
        }
        if (elementType.equals(Operators.typeOf(Void.TYPE))) {
            throw new NotSupportedException("Array type can not be void");
        }
        if (lengths.length < 1) {
            throw new ArgumentException("Must provide at least one rank.");
        }
        if (lengths.length != lowerBounds.length) {
            throw new ArgumentException("Number of lengths and lowerBounds must match.");
        }
        for (int i2 = 0; i2 < lowerBounds.length; ++i2) {
            if (lengths[i2] < 0) {
                throw new ArgumentOutOfRangeException("lengths[" + i2 + "]", "Non-negative number required.");
            }
            if ((long)lowerBounds[i2] + (long)lengths[i2] <= Integer.MAX_VALUE) continue;
            throw new ArgumentOutOfRangeException("lengths", "Length + bound must not exceed Int32.MaxValue.");
        }
        if (lengths.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        return Array.a(elementType, lengths, lowerBounds);
    }

    private static Array a(Type type, int[] nArray, int[] nArray2) {
        int n2;
        if (nArray2 != null) {
            throw new NotImplementedException("Not implemented yet");
        }
        if (nArray == null) {
            throw new ArgumentNullException("lengths");
        }
        if (nArray.length < 1) {
            throw new ArgumentException("Arrays must contain >= 1 elements.");
        }
        if (nArray.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 0) continue;
            throw new ArgumentOutOfRangeException("lengths[" + n2 + ']', "Non-negative number required.");
        }
        n2 = 0;
        for (Class<?> clazz = type.getJavaClass().getComponentType(); clazz != null; clazz = clazz.getComponentType()) {
            ++n2;
        }
        Object object = null;
        object = nArray.length > 1 ? java.lang.reflect.Array.newInstance(type.getJavaClass(), nArray) : java.lang.reflect.Array.newInstance(type.getJavaClass(), nArray[0]);
        Array array = Array.boxing(object, nArray.length, n2 > 0);
        array.initialize();
        return array;
    }

    private static int a(String string) {
        if (string.charAt(0) == '[') {
            int n2 = 1;
            while (string.charAt(n2) == '[') {
                ++n2;
            }
            return n2;
        }
        return 0;
    }

    public static <T> void resize(T[][] refToArray, int newSize) {
        if (newSize < 0) {
            throw new ArgumentOutOfRangeException("Non-negative number required.");
        }
        if (refToArray[0] == null) {
            Array array = Array.createInstance(Operators.typeOf(refToArray.getClass().getComponentType().getComponentType()), newSize);
            refToArray[0] = (Object[])Array.unboxing(array);
            return;
        }
        int n2 = refToArray[0].length;
        if (n2 == newSize) {
            return;
        }
        int n3 = 0;
        for (Class<?> clazz = refToArray[0].getClass().getComponentType(); clazz != null; clazz = clazz.getComponentType()) {
            ++n3;
        }
        Array array = Array.createInstance(Operators.typeOf(refToArray[0].getClass().getComponentType()), newSize);
        if (n2 != 0) {
            Array.a(Array.boxing(refToArray[0], 1, n3 > 0), 0, array, 0, msMath.min(newSize, n2));
        }
        refToArray[0] = (Object[])Array.unboxing(array);
    }

    public int getLength() {
        return (int)this.getArrayInfo().e;
    }

    public long getLongLength() {
        return this.getArrayInfo().e;
    }

    public Object getValue(int index) {
        if (this.getRank() != 1) {
            throw new ArgumentException("Array was not a one-dimensional array.");
        }
        if (index < this.getLowerBound(0) || index > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array");
        }
        return this.getValueImpl(index);
    }

    public Object getValue(int index1, int index2) {
        if (this.getRank() != 2) {
            throw new ArgumentException("The current Array does not have exactly two dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2};
        return this.getValueImpl(nArray);
    }

    public Object getValue(int index1, int index2, int index3) {
        if (this.getRank() != 3) {
            throw new ArgumentException("The current Array does not have exactly three dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index3 < this.getLowerBound(2) || index3 > this.getUpperBound(2)) {
            throw new IndexOutOfRangeException("Index3 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2, index3};
        return this.getValueImpl(nArray);
    }

    public Object getValue(long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)index);
    }

    public Object getValue(long index1, long index2) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)index1, (int)index2);
    }

    public Object getValue(long index1, long index2, long index3) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index3 < 0L || index3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index3", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)index1, (int)index2, (int)index3);
    }

    public void setValue(Object value, int index) {
        if (this.getRank() != 1) {
            throw new ArgumentException("Array was not a one-dimensional array.");
        }
        if (index < this.getLowerBound(0) || index > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array");
        }
        this.setValueImpl(value, index - this.getLowerBound(0));
    }

    public void setValue(Object value, int index1, int index2) {
        if (this.getRank() != 2) {
            throw new ArgumentException("The current Array does not have exactly two dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2};
        this.setValueImpl(value, nArray);
    }

    public void setValue(Object value, int index1, int index2, int index3) {
        if (this.getRank() != 3) {
            throw new ArgumentException("The current Array does not have exactly three dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index3 < this.getLowerBound(2) || index3 > this.getUpperBound(2)) {
            throw new IndexOutOfRangeException("Index3 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2, index3};
        this.setValueImpl(value, nArray);
    }

    public void setValue(Object value, long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        this.setValue(value, (int)index);
    }

    public void setValue(Object value, long index1, long index2) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        int[] nArray = new int[]{(int)index1, (int)index2};
        this.setValue(value, nArray);
    }

    public void setValue(Object value, long index1, long index2, long index3) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index3 < 0L || index3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index3", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        int[] nArray = new int[]{(int)index1, (int)index2, (int)index3};
        this.setValue(value, nArray);
    }

    public int getUpperBound(int dimension) {
        if (dimension < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (dimension >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return this.getArrayInfo().c[dimension];
    }

    public int getLength(int dimension) {
        if (dimension < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (dimension >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return this.getArrayInfo().c[dimension] + 1;
    }

    public static void sort(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, null, array.getLowerBound(0), array.getLength(), null);
    }

    public static <T> void sort(T[] array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, Array.boxing(array).getLowerBound(0), array.length, null);
    }

    public static <T> void sort(T[] array, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, 0, array.length, comparer);
    }

    public static <T> void sort(T[] array, Comparison<T> comparison) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        FunctorComparer<T> functorComparer = new FunctorComparer<T>(comparison);
        Array.sort(array, functorComparer);
    }

    public static void sort(Array keys, Array items) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, keys.getLowerBound(0), keys.getLength(), null);
    }

    public static void sort(Array array, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, null, array.getLowerBound(0), array.getLength(), comparer);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, 0, keys.length, null);
    }

    public static <T> void sort(T[] array, int index, int length) {
        Array.sort(array, index, length, null);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items, Comparator<TKey> comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, 0, keys.length, comparer);
    }

    public static void sort(Array keys, Array items, Comparator comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, keys.getLowerBound(0), keys.getLength(), comparer);
    }

    public static void sort(Array array, int index, int length) {
        Array.sort(array, null, index, length, null);
    }

    public static void sort(Array array, int index, int length, Comparator comparer) {
        Array.sort(array, null, index, length, comparer);
    }

    public static <T> void sort(T[] array, int index, int length, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(length < 0 ? "length" : "index", "Non-negative number required");
        }
        if (array.length - index < length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (length > 1) {
            if (comparer != null && comparer != com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault()) {
                Array.sort(array, null, index, length, comparer);
            } else {
                Array.sort(array, null, index, length, com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault());
            }
        }
    }

    public static void sort(Array keys, Array items, int index, int length) {
        Array.sort(keys, items, index, length, null);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items, int index, int length) {
        Array.sort(keys, items, index, length, null);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items, int index, int length, Comparator<TKey> comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(length < 0 ? "length" : "index", "Non-negative number required");
        }
        if (keys.length - index < length || items != null && index > items.length - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (comparer == null) {
            comparer = com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault();
        }
        if (length > 1) {
            if (comparer != null && comparer != com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault()) {
                Array.a(keys, items, index, index + length - 1, comparer);
            } else {
                Array.a(keys, items, index, index + length - 1, com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault());
            }
        }
    }

    private static <TKey, TValue> void a(TKey[] TKeyArray, TValue[] TValueArray, int n2, int n3, Comparator<TKey> comparator) {
        int n4 = n2;
        int n5 = n3;
        int n6 = (n4 + n5) / 2;
        TKey TKey = TKeyArray[n6];
        while (true) {
            if (comparator.compare(TKeyArray[n4], TKey) < 0) {
                ++n4;
                continue;
            }
            while (comparator.compare(TKeyArray[n5], TKey) > 0) {
                --n5;
            }
            if (n4 <= n5) {
                TKey TKey2 = TKeyArray[n4];
                TKeyArray[n4] = TKeyArray[n5];
                TKeyArray[n5] = TKey2;
                if (TValueArray != null) {
                    TValue TValue = TValueArray[n4];
                    TValueArray[n4] = TValueArray[n5];
                    TValueArray[n5] = TValue;
                }
                ++n4;
                --n5;
            }
            if (n4 >= n5) break;
        }
        if (n2 < n5) {
            Array.a(TKeyArray, TValueArray, n2, n5, comparator);
        }
        if (n4 < n3) {
            Array.a(TKeyArray, TValueArray, n4, n3, comparator);
        }
    }

    public static void sort(Array keys, Array items, int index, int length, Comparator comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        if (keys.getRank() != 1 || items != null && items.getRank() != 1) {
            throw new RankException("Only single dimension arrays are supported");
        }
        if (items != null && keys.getLowerBound(0) != items.getLowerBound(0)) {
            throw new ArgumentException("Lower bounds must match");
        }
        if (index < keys.getLowerBound(0) || length < 0) {
            throw new ArgumentOutOfRangeException(length < 0 ? "length" : "index", "Non-negative number required");
        }
        if (keys.getLength() - (index - keys.getLowerBound(0)) < length || items != null && index - items.getLowerBound(0) > items.getLength() - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (length > 1) {
            Object object = Array.unboxing(keys);
            Object object2 = items != null ? Array.unboxing(items) : null;
            Object[] objectArray = object instanceof Object[] ? (Object[])object : null;
            Object[] objectArray2 = null;
            if (objectArray != null) {
                Object[] objectArray3 = objectArray2 = object2 instanceof Object[] ? (Object[])object2 : null;
            }
            if (comparer == null) {
                comparer = com.aspose.html.internal.ms.System.Collections.Generic.Comparer.getDefault();
            }
            if (objectArray != null && (items == null || objectArray2 != null)) {
                Array.b(objectArray, objectArray2, comparer, index, index + length - 1);
            } else {
                Array.b(keys, items, comparer, index, index + length - 1);
            }
        }
    }

    private static int c(int n2, int n3) {
        return n2 + (n3 - n2 >> 1);
    }

    private static void a(Object[] objectArray, Object[] objectArray2, Comparator comparator, int n2, int n3) {
        if (n2 != n3) {
            try {
                if (comparator.compare(objectArray[n2], objectArray[n3]) > 0) {
                    Object object = objectArray[n2];
                    objectArray[n2] = objectArray[n3];
                    objectArray[n3] = object;
                    if (objectArray2 != null) {
                        Object object2 = objectArray2[n2];
                        objectArray2[n2] = objectArray2[n3];
                        objectArray2[n3] = object2;
                    }
                }
            }
            catch (IndexOutOfRangeException indexOutOfRangeException) {
                throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
            }
            catch (Exception exception) {
                throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
            }
        }
    }

    private static void a(Array array, Array array2, Comparator comparator, int n2, int n3) {
        if (n2 != n3) {
            try {
                if (comparator.compare(array.getValue(n2), array.getValue(n3)) > 0) {
                    Object object = array.getValue(n2);
                    array.setValue(array.getValue(n3), n2);
                    array.setValue(object, n3);
                    if (array2 != null) {
                        Object object2 = array2.getValue(n2);
                        array2.setValue(array2.getValue(n3), n2);
                        array2.setValue(object2, n3);
                    }
                }
            }
            catch (IndexOutOfRangeException indexOutOfRangeException) {
                throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
            }
            catch (Exception exception) {
                throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
            }
        }
    }

    private static void b(Object[] objectArray, Object[] objectArray2, Comparator comparator, int n2, int n3) {
        do {
            int n4 = n2;
            int n5 = n3;
            int n6 = Array.c(n4, n5);
            Array.a(objectArray, objectArray2, comparator, n4, n6);
            Array.a(objectArray, objectArray2, comparator, n4, n5);
            Array.a(objectArray, objectArray2, comparator, n6, n5);
            Object object = objectArray[n6];
            do {
                try {
                    while (comparator.compare(objectArray[n4], object) < 0) {
                        ++n4;
                    }
                    while (comparator.compare(object, objectArray[n5]) < 0) {
                        --n5;
                    }
                }
                catch (IndexOutOfRangeException indexOutOfRangeException) {
                    throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
                }
                if (n4 > n5) break;
                if (n4 >= n5) continue;
                Object object2 = objectArray[n4];
                objectArray[n4] = objectArray[n5];
                objectArray[n5] = object2;
                if (objectArray2 == null) continue;
                Object object3 = objectArray2[n4];
                objectArray2[n4] = objectArray2[n5];
                objectArray2[n5] = object3;
            } while (++n4 <= --n5);
            if (n5 - n2 <= n3 - n4) {
                if (n2 < n5) {
                    Array.b(objectArray, objectArray2, comparator, n2, n5);
                }
                n2 = n4;
                continue;
            }
            if (n4 < n3) {
                Array.b(objectArray, objectArray2, comparator, n4, n3);
            }
            n3 = n5;
        } while (n2 < n3);
    }

    private static <T> void b(Array array, Array array2, Comparator comparator, int n2, int n3) {
        do {
            int n4 = n2;
            int n5 = n3;
            int n6 = Array.c(n4, n5);
            Array.a(array, array2, comparator, n4, n6);
            Array.a(array, array2, comparator, n4, n5);
            Array.a(array, array2, comparator, n6, n5);
            Object object = array.getValue(n6);
            do {
                try {
                    while (comparator.compare(array.getValue(n4), object) < 0) {
                        ++n4;
                    }
                    while (comparator.compare(object, array.getValue(n5)) < 0) {
                        --n5;
                    }
                }
                catch (IndexOutOfRangeException indexOutOfRangeException) {
                    throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
                }
                if (n4 > n5) break;
                if (n4 < n5) {
                    Object object2 = array.getValue(n4);
                    array.setValue(array.getValue(n5), n4);
                    array.setValue(object2, n5);
                    if (array2 != null) {
                        Object object3 = array2.getValue(n4);
                        array2.setValue(array2.getValue(n5), n4);
                        array2.setValue(object3, n5);
                    }
                }
                if (n4 != Integer.MAX_VALUE) {
                    ++n4;
                }
                if (n5 == Integer.MIN_VALUE) continue;
                --n5;
            } while (n4 <= n5);
            if (n5 - n2 <= n3 - n4) {
                if (n2 < n5) {
                    Array.b(array, array2, comparator, n2, n5);
                }
                n2 = n4;
                continue;
            }
            if (n4 < n3) {
                Array.b(array, array2, comparator, n4, n3);
            }
            n3 = n5;
        } while (n2 < n3);
    }

    public static class FunctorComparer<T>
    implements Comparator<T> {
        private final Comparison<T> a;

        public FunctorComparer(Comparison<T> comparison) {
            this.a = comparison;
        }

        @Override
        public int compare(T x2, T y2) {
            return this.a.invoke(x2, y2);
        }
    }

    public static abstract class ElementInitializer<T> {
        public abstract T createInstance();
    }

    private static class MultiDimensionalEnumerator
    implements ArrayEnumerator,
    IEnumerator,
    ICloneable,
    Cloneable {
        private final Array a;
        private int b;
        private int c;
        private int d;
        private boolean e;
        private int[] f;

        private MultiDimensionalEnumerator(MultiDimensionalEnumerator enumerator) {
            this.a = enumerator.a;
            this.b = enumerator.b;
            this.c = enumerator.c;
            this.d = enumerator.d;
            this.e = enumerator.e;
            this.f = (int[])enumerator.f.clone();
        }

        MultiDimensionalEnumerator(Array array, int startIndex, int count) {
            this.a = array;
            this.d = startIndex;
            this.b = startIndex + count - 1;
            this.f = new int[array.getRank()];
            this.reset();
        }

        private void b() {
            if (this.c < this.d) {
                throw new InvalidOperationException("Enumeration has not started");
            }
            if (this.e) {
                throw new InvalidOperationException("Enumeration has already ended");
            }
        }

        @Override
        public Object next() {
            this.b();
            return this.a.getValueImpl(this.f);
        }

        @Override
        public void a(Object object) {
            this.b();
            this.a.setValueImpl(object, this.f);
        }

        private void c() {
            ++this.c;
            if (this.c > this.b) {
                this.e = true;
                return;
            }
            int n2 = this.a.getRank();
            int n3 = n2 - 1;
            this.f[n3] = this.f[n3] + 1;
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (this.f[i2] <= this.a.getUpperBound(i2)) continue;
                if (i2 == 0) {
                    this.e = true;
                    this.f[0] = this.a.getLowerBound(0);
                    return;
                }
                for (int i3 = i2; i3 < n2; ++i3) {
                    this.f[i3] = this.a.getLowerBound(i3);
                }
                int n4 = i2 - 1;
                this.f[n4] = this.f[n4] + 1;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.e) {
                return false;
            }
            this.c();
            return !this.e;
        }

        @Override
        public void reset() {
            int n2;
            this.c = this.d - 1;
            int[] nArray = new int[]{this.d};
            int n3 = 1;
            for (n2 = 0; n2 < this.a.getRank(); ++n2) {
                int n4 = this.a.getLength(n2);
                this.f[n2] = msMath.divRem(nArray[0], n4, nArray);
                n3 *= n4;
            }
            n2 = this.a.getLength(this.f.length - 1);
            this.f[this.f.length - 1] = nArray[0] - 1;
            this.e = (n3 *= n2) == 0 || this.d > this.b;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return new MultiDimensionalEnumerator(this);
        }

        @Override
        public void remove() {
            throw new NotSupportedException("Collection was of a fixed size.");
        }
    }

    private static class OneDimensionalEnumerator
    implements ArrayEnumerator {
        private final Array a;
        private int b;
        private int c;
        private int d;
        private boolean e;

        private OneDimensionalEnumerator(OneDimensionalEnumerator enumerator) {
            this.a = enumerator.a;
            this.b = enumerator.b;
            this.c = enumerator.c;
            this.d = enumerator.d;
            this.e = enumerator.e;
        }

        public OneDimensionalEnumerator(Array array, int startIndex, int count) {
            this.a = array;
            this.b = startIndex;
            this.d = startIndex + count - 1;
            this.reset();
        }

        private void b() {
            if (this.c < this.b) {
                throw new InvalidOperationException("Enumeration has not started.");
            }
            if (this.e) {
                throw new InvalidOperationException("Enumeration has already ended");
            }
        }

        @Override
        public Object next() {
            this.b();
            return this.a.getValueImpl(this.c);
        }

        @Override
        public void a(Object object) {
            this.b();
            this.a.setValueImpl(object, this.c);
        }

        private void c() {
            ++this.c;
            this.e = this.c > this.d;
        }

        @Override
        public boolean hasNext() {
            if (this.e) {
                return false;
            }
            this.c();
            return !this.e;
        }

        @Override
        public void reset() {
            this.c = this.b - 1;
            this.e = this.b > this.d;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return new OneDimensionalEnumerator(this);
        }

        @Override
        public void remove() {
            throw new NotSupportedException("Collection was of a fixed size.");
        }
    }

    private static interface ArrayEnumerator
    extends IEnumerator,
    ICloneable,
    Cloneable {
        public void a(Object var1);
    }

    private static class GenericArray<T>
    implements IGenericList<T> {
        private Array a;

        private GenericArray(Array array) {
            this.a = array;
        }

        @Override
        public int indexOfItem(T item) {
            return this.a.indexOf(item);
        }

        @Override
        public void insertItem(int index, T item) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public T get_Item(int index) {
            return (T)this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, T value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.getLength();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(T item) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read-only");
        }

        @Override
        public boolean containsItem(T item) {
            return this.a.contains(item);
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            this.a.copyTo(Array.boxing(array), arrayIndex);
        }

        @Override
        public boolean removeItem(T item) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public IGenericEnumerator<T> iterator() {
            return new GenericEnumerator();
        }

        private class GenericEnumerator<T>
        implements IGenericEnumerator<T> {
            IEnumerator a;

            private GenericEnumerator() {
                this.a = GenericArray.this.a.iterator();
            }

            @Override
            public T next() {
                return this.a.next();
            }

            @Override
            public void remove() {
                this.a.remove();
            }

            @Override
            public boolean hasNext() {
                return this.a.hasNext();
            }

            @Override
            public void reset() {
                this.a.reset();
            }

            @Override
            public void dispose() {
            }
        }
    }

    static interface Swapper {
        public void a(int var1, int var2);
    }

    private static final class MultiDimensional
    extends Box {
        private MultiDimensional(Object javaArray, int rank, boolean isJagged) {
            super(javaArray, rank, isJagged);
        }

        @Override
        protected ArrayEnumerator createEnumerator(int index, int count) {
            return new MultiDimensionalEnumerator(this, index, count);
        }

        @Override
        protected Object getValueImpl(int index) {
            int[] nArray = this.a(index);
            return this.getValueImpl(nArray);
        }

        private int[] a(int n2) {
            Info info = this.getArrayInfo();
            int[] nArray = new int[info.a];
            for (int i2 = info.a - 1; i2 >= 0; --i2) {
                int n3 = this.getLength(i2);
                nArray[i2] = n2 % n3;
                n2 /= n3;
            }
            return nArray;
        }

        @Override
        protected Object getValueImpl(int ... indices) {
            if (this.getArrayInfo().a != indices.length) {
                throw new ArgumentException("Indices length does not match the array rank.");
            }
            Object object = this.getInternalObject();
            for (int i2 = 0; i2 < indices.length; ++i2) {
                a a2 = i2 == indices.length - 1 ? this.getArrayHelper() : a.a();
                object = Array.b(a2, object, indices[i2]);
            }
            return object;
        }

        @Override
        protected void setValueImpl(Object value, int index) {
            int[] nArray = this.a(index);
            this.setValueImpl(value, nArray);
        }
    }

    private static final class OneDimensional
    extends Box {
        private OneDimensional(Object javaArray, boolean isJagged) {
            super(javaArray, 1, isJagged);
        }

        @Override
        protected ArrayEnumerator createEnumerator(int startIndex, int count) {
            return new OneDimensionalEnumerator(this, startIndex, count);
        }

        @Override
        protected Object getValueImpl(int index) {
            return this.getValueImpl(new int[]{index});
        }

        @Override
        protected Object getValueImpl(int ... indices) {
            int n2 = indices[0];
            return Array.b(this.getArrayHelper(), this.getInternalObject(), n2);
        }

        @Override
        protected void setValueImpl(Object value, int index) {
            this.setValueImpl(value, new int[]{index});
        }

        @Override
        protected void setValueImpl(Object value, int ... indices) {
            int n2 = indices[0];
            Class clazz = this.getArrayInfo().b;
            if (value == null && clazz.isPrimitive()) {
                value = Operators.defaultValue(clazz);
            }
            if (value != null && !ConversionUtils.isCompatible(value.getClass(), clazz) && (clazz.isPrimitive() || ConversionUtils.getUnboxedClass(clazz) != null)) {
                throw new ArgumentException("Cannot widen from source type to target type either because the source type is a not a primitive type or the conversion cannot be accomplished");
            }
            try {
                Array.b(this.getArrayHelper(), this.getInternalObject(), n2, value);
            }
            catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
                throw argumentOutOfRangeException;
            }
            catch (java.lang.Exception exception) {
                throw new InvalidCastException("Cannot save value in this array");
            }
        }
    }

    private static abstract class Box
    extends Array {
        private final Object a;
        private final Info b;
        private final a c;

        Box(Object javaArray, Info info) {
            this.a = javaArray;
            this.b = info;
            this.c = com.aspose.html.internal.ms.core.System.a.a(info.b);
        }

        Box(Object javaArray, int rank, boolean isJagged) {
            this(javaArray, new Info(javaArray, rank, isJagged));
        }

        @Override
        protected Object getInternalObject() {
            return this.a;
        }

        @Override
        protected Info getArrayInfo() {
            return this.b;
        }

        @Override
        protected a getArrayHelper() {
            return this.c;
        }
    }

    private static final class Info {
        private final int a;
        private final Class<?> b;
        private final int[] c;
        private final boolean d;
        private final long e;

        private Info(Object array, int arrayRank, boolean isJagged) {
            int n2 = 0;
            Class<?> clazz = null;
            Class<?> clazz2 = array.getClass().getComponentType();
            while (clazz2 != null) {
                clazz = clazz2;
                clazz2 = clazz.getComponentType();
                if (!isJagged || ++n2 != arrayRank) continue;
            }
            if (n2 == 0) {
                throw new ArgumentException("Array required");
            }
            if (arrayRank > n2) {
                throw new ArgumentException("Required arrays dimension doesn't match to actual", "rank");
            }
            this.a = arrayRank;
            this.b = clazz;
            this.c = new int[this.a];
            for (int i2 = 0; i2 < arrayRank; ++i2) {
                this.c[i2] = -1;
            }
            this.d = isJagged;
            Object object = array;
            int n3 = 0;
            int n4 = 1;
            a a2 = com.aspose.html.internal.ms.core.System.a.a();
            a a3 = com.aspose.html.internal.ms.core.System.a.a(this.b);
            while (true) {
                int n5;
                if (object == null && !isJagged) {
                    throw new ArgumentException("Jagged array not expected", "array");
                }
                boolean bl2 = n3 < arrayRank - 1;
                int n6 = n5 = bl2 ? a2.a(object) : a3.a(object);
                if ((n4 *= n5) == 0) break;
                this.c[n3] = n5 - 1;
                if (!bl2) break;
                object = Array.b(a2, object, 0);
                ++n3;
            }
            this.e = n4;
        }

        final boolean a() {
            return false;
        }

        final boolean b() {
            return false;
        }
    }
}

