/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.forms;

import com.aspose.html.HTMLDataListElement;
import com.aspose.html.HTMLInputElement;
import com.aspose.html.Url;
import com.aspose.html.dom.Element;
import com.aspose.html.drawing.Color;
import com.aspose.html.forms.DataListElement;
import com.aspose.html.forms.FormElement;
import com.aspose.html.forms.InputElementType;
import com.aspose.html.internal.ms.System.ByteExtensions;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.EnumExtensions;
import com.aspose.html.internal.ms.System.Globalization.NumberFormatInfo;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.File;
import com.aspose.html.internal.ms.System.IO.FileStream;
import com.aspose.html.internal.ms.System.IO.MemoryStream;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p4.z38;
import com.aspose.html.io.z2;
import com.aspose.html.io.z3;
import com.aspose.time.TimeSpan;

public class InputElement
extends FormElement<HTMLInputElement> {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("hidden", "text", "search", "tel", "url", "email", "password", "date", "month", "week", "time", "datetime-local", "number", "range", "color", "checkbox", "radio", "file", "submit", "image", "reset", "button");
    private DataListElement _list;

    public InputElement(HTMLInputElement element) {
        super(element, 1);
    }

    @Override
    public String getName() {
        return ((HTMLInputElement)this.getHtmlElement()).getName();
    }

    @Override
    public void setName(String value) {
        ((HTMLInputElement)this.getHtmlElement()).setName(value);
    }

    @Override
    public String getId() {
        return ((HTMLInputElement)this.getHtmlElement()).getId_Rename_Namesake();
    }

    @Override
    public void setId(String value) {
        ((HTMLInputElement)this.getHtmlElement()).setId_Rename_Namesake(value);
    }

    public DataListElement getList() {
        HTMLDataListElement hTMLDataListElement;
        if (!StringExtensions.isNullOrEmpty(((HTMLInputElement)this.getHtmlElement()).getList()) && (hTMLDataListElement = (HTMLDataListElement)((HTMLInputElement)this.getHtmlElement()).getForm().getOwnerDocument().getElementById(((HTMLInputElement)this.getHtmlElement()).getList())) != null) {
            this._list = new DataListElement((HTMLDataListElement)((HTMLInputElement)this.getHtmlElement()).getForm().getOwnerDocument().getElementById(((HTMLInputElement)this.getHtmlElement()).getList()));
        }
        return this._list;
    }

    private void setList(DataListElement value) {
    }

    @Override
    public String getValue() {
        return ((HTMLInputElement)this.getHtmlElement()).getValue();
    }

    @Override
    public void setValue(String value) {
        ((HTMLInputElement)this.getHtmlElement()).setValue(value);
    }

    public int getType() {
        return this.inputElementTypeToEnum(((HTMLInputElement)this.getHtmlElement()).getType());
    }

    public void setType(int value) {
        ((HTMLInputElement)this.getHtmlElement()).setType(this.inputElementTypeToString(value));
    }

    public Url getUrlValue() {
        if (!this.checkIsValidType(5)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return new Url(((HTMLInputElement)this.getHtmlElement()).getValue());
    }

    public void setUrlValue(Url value) {
        if (!this.checkIsValidType(5)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(value.toString());
    }

    public String getEmailValue() {
        if (!this.checkIsValidType(6)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return ((HTMLInputElement)this.getHtmlElement()).getValue();
    }

    public void setEmailValue(String value) {
        if (!this.checkIsValidType(6)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(value);
    }

    public String getPasswordValue() {
        if (!this.checkIsValidType(7)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return ((HTMLInputElement)this.getHtmlElement()).getValue();
    }

    public void setPasswordValue(String value) {
        if (!this.checkIsValidType(7)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(value);
    }

    public DateTime getDateValue() {
        if (!this.checkIsValidType(8)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return DateTime.parse(((HTMLInputElement)this.getHtmlElement()).getValue());
    }

    public void setDateValue(DateTime value) {
        if (!this.checkIsValidType(8)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(value.toString("yyyy-MM-dd"));
    }

    public DateTime getMonthValue() {
        if (!this.checkIsValidType(9)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return DateTime.parse(((HTMLInputElement)this.getHtmlElement()).getValue());
    }

    public void setMonthValue(DateTime value) {
        if (!this.checkIsValidType(9)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(value.toString("yyyy-MM"));
    }

    public String getWeekValue() {
        if (!this.checkIsValidType(10)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return ((HTMLInputElement)this.getHtmlElement()).getValue();
    }

    public void setWeekValue(String value) {
        if (!this.checkIsValidType(10)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(value);
    }

    public TimeSpan getTimeValue() {
        if (!this.checkIsValidType(11)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        TimeSpan timeSpan = new TimeSpan();
        TimeSpan[] timeSpanArray = new TimeSpan[]{timeSpan};
        boolean bl2 = !TimeSpan.tryParse(((HTMLInputElement)this.getHtmlElement()).getValue(), timeSpanArray);
        timeSpanArray[0].CloneTo(timeSpan);
        if (bl2) {
            return TimeSpan.Zero;
        }
        return timeSpan;
    }

    public void setTimeValue(TimeSpan value) {
        if (!this.checkIsValidType(11)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        String string = "{0:D2}:{1:D2}";
        if (value.getMilliseconds() != 0) {
            string = StringExtensions.concat(string, ":{2:D2}.{3:D3}");
        } else if (value.getSeconds() != 0) {
            string = StringExtensions.concat(string, ":{2:D2}");
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(StringExtensions.format(string, value.getHours(), value.getMinutes(), value.getSeconds(), value.getMilliseconds()));
    }

    public DateTime getDateTimeLocalValue() {
        if (!this.checkIsValidType(12)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return DateTime.parse(((HTMLInputElement)this.getHtmlElement()).getValue());
    }

    public void setDateTimeLocalValue(DateTime value) {
        if (!this.checkIsValidType(12)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of this instance.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(value.toString("yyyy-MM-ddTHH:mm:ss.FFF"));
    }

    public float getNumberValue() {
        if (!this.checkIsValidType(13)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        float f2 = 0.0f;
        float[] fArray = new float[]{0.0f};
        SingleExtensions.tryParse(((HTMLInputElement)this.getHtmlElement()).getValue(), 511, com.aspose.html.dom.z2.DEFAULT_CULTURE.getNumberFormat(), fArray);
        f2 = fArray[0];
        return f2;
    }

    public void setNumberValue(float value) {
        if (!this.checkIsValidType(13)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setValue(SingleExtensions.toString(value, NumberFormatInfo.getInvariantInfo()));
    }

    public Color getColorValue() {
        if (!this.checkIsValidType(15)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        try {
            return com.aspose.html.drawing.z3.m289(this.getValue());
        }
        catch (RuntimeException runtimeException) {
            return Color.getTransparent();
        }
    }

    public void setColorValue(Color value) {
        if (!this.checkIsValidType(15)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        msStringBuilder msStringBuilder2 = new msStringBuilder("#");
        msStringBuilder2.append(ByteExtensions.toString(value.getR(), "X2"));
        msStringBuilder2.append(ByteExtensions.toString(value.getG(), "X2"));
        msStringBuilder2.append(ByteExtensions.toString(value.getB(), "X2"));
        ((HTMLInputElement)this.getHtmlElement()).setValue(msStringBuilder2.toString());
    }

    public boolean getCheckboxValue() {
        if (!this.checkIsValidType(16)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return ((HTMLInputElement)this.getHtmlElement()).getChecked();
    }

    public void setCheckboxValue(boolean value) {
        if (!this.checkIsValidType(16)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setChecked(value);
    }

    public boolean getRadioValue() {
        if (!this.checkIsValidType(17)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        return ((HTMLInputElement)this.getHtmlElement()).getChecked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRadioValue(boolean value) {
        if (!this.checkIsValidType(17)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        ((HTMLInputElement)this.getHtmlElement()).setChecked(value);
        IEnumerator iEnumerator = ((HTMLInputElement)this.getHtmlElement()).getForm().getElements().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element = (Element)iEnumerator.next();
                HTMLInputElement hTMLInputElement = (HTMLInputElement)element;
                if (!"radio".equals(hTMLInputElement.getType()) || hTMLInputElement.getName() == null || !StringExtensions.equals(hTMLInputElement.getName(), ((HTMLInputElement)this.getHtmlElement()).getName(), (short)5) || ((HTMLInputElement)this.getHtmlElement()).equals(hTMLInputElement)) continue;
                hTMLInputElement.setChecked(!((HTMLInputElement)this.getHtmlElement()).getChecked());
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String uri) {
        if (!this.checkIsValidType(18)) {
            throw new NotSupportedException(StringExtensions.format("This method is not compatible to '{0}' type of current instance, please use corresponding getter or direct access via 'value' property.", EnumExtensions.toString(InputElementType.class, this.getType())));
        }
        Url url = new Url(uri);
        FileStream fileStream = File.openRead(uri);
        try {
            MemoryStream memoryStream = new MemoryStream();
            try {
                int n2;
                byte[] byArray = new byte[16384];
                while ((n2 = ((Stream)fileStream).read(byArray, 0, byArray.length)) > 0) {
                    memoryStream.write(byArray, 0, n2);
                }
                memoryStream.flush();
                z2 z2100 = new z2(memoryStream.toArray(), z38.m15(url));
                ((z3)((HTMLInputElement)this.getHtmlElement()).getFiles()).addItem(z2100);
            }
            finally {
                if (memoryStream != null) {
                    memoryStream.dispose();
                }
            }
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
    }

    private String inputElementTypeToString(int elementType) {
        switch (elementType) {
            case 1: {
                return "hidden";
            }
            case 2: {
                return "text";
            }
            case 3: {
                return "search";
            }
            case 4: {
                return "tel";
            }
            case 5: {
                return "url";
            }
            case 6: {
                return "email";
            }
            case 7: {
                return "password";
            }
            case 8: {
                return "date";
            }
            case 9: {
                return "month";
            }
            case 10: {
                return "week";
            }
            case 11: {
                return "time";
            }
            case 12: {
                return "datetime-local";
            }
            case 13: {
                return "number";
            }
            case 14: {
                return "range";
            }
            case 15: {
                return "color";
            }
            case 16: {
                return "checkbox";
            }
            case 17: {
                return "radio";
            }
            case 18: {
                return "file";
            }
            case 19: {
                return "submit";
            }
            case 20: {
                return "image";
            }
            case 21: {
                return "reset";
            }
            case 22: {
                return "button";
            }
        }
        return StringExtensions.Empty;
    }

    private int inputElementTypeToEnum(String elementType) {
        switch (gStringSwitchMap.of(elementType)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 9;
            }
            case 9: {
                return 10;
            }
            case 10: {
                return 11;
            }
            case 11: {
                return 12;
            }
            case 12: {
                return 13;
            }
            case 13: {
                return 14;
            }
            case 14: {
                return 15;
            }
            case 15: {
                return 16;
            }
            case 16: {
                return 17;
            }
            case 17: {
                return 18;
            }
            case 18: {
                return 19;
            }
            case 19: {
                return 20;
            }
            case 20: {
                return 21;
            }
            case 21: {
                return 22;
            }
        }
        return 0;
    }

    private boolean checkIsValidType(int validType) {
        return this.getType() == validType;
    }
}

