/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.forms;

import com.aspose.html.HTMLButtonElement;
import com.aspose.html.HTMLDocument;
import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.HTMLInputElement;
import com.aspose.html.HTMLObjectElement;
import com.aspose.html.HTMLOptionElement;
import com.aspose.html.HTMLSelectElement;
import com.aspose.html.HTMLTextAreaElement;
import com.aspose.html.Url;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.z2;
import com.aspose.html.forms.FormEditor;
import com.aspose.html.forms.SubmissionResult;
import com.aspose.html.internal.ms.System.ApplicationException;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.KeyValuePair;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.Net.CookieContainer;
import com.aspose.html.internal.ms.System.Net.CredentialCache;
import com.aspose.html.internal.ms.System.Net.ICredentials;
import com.aspose.html.internal.ms.System.NotSupportedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.Encoding;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p259.z4;
import com.aspose.html.internal.p331.z6;
import com.aspose.html.internal.p4.z23;
import com.aspose.html.internal.p4.z52;
import com.aspose.html.net.ByteArrayContent;
import com.aspose.html.net.Content;
import com.aspose.html.net.FormUrlEncodedContent;
import com.aspose.html.net.HttpMethod;
import com.aspose.html.net.MultipartFormDataContent;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.net.StringContent;
import com.aspose.time.TimeSpan;

public class FormSubmitter
implements IDisposable {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("application/x-www-form-urlencoded", "multipart/form-data", "text/plain");
    private HTMLFormElement _form;
    private HttpMethod _method;
    private String _action;
    private SubmissionResult lastResult;

    public FormSubmitter(HTMLFormElement form) {
        this._form = form;
    }

    public FormSubmitter(HTMLDocument document, int index) {
        HTMLFormElement hTMLFormElement = Operators.as(document.getForms().get_Item(index), HTMLFormElement.class);
        if (hTMLFormElement == null) {
            throw com.aspose.html.internal.p68.z1.m1208();
        }
        this._form = hTMLFormElement;
    }

    public FormSubmitter(HTMLDocument document, String id2) {
        Element element = document.getElementById(id2);
        if (element == null) {
            throw com.aspose.html.internal.p68.z1.m1213();
        }
        HTMLFormElement hTMLFormElement = Operators.as(element, HTMLFormElement.class);
        if (hTMLFormElement == null) {
            throw com.aspose.html.internal.p68.z1.m1240();
        }
        this._form = hTMLFormElement;
    }

    public FormSubmitter(FormEditor editor) {
        this._form = editor.getForm();
    }

    private static String normalizeLineBreaks(String input) {
        msStringBuilder msStringBuilder2 = new msStringBuilder(Operators.castToInt32((double)input.length() * 1.1, 14));
        boolean bl2 = false;
        block4: for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (bl2) {
                bl2 = false;
                if (c2 == '\n') continue;
            }
            switch (c2) {
                case '\r': {
                    msStringBuilder2.append("\r\n");
                    bl2 = true;
                    continue block4;
                }
                case '\n': {
                    msStringBuilder2.append("\r\n");
                    continue block4;
                }
                default: {
                    msStringBuilder2.append(c2);
                }
            }
        }
        return msStringBuilder2.toString();
    }

    public HttpMethod getMethod() {
        if (this._method == null) {
            if (!StringExtensions.isNullOrEmpty(this._form.getMethod())) {
                return new HttpMethod(this._form.getMethod());
            }
            return HttpMethod.getGet();
        }
        return this._method;
    }

    public void setMethod(HttpMethod value) {
        this._method = value;
    }

    public String getAction() {
        if (this._action == null) {
            return this._form.getAction();
        }
        return this._action;
    }

    public void setAction(String value) {
        this._action = value;
    }

    public SubmissionResult submit() {
        return this.submit(CredentialCache.getDefaultCredentials(), TimeSpan.fromSeconds(100.0).Clone(), false, this._form.getOwnerDocument().getCookies());
    }

    public SubmissionResult submit(CookieContainer cookieContainer) {
        return this.submit(CredentialCache.getDefaultCredentials(), TimeSpan.fromSeconds(100.0).Clone(), false, cookieContainer);
    }

    public SubmissionResult submit(ICredentials credentials) {
        return this.submit(credentials, TimeSpan.fromSeconds(100.0).Clone(), true);
    }

    public SubmissionResult submit(ICredentials credentials, CookieContainer cookieContainer) {
        return this.submit(credentials, TimeSpan.fromSeconds(100.0).Clone(), true, cookieContainer);
    }

    public SubmissionResult submit(TimeSpan timeout) {
        return this.submit(CredentialCache.getDefaultCredentials(), timeout.Clone(), false);
    }

    public SubmissionResult submit(TimeSpan timeout, CookieContainer cookieContainer) {
        return this.submit(CredentialCache.getDefaultCredentials(), timeout.Clone(), false, cookieContainer);
    }

    public SubmissionResult submit(ICredentials credentials, TimeSpan timeout) {
        return this.submit(credentials, timeout.Clone(), true, this._form.getOwnerDocument().getCookies());
    }

    public SubmissionResult submit(ICredentials credentials, TimeSpan timeout, CookieContainer cookieContainer) {
        return this.submit(credentials, timeout.Clone(), true, cookieContainer);
    }

    public SubmissionResult submit(ICredentials credentials, TimeSpan timeout, boolean preAuthenticate) {
        return this.submit(credentials, timeout.Clone(), preAuthenticate, this._form.getOwnerDocument().getCookies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubmissionResult submit(ICredentials credentials, TimeSpan timeout, boolean preAuthenticate, CookieContainer cookieContainer) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        HttpMethod httpMethod;
        Object object5;
        HTMLDocument hTMLDocument = (HTMLDocument)this._form.getOwnerDocument();
        if ((hTMLDocument.getContext().getSecurity() & 0x20) == 32) {
            return null;
        }
        HTMLElement hTMLElement = this.getSubmitButton();
        Object object6 = this.getAction();
        if (StringExtensions.isNullOrEmpty((String)object6)) {
            object6 = hTMLDocument.getDocumentURI();
        }
        if (hTMLElement != null && !StringExtensions.isNullOrEmpty((String)(object5 = hTMLElement.getAttribute("formaction")))) {
            object6 = object5;
        }
        object5 = new Url((String)object6, hTMLDocument.getBaseURI());
        List<z52<String, z1, String>> list = this.getDataSetFromForm(hTMLElement);
        IDisposable iDisposable = (IDisposable)((z6)z23.get("Func3<Document, List<Tuple3<String, FormSubmitter.Value,String>>, IDisposable>")).m1(this._form.getOwnerDocument(), list);
        try {
            z4 z4100 = ((Url)object5).UrlRecord.m16663;
            if (!z2.z10.m4148.m2(z4100) && !z2.z10.m4149.m2(z4100)) {
                throw new NotSupportedException(StringExtensions.format("Scheme {0} is not supported.", z4100));
            }
            httpMethod = this.getMethodFromSubmitter(hTMLElement);
            string = this.getEnctypeFromSubmitter(hTMLElement);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
        if (HttpMethod.op_Equality(HttpMethod.getGet(), httpMethod)) {
            ((Url)object5).UrlRecord.m16656 = new com.aspose.html.internal.p262.z2().m87(list);
            RequestMessage requestMessage = new RequestMessage((Url)object5);
            requestMessage.setMethod(HttpMethod.getGet());
            requestMessage.setCredentials(credentials);
            requestMessage.setPreAuthenticate(true);
            requestMessage.setCookieContainer(cookieContainer);
            this.lastResult = new SubmissionResult(requestMessage, this._form.getOwnerDocument().getContext().getNetwork().send(requestMessage), this._form);
            return this.lastResult;
        }
        Encoding encoding = this.pickEncodingForForm();
        List<KeyValuePair<String, String>> list2 = new List<KeyValuePair<String, String>>();
        switch (gStringSwitchMap.of(string)) {
            case 0: {
                object4 = list.iterator();
                try {
                    while (object4.hasNext()) {
                        object3 = (z52)object4.next();
                        object2 = ((z1)((z52)object3).m161()).getStringValue();
                        if (!StringExtensions.isNullOrEmpty((String)((z52)object3).m163()) && "hidden".equals(((z52)object3).m163()) && "_charset_".equals(((z52)object3).m160())) {
                            object2 = this.pickEncodingForForm().getEncodingName();
                        }
                        list2.addItem(new KeyValuePair<String, Object>((String)((z52)object3).m160(), object2));
                    }
                }
                finally {
                    if (Operators.is(object4, IDisposable.class)) {
                        ((IDisposable)object4).dispose();
                    }
                }
                object = new FormUrlEncodedContent(list2);
                break;
            }
            case 1: {
                object4 = encoding.getEncodingName();
                object3 = new MultipartFormDataContent();
                object2 = list.iterator();
                try {
                    while (object2.hasNext()) {
                        z52 z5210 = (z52)object2.next();
                        byte[] byArray = ((z1)z5210.m161()).m1988();
                        if (!StringExtensions.isNullOrEmpty((String)z5210.m163()) && "hidden".equals(z5210.m163()) && "_charset_".equals(z5210.m160())) {
                            byArray = z2.m3363.getBytes((String)object4);
                        }
                        ByteArrayContent byteArrayContent = new ByteArrayContent(byArray);
                        if ("file".equals(z5210.m163())) {
                            String string2 = Path.getFileName(((z1)z5210.m161()).getName());
                            ((MultipartFormDataContent)object3).add(byteArrayContent, (String)z5210.m160(), string2);
                            continue;
                        }
                        ((MultipartFormDataContent)object3).add(byteArrayContent, (String)z5210.m160());
                    }
                }
                finally {
                    if (Operators.is(object2, IDisposable.class)) {
                        ((IDisposable)object2).dispose();
                    }
                }
                object = object3;
                break;
            }
            case 2: {
                object4 = list.iterator();
                try {
                    while (object4.hasNext()) {
                        object3 = (z52)object4.next();
                        object2 = ((z1)((z52)object3).m161()).getStringValue();
                        if (!StringExtensions.isNullOrEmpty((String)((z52)object3).m163()) && "hidden".equals(((z52)object3).m163()) && "_charset_".equals(((z52)object3).m160())) {
                            object2 = encoding.getEncodingName();
                        }
                        list2.addItem(new KeyValuePair<String, Object>((String)((z52)object3).m160(), object2));
                    }
                }
                finally {
                    if (Operators.is(object4, IDisposable.class)) {
                        ((IDisposable)object4).dispose();
                    }
                }
                object3 = new msStringBuilder();
                object2 = list2.iterator();
                try {
                    while (object2.hasNext()) {
                        KeyValuePair keyValuePair = (KeyValuePair)object2.next();
                        ((msStringBuilder)object3).append((String)keyValuePair.getKey());
                        ((msStringBuilder)object3).append('=');
                        ((msStringBuilder)object3).append((String)keyValuePair.getValue());
                        ((msStringBuilder)object3).append("\r\n");
                    }
                }
                finally {
                    if (Operators.is(object2, IDisposable.class)) {
                        ((IDisposable)object2).dispose();
                    }
                }
                object = new StringContent(((msStringBuilder)object3).toString(), encoding);
                break;
            }
            default: {
                throw new ApplicationException(StringExtensions.format("The enctype '{0}' is not supported while submitting data to the server.", string));
            }
        }
        object4 = (IDisposable)((z6)z23.get("Func3<Document, Stream, IDisposable>")).m1(this._form.getOwnerDocument(), ((Content)object).readAsStream());
        try {
            object3 = new RequestMessage((Url)object5);
            ((RequestMessage)object3).setMethod(httpMethod);
            ((RequestMessage)object3).setContent((Content)object);
            ((RequestMessage)object3).setCredentials(credentials);
            ((RequestMessage)object3).setPreAuthenticate(preAuthenticate);
            ((RequestMessage)object3).setTimeout(timeout.Clone());
            ((RequestMessage)object3).setCookieContainer(cookieContainer);
            this.lastResult = new SubmissionResult((RequestMessage)object3, this._form.getOwnerDocument().getContext().getNetwork().send((RequestMessage)object3), this._form);
            object2 = this.lastResult;
            return object2;
        }
        finally {
            if (object4 != null) {
                object4.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTMLElement getSubmitButton() {
        IEnumerator iEnumerator = this._form.getElements().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element = (Element)iEnumerator.next();
                if ((!ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3908) || !StringExtensions.equals("submit", ((HTMLInputElement)element).getType(), (short)5)) && (!ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3909) || !StringExtensions.equals("submit", ((HTMLButtonElement)element).getType(), (short)5))) continue;
                HTMLElement hTMLElement = (HTMLElement)element;
                return hTMLElement;
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return null;
    }

    private HttpMethod getMethodFromSubmitter(HTMLElement submitter) {
        String string;
        if (submitter != null && !StringExtensions.isNullOrEmpty(string = submitter.getAttribute("formethod"))) {
            return new HttpMethod(string);
        }
        return this.getMethod();
    }

    private String getEnctypeFromSubmitter(HTMLElement submitter) {
        String string;
        if (submitter != null && !StringExtensions.isNullOrEmpty(string = submitter.getAttribute("formenctype"))) {
            return StringExtensions.toLower(string);
        }
        return StringExtensions.toLower(this._form.getEnctype());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<z52<String, z1, String>> getDataSetFromForm(HTMLElement submitter) {
        List<HTMLElement> list = this.getSubmittableElements(submitter);
        List<z52<String, z1, String>> list2 = new List<z52<String, z1, String>>();
        IGenericEnumerator iGenericEnumerator = list.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                IDisposable iDisposable;
                Object object;
                IDisposable iDisposable2;
                HTMLElement hTMLElement = (HTMLElement)iGenericEnumerator.next();
                String string = this.getTypeOfField(hTMLElement);
                if ("image".equals(string)) continue;
                String string2 = hTMLElement.getAttribute("name");
                if (ObjectExtensions.referenceEquals(hTMLElement._Tag, z2.z9.m3910)) {
                    iDisposable2 = ((HTMLSelectElement)hTMLElement).getOptions().iterator();
                    try {
                        while (iDisposable2.hasNext()) {
                            object = (Element)iDisposable2.next();
                            iDisposable = (HTMLOptionElement)object;
                            if (!((HTMLOptionElement)iDisposable).getSelected() || ((HTMLOptionElement)iDisposable).getDisabled()) continue;
                            list2.addItem(new z52<String, z1, String>(string2, z1.m290(((HTMLOptionElement)iDisposable).getValue()), string));
                        }
                        continue;
                    }
                    finally {
                        if (!Operators.is(iDisposable2, IDisposable.class)) continue;
                        iDisposable2.dispose();
                        continue;
                    }
                }
                if (ObjectExtensions.referenceEquals(hTMLElement._Tag, z2.z9.m3908)) {
                    iDisposable2 = (HTMLInputElement)hTMLElement;
                    if ("checkbox".equals(((HTMLInputElement)iDisposable2).getType()) || "radio".equals(((HTMLInputElement)iDisposable2).getType())) {
                        object = "on";
                        if (hTMLElement.hasAttribute("value")) {
                            object = ((HTMLInputElement)hTMLElement).getValue();
                        }
                        list2.addItem(new z52<String, z1, String>(string2, z1.m290((String)object), string));
                        continue;
                    }
                    if ("file".equals(((HTMLInputElement)iDisposable2).getType())) {
                        boolean bl2 = false;
                        iDisposable = ((HTMLInputElement)hTMLElement).getFiles().iterator();
                        try {
                            while (iDisposable.hasNext()) {
                                com.aspose.html.io.z2 z2100 = (com.aspose.html.io.z2)iDisposable.next();
                                list2.addItem(new z52<String, z1, String>(string2, z1.m4(z2100), string));
                                bl2 = true;
                            }
                        }
                        finally {
                            if (Operators.is(iDisposable, IDisposable.class)) {
                                iDisposable.dispose();
                            }
                        }
                        if (bl2) continue;
                        list2.addItem(new z52<String, z1, String>(string2, z1.m290(StringExtensions.Empty), "application/octet-stream"));
                        continue;
                    }
                    list2.addItem(new z52<String, z1, String>(string2, z1.m290(((HTMLInputElement)hTMLElement).getValue()), string));
                    continue;
                }
                if (ObjectExtensions.referenceEquals(hTMLElement._Tag, z2.z9.m3914)) {
                    list2.addItem(new z52<String, z1, String>(string2, z1.m290(((HTMLTextAreaElement)hTMLElement).getValue()), string));
                    continue;
                }
                if (ObjectExtensions.referenceEquals(hTMLElement._Tag, z2.z9.m3888)) continue;
                list2.addItem(new z52<String, z1, String>(string2, z1.m290(((HTMLInputElement)hTMLElement).getValue()), string));
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        int n2 = 0;
        while (n2 < list2.size()) {
            if (!"file".equals(list2.get_Item(n2).m163()) && !"textarea".equals(list2.get_Item(n2).m163())) {
                list2.set_Item(n2, new z52<String, z1, String>(FormSubmitter.normalizeLineBreaks(list2.get_Item(n2).m160()), z1.m290(FormSubmitter.normalizeLineBreaks(list2.get_Item(n2).m161().getStringValue())), list2.get_Item(n2).m163()));
            }
            ++n2;
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HTMLElement> getSubmittableElements(HTMLElement submitter) {
        List<HTMLElement> list = new List<HTMLElement>();
        IEnumerator iEnumerator = this._form.getElements().iterator();
        try {
            while (iEnumerator.hasNext()) {
                Element element = (Element)iEnumerator.next();
                if (!ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3908) && !ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3888) && !ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3910) && !ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3914) || !this.isValidElementToSubmit((HTMLElement)element, submitter)) continue;
                list.addItem((HTMLElement)element);
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
        return list;
    }

    private boolean isValidElementToSubmit(HTMLElement element, HTMLElement submitter) {
        if (ObjectExtensions.referenceEquals(element.getParentElement()._Tag, z2.z9.m3911)) {
            return false;
        }
        if (element.hasAttribute("disabled")) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3909) && !element.equals(submitter)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3908)) {
            HTMLInputElement hTMLInputElement = (HTMLInputElement)element;
            if ("checkbox".equals(StringExtensions.toLower(hTMLInputElement.getType())) && !hTMLInputElement.getChecked()) {
                return false;
            }
            if ("radio".equals(StringExtensions.toLower(hTMLInputElement.getType())) && !hTMLInputElement.getChecked() && hTMLInputElement.getValue() != null && !"checked".equals(StringExtensions.toLower(hTMLInputElement.getValue()))) {
                return false;
            }
            if (!"image".equals(hTMLInputElement.getType()) && StringExtensions.isNullOrEmpty(hTMLInputElement.getAttribute("name"))) {
                return false;
            }
        }
        return !ObjectExtensions.referenceEquals(element._Tag, z2.z9.m3914) || !StringExtensions.isNullOrEmpty(element.getAttribute("name"));
    }

    private String getTypeOfField(HTMLElement element) {
        if (Operators.is(element, HTMLInputElement.class)) {
            return ((HTMLInputElement)element).getType();
        }
        if (Operators.is(element, HTMLSelectElement.class)) {
            return ((HTMLSelectElement)element).getType();
        }
        if (Operators.is(element, HTMLButtonElement.class)) {
            return ((HTMLButtonElement)element).getType();
        }
        if (Operators.is(element, HTMLObjectElement.class)) {
            return ((HTMLObjectElement)element).getType();
        }
        if (Operators.is(element, HTMLTextAreaElement.class)) {
            return ((HTMLTextAreaElement)element).getType();
        }
        return StringExtensions.Empty;
    }

    private Encoding pickEncodingForForm() {
        if (this._form.hasAttribute("accept-charset")) {
            String[] stringArray;
            String string = this._form.getAttribute("accept-charset");
            for (String string2 : stringArray = StringExtensions.split(string, new String[]{" "}, 1)) {
                try {
                    return Encoding.getEncoding(string2);
                }
                catch (RuntimeException runtimeException) {
                }
            }
        }
        return z2.m3363;
    }

    @Override
    public void dispose() {
        this._form = null;
        if (this.lastResult != null) {
            this.lastResult.dispose();
            this.lastResult = null;
        }
    }

    public static abstract class com.aspose.html.forms.FormSubmitter$z1 {
        public static final int m9104 = 1;
        public static final int m9105 = 2;

        public static com.aspose.html.forms.FormSubmitter$z1 m4(com.aspose.html.io.z2 z2100) {
            return new z1(z2100);
        }

        public static com.aspose.html.forms.FormSubmitter$z1 m290(String string) {
            return new z2(string);
        }

        public String getName() {
            return StringExtensions.Empty;
        }

        public abstract int getType();

        public abstract String getStringValue();

        public abstract byte[] m1988();

        private static class z2
        extends com.aspose.html.forms.FormSubmitter$z1 {
            private String value;

            public z2(String string) {
                this.value = string;
            }

            @Override
            public String getStringValue() {
                return this.value;
            }

            @Override
            public byte[] m1988() {
                return Encoding.getUTF8().getBytes(this.value);
            }

            @Override
            public int getType() {
                return 1;
            }
        }

        private static class z1
        extends com.aspose.html.forms.FormSubmitter$z1 {
            private com.aspose.html.io.z2 m9106;

            public z1(com.aspose.html.io.z2 z2100) {
                this.m9106 = z2100;
            }

            @Override
            public String getStringValue() {
                return this.m9106.toString();
            }

            @Override
            public byte[] m1988() {
                return this.m9106.getData();
            }

            @Override
            public String getName() {
                return this.m9106.getName();
            }

            @Override
            public int getType() {
                return 2;
            }
        }
    }
}

