/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.drawing;

import com.aspose.html.drawing.Dimension;
import com.aspose.html.drawing.Numeric;
import com.aspose.html.drawing.UnitType;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.p110.z5;

public class Resolution
extends Dimension {
    private static final z5 converter = new z5();

    public Resolution(double value, UnitType type) {
        super(value, type);
    }

    public static Resolution to_Resolution(double value) {
        return Resolution.fromDotsPerInch(value);
    }

    public static Resolution to_Resolution(float value) {
        return Resolution.fromDotsPerInch(value);
    }

    public static Resolution op_Addition(Resolution a2, Resolution b2) {
        double d2 = Numeric.z1.m1(a2, b2);
        d2 = converter.m1(d2, a2.getUnitType().getFraction(), a2.getUnitType());
        return new Resolution(d2, a2.getUnitType());
    }

    public static Resolution op_Subtraction(Resolution a2, Resolution b2) {
        double d2 = Numeric.z1.m2(a2, b2);
        d2 = converter.m1(d2, a2.getUnitType().getFraction(), a2.getUnitType());
        return new Resolution(d2, a2.getUnitType());
    }

    public static boolean op_LessThan(Resolution a2, Resolution b2) {
        return Numeric.z1.m4(a2, b2);
    }

    public static boolean op_GreaterThan(Resolution a2, Resolution b2) {
        return Numeric.z1.m6(a2, b2);
    }

    public static boolean op_LessThanOrEqual(Resolution a2, Resolution b2) {
        return Numeric.z1.m5(a2, b2);
    }

    public static boolean op_GreaterThanOrEqual(Resolution a2, Resolution b2) {
        return Numeric.z1.m7(a2, b2);
    }

    public static boolean op_Equality(Resolution a2, Resolution b2) {
        if (ObjectExtensions.referenceEquals(a2, b2)) {
            return true;
        }
        if (ObjectExtensions.referenceEquals(a2, null)) {
            return false;
        }
        return a2.equals(b2);
    }

    public static boolean op_Inequality(Resolution a2, Resolution b2) {
        return !Resolution.op_Equality(a2, b2);
    }

    @Override
    protected double onConvert(double value, UnitType fromType, UnitType toType) {
        return converter.m1(value, fromType, toType);
    }
}

