/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.drawing;

import com.aspose.html.drawing.z6;
import com.aspose.html.internal.ms.System.ArgumentException;
import com.aspose.html.internal.ms.System.Drawing.KnownColor;
import com.aspose.html.internal.ms.System.Enum;
import com.aspose.html.internal.ms.System.Exception;
import com.aspose.html.internal.ms.System.FlagsAttribute;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.SerializableAttribute;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Struct;

@SerializableAttribute
public class Color
extends Struct<Color> {
    private long e;
    short a;
    short b;
    String c;
    public static Color Empty = new Color();

    public java.awt.Color getNativeObject() {
        return new java.awt.Color(this.getR() & 0xFF, this.getG() & 0xFF, this.getB() & 0xFF, this.getA() & 0xFF);
    }

    static Color a(int n2, int n3, int n4, int n5, String string, int n6) {
        Color color = Color.fromArgb(n2, n3, n4, n5).Clone();
        color.a = (short)5;
        color.c = z6.getName(n6);
        color.b = (short)n6;
        return color;
    }

    static Color b(int n2, int n3, int n4, int n5, String string, int n6) {
        Color color = Color.a(n2, n3, n4, n5, string, n6).Clone();
        color.a = (short)(color.a | 8);
        return color;
    }

    public String getName() {
        if (this.c == null) {
            this.c = this.isNamedColor() ? z6.m10(this.b) : StringExtensions.format("{0:x}", this.toArgb());
        }
        return this.c;
    }

    public boolean isKnownColor() {
        return (this.a & 1) != 0;
    }

    public boolean isSystemColor() {
        return (this.a & 8) != 0;
    }

    public boolean isNamedColor() {
        return (this.a & 5) != 0;
    }

    long a() {
        if (this.e == 0L && this.isKnownColor()) {
            this.e = (long)z6.fromKnownColor(this.b).toArgb() & 0xFFFFFFFFL;
        }
        return this.e;
    }

    void a(long l2) {
        this.e = l2;
    }

    public static Color fromArgb(int red, int green, int blue) {
        return Color.fromArgb(255, red, green, blue);
    }

    public static Color fromArgb(int alpha, int red, int green, int blue) {
        Color.a(alpha, red, green, blue);
        Color color = new Color();
        color.a = (short)2;
        color.a((alpha << 24) + (red << 16) + (green << 8) + blue);
        return color;
    }

    public int toArgb() {
        return (int)this.a();
    }

    public static Color fromArgb(int alpha, Color baseColor) {
        return Color.fromArgb(alpha, baseColor.getR() & 0xFF, baseColor.getG() & 0xFF, baseColor.getB() & 0xFF);
    }

    public static Color fromArgb(int argb) {
        return Color.fromArgb(argb >>> 24 & 0xFF, argb >>> 16 & 0xFF, argb >>> 8 & 0xFF, argb & 0xFF);
    }

    public static Color fromKnownColor(int color) {
        return z6.fromKnownColor(color);
    }

    public static Color fromName(String name) {
        try {
            int n2 = (int)Enum.parse(KnownColor.class, name, (Boolean)true);
            return z6.fromKnownColor(n2);
        }
        catch (Exception exception) {
            Color color = Color.fromArgb(0, 0, 0, 0).Clone();
            color.c = name;
            color.a = (short)(color.a | 4);
            return color;
        }
    }

    public static boolean op_Equality(Color left, Color right) {
        if (left.a() != right.a()) {
            return false;
        }
        if (left.isNamedColor() != right.isNamedColor()) {
            return false;
        }
        if (left.isSystemColor() != right.isSystemColor()) {
            return false;
        }
        if (left.isEmpty() != right.isEmpty()) {
            return false;
        }
        return !left.isNamedColor() || StringExtensions.equals(left.getName(), right.getName());
    }

    public static boolean op_Inequality(Color left, Color right) {
        return !Color.equals(left, right);
    }

    public float getBrightness() {
        byte by2 = (byte)Math.min(this.getR() & 0xFF, Math.min(this.getG() & 0xFF, this.getB() & 0xFF));
        byte by3 = (byte)Math.max(this.getR() & 0xFF, Math.max(this.getG() & 0xFF, this.getB() & 0xFF));
        return (float)((by3 & 0xFF) + (by2 & 0xFF)) / 510.0f;
    }

    public float getSaturation() {
        byte by2 = (byte)Math.min(this.getR() & 0xFF, Math.min(this.getG() & 0xFF, this.getB() & 0xFF));
        byte by3 = (byte)Math.max(this.getR() & 0xFF, Math.max(this.getG() & 0xFF, this.getB() & 0xFF));
        if (by3 == by2) {
            return 0.0f;
        }
        int n2 = (by3 & 0xFF) + (by2 & 0xFF);
        if (n2 > 255) {
            n2 = 510 - n2;
        }
        return (float)((by3 & 0xFF) - (by2 & 0xFF)) / (float)n2;
    }

    public float getHue() {
        int n2 = this.getR() & 0xFF;
        int n3 = this.getG() & 0xFF;
        int n4 = this.getB() & 0xFF;
        byte by2 = (byte)Math.min(n2, Math.min(n3, n4));
        byte by3 = (byte)Math.max(n2, Math.max(n3, n4));
        if (by3 == by2) {
            return 0.0f;
        }
        float f2 = (by3 & 0xFF) - (by2 & 0xFF);
        float f3 = (float)((by3 & 0xFF) - n2) / f2;
        float f4 = (float)((by3 & 0xFF) - n3) / f2;
        float f5 = (float)((by3 & 0xFF) - n4) / f2;
        float f6 = 0.0f;
        if (n2 == (by3 & 0xFF)) {
            f6 = 60.0f * (6.0f + f5 - f4);
        }
        if (n3 == (by3 & 0xFF)) {
            f6 = 60.0f * (2.0f + f3 - f5);
        }
        if (n4 == (by3 & 0xFF)) {
            f6 = 60.0f * (4.0f + f4 - f3);
        }
        if (f6 > 360.0f) {
            f6 -= 360.0f;
        }
        return f6;
    }

    public int toKnownColor() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.a == 0;
    }

    public byte getA() {
        return (byte)(this.a() >> 24 & 0xFFL);
    }

    public byte getR() {
        return (byte)(this.a() >> 16 & 0xFFL);
    }

    public byte getG() {
        return (byte)(this.a() >> 8 & 0xFFL);
    }

    public byte getB() {
        return (byte)(this.a() & 0xFFL);
    }

    public int hashCode() {
        int n2 = (int)(this.a() ^ this.a() >> 32 ^ (long)this.a ^ (long)(this.b >> 16));
        if (this.isNamedColor()) {
            n2 ^= this.getName().hashCode();
        }
        return n2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Color [Empty]";
        }
        if (this.isNamedColor()) {
            return "Color [" + this.getName() + "]";
        }
        return StringExtensions.format("Color [A={0}, R={1}, G={2}, B={3}]", this.getA() & 0xFF, this.getR() & 0xFF, this.getG() & 0xFF, this.getB() & 0xFF);
    }

    private static void a(int n2, int n3, int n4) {
        if (n2 > 255 || n2 < 0) {
            throw Color.a(n2, "red");
        }
        if (n3 > 255 || n3 < 0) {
            throw Color.a(n3, "green");
        }
        if (n4 > 255 || n4 < 0) {
            throw Color.a(n4, "blue");
        }
    }

    private static ArgumentException a(int n2, String string) {
        return new ArgumentException(StringExtensions.format("'{0}' is not a valid value for '{1}'. '{1}' should be greater or equal to 0 and less than or equal to 255.", n2, string));
    }

    private static void a(int n2, int n3, int n4, int n5) {
        if (n2 > 255 || n2 < 0) {
            throw Color.a(n2, "alpha");
        }
        Color.a(n3, n4, n5);
    }

    public static Color getTransparent() {
        return z6.fromKnownColor(27);
    }

    public static Color getAliceBlue() {
        return z6.fromKnownColor(28);
    }

    public static Color getAntiqueWhite() {
        return z6.fromKnownColor(29);
    }

    public static Color getAqua() {
        return z6.fromKnownColor(30);
    }

    public static Color getAquamarine() {
        return z6.fromKnownColor(31);
    }

    public static Color getAzure() {
        return z6.fromKnownColor(32);
    }

    public static Color getBeige() {
        return z6.fromKnownColor(33);
    }

    public static Color getBisque() {
        return z6.fromKnownColor(34);
    }

    public static Color getBlack() {
        return z6.fromKnownColor(35);
    }

    public static Color getBlanchedAlmond() {
        return z6.fromKnownColor(36);
    }

    public static Color getBlue() {
        return z6.fromKnownColor(37);
    }

    public static Color getBlueViolet() {
        return z6.fromKnownColor(38);
    }

    public static Color getBrown() {
        return z6.fromKnownColor(39);
    }

    public static Color getBurlyWood() {
        return z6.fromKnownColor(40);
    }

    public static Color getCadetBlue() {
        return z6.fromKnownColor(41);
    }

    public static Color getChartreuse() {
        return z6.fromKnownColor(42);
    }

    public static Color getChocolate() {
        return z6.fromKnownColor(43);
    }

    public static Color getCoral() {
        return z6.fromKnownColor(44);
    }

    public static Color getCornflowerBlue() {
        return z6.fromKnownColor(45);
    }

    public static Color getCornsilk() {
        return z6.fromKnownColor(46);
    }

    public static Color getCrimson() {
        return z6.fromKnownColor(47);
    }

    public static Color getCyan() {
        return z6.fromKnownColor(48);
    }

    public static Color getDarkBlue() {
        return z6.fromKnownColor(49);
    }

    public static Color getDarkCyan() {
        return z6.fromKnownColor(50);
    }

    public static Color getDarkGoldenrod() {
        return z6.fromKnownColor(51);
    }

    public static Color getDarkGray() {
        return z6.fromKnownColor(52);
    }

    public static Color getDarkGreen() {
        return z6.fromKnownColor(53);
    }

    public static Color getDarkKhaki() {
        return z6.fromKnownColor(54);
    }

    public static Color getDarkMagenta() {
        return z6.fromKnownColor(55);
    }

    public static Color getDarkOliveGreen() {
        return z6.fromKnownColor(56);
    }

    public static Color getDarkOrange() {
        return z6.fromKnownColor(57);
    }

    public static Color getDarkOrchid() {
        return z6.fromKnownColor(58);
    }

    public static Color getDarkRed() {
        return z6.fromKnownColor(59);
    }

    public static Color getDarkSalmon() {
        return z6.fromKnownColor(60);
    }

    public static Color getDarkSeaGreen() {
        return z6.fromKnownColor(61);
    }

    public static Color getDarkSlateBlue() {
        return z6.fromKnownColor(62);
    }

    public static Color getDarkSlateGray() {
        return z6.fromKnownColor(63);
    }

    public static Color getDarkTurquoise() {
        return z6.fromKnownColor(64);
    }

    public static Color getDarkViolet() {
        return z6.fromKnownColor(65);
    }

    public static Color getDeepPink() {
        return z6.fromKnownColor(66);
    }

    public static Color getDeepSkyBlue() {
        return z6.fromKnownColor(67);
    }

    public static Color getDimGray() {
        return z6.fromKnownColor(68);
    }

    public static Color getDodgerBlue() {
        return z6.fromKnownColor(69);
    }

    public static Color getFirebrick() {
        return z6.fromKnownColor(70);
    }

    public static Color getFloralWhite() {
        return z6.fromKnownColor(71);
    }

    public static Color getForestGreen() {
        return z6.fromKnownColor(72);
    }

    public static Color getFuchsia() {
        return z6.fromKnownColor(73);
    }

    public static Color getGainsboro() {
        return z6.fromKnownColor(74);
    }

    public static Color getGhostWhite() {
        return z6.fromKnownColor(75);
    }

    public static Color getGold() {
        return z6.fromKnownColor(76);
    }

    public static Color getGoldenrod() {
        return z6.fromKnownColor(77);
    }

    public static Color getGray() {
        return z6.fromKnownColor(78);
    }

    public static Color getGreen() {
        return z6.fromKnownColor(79);
    }

    public static Color getGreenYellow() {
        return z6.fromKnownColor(80);
    }

    public static Color getHoneydew() {
        return z6.fromKnownColor(81);
    }

    public static Color getHotPink() {
        return z6.fromKnownColor(82);
    }

    public static Color getIndianRed() {
        return z6.fromKnownColor(83);
    }

    public static Color getIndigo() {
        return z6.fromKnownColor(84);
    }

    public static Color getIvory() {
        return z6.fromKnownColor(85);
    }

    public static Color getKhaki() {
        return z6.fromKnownColor(86);
    }

    public static Color getLavender() {
        return z6.fromKnownColor(87);
    }

    public static Color getLavenderBlush() {
        return z6.fromKnownColor(88);
    }

    public static Color getLawnGreen() {
        return z6.fromKnownColor(89);
    }

    public static Color getLemonChiffon() {
        return z6.fromKnownColor(90);
    }

    public static Color getLightBlue() {
        return z6.fromKnownColor(91);
    }

    public static Color getLightCoral() {
        return z6.fromKnownColor(92);
    }

    public static Color getLightCyan() {
        return z6.fromKnownColor(93);
    }

    public static Color getLightGoldenrodYellow() {
        return z6.fromKnownColor(94);
    }

    public static Color getLightGreen() {
        return z6.fromKnownColor(96);
    }

    public static Color getLightGray() {
        return z6.fromKnownColor(95);
    }

    public static Color getLightPink() {
        return z6.fromKnownColor(97);
    }

    public static Color getLightSalmon() {
        return z6.fromKnownColor(98);
    }

    public static Color getLightSeaGreen() {
        return z6.fromKnownColor(99);
    }

    public static Color getLightSkyBlue() {
        return z6.fromKnownColor(100);
    }

    public static Color getLightSlateGray() {
        return z6.fromKnownColor(101);
    }

    public static Color getLightSteelBlue() {
        return z6.fromKnownColor(102);
    }

    public static Color getLightYellow() {
        return z6.fromKnownColor(103);
    }

    public static Color getLime() {
        return z6.fromKnownColor(104);
    }

    public static Color getLimeGreen() {
        return z6.fromKnownColor(105);
    }

    public static Color getLinen() {
        return z6.fromKnownColor(106);
    }

    public static Color getMagenta() {
        return z6.fromKnownColor(107);
    }

    public static Color getMaroon() {
        return z6.fromKnownColor(108);
    }

    public static Color getMediumAquamarine() {
        return z6.fromKnownColor(109);
    }

    public static Color getMediumBlue() {
        return z6.fromKnownColor(110);
    }

    public static Color getMediumOrchid() {
        return z6.fromKnownColor(111);
    }

    public static Color getMediumPurple() {
        return z6.fromKnownColor(112);
    }

    public static Color getMediumSeaGreen() {
        return z6.fromKnownColor(113);
    }

    public static Color getMediumSlateBlue() {
        return z6.fromKnownColor(114);
    }

    public static Color getMediumSpringGreen() {
        return z6.fromKnownColor(115);
    }

    public static Color getMediumTurquoise() {
        return z6.fromKnownColor(116);
    }

    public static Color getMediumVioletRed() {
        return z6.fromKnownColor(117);
    }

    public static Color getMidnightBlue() {
        return z6.fromKnownColor(118);
    }

    public static Color getMintCream() {
        return z6.fromKnownColor(119);
    }

    public static Color getMistyRose() {
        return z6.fromKnownColor(120);
    }

    public static Color getMoccasin() {
        return z6.fromKnownColor(121);
    }

    public static Color getNavajoWhite() {
        return z6.fromKnownColor(122);
    }

    public static Color getNavy() {
        return z6.fromKnownColor(123);
    }

    public static Color getOldLace() {
        return z6.fromKnownColor(124);
    }

    public static Color getOlive() {
        return z6.fromKnownColor(125);
    }

    public static Color getOliveDrab() {
        return z6.fromKnownColor(126);
    }

    public static Color getOrange() {
        return z6.fromKnownColor(127);
    }

    public static Color getOrangeRed() {
        return z6.fromKnownColor(128);
    }

    public static Color getOrchid() {
        return z6.fromKnownColor(129);
    }

    public static Color getPaleGoldenrod() {
        return z6.fromKnownColor(130);
    }

    public static Color getPaleGreen() {
        return z6.fromKnownColor(131);
    }

    public static Color getPaleTurquoise() {
        return z6.fromKnownColor(132);
    }

    public static Color getPaleVioletRed() {
        return z6.fromKnownColor(133);
    }

    public static Color getPapayaWhip() {
        return z6.fromKnownColor(134);
    }

    public static Color getPeachPuff() {
        return z6.fromKnownColor(135);
    }

    public static Color getPeru() {
        return z6.fromKnownColor(136);
    }

    public static Color getPink() {
        return z6.fromKnownColor(137);
    }

    public static Color getPlum() {
        return z6.fromKnownColor(138);
    }

    public static Color getPowderBlue() {
        return z6.fromKnownColor(139);
    }

    public static Color getPurple() {
        return z6.fromKnownColor(140);
    }

    public static Color getRed() {
        return z6.fromKnownColor(141);
    }

    public static Color getRosyBrown() {
        return z6.fromKnownColor(142);
    }

    public static Color getRoyalBlue() {
        return z6.fromKnownColor(143);
    }

    public static Color getSaddleBrown() {
        return z6.fromKnownColor(144);
    }

    public static Color getSalmon() {
        return z6.fromKnownColor(145);
    }

    public static Color getSandyBrown() {
        return z6.fromKnownColor(146);
    }

    public static Color getSeaGreen() {
        return z6.fromKnownColor(147);
    }

    public static Color getSeaShell() {
        return z6.fromKnownColor(148);
    }

    public static Color getSienna() {
        return z6.fromKnownColor(149);
    }

    public static Color getSilver() {
        return z6.fromKnownColor(150);
    }

    public static Color getSkyBlue() {
        return z6.fromKnownColor(151);
    }

    public static Color getSlateBlue() {
        return z6.fromKnownColor(152);
    }

    public static Color getSlateGray() {
        return z6.fromKnownColor(153);
    }

    public static Color getSnow() {
        return z6.fromKnownColor(154);
    }

    public static Color getSpringGreen() {
        return z6.fromKnownColor(155);
    }

    public static Color getSteelBlue() {
        return z6.fromKnownColor(156);
    }

    public static Color getTan() {
        return z6.fromKnownColor(157);
    }

    public static Color getTeal() {
        return z6.fromKnownColor(158);
    }

    public static Color getThistle() {
        return z6.fromKnownColor(159);
    }

    public static Color getTomato() {
        return z6.fromKnownColor(160);
    }

    public static Color getTurquoise() {
        return z6.fromKnownColor(161);
    }

    public static Color getViolet() {
        return z6.fromKnownColor(162);
    }

    public static Color getWheat() {
        return z6.fromKnownColor(163);
    }

    public static Color getWhite() {
        return z6.fromKnownColor(164);
    }

    public static Color getWhiteSmoke() {
        return z6.fromKnownColor(165);
    }

    public static Color getYellow() {
        return z6.fromKnownColor(166);
    }

    public static Color getYellowGreen() {
        return z6.fromKnownColor(167);
    }

    @Override
    public void CloneTo(Color that) {
        that.e = this.e;
        that.a = this.a;
        that.b = this.b;
        that.c = this.c;
    }

    @Override
    public Color Clone() {
        Color color = new Color();
        this.CloneTo(color);
        return color;
    }

    public Object clone() {
        return this.Clone();
    }

    private boolean a(Color color) {
        return color.e == this.e && color.a == this.a && color.b == this.b && ObjectExtensions.equals(color.c, this.c);
    }

    public boolean equals(Object obj) {
        assert (obj != null);
        if (ObjectExtensions.referenceEquals(null, obj)) {
            return false;
        }
        if (ObjectExtensions.referenceEquals(this, obj)) {
            return true;
        }
        if (!(obj instanceof Color)) {
            return false;
        }
        return this.a((Color)obj);
    }

    public static boolean equals(Color obj1, Color obj2) {
        return obj1.equals(obj2);
    }

    public static java.awt.Color toJava(Color color) {
        if (color == null) {
            return null;
        }
        return color.getNativeObject();
    }

    public static Color fromJava(java.awt.Color nativeObject) {
        if (nativeObject == null) {
            return new Color();
        }
        return Color.fromArgb(nativeObject.getRGB());
    }

    @FlagsAttribute
    public static final class z1 {
        public static final short m9043 = 0;
        public static final short m9044 = 1;
        public static final short m9045 = 2;
        public static final short m9046 = 4;
        public static final short m9047 = 8;

        static {
            Enum.register(new com.aspose.html.drawing.z1((Class)z1.class, Short.class));
        }
    }
}

