/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg;

import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.svg.ISVGTests;
import com.aspose.html.dom.svg.SVGElement;
import com.aspose.html.dom.svg.SVGForeignObjectElement;
import com.aspose.html.dom.svg.SVGGeometryElement;
import com.aspose.html.dom.svg.SVGImageElement;
import com.aspose.html.dom.svg.SVGSVGElement;
import com.aspose.html.dom.svg.SVGUseElement;
import com.aspose.html.dom.svg.datatypes.SVGAnimatedTransformList;
import com.aspose.html.dom.svg.datatypes.SVGLength;
import com.aspose.html.dom.svg.datatypes.SVGMatrix;
import com.aspose.html.dom.svg.datatypes.SVGPreserveAspectRatio;
import com.aspose.html.dom.svg.datatypes.SVGRect;
import com.aspose.html.dom.svg.datatypes.SVGStringList;
import com.aspose.html.dom.svg.datatypes.SVGTransform;
import com.aspose.html.dom.z2;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p106.z4;
import com.aspose.html.internal.p78.z16;
import com.aspose.html.internal.p78.z19;
import com.aspose.html.internal.p91.z2;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGGraphicsElement")
public class SVGGraphicsElement
extends SVGElement
implements ISVGTests {
    private final z16 transform = new z16((SVGElement)this, "transform", 1);
    private final z19 requiredFeatures = new z19(this, "requiredFeatures");
    private final z19 requiredExtensions = new z19(this, "requiredExtensions");
    private final z19 systemLanguage = new z19((SVGElement)this, "systemLanguage", 1);

    public SVGGraphicsElement(z8 name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="nearestViewportElement")
    public SVGElement getNearestViewportElement() {
        return this.getViewportElement();
    }

    @DOMNameAttribute(name="farthestViewportElement")
    public SVGElement getFarthestViewportElement() {
        Element element = null;
        for (Element element2 = this.getParentElement(); element2 != null; element2 = element2.getParentElement()) {
            if (!"svg".equals(element2.getTagName())) continue;
            element = element2;
        }
        return (SVGElement)element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DOMNameAttribute(name="getBBox")
    public SVGRect getBBox() {
        if (this.flags.get(Node.z2.m4279) || this.flags.get(Node.z2.m4280) || "a".equals(this.getTagName()) && this.getParentNode().flags.get(Node.z2.m4280)) {
            SVGGeometryElement sVGGeometryElement = Operators.as(this, SVGGeometryElement.class);
            if (sVGGeometryElement == null) {
                return new SVGRect();
            }
            z2 z2100 = new z2();
            z2100.m9(sVGGeometryElement.equivalentPath());
            return new SVGRect(z2100.m387().getX(), z2100.m387().getY(), z2100.m387().getWidth(), z2100.m387().getHeight());
        }
        if (this.flags.get(Node.z2.m4281) || "use".equals(this.getTagName())) {
            SVGGraphicsElement sVGGraphicsElement;
            SVGRect sVGRect = null;
            SVGElement sVGElement = sVGGraphicsElement = this.flags.get(Node.z2.m4281) ? this : ((SVGUseElement)this).getAnimatedInstanceRoot();
            if (sVGGraphicsElement.flags.get(Node.z2.m4281)) {
                DOMObject dOMObject;
                Node node;
                IEnumerator iEnumerator = sVGGraphicsElement.getChildNodes().iterator();
                try {
                    while (iEnumerator.hasNext()) {
                        node = (Node)iEnumerator.next();
                        if (node.flags.get(Node.z2.m4281)) {
                            sVGRect = z4.m1(sVGRect, ((SVGGraphicsElement)node).getBBox());
                            continue;
                        }
                        if (!node.flags.get(Node.z2.m4282) || !((SVGElement)(dOMObject = (SVGGraphicsElement)node)).isRendered()) continue;
                        sVGRect = z4.m1(sVGRect, ((SVGGraphicsElement)node).getBBox());
                    }
                }
                finally {
                    if (Operators.is(iEnumerator, IDisposable.class)) {
                        ((IDisposable)((Object)iEnumerator)).dispose();
                    }
                }
                if (sVGGraphicsElement.hasAttribute("transform") && sVGRect != null) {
                    node = Operators.as(sVGGraphicsElement.getParentElement(), SVGGraphicsElement.class);
                    dOMObject = node != null ? ((SVGGraphicsElement)node).getCTM() : null;
                    SVGMatrix sVGMatrix = sVGGraphicsElement.getCTM();
                    sVGRect.setX(sVGRect.getX() + (sVGMatrix.getE() - (dOMObject != null ? ((SVGMatrix)dOMObject).getE() : 0.0f)));
                    sVGRect.setY(sVGRect.getY() + (sVGMatrix.getF() - (dOMObject != null ? ((SVGMatrix)dOMObject).getF() : 0.0f)));
                }
            } else {
                sVGRect = sVGGraphicsElement.getBBox();
                sVGRect.setX(sVGRect.getX() + ((SVGLength)((SVGUseElement)this).getX().getAnimVal()).getValue());
                sVGRect.setY(sVGRect.getY() + ((SVGLength)((SVGUseElement)this).getY().getAnimVal()).getValue());
            }
            return sVGRect;
        }
        if ("foreignObject".equals(this.getTagName())) {
            SVGForeignObjectElement sVGForeignObjectElement = (SVGForeignObjectElement)this;
            return new SVGRect(((SVGLength)sVGForeignObjectElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGForeignObjectElement.getHeight().getAnimVal()).getValue());
        }
        if ("image".equals(this.getTagName())) {
            SVGImageElement sVGImageElement = (SVGImageElement)this;
            return new SVGRect(((SVGLength)sVGImageElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGImageElement.getHeight().getAnimVal()).getValue());
        }
        return new SVGRect(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @DOMNameAttribute(name="getCTM")
    public SVGMatrix getCTM() {
        SVGMatrix sVGMatrix;
        if (this.getOwnerDocument() == null) {
            return null;
        }
        if (z2.z9.m3935.m2(this) && this.getOwnerSVGElement() == null) {
            return this.rootSVGTransform();
        }
        Element element = this.getParentElement();
        while (!Operators.is(element, SVGGraphicsElement.class)) {
            element = element.getParentElement();
        }
        SVGGraphicsElement sVGGraphicsElement = (SVGGraphicsElement)element;
        if (z2.z9.m3935.m2(sVGGraphicsElement)) {
            sVGMatrix = new SVGMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            for (SVGTransform sVGTransform : (Iterable)sVGGraphicsElement.getTransform().getAnimVal()) {
                sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            }
        } else {
            sVGMatrix = sVGGraphicsElement.getCTM();
        }
        for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
            sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
        }
        return sVGMatrix;
    }

    @DOMNameAttribute(name="getScreenCTM")
    public SVGMatrix getScreenCTM() {
        SVGMatrix sVGMatrix;
        if (this.getOwnerDocument() == null) {
            return null;
        }
        if (z2.z9.m3935.m2(this) && this.getOwnerSVGElement() == null) {
            sVGMatrix = this.rootSVGTransform();
        } else {
            Element element = this.getParentElement();
            while (!Operators.is(element, SVGGraphicsElement.class)) {
                element = element.getParentElement();
            }
            SVGGraphicsElement sVGGraphicsElement = (SVGGraphicsElement)element;
            sVGMatrix = sVGGraphicsElement.getScreenCTM();
            for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
                sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
            }
        }
        return sVGMatrix;
    }

    private SVGMatrix rootSVGTransform() {
        SVGSVGElement sVGSVGElement = (SVGSVGElement)this;
        SVGMatrix sVGMatrix = new SVGMatrix(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        for (SVGTransform sVGTransform : (Iterable)this.getTransform().getAnimVal()) {
            sVGMatrix = sVGMatrix.multiply(sVGTransform.getMatrix());
        }
        sVGMatrix = sVGMatrix.translate(sVGSVGElement.getCurrentTranslate().getX(), sVGSVGElement.getCurrentTranslate().getY());
        sVGMatrix = sVGMatrix.scale(sVGSVGElement.getCurrentScale());
        if (this.hasAttribute("viewBox")) {
            SVGRect sVGRect = new SVGRect(((SVGLength)sVGSVGElement.getX().getAnimVal()).getValue(), ((SVGLength)sVGSVGElement.getY().getAnimVal()).getValue(), ((SVGLength)sVGSVGElement.getWidth().getAnimVal()).getValue(), ((SVGLength)sVGSVGElement.getHeight().getAnimVal()).getValue());
            sVGMatrix = sVGMatrix.multiply(z4.m1((SVGRect)sVGSVGElement.getViewBox().getAnimVal(), sVGRect, (SVGPreserveAspectRatio)sVGSVGElement.getPreserveAspectRatio().getAnimVal()));
        }
        return sVGMatrix;
    }

    @DOMNameAttribute(name="transform")
    public SVGAnimatedTransformList getTransform() {
        return (SVGAnimatedTransformList)this.transform.getValue();
    }

    @Override
    public SVGStringList getRequiredFeatures() {
        return (SVGStringList)this.requiredFeatures.getValue();
    }

    @Override
    public SVGStringList getRequiredExtensions() {
        return (SVGStringList)this.requiredExtensions.getValue();
    }

    @Override
    public SVGStringList getSystemLanguage() {
        return (SVGStringList)this.systemLanguage.getValue();
    }
}

