/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom.svg;

import com.aspose.html.Configuration;
import com.aspose.html.Url;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.css.ICSSStyleDeclaration;
import com.aspose.html.dom.css.IDocumentCSS;
import com.aspose.html.dom.events.IDocumentEvent;
import com.aspose.html.dom.events.z5;
import com.aspose.html.dom.svg.SVGElement;
import com.aspose.html.dom.svg.SVGSVGElement;
import com.aspose.html.dom.svg.saving.SVGSaveOptions;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.IO.Directory;
import com.aspose.html.internal.ms.System.IO.Path;
import com.aspose.html.internal.ms.System.IO.Stream;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p148.z1;
import com.aspose.html.internal.p250.z2;
import com.aspose.html.internal.p76.z10;
import com.aspose.html.net.RequestMessage;
import com.aspose.html.rendering.IDevice;
import com.aspose.html.rendering.SvgRenderer;
import com.aspose.html.z3;

@DOMObjectAttribute
@DOMNameAttribute(name="SVGDocument")
public class SVGDocument
extends Document
implements IDocumentCSS,
IDocumentEvent {
    private static final String EmptyDocument = "<svg xmlns=\"http://www.w3.org/2000/svg\"/>";
    private String auto_Referrer;
    private String auto_Domain;
    private String auto_URL;

    public SVGDocument() {
        this(EmptyDocument, "about:blank");
    }

    public SVGDocument(Configuration configuration) {
        this(EmptyDocument, "about:blank", configuration);
    }

    public SVGDocument(String address) {
        this(new Url(address, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public SVGDocument(Url url) {
        this(url, new Configuration());
    }

    public SVGDocument(String address, Configuration configuration) {
        this(new Url(address, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), configuration);
    }

    public SVGDocument(Url url, Configuration configuration) {
        this(z1.m20(url), configuration, 3);
    }

    public SVGDocument(Stream content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public SVGDocument(Stream content, String baseUri, Configuration configuration) {
        this(z1.m5(content, baseUri), configuration, 3);
    }

    public SVGDocument(String content, String baseUri) {
        this(content, baseUri, new Configuration());
    }

    public SVGDocument(String content, String baseUri, Configuration configuration) {
        this(z1.m47(content, baseUri), configuration, 3);
    }

    public SVGDocument(RequestMessage request) {
        this(request, new Configuration());
    }

    public SVGDocument(RequestMessage request, Configuration configuration) {
        this(request, configuration, 1);
    }

    private SVGDocument(final RequestMessage request, Configuration configuration, final byte flags) {
        super(new z3(configuration), new Document.z1(){
            {
                this.m1(z5.m7342);
                this.m1(request);
                this.setFlags(flags);
            }
        });
    }

    public SVGDocument(z3 context) {
        super(context);
    }

    @DOMNameAttribute(name="title")
    public String getTitle() {
        HTMLCollection hTMLCollection = this.getRootElement().getElementsByTagName("title");
        if (hTMLCollection.getLength() == 0) {
            return StringExtensions.Empty;
        }
        String string = hTMLCollection.get_Item(0).getTextContent();
        if (string == null) {
            string = StringExtensions.Empty;
        }
        return string;
    }

    @DOMNameAttribute(name="referrer")
    public String getReferrer() {
        return this.auto_Referrer;
    }

    @DOMNameAttribute(name="referrer")
    private void setReferrer(String value) {
        this.auto_Referrer = value;
    }

    @DOMNameAttribute(name="domain")
    public String getDomain() {
        return this.auto_Domain;
    }

    @DOMNameAttribute(name="domain")
    private void setDomain(String value) {
        this.auto_Domain = value;
    }

    @DOMNameAttribute(name="URL")
    public String getURL() {
        return this.auto_URL;
    }

    @DOMNameAttribute(name="URL")
    private void setURL(String value) {
        this.auto_URL = value;
    }

    @DOMNameAttribute(name="rootElement")
    public SVGSVGElement getRootElement() {
        return Operators.as(this.getDocumentElement(), SVGSVGElement.class);
    }

    public void save(Url url) {
        this.save(url, 0);
    }

    public void save(String path) {
        this.save(new Url(path, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))));
    }

    public void save(String path, int saveFormat) {
        this.save(new Url(path, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), saveFormat);
    }

    public void save(String path, SVGSaveOptions saveOptions) {
        this.save(new Url(path, StringExtensions.concat(Directory.getCurrentDirectory(), Character.valueOf(Path.DirectorySeparatorChar))), saveOptions);
    }

    public void save(Url url, int saveFormat) {
        switch (saveFormat) {
            case 0: {
                this.save(url, new SVGSaveOptions());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Url url, SVGSaveOptions saveOptions) {
        z2 z2100 = this.getContext().getService(com.aspose.html.services.z10.class).m11(this.getBrowsingContext());
        IDisposable iDisposable = z2100.m1((Url)this.getLocation(), saveOptions);
        try {
            z2100.m4414().m23(url);
            z2100.m32(this);
        }
        finally {
            if (iDisposable != null) {
                iDisposable.dispose();
            }
        }
    }

    @Override
    public void renderTo(IDevice device) {
        SvgRenderer svgRenderer = new SvgRenderer();
        try {
            svgRenderer.render(device, this);
        }
        finally {
            if (svgRenderer != null) {
                svgRenderer.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICSSStyleDeclaration getOverrideStyle(Element elt, String pseudoElt) {
        ICSSStyleDeclaration iCSSStyleDeclaration = this.getBrowsingContext().m6().getOverrideStyle(elt, pseudoElt);
        SVGElement sVGElement = Operators.as(elt, SVGElement.class);
        if (sVGElement != null) {
            IGenericEnumerator<z10> iGenericEnumerator = sVGElement.getSVGAttributeBindings().iterator();
            try {
                while (iGenericEnumerator.hasNext()) {
                    z10 z1010 = (z10)iGenericEnumerator.next();
                    if ((z1010.getType() & 1) != 1) continue;
                    iCSSStyleDeclaration.setProperty(z1010.getAttributeName(), z1010.m1809(), null);
                }
            }
            finally {
                if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                    ((IDisposable)iGenericEnumerator).dispose();
                }
            }
        }
        return iCSSStyleDeclaration;
    }
}

