/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom;

import com.aspose.html.collections.NamedNodeMap;
import com.aspose.html.collections.NodeList;
import com.aspose.html.dom.Attr;
import com.aspose.html.dom.DOMObject;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.DocumentFragment;
import com.aspose.html.dom.DocumentType;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.EventTarget;
import com.aspose.html.dom.ProcessingInstruction;
import com.aspose.html.dom.Text;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNullableAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.attributes.DOMParameterAttribute;
import com.aspose.html.dom.mutations.MutationRecord;
import com.aspose.html.dom.traversal.ITreeWalker;
import com.aspose.html.dom.xpath.IXPathNSResolver;
import com.aspose.html.dom.z15;
import com.aspose.html.internal.ms.System.Array;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerable;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericEnumerator;
import com.aspose.html.internal.ms.System.Collections.Generic.IGenericList;
import com.aspose.html.internal.ms.System.Collections.Generic.List;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.NotImplementedException;
import com.aspose.html.internal.ms.System.ObjectExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.PropertyAttribute;
import com.aspose.html.internal.p331.z4;
import com.aspose.html.internal.p4.z33;
import com.aspose.html.internal.p72.z2;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

@DOMObjectAttribute
@DOMNameAttribute(name="Node")
public abstract class Node
extends EventTarget
implements IXPathNSResolver {
    @DOMNameAttribute(name="ELEMENT_NODE")
    public static final int ELEMENT_NODE = 1;
    @DOMNameAttribute(name="ATTRIBUTE_NODE")
    public static final int ATTRIBUTE_NODE = 2;
    @DOMNameAttribute(name="TEXT_NODE")
    public static final int TEXT_NODE = 3;
    @DOMNameAttribute(name="CDATA_SECTION_NODE")
    public static final int CDATA_SECTION_NODE = 4;
    @DOMNameAttribute(name="ENTITY_REFERENCE_NODE")
    public static final int ENTITY_REFERENCE_NODE = 5;
    @DOMNameAttribute(name="ENTITY_NODE")
    public static final int ENTITY_NODE = 6;
    @DOMNameAttribute(name="PROCESSING_INSTRUCTION_NODE")
    public static final int PROCESSING_INSTRUCTION_NODE = 7;
    @DOMNameAttribute(name="COMMENT_NODE")
    public static final int COMMENT_NODE = 8;
    @DOMNameAttribute(name="DOCUMENT_NODE")
    public static final int DOCUMENT_NODE = 9;
    @DOMNameAttribute(name="DOCUMENT_TYPE_NODE")
    public static final int DOCUMENT_TYPE_NODE = 10;
    @DOMNameAttribute(name="DOCUMENT_FRAGMENT_NODE")
    public static final int DOCUMENT_FRAGMENT_NODE = 11;
    @DOMNameAttribute(name="NOTATION_NODE")
    public static final int NOTATION_NODE = 12;
    @DOMNameAttribute(name="DOCUMENT_POSITION_DISCONNECTED")
    private static final int DOCUMENT_POSITION_DISCONNECTED = 1;
    @DOMNameAttribute(name="DOCUMENT_POSITION_PRECEDING")
    private static final int DOCUMENT_POSITION_PRECEDING = 2;
    @DOMNameAttribute(name="DOCUMENT_POSITION_FOLLOWING")
    private static final int DOCUMENT_POSITION_FOLLOWING = 4;
    @DOMNameAttribute(name="DOCUMENT_POSITION_CONTAINS")
    private static final int DOCUMENT_POSITION_CONTAINS = 8;
    @DOMNameAttribute(name="DOCUMENT_POSITION_CONTAINED_BY")
    private static final int DOCUMENT_POSITION_CONTAINED_BY = 16;
    @DOMNameAttribute(name="DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC")
    private static final int DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC = 32;
    public z2 flags = new z2();
    public Document nodeDocument;
    protected Node parent;
    private z1 children;
    private Node first;
    private Node last;
    private Node previous;
    private Node next;
    private com.aspose.html.internal.p72.z2 auto_RegisteredObservers;
    private String auto_LocalName;
    private String auto_NamespaceURI;
    private String auto_Prefix;

    protected Node(Document document) {
        Document document2 = document;
        if (document2 == null) {
            document2 = com.aspose.html.internal.p111.z2.m1(Document.class, this) ? (Document)this : null;
        }
        this.nodeDocument = document2;
        com.aspose.html.internal.p275.z1.assert_(this.nodeDocument != null, "Unknown type of node.");
        this.children = new z1(this);
        this.setRegisteredObservers(new com.aspose.html.internal.p72.z2());
    }

    public static void adoptNode(Node node, Document document) {
        Document document2 = node.nodeDocument;
        if (node.parent != null) {
            Node.remove(node, node.parent, false);
        }
        if (document != document2) {
            Node.adoptDescendantNode(node, document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void adoptDescendantNode(Node node, Document document) {
        node.nodeDocument = document;
        if (node.getNodeType() == 1) {
            IEnumerator iEnumerator = ((Element)node).getAttributes().iterator();
            try {
                while (iEnumerator.hasNext()) {
                    Attr attr = (Attr)iEnumerator.next();
                    attr.nodeDocument = document;
                }
            }
            finally {
                if (Operators.is(iEnumerator, IDisposable.class)) {
                    ((IDisposable)((Object)iEnumerator)).dispose();
                }
            }
        }
        com.aspose.html.z3.m2().m1(node, document);
        node = node.first;
        while (node != null) {
            Node.adoptDescendantNode(node, document);
            node = node.next;
        }
    }

    private static boolean isEqualNode(Node a2, Node b2) {
        DOMObject dOMObject;
        DOMObject dOMObject2;
        if (ObjectExtensions.referenceEquals(a2, b2)) {
            return true;
        }
        if (ObjectExtensions.referenceEquals(a2, null) || ObjectExtensions.referenceEquals(b2, null)) {
            return false;
        }
        if ((a2.getNodeType() & 0xFFFF) != (b2.getNodeType() & 0xFFFF)) {
            return false;
        }
        switch (a2.getNodeType()) {
            case 10: {
                dOMObject2 = (DocumentType)a2;
                dOMObject = (DocumentType)b2;
                if (StringExtensions.equals(((DocumentType)dOMObject2).getName(), ((DocumentType)dOMObject).getName()) && StringExtensions.equals(((DocumentType)dOMObject2).getPublicId(), ((DocumentType)dOMObject).getPublicId()) && StringExtensions.equals(((DocumentType)dOMObject2).getSystemId(), ((DocumentType)dOMObject).getSystemId())) break;
                return false;
            }
            case 1: {
                dOMObject2 = (Element)a2;
                dOMObject = (Element)b2;
                if (StringExtensions.equals(((Element)dOMObject2).getNamespaceURI(), ((Element)dOMObject).getNamespaceURI()) && StringExtensions.equals(((Element)dOMObject2).getPrefix(), ((Element)dOMObject).getPrefix()) && StringExtensions.equals(((Element)dOMObject2).getLocalName(), ((Element)dOMObject).getLocalName()) && ((Element)dOMObject2).getAttributes().getLength() == ((Element)dOMObject).getAttributes().getLength()) break;
                return false;
            }
            case 2: {
                dOMObject2 = (Attr)a2;
                dOMObject = (Attr)b2;
                if (StringExtensions.equals(((Attr)dOMObject2).getNamespaceURI(), ((Attr)dOMObject).getNamespaceURI()) && StringExtensions.equals(((Attr)dOMObject2).getLocalName(), ((Attr)dOMObject).getLocalName()) && StringExtensions.equals(((Attr)dOMObject2).getValue(), ((Attr)dOMObject).getValue())) break;
                return false;
            }
            case 7: {
                dOMObject2 = (ProcessingInstruction)a2;
                dOMObject = (ProcessingInstruction)b2;
                if (StringExtensions.equals(((ProcessingInstruction)dOMObject2).getTarget(), ((ProcessingInstruction)dOMObject).getTarget()) && StringExtensions.equals(((com.aspose.html.dom.z1)dOMObject2).getData(), ((com.aspose.html.dom.z1)dOMObject).getData())) break;
                return false;
            }
            case 3: 
            case 8: {
                if (StringExtensions.equals(((com.aspose.html.dom.z1)a2).getData(), ((com.aspose.html.dom.z1)b2).getData())) break;
                return false;
            }
        }
        if (a2.getNodeType() == 1) {
            dOMObject2 = ((Element)a2).getAttributes();
            dOMObject = ((Element)b2).getAttributes();
            for (int i2 = 0; i2 < ((NamedNodeMap)dOMObject2).getLength(); ++i2) {
                if (Node.isEqualNode(((NamedNodeMap)dOMObject2).get_Item(i2), ((NamedNodeMap)dOMObject).get_Item(i2))) continue;
                return false;
            }
        }
        dOMObject2 = a2.first;
        dOMObject = b2.first;
        while (dOMObject2 != null) {
            if (!Node.isEqualNode((Node)dOMObject2, (Node)dOMObject)) {
                return false;
            }
            dOMObject2 = ((Node)dOMObject2).next;
            dOMObject = ((Node)dOMObject).next;
        }
        return dOMObject == null;
    }

    private static void ensurePreInsertionValidity(Node node, Node parent, Node child) {
        if ((parent.getNodeType() & 0xFFFF) != 9 && (parent.getNodeType() & 0xFFFF) != 11 && (parent.getNodeType() & 0xFFFF) != 1) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (Node.containsIncludingHostElements(node, parent)) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (child != null && child.parent != parent) {
            throw com.aspose.html.internal.p68.z1.m1213();
        }
        if ((node.getNodeType() & 0xFFFF) != 11 && (node.getNodeType() & 0xFFFF) != 10 && (node.getNodeType() & 0xFFFF) != 1 && (node.getNodeType() & 0xFFFF) != 3 && (node.getNodeType() & 0xFFFF) != 7 && (node.getNodeType() & 0xFFFF) != 8) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (node.getNodeType() == 3 && parent.getNodeType() == 9 || node.getNodeType() == 10 && (parent.getNodeType() & 0xFFFF) != 9) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (parent.getNodeType() == 9) {
            if (node.getNodeType() == 11) {
                if (node.hasMultipleChildrenOfType(1) || node.hasChildOfType(3)) {
                    throw com.aspose.html.internal.p68.z1.m1209();
                }
                if (node.hasChildOfType(1) && (parent.hasChildOfType(1) || com.aspose.html.internal.p111.z2.m1(child, 10) || child != null && com.aspose.html.internal.p111.z2.m1(child.next, 10))) {
                    throw com.aspose.html.internal.p68.z1.m1209();
                }
            } else if (node.getNodeType() == 1 ? parent.hasChildOfType(1) || com.aspose.html.internal.p111.z2.m1(child, 10) || child != null && com.aspose.html.internal.p111.z2.m1(child.next, 10) : node.getNodeType() == 10 && (parent.hasChildOfType(10) || child != null && com.aspose.html.internal.p111.z2.m1(child.previous, 1) || child == null && parent.hasChildOfType(1))) {
                throw com.aspose.html.internal.p68.z1.m1209();
            }
        }
    }

    private static Node preInsert(Node node, Node parent, Node child) {
        Node.ensurePreInsertionValidity(node, parent, child);
        Node node2 = child;
        if (node2 == node) {
            node.next = node2;
        }
        parent.nodeDocument.adoptNode(node);
        Node.insert(node, parent, node2, false);
        return node;
    }

    private static void insert(Node node, Node parent, Node child, boolean suppressObservers) {
        Node[] nodeArray;
        int n2;
        int n3 = n2 = node.getNodeType() == 11 ? node.children.getLength() : 1;
        if (child != null) {
            // empty if block
        }
        if (node.getNodeType() == 11) {
            nodeArray = ((DocumentFragment)node).getChildNodes().toArray();
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        Node[] nodeArray3 = nodeArray;
        if (node.getNodeType() == 11) {
            for (Node node2 : nodeArray3) {
                Node.remove(node2, node, true);
            }
            ((com.aspose.html.z3)node.nodeDocument.getContext()).m1(node, MutationRecord.EMPTY_NODES, Array.toGenericList(nodeArray3), null, null);
        }
        Node node3 = child == null ? parent.last : child.previous;
        for (Node node4 : nodeArray3) {
            if (child == null) {
                parent.children.m26(node4);
            } else {
                parent.children.m3(node4, child);
            }
            if (node.getNodeType() == 3) {
                com.aspose.html.z3.m2().m2(parent);
            }
            com.aspose.html.z3.m2().m1(node4);
        }
        if (!suppressObservers) {
            ((com.aspose.html.z3)node.nodeDocument.getContext()).m1(parent, Array.toGenericList(nodeArray3), MutationRecord.EMPTY_NODES, node3, child);
        }
        node.flags.set(z2.m4278);
    }

    private static Node replace(Node child, Node node, Node parent) {
        Node[] nodeArray;
        Node node2;
        if ((parent.getNodeType() & 0xFFFF) != 9 && (parent.getNodeType() & 0xFFFF) != 11 && (parent.getNodeType() & 0xFFFF) != 1) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (Node.containsIncludingHostElements(node, parent)) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (child.parent != parent) {
            throw com.aspose.html.internal.p68.z1.m1213();
        }
        if ((node.getNodeType() & 0xFFFF) != 11 && (node.getNodeType() & 0xFFFF) != 10 && (node.getNodeType() & 0xFFFF) != 1 && (node.getNodeType() & 0xFFFF) != 3 && (node.getNodeType() & 0xFFFF) != 7 && (node.getNodeType() & 0xFFFF) != 8) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (node.getNodeType() == 3 && parent.getNodeType() == 9 || node.getNodeType() == 10 && (parent.getNodeType() & 0xFFFF) != 9) {
            throw com.aspose.html.internal.p68.z1.m1209();
        }
        if (parent.getNodeType() == 9) {
            if (node.getNodeType() == 11) {
                if (node.hasMultipleChildrenOfType(1) || node.hasChildOfType(3)) {
                    throw com.aspose.html.internal.p68.z1.m1209();
                }
                if (node.hasChildOfType(1) && (parent.hasChildOfType(1) && parent.getChildOfType(1) != child || com.aspose.html.internal.p111.z2.m1(child.next, 10))) {
                    throw com.aspose.html.internal.p68.z1.m1209();
                }
            } else if (node.getNodeType() == 1 ? parent.hasChildOfType(1) && parent.getChildOfType(1) != child || com.aspose.html.internal.p111.z2.m1(child.next, 10) : node.getNodeType() == 10 && (parent.hasChildOfType(10) && parent.getChildOfType(10) != child || com.aspose.html.internal.p111.z2.m1(child.previous, 1))) {
                throw com.aspose.html.internal.p68.z1.m1209();
            }
        }
        if ((node2 = child.next) == node) {
            node.next = node2;
        }
        Node node3 = child.previous;
        parent.nodeDocument.adoptNode(node);
        IGenericList<Node> iGenericList = MutationRecord.EMPTY_NODES;
        if (child.parent != null) {
            iGenericList = Array.toGenericList(new Node[]{child});
            Node.remove(child, parent, true);
        }
        if (node.getNodeType() == 11) {
            nodeArray = ((DocumentFragment)node).getChildNodes().toArray();
        } else {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node;
        }
        Node[] nodeArray3 = nodeArray;
        Node.insert(node, parent, node2, true);
        ((com.aspose.html.z3)node.nodeDocument.getContext()).m1(parent, Array.toGenericList(nodeArray3), iGenericList, node3, node2);
        return child;
    }

    private static Node preRemove(Node child, Node parent) {
        if (child == null || child.parent != parent) {
            throw com.aspose.html.internal.p68.z1.m1213();
        }
        Node.remove(child, parent, false);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void remove(Node node, Node parent, boolean suppressObserversFlag) {
        parent.nodeDocument.getIterators().m31(node);
        Node node2 = node.previous;
        Node node3 = node.next;
        parent.children.m27(node);
        com.aspose.html.z3.m2().m1(node, parent);
        IGenericEnumerator<Node> iGenericEnumerator = z3.m28(node).iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Object object;
                Node node4 = (Node)iGenericEnumerator.next();
                List<Object> list = new List<Object>();
                IEnumerator iEnumerator = node4.getRegisteredObservers().iterator();
                try {
                    while (iEnumerator.hasNext()) {
                        object = (z2.z1)iEnumerator.next();
                        if (!((z2.z1)object).m8548.getSubtree()) continue;
                        list.addItem(object);
                    }
                }
                finally {
                    if (Operators.is(iEnumerator, IDisposable.class)) {
                        ((IDisposable)((Object)iEnumerator)).dispose();
                    }
                }
                object = list.iterator();
                try {
                    while (object.hasNext()) {
                        z2.z1 z1100 = (z2.z1)object.next();
                        node4.getRegisteredObservers().m1(z1100.m8547, z1100.m8548.Clone(), z1100);
                    }
                }
                finally {
                    if (!Operators.is(object, IDisposable.class)) continue;
                    ((IDisposable)object).dispose();
                }
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        if (!suppressObserversFlag) {
            ((com.aspose.html.z3)parent.nodeDocument.getContext()).m1(parent, MutationRecord.EMPTY_NODES, Array.toGenericList(new Node[]{node}), node2, node3);
        }
        if (node.getNodeType() == 3) {
            com.aspose.html.z3.m2().m2(parent);
        }
        node.flags.m31(z2.m4278);
    }

    public static void replaceAll(Node node, Node parent) {
        IGenericList<Node> iGenericList;
        IGenericList<Node> iGenericList2;
        if (node != null) {
            parent.nodeDocument.adoptNode(node);
        }
        Node[] nodeArray = parent.children.toArray();
        if (node == null) {
            iGenericList2 = MutationRecord.EMPTY_NODES;
        } else {
            Node[] nodeArray2;
            if (node.getNodeType() == 11) {
                nodeArray2 = node.children.toArray();
            } else {
                Node[] nodeArray3 = new Node[1];
                nodeArray2 = nodeArray3;
                nodeArray3[0] = node;
            }
            iGenericList2 = iGenericList = Array.toGenericList(nodeArray2);
        }
        while (parent.first != null) {
            Node.remove(parent.first, parent, true);
        }
        if (node != null) {
            Node.insert(node, parent, null, true);
        }
        ((com.aspose.html.z3)parent.nodeDocument.getContext()).m1(parent, iGenericList, Array.toGenericList(nodeArray), null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsIncludingHostElements(Node parent, Node node) {
        IGenericEnumerator<Node> iGenericEnumerator = z3.m28(node).iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                Node node2 = (Node)iGenericEnumerator.next();
                if (node2 != parent) continue;
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            if (Operators.is(iGenericEnumerator, IDisposable.class)) {
                ((IDisposable)iGenericEnumerator).dispose();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node deepClone(Node node, Document document, boolean cloneChildren) {
        Iterator iterator;
        if (document == null) {
            document = node.nodeDocument;
        }
        Node node2 = null;
        if (node.getNodeType() == 1) {
            node2 = node.nodeDocument.createElementNS(((Element)node).getNamespaceURI(), node.getNodeName());
            iterator = ((Element)node).getAttributes().iterator();
            try {
                while (iterator.hasNext()) {
                    Node node3 = (Attr)iterator.next();
                    Attr attr = (Attr)Node.deepClone(node3, document, cloneChildren);
                    NamedNodeMap.append(attr, (Element)node2);
                }
            }
            finally {
                if (Operators.is(iterator, IDisposable.class)) {
                    ((IDisposable)((Object)iterator)).dispose();
                }
            }
        }
        switch (node.getNodeType()) {
            case 9: {
                iterator = (Document)node;
                node2 = ((Document)((Object)iterator)).getImplementation().createDocument(((Document)((Object)iterator)).getDocumentElement().getNamespaceURI(), null, null);
                break;
            }
            case 10: {
                iterator = (DocumentType)node;
                node2 = node.nodeDocument.createDocumentType(((DocumentType)((Object)iterator)).getName(), ((DocumentType)((Object)iterator)).getPublicId(), ((DocumentType)((Object)iterator)).getSystemId(), ((DocumentType)((Object)iterator)).getInternalSubset());
                break;
            }
            case 11: {
                node2 = node.nodeDocument.createDocumentFragment();
                break;
            }
            case 2: {
                iterator = (Attr)node;
                node2 = node.nodeDocument.createAttributeNS(((Attr)((Object)iterator)).getNamespaceURI(), ((Attr)((Object)iterator)).getNodeName());
                ((Attr)node2).setValue(((Attr)((Object)iterator)).getValue());
                break;
            }
            case 3: {
                node2 = node.nodeDocument.createTextNode(((com.aspose.html.dom.z1)node).getData());
                break;
            }
            case 8: {
                node2 = node.nodeDocument.createComment(((com.aspose.html.dom.z1)node).getData());
                break;
            }
            case 7: {
                iterator = (ProcessingInstruction)node;
                node2 = node.nodeDocument.createProcessingInstruction(((ProcessingInstruction)((Object)iterator)).getTarget(), ((com.aspose.html.dom.z1)((Object)iterator)).getData());
                break;
            }
        }
        if (node2 != null) {
            if (com.aspose.html.internal.p111.z2.m1(node2, 9)) {
                iterator = (Document)node2;
                document = iterator;
                node2.nodeDocument = iterator;
            } else {
                node2.nodeDocument = document;
            }
        }
        com.aspose.html.z3.m2().m1(node2, node, (Document)document, cloneChildren);
        if (cloneChildren) {
            for (Node node3 : node.children) {
                node2.children.m26(Node.deepClone(node3, document, cloneChildren));
            }
        }
        return node2;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public com.aspose.html.internal.p72.z2 getRegisteredObservers() {
        return this.auto_RegisteredObservers;
    }

    private void setRegisteredObservers(com.aspose.html.internal.p72.z2 value) {
        this.auto_RegisteredObservers = value;
    }

    @DOMNameAttribute(name="nodeType")
    public abstract int getNodeType();

    @DOMNameAttribute(name="localName")
    public String getLocalName() {
        return this.auto_LocalName;
    }

    @DOMNameAttribute(name="localName")
    protected void setLocalName(String value) {
        this.auto_LocalName = value;
    }

    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    public String getNamespaceURI() {
        return this.auto_NamespaceURI;
    }

    @DOMNameAttribute(name="namespaceURI")
    @DOMNullableAttribute
    protected void setNamespaceURI(String value) {
        this.auto_NamespaceURI = value;
    }

    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public String getPrefix() {
        return this.auto_Prefix;
    }

    @DOMNameAttribute(name="prefix")
    @DOMNullableAttribute
    public void setPrefix(String value) {
        this.auto_Prefix = value;
    }

    @DOMNameAttribute(name="nodeName")
    public abstract String getNodeName();

    @DOMNameAttribute(name="baseURI")
    public String getBaseURI() {
        if (this.nodeDocument == null) {
            return null;
        }
        return this.nodeDocument.getBaseURI();
    }

    @DOMNameAttribute(name="ownerDocument")
    @DOMNullableAttribute
    public Document getOwnerDocument() {
        return this.nodeDocument;
    }

    @DOMNameAttribute(name="parentNode")
    @DOMNullableAttribute
    public Node getParentNode() {
        return this.parent;
    }

    public void setParentNode(Node parent) {
        this.parent = parent;
    }

    @DOMNameAttribute(name="parentElement")
    @DOMNullableAttribute
    public Element getParentElement() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.getNodeType() == 1) {
            return Operators.as(this.parent, Element.class);
        }
        return null;
    }

    @DOMNameAttribute(name="hasChildNodes")
    public boolean hasChildNodes() {
        return this.first != null;
    }

    @DOMNameAttribute(name="childNodes")
    public NodeList getChildNodes() {
        return this.children;
    }

    @DOMNameAttribute(name="firstChild")
    public Node getFirstChild() {
        return this.first;
    }

    @DOMNameAttribute(name="lastChild")
    public Node getLastChild() {
        return this.last;
    }

    @DOMNameAttribute(name="previousSibling")
    public Node getPreviousSibling() {
        return this.previous;
    }

    @DOMNameAttribute(name="nextSibling")
    public Node getNextSibling() {
        return this.next;
    }

    @DOMNameAttribute(name="attributes")
    public NamedNodeMap getAttributes() {
        return null;
    }

    @DOMNameAttribute(name="hasAttributes")
    public boolean hasAttributes() {
        return false;
    }

    @DOMNameAttribute(name="nodeValue")
    public String getNodeValue() {
        return null;
    }

    @DOMNameAttribute(name="nodeValue")
    public void setNodeValue(String value) {
    }

    @DOMNameAttribute(name="textContent")
    public String getTextContent() {
        return null;
    }

    @DOMNameAttribute(name="textContent")
    public void setTextContent(String value) {
    }

    @PropertyAttribute(value="ChildNodesInternal")
    public final NodeList getChildNodesInternal() {
        return this.children;
    }

    @DOMNameAttribute(name="normalize")
    public void normalize() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 4L, null);
        while (iTreeWalker.nextNode() != null) {
            Text text = (Text)iTreeWalker.getCurrentNode();
            int n2 = text.getLength();
            if (n2 == 0) {
                text.parent.removeChild(text);
                continue;
            }
            msStringBuilder msStringBuilder2 = new msStringBuilder();
            Node node = text.getNextSibling();
            while (node != null && node.getNodeType() == 3) {
                Text text2 = (Text)node;
                msStringBuilder2.append(text2.getData());
                n2 += text2.getLength();
                text.parent.removeChild(node);
                node = text.getNextSibling();
            }
            text.replaceData(text.getLength(), 0, msStringBuilder2.toString());
        }
    }

    @DOMNameAttribute(name="cloneNode")
    public Node cloneNode(@DOMParameterAttribute(name="deep", optional=true) boolean deep) {
        return Node.deepClone(this, null, deep);
    }

    @DOMNameAttribute(name="isEqualNode")
    public boolean isEqualNode(@DOMNullableAttribute Node otherNode) {
        return Node.isEqualNode(this, otherNode);
    }

    @DOMNameAttribute(name="isSameNode")
    public boolean isSameNode(Node otherNode) {
        return ObjectExtensions.referenceEquals(this, otherNode);
    }

    @DOMNameAttribute(name="compareDocumentPosition")
    private short compareDocumentPosition(Node other) {
        throw new NotImplementedException();
    }

    @DOMNameAttribute(name="lookupPrefix")
    public String lookupPrefix(@DOMNullableAttribute String namespaceURI) {
        return z15.m3(this, namespaceURI);
    }

    @Override
    @DOMNameAttribute(name="lookupNamespaceURI")
    public String lookupNamespaceURI(@DOMNullableAttribute String prefix) {
        return z15.m2(this, prefix);
    }

    @DOMNameAttribute(name="isDefaultNamespace")
    public boolean isDefaultNamespace(@DOMNullableAttribute String namespaceURI) {
        return z15.m4(this, namespaceURI);
    }

    @DOMNameAttribute(name="insertBefore")
    public Node insertBefore(Node node, @DOMNullableAttribute Node child) {
        return Node.preInsert(node, this, child);
    }

    @DOMNameAttribute(name="replaceChild")
    public Node replaceChild(Node node, @DOMNullableAttribute Node child) {
        return Node.replace(child, node, this);
    }

    @DOMNameAttribute(name="removeChild")
    public Node removeChild(Node child) {
        return Node.preRemove(child, this);
    }

    @DOMNameAttribute(name="appendChild")
    public Node appendChild(Node node) {
        Node.preInsert(node, this, null);
        return node;
    }

    @Override
    protected void dispose(boolean disposing) {
        Node node = this.first;
        while (node != null) {
            node.dispose();
            node = node.next;
        }
        super.dispose(disposing);
    }

    private boolean hasChildOfType(int type) {
        Node node = this.first;
        while (node != null) {
            if (node.getNodeType() == type) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    private Node getChildOfType(int type) {
        Node node = this.first;
        while (node != null) {
            if (node.getNodeType() == type) {
                return node;
            }
            node = node.next;
        }
        return null;
    }

    private boolean hasMultipleChildrenOfType(int type) {
        boolean bl2 = false;
        Node node = this.first;
        while (node != null) {
            if (node.getNodeType() == type) {
                if (bl2) {
                    return true;
                }
                bl2 = true;
            }
            node = node.next;
        }
        return false;
    }

    public String toString() {
        return StringExtensions.format("{0}, Value=\"{1}\"", this.getNodeName(), this.getNodeValue());
    }

    public static class z2
    extends z33 {
        public static final int m4271;
        public static final int m4272;
        public static final int m4273;
        public static final int m4274;
        public static final int m4275;
        public static final int m4276;
        public static final int m4277;
        public static final int m4278;
        public static final int m4279;
        public static final int m4280;
        public static final int m4281;
        public static final int m4282;
        public static final int m4283;
        public static final int m4284;
        public static final int m4285;
        public static final int m4286;
        public static final int m4287;
        private static AtomicReference<z33.z1> m41;
        private AtomicInteger m4288 = new AtomicInteger();

        protected z2(z33.z1 z1100) {
            super(z1100);
        }

        public z2() {
            super(m41.get());
        }

        public void m362(int n2) {
            if (n2 == m4285) {
                this.m4288.incrementAndGet();
            }
            this.set(n2);
        }

        public void m363(int n2) {
            if (n2 == m4285 && this.m4288.decrementAndGet() == 0) {
                this.m31(n2);
            }
        }

        static {
            m41 = new AtomicReference<Object>(null);
            z33.z1 z1100 = new z33.z1();
            m4271 = z1100.m56("NODE_FIRST_CHILD");
            m4272 = z1100.m56("NODE_READ_ONLY");
            m4274 = z1100.m56("DETACHED");
            m4273 = z1100.m56("SUPPRESS_OBSERVERS");
            m4275 = z1100.m56("OBSERVER_SUPPRESSED");
            m4278 = z1100.m56("CONNECTED");
            m4276 = z1100.m56("DIRTY_VALUE_FLAG");
            m4277 = z1100.m56("DIRTY_CHECKEDNESS_FLAG");
            m4279 = z1100.m56("NODE_IS_SHAPE");
            m4280 = z1100.m56("NODE_IS_TEXT_CONTENT");
            m4281 = z1100.m56("NODE_IS_CONTAINER");
            m4282 = z1100.m56("NODE_IS_GRAPHICS");
            m4283 = z1100.m56("NODE_IS_DESCRIPTIVE_ELEMENT");
            m4284 = z1100.m56("NODE_NEVER_RENDERED");
            m4285 = z1100.m56("DELAYS_THE_LOAD_EVENT");
            m4286 = z1100.m56("READY_FOR_POST_LOAD_TASKS");
            m4287 = z1100.m56("COMPLETELY_LOADED");
            m41.set(z1100);
        }
    }

    private static class z3
    implements IGenericEnumerable<Node> {
        private z4<IGenericEnumerator<Node>> m4289;

        private z3(z4<IGenericEnumerator<Node>> z4100) {
            this.m4289 = z4100;
        }

        public static IGenericEnumerable<Node> m28(final Node node) {
            return new z3(new z4<IGenericEnumerator<Node>>(){

                public IGenericEnumerator<Node> m183() {
                    return new z1(node);
                }

                @Override
                public /* synthetic */ Object invoke() {
                    return this.m183();
                }
            });
        }

        @Override
        public IGenericEnumerator<Node> iterator() {
            return this.m4289.invoke();
        }

        private static class z1
        implements IGenericEnumerator<Node> {
            private final Node m4291;
            private Node m4270;

            public z1(Node node) {
                this.m4291 = node;
            }

            @Override
            public void dispose() {
            }

            @Override
            public boolean hasNext() {
                if (this.m4270 == null) {
                    this.m4270 = this.m4291;
                    return true;
                }
                if (this.m4270.parent != null) {
                    this.m4270 = this.m4270.parent;
                    return true;
                }
                return false;
            }

            @Override
            public void reset() {
                this.m4270 = null;
            }

            public Node m122() {
                return this.m4270;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.m122();
            }
        }
    }

    private static class com.aspose.html.dom.Node$z1
    extends NodeList {
        private final Node parent;

        public com.aspose.html.dom.Node$z1(Node node) {
            this.parent = node;
        }

        public void m26(Node node) {
            if (this.parent.first == null) {
                this.parent.first = node;
                this.parent.last = node;
            } else {
                Node node2 = this.parent.last;
                node2.next = node;
                node.previous = node2;
                this.parent.last = node;
            }
            node.parent = this.parent;
        }

        public void m3(Node node, Node node2) {
            Node node3 = node2.previous;
            node.previous = node3;
            node.next = node2;
            if (node3 != null) {
                node3.next = node;
            } else {
                this.parent.first = node;
            }
            node2.previous = node;
            node.parent = this.parent;
        }

        public void m27(Node node) {
            if (this.parent.first == node) {
                this.parent.first = node.next;
            }
            if (this.parent.last == node) {
                this.parent.last = node.previous;
            }
            if (node.previous != null) {
                node.previous.next = node.next;
            }
            if (node.next != null) {
                node.next.previous = node.previous;
            }
            node.next = null;
            node.previous = null;
            node.parent = null;
        }

        @Override
        public Node get_Item(int index) {
            if (index < 0) {
                return null;
            }
            Node node = this.parent.first;
            while (node != null) {
                if (index == 0) {
                    return node;
                }
                --index;
                node = node.next;
            }
            return null;
        }

        @Override
        public int getLength() {
            int n2 = 0;
            Node node = this.parent.first;
            while (node != null) {
                ++n2;
                node = node.next;
            }
            return n2;
        }

        @Override
        public IGenericEnumerator<Node> iterator() {
            return new z1(this.parent);
        }

        private static class z1
        implements IGenericEnumerator<Node> {
            private Node parent;
            private Node m4270;

            public z1(Node node) {
                this.parent = node;
            }

            @Override
            public void dispose() {
                this.parent = null;
            }

            @Override
            public boolean hasNext() {
                if (this.m4270 == null) {
                    this.m4270 = this.parent.first;
                    return this.m4270 != null;
                }
                if (this.m4270.next == null) {
                    return false;
                }
                this.m4270 = this.m4270.next;
                return true;
            }

            @Override
            public void reset() {
                this.m4270 = null;
            }

            public Node m122() {
                return this.m4270;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.m122();
            }
        }
    }
}

