/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html.dom;

import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.collections.NodeList;
import com.aspose.html.collections.z4;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.IParentNode;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.Text;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.traversal.ITreeWalker;
import com.aspose.html.dom.traversal.filters.z1;
import com.aspose.html.dom.traversal.filters.z8;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.System.Text.msStringBuilder;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.services.z10;
import com.aspose.html.z3;

@DOMObjectAttribute
@DOMNameAttribute(name="DocumentFragment")
public class DocumentFragment
extends Node
implements IParentNode {
    public DocumentFragment(Document ownerDocument) {
        super(ownerDocument);
    }

    @Override
    public String getNodeName() {
        return this.nodeDocument.strDocumentFragmentName;
    }

    @Override
    public int getNodeType() {
        return 11;
    }

    public String getInnerHTML() {
        return this.nodeDocument.getContext().getService(z10.class).m4430().m1((Node)this, new z8(this), true);
    }

    public void setInnerHTML(String value) {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            this.removeChild(node);
            node = node2;
        }
        ((z3)this.getOwnerDocument().getContext()).m1(this, value);
    }

    public String getOuterHTML() {
        return this.nodeDocument.getContext().getService(z10.class).m4430().m2(this, true);
    }

    public void setOuterHTML(String value) {
    }

    @Override
    public String getTextContent() {
        ITreeWalker iTreeWalker = this.nodeDocument.createTreeWalker(this, 4L, null);
        msStringBuilder msStringBuilder2 = new msStringBuilder();
        while (iTreeWalker.nextNode() != null) {
            msStringBuilder2.append(iTreeWalker.getCurrentNode());
        }
        return msStringBuilder2.toString();
    }

    @Override
    public void setTextContent(String value) {
        Text text = null;
        if (StringExtensions.isNullOrEmpty(value)) {
            text = new Text(value, this.nodeDocument);
        }
        DocumentFragment.replaceAll(text, this);
    }

    @Override
    public HTMLCollection getChildren() {
        return new z4(this, new z1(this));
    }

    @Override
    public Element getFirstElementChild() {
        ITreeWalker iTreeWalker = this.getOwnerDocument().createTreeWalker(this, 1L, null);
        try {
            Element element = Operators.as(iTreeWalker.firstChild(), Element.class);
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getLastElementChild() {
        ITreeWalker iTreeWalker = this.getOwnerDocument().createTreeWalker(this, 1L, null);
        try {
            Element element = Operators.as(iTreeWalker.lastChild(), Element.class);
            return element;
        }
        finally {
            if (iTreeWalker != null) {
                iTreeWalker.dispose();
            }
        }
    }

    @Override
    public Element getPreviousElementSibling() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public Element getNextElementSibling() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    @Override
    public int getChildElementCount() {
        return this.getChildren().getLength();
    }

    @Override
    public Element querySelector(String selector) {
        return this.nodeDocument.getBrowsingContext().m6().m2(selector, this);
    }

    @Override
    public NodeList querySelectorAll(String selector) {
        return this.nodeDocument.getBrowsingContext().m6().m1(selector, this);
    }
}

