/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLTableCaptionElement;
import com.aspose.html.HTMLTableSectionElement;
import com.aspose.html.collections.HTMLCollection;
import com.aspose.html.collections.z4;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNullableAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.traversal.filters.z6;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.p68.z1;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLTableElement")
public class HTMLTableElement
extends HTMLElement {
    private HTMLTableSectionElement body;

    public HTMLTableElement(z8 name, Document doc) {
        super(name, doc);
    }

    @DOMNameAttribute(name="caption")
    public HTMLTableCaptionElement getCaption() {
        return this.getChildOfType(HTMLTableCaptionElement.class);
    }

    @DOMNameAttribute(name="tHead")
    @DOMNullableAttribute
    public HTMLTableSectionElement getTHead() {
        return this.getTableSection("THEAD");
    }

    @DOMNameAttribute(name="tFoot")
    @DOMNullableAttribute
    public HTMLTableSectionElement getTFoot() {
        return this.getTableSection("TFOOT");
    }

    private HTMLTableSectionElement getTableSection(String sectionName) {
        z4 z4100 = new z4(this, new z6(sectionName));
        if (z4100.getLength() > 0) {
            return Operators.as(z4100.get_Item(0), HTMLTableSectionElement.class);
        }
        return null;
    }

    @DOMNameAttribute(name="rows")
    public HTMLCollection getRows() {
        return new z4(this, new z6("TR"));
    }

    @DOMNameAttribute(name="tBodies")
    public HTMLCollection getTBodies() {
        return new z4(this, new z6("TBODY"));
    }

    public HTMLTableSectionElement getBody() {
        HTMLCollection hTMLCollection;
        if (this.body == null && (hTMLCollection = this.getTBodies()).getLength() != 0) {
            this.body = Operators.as(hTMLCollection.get_Item(hTMLCollection.getLength() - 1), HTMLTableSectionElement.class);
        }
        return this.body;
    }

    @DOMNameAttribute(name="align")
    public String getAlign() {
        return this.getAttributeOrDefault("align", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="align")
    public void setAlign(String value) {
        this.setAttribute("align", value);
    }

    @DOMNameAttribute(name="bgColor")
    public String getBgColor() {
        return this.getAttributeOrDefault("bgcolor", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="bgColor")
    public void setBgColor(String value) {
        this.setAttribute("bgcolor", value);
    }

    @DOMNameAttribute(name="border")
    public String getBorder() {
        return this.getAttributeOrDefault("border", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="border")
    public void setBorder(String value) {
        this.setAttribute("border", value);
    }

    @DOMNameAttribute(name="cellPadding")
    public String getCellPadding() {
        return this.getAttributeOrDefault("cellpadding", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="cellPadding")
    public void setCellPadding(String value) {
        this.setAttribute("cellpadding", value);
    }

    @DOMNameAttribute(name="cellSpacing")
    public String getCellSpacing() {
        return this.getAttributeOrDefault("cellspacing", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="cellSpacing")
    public void setCellSpacing(String value) {
        this.setAttribute("cellspacing", value);
    }

    @DOMNameAttribute(name="frame")
    public String getFrame() {
        return this.getAttributeOrDefault("frame", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="frame")
    public void setFrame(String value) {
        this.setAttribute("frame", value);
    }

    @DOMNameAttribute(name="rules")
    public String getRules() {
        return this.getAttributeOrDefault("rules", "none");
    }

    @DOMNameAttribute(name="rules")
    public void setRules(String value) {
        this.setAttribute("rules", value);
    }

    @DOMNameAttribute(name="summary")
    public String getSummary() {
        return this.getAttributeOrDefault("summary", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="summary")
    public void setSummary(String value) {
        this.setAttribute("summary", value);
    }

    @DOMNameAttribute(name="width")
    public String getWidth() {
        return this.getAttributeOrDefault("width", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="width")
    public void setWidth(String value) {
        this.setAttribute("width", value);
    }

    @DOMNameAttribute(name="createTHead")
    public Element createTHead() {
        HTMLElement hTMLElement = Operators.as(this.getTHead(), HTMLElement.class);
        if (hTMLElement != null) {
            return hTMLElement;
        }
        HTMLElement hTMLElement2 = Operators.as(this.getOwnerDocument().createElement("THEAD"), HTMLElement.class);
        HTMLElement hTMLElement3 = Operators.as(this.getCaption(), HTMLElement.class);
        if (hTMLElement3 != null) {
            return Operators.as(this.insertBefore(hTMLElement2, hTMLElement3.getNextSibling()), HTMLElement.class);
        }
        return Operators.as(this.insertBefore(hTMLElement2, Operators.as(this.getFirstElementChild(), Element.class)), HTMLElement.class);
    }

    @DOMNameAttribute(name="deleteTHead")
    public void deleteTHead() {
        this.removeSectionElement(Operators.as(this.getTHead(), HTMLElement.class));
    }

    @DOMNameAttribute(name="createTFoot")
    public Element createTFoot() {
        if (this.getTFoot() == null) {
            this.appendChild(this.getOwnerDocument().createElement("TFOOT"));
        }
        return this.getTFoot();
    }

    @DOMNameAttribute(name="deleteTFoot")
    public void deleteTFoot() {
        this.removeSectionElement(Operators.as(this.getTFoot(), HTMLElement.class));
    }

    @DOMNameAttribute(name="createCaption")
    public Element createCaption() {
        if (this.getCaption() == null) {
            this.insertBefore(this.getOwnerDocument().createElement("CAPTION"), this.getFirstElementChild());
        }
        return this.getCaption();
    }

    @DOMNameAttribute(name="deleteCaption")
    public void deleteCaption() {
        this.removeSectionElement(Operators.as(this.getCaption(), HTMLElement.class));
    }

    private void removeSectionElement(HTMLElement element) {
        if (element != null) {
            this.removeChild(element);
        }
    }

    @DOMNameAttribute(name="insertRow")
    public Node insertRow(int index) {
        HTMLElement hTMLElement;
        Element element;
        HTMLCollection hTMLCollection = this.getRows();
        if (index < -1 || index > hTMLCollection.getLength()) {
            throw z1.m1208();
        }
        HTMLElement hTMLElement2 = hTMLCollection.getLength() > index && index != -1 ? Operators.as(hTMLCollection.get_Item(index), HTMLElement.class) : null;
        HTMLElement hTMLElement3 = hTMLElement2 != null ? (HTMLElement)hTMLElement2.getParentOfType(HTMLTableSectionElement.class) : null;
        HTMLCollection hTMLCollection2 = this.getTBodies();
        if (hTMLCollection2.getLength() == 0) {
            element = Operators.as(this.getTHead(), HTMLElement.class);
            if (element == null) {
                element = Operators.as(this.getCaption(), HTMLElement.class);
            }
            hTMLElement = Operators.as(this.getOwnerDocument().createElement("TBODY"), HTMLElement.class);
            hTMLElement = element != null ? Operators.as(this.insertBefore(hTMLElement, element.getNextSibling()), HTMLElement.class) : Operators.as(this.insertBefore(hTMLElement, Operators.as(this.getFirstElementChild(), Element.class)), HTMLElement.class);
        } else {
            element = hTMLElement3;
            if (element == null) {
                element = Operators.as(hTMLCollection2.get_Item(hTMLCollection2.getLength() - 1), HTMLElement.class);
            }
            hTMLElement = element;
        }
        element = this.getOwnerDocument().createElement("TR");
        if (hTMLElement != null && hTMLElement3 == hTMLElement && index != -1) {
            return Operators.as(hTMLElement.insertBefore(Operators.as(element, Element.class), hTMLElement2), HTMLElement.class);
        }
        if (hTMLElement != null) {
            return Operators.as(hTMLElement.appendChild(Operators.as(element, Element.class)), HTMLElement.class);
        }
        return null;
    }

    @DOMNameAttribute(name="deleteRow")
    public void deleteRow(int index) {
        HTMLCollection hTMLCollection = this.getRows();
        if (index < -1 || index >= hTMLCollection.getLength()) {
            throw z1.m1208();
        }
        HTMLElement hTMLElement = Operators.as(index != -1 ? hTMLCollection.get_Item(index) : hTMLCollection.get_Item(hTMLCollection.getLength() - 1), HTMLElement.class);
        Element element = hTMLElement.getParentElement();
        element.removeChild(hTMLElement);
    }
}

