/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.html;

import com.aspose.html.HTMLElement;
import com.aspose.html.HTMLFormElement;
import com.aspose.html.dom.Attr;
import com.aspose.html.dom.Document;
import com.aspose.html.dom.Element;
import com.aspose.html.dom.Node;
import com.aspose.html.dom.attributes.DOMNameAttribute;
import com.aspose.html.dom.attributes.DOMNullableAttribute;
import com.aspose.html.dom.attributes.DOMObjectAttribute;
import com.aspose.html.dom.z8;
import com.aspose.html.internal.ms.System.Action;
import com.aspose.html.internal.ms.System.Collections.IEnumerator;
import com.aspose.html.internal.ms.System.DateTime;
import com.aspose.html.internal.ms.System.Globalization.CultureInfo;
import com.aspose.html.internal.ms.System.Globalization.DateTimeFormatInfo;
import com.aspose.html.internal.ms.System.Globalization.msCalendar;
import com.aspose.html.internal.ms.System.IDisposable;
import com.aspose.html.internal.ms.System.Int32Extensions;
import com.aspose.html.internal.ms.System.SingleExtensions;
import com.aspose.html.internal.ms.System.StringExtensions;
import com.aspose.html.internal.ms.lang.Operators;
import com.aspose.html.internal.ms.lang.StringSwitchMap;
import com.aspose.html.internal.p4.z14;
import com.aspose.html.internal.p58.z9;
import com.aspose.html.io.IFileList;
import com.aspose.html.io.z3;

@DOMObjectAttribute
@DOMNameAttribute(name="HTMLInputElement")
public class HTMLInputElement
extends HTMLElement {
    private static final StringSwitchMap gStringSwitchMap = new StringSwitchMap("type", "checked", "multiple", "value", "name", "email", "url", "text", "search", "tel", "password", "date", "month", "week", "time", "color", "datetimelocal");
    private HTMLFormElement form;
    private boolean checkedAccessed;
    private boolean valueAccessed;
    private boolean checked;
    private boolean dirtyChechedness;
    private boolean argumentParsed = false;
    private String value;
    private IFileList _files = new z3();

    public HTMLInputElement(z8 name, Document doc) {
        super(name, doc);
        this.flags.set(Node.z2.m4276, false);
        this.flags.set(Node.z2.m4277, false);
        this.getAttributes().subscribe(z14.m1(new Action<Attr>(){

            public void m1(Attr attr) {
                HTMLInputElement.this.onUpdate(attr);
            }

            @Override
            public /* synthetic */ void invoke(Object object) {
                this.m1((Attr)object);
            }
        }));
    }

    @DOMNameAttribute(name="defaultValue")
    public String getDefaultValue() {
        return this.getAttributeOrDefault("value", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="defaultValue")
    public void setDefaultValue(String value) {
        this.initValueAttribute();
        this.setAttribute("value", value);
    }

    @DOMNameAttribute(name="defaultChecked")
    public boolean getDefaultChecked() {
        return this.hasAttribute("checked");
    }

    @DOMNameAttribute(name="defaultChecked")
    public void setDefaultChecked(boolean value) {
        this.initCheckedAttribute();
        this.toggleAttribute("checked", value);
    }

    @DOMNameAttribute(name="form")
    @DOMNullableAttribute
    public HTMLFormElement getForm() {
        if (this.form == null) {
            this.form = this.getParentOfType(HTMLFormElement.class);
        }
        return this.form;
    }

    @DOMNameAttribute(name="form")
    @DOMNullableAttribute
    public void setForm(HTMLFormElement value) {
        this.form = value;
    }

    @DOMNameAttribute(name="files")
    public IFileList getFiles() {
        return this._files;
    }

    @DOMNameAttribute(name="accept")
    public String getAccept() {
        return this.getAttributeOrDefault("accept", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="accept")
    public void setAccept(String value) {
        this.setAttribute("accept", value);
    }

    @DOMNameAttribute(name="accessKey")
    public String getAccessKey() {
        return this.getAttributeOrDefault("accesskey", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="accessKey")
    public void setAccessKey(String value) {
        this.setAttribute("accesskey", value);
    }

    @DOMNameAttribute(name="align")
    public String getAlign() {
        return this.getAttributeOrDefault("align", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="align")
    public void setAlign(String value) {
        this.setAttribute("align", value);
    }

    @DOMNameAttribute(name="alt")
    public String getAlt() {
        return this.getAttributeOrDefault("alt", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="alt")
    public void setAlt(String value) {
        this.setAttribute("alt", value);
    }

    @DOMNameAttribute(name="checked")
    public boolean getChecked() {
        this.initCheckedAttribute();
        return this.checked;
    }

    @DOMNameAttribute(name="checked")
    public void setChecked(boolean value) {
        this.flags.set(Node.z2.m4277, true);
        this.checked = value;
        this.checkedAccessed = true;
        if (this.checked) {
            this.switchOtherRadioButtonToFalse();
        }
    }

    @DOMNameAttribute(name="disabled")
    public boolean getDisabled() {
        return this.hasAttribute("disabled");
    }

    @DOMNameAttribute(name="disabled")
    public void setDisabled(boolean value) {
        this.toggleAttribute("disabled", value);
    }

    @DOMNameAttribute(name="list")
    public String getList() {
        return this.getAttributeOrDefault("list", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="list")
    public void setList(String value) {
        this.setAttribute("list", value);
    }

    @DOMNameAttribute(name="maxLength")
    public int getMaxLength() {
        return this.getAttributeOrDefault("maxlength", (short)Short.MAX_VALUE);
    }

    @DOMNameAttribute(name="maxLength")
    public void setMaxLength(int value) {
        this.setAttribute("maxlength", value);
    }

    @DOMNameAttribute(name="name")
    public String getName() {
        return this.getAttributeOrDefault("name", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="name")
    public void setName(String value) {
        this.setAttribute("name", value);
    }

    @DOMNameAttribute(name="readOnly")
    public boolean getReadOnly() {
        return this.hasAttribute("readonly");
    }

    @DOMNameAttribute(name="readOnly")
    public void setReadOnly(boolean value) {
        this.toggleAttribute("readonly", value);
    }

    @DOMNameAttribute(name="size")
    public int getSize() {
        return this.getAttributeOrDefault("size", 20);
    }

    @DOMNameAttribute(name="size")
    public void setSize(int value) {
        this.setAttribute("size", value);
    }

    @DOMNameAttribute(name="src")
    public String getSrc() {
        return this.getAttributeOrDefault("src", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="src")
    public void setSrc(String value) {
        this.setAttribute("src", value);
    }

    @DOMNameAttribute(name="tabIndex")
    public int getTabIndex() {
        return this.getAttributeOrDefault("tabindex", 0);
    }

    @DOMNameAttribute(name="tabIndex")
    public void setTabIndex(int value) {
        this.setAttribute("tabindex", value);
    }

    @DOMNameAttribute(name="type")
    public String getType() {
        return this.getAttributeOrDefault("type", "text");
    }

    @DOMNameAttribute(name="type")
    public void setType(String value) {
        this.setAttribute("type", value);
    }

    @DOMNameAttribute(name="useMap")
    public String getUseMap() {
        return this.getAttributeOrDefault("usemap", StringExtensions.Empty);
    }

    @DOMNameAttribute(name="useMap")
    public void setUseMap(String value) {
        this.setAttribute("usemap", value);
    }

    @DOMNameAttribute(name="value")
    public String getValue() {
        this.initValueAttribute();
        return this.value;
    }

    @DOMNameAttribute(name="value")
    public void setValue(String value) {
        this.value = value;
        this.valueAccessed = true;
        this.flags.set(Node.z2.m4276, true);
        this.sanitizeValue();
    }

    @DOMNameAttribute(name="blur")
    public void blur() {
    }

    @DOMNameAttribute(name="focus")
    public void focus() {
    }

    @DOMNameAttribute(name="select")
    public void select() {
    }

    @DOMNameAttribute(name="click")
    public void click() {
    }

    private void initCheckedAttribute() {
        if (this.checkedAccessed) {
            return;
        }
        this.checked = this.getDefaultChecked();
        this.checkedAccessed = true;
    }

    private void onUpdate(Attr attribute) {
        switch (gStringSwitchMap.of(attribute.getName())) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.flags.get(Node.z2.m4277) && this.hasAttribute("checked")) {
                    this.checked = true;
                    this.switchOtherRadioButtonToFalse();
                }
                if (this.flags.get(Node.z2.m4277) || this.hasAttribute("checked")) break;
                this.checked = false;
                break;
            }
            case 2: 
            case 3: {
                this.flags.set(Node.z2.m4276, true);
                this.sanitizeValue();
                break;
            }
            case 4: {
                this.checked = this.hasAttribute("checked");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchOtherRadioButtonToFalse() {
        if (this.getForm() == null) {
            return;
        }
        IEnumerator iEnumerator = this.getForm().getElements().iterator();
        try {
            while (iEnumerator.hasNext()) {
                HTMLInputElement hTMLInputElement;
                Element element = (Element)iEnumerator.next();
                if (!element.getTagName().equals("INPUT") || (hTMLInputElement = Operators.as(element, HTMLInputElement.class)) == null || !"radio".equals(hTMLInputElement.getType()) || hTMLInputElement.getName() == null || !StringExtensions.equals(StringExtensions.toLowerInvariant(hTMLInputElement.getName()), StringExtensions.toLowerInvariant(this.getName())) || this.equals(hTMLInputElement)) continue;
                hTMLInputElement.setChecked(false);
            }
        }
        finally {
            if (Operators.is(iEnumerator, IDisposable.class)) {
                ((IDisposable)((Object)iEnumerator)).dispose();
            }
        }
    }

    private void initValueAttribute() {
        if (this.valueAccessed) {
            return;
        }
        this.value = this.getDefaultValue();
        this.valueAccessed = true;
    }

    private void sanitizeValue() {
        switch (gStringSwitchMap.of(this.getType())) {
            case 5: {
                if (this.hasAttribute("multiple")) {
                    String[] stringArray = StringExtensions.split(this.getValue(), new String[]{","}, 1);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        stringArray[i2] = StringExtensions.trim(stringArray[i2]);
                    }
                    this.value = StringExtensions.join(",", stringArray);
                    break;
                }
                this.value = StringExtensions.trim(StringExtensions.replace(StringExtensions.replace(this.getValue(), "\r", StringExtensions.Empty), "\n", StringExtensions.Empty));
                break;
            }
            case 6: {
                this.value = StringExtensions.trim(StringExtensions.replace(StringExtensions.replace(this.getValue(), "\r", StringExtensions.Empty), "\n", StringExtensions.Empty));
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.value = StringExtensions.replace(StringExtensions.replace(this.getValue(), "\r", StringExtensions.Empty), "\n", StringExtensions.Empty);
                break;
            }
            case 11: {
                if (this.checkValidDate(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 12: {
                if (this.checkValidMonth(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 13: {
                if (this.checkValidWeek(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 14: {
                if (this.checkValidTime(this.getValue())) break;
                this.value = StringExtensions.Empty;
                break;
            }
            case 15: {
                if (!this.checkValidColor(this.getValue())) {
                    this.value = "#000000";
                    break;
                }
                this.value = StringExtensions.toLower(this.getValue());
                break;
            }
            case 16: {
                this.value = !this.checkValidDateTimeLocal(this.value) ? StringExtensions.Empty : this.getValue();
            }
        }
    }

    private boolean checkValidDateTimeLocal(String s2) {
        String[] stringArray = StringExtensions.split(s2, new char[]{'T'}, (short)1);
        return this.checkValidDate(stringArray[0]) || this.checkValidTime(stringArray[1]);
    }

    private boolean checkValidColor(String s2) {
        if (s2.length() != 7) {
            return false;
        }
        if (s2.charAt(0) != '#') {
            return false;
        }
        for (int i2 = 1; i2 < 7; ++i2) {
            if (z9.m21(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private boolean checkValidTime(String s2) {
        int n2 = 0;
        int n3 = 0;
        float f2 = 0.0f;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        float[] fArray = new float[]{0.0f};
        boolean bl2 = this.tryParseTime(s2, nArray, nArray2, fArray);
        n2 = nArray[0];
        n3 = nArray2[0];
        f2 = fArray[0];
        return bl2;
    }

    private boolean tryParseTime(String s2, int[] hour, int[] minute, float[] second) {
        boolean bl2 = false;
        hour[0] = 0;
        int n2 = 0;
        minute[0] = 0;
        int n3 = 0;
        second[0] = 0.0f;
        int n4 = s2.length();
        if (n4 < 5) {
            return false;
        }
        int[] nArray = new int[]{0};
        boolean bl3 = !Int32Extensions.tryParse(StringExtensions.substring(s2, 0, 2), nArray);
        n2 = nArray[0];
        if (bl3) {
            return false;
        }
        if (n2 < 0 || n2 > 23) {
            return false;
        }
        if (s2.charAt(2) != ':') {
            return false;
        }
        int[] nArray2 = new int[]{0};
        boolean bl4 = !Int32Extensions.tryParse(StringExtensions.substring(s2, 3, 2), nArray2);
        n3 = nArray2[0];
        if (bl4) {
            return false;
        }
        if (n3 < 0 || n3 > 59) {
            return false;
        }
        if (n4 == 5) {
            bl2 = true;
            hour[0] = n2;
            minute[0] = n3;
        }
        if (!bl2 && s2.charAt(5) != ':') {
            return false;
        }
        int n5 = 0;
        int[] nArray3 = new int[]{0};
        boolean bl5 = !bl2 && !Int32Extensions.tryParse(StringExtensions.substring(s2, 6, 2), nArray3);
        n5 = nArray3[0];
        if (bl5) {
            return false;
        }
        if (!(bl2 || n5 >= 0 && n5 <= 59)) {
            return false;
        }
        if (!bl2 && n4 == 8) {
            second[0] = n5;
            bl2 = true;
        }
        if (!bl2 && s2.charAt(8) != '.') {
            return false;
        }
        int n6 = 0;
        int[] nArray4 = new int[]{0};
        boolean bl6 = !bl2 && !Int32Extensions.tryParse(StringExtensions.substring(s2, 9), nArray4);
        n6 = nArray4[0];
        if (bl6) {
            return false;
        }
        if (!bl2 && n4 > 12) {
            return false;
        }
        return SingleExtensions.tryParse(StringExtensions.concat(Int32Extensions.toString(n5), ".", Int32Extensions.toString(n6)), 167, CultureInfo.getInvariantCulture(), second);
    }

    private boolean checkValidDate(String s2) {
        DateTime dateTime = new DateTime();
        DateTime[] dateTimeArray = new DateTime[]{dateTime};
        boolean bl2 = DateTime.tryParse(s2, dateTimeArray);
        dateTimeArray[0].CloneTo(dateTime);
        if (bl2) {
            return true;
        }
        if (s2.length() != 10) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        boolean bl3 = !this.checkValidMonth(StringExtensions.substring(s2, 0, 7), nArray, nArray2);
        n2 = nArray[0];
        n3 = nArray2[0];
        if (bl3) {
            return false;
        }
        if (s2.charAt(7) != '-') {
            return false;
        }
        int n4 = 0;
        int[] nArray3 = new int[]{0};
        boolean bl4 = !Int32Extensions.tryParse(StringExtensions.substring(s2, 8, 2), nArray3);
        n4 = nArray3[0];
        if (bl4) {
            return false;
        }
        return n4 > 0 && n4 <= DateTime.daysInMonth(n2, n3);
    }

    private boolean checkValidWeek(String s2) {
        if (s2.length() != 8) {
            return false;
        }
        int n2 = 0;
        int[] nArray = new int[]{0};
        boolean bl2 = !Int32Extensions.tryParse(StringExtensions.substring(s2, 0, 4), nArray);
        n2 = nArray[0];
        if (bl2) {
            return false;
        }
        if (n2 <= 0 && n2 > 9999) {
            return false;
        }
        if (s2.charAt(4) != '-') {
            return false;
        }
        if (s2.charAt(5) != 'W') {
            return false;
        }
        int n3 = 0;
        int[] nArray2 = new int[]{0};
        boolean bl3 = !Int32Extensions.tryParse(StringExtensions.substring(s2, 6, 2), nArray2);
        n3 = nArray2[0];
        if (bl3) {
            return false;
        }
        int n4 = this.getWeeksInYear(n2);
        return n3 >= 1 && n3 <= n4;
    }

    private int getWeeksInYear(int year) {
        DateTimeFormatInfo dateTimeFormatInfo = DateTimeFormatInfo.getCurrentInfo();
        DateTime dateTime = new DateTime(year, 12, 31);
        msCalendar msCalendar2 = dateTimeFormatInfo.getCalendar();
        return msCalendar2.getWeekOfYear(dateTime.Clone(), dateTimeFormatInfo.getCalendarWeekRule(), dateTimeFormatInfo.getFirstDayOfWeek());
    }

    private boolean checkValidMonth(String s2) {
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        boolean bl2 = this.checkValidMonth(s2, nArray, nArray2);
        n2 = nArray[0];
        n3 = nArray2[0];
        return bl2;
    }

    private boolean checkValidMonth(String s2, int[] year, int[] month) {
        year[0] = 0;
        month[0] = 0;
        if (s2.length() != 7) {
            return false;
        }
        if (!Int32Extensions.tryParse(StringExtensions.substring(s2, 0, 4), year)) {
            return false;
        }
        if (year[0] <= 0 && year[0] > 9999) {
            return false;
        }
        if (s2.charAt(4) != '-') {
            return false;
        }
        if (!Int32Extensions.tryParse(StringExtensions.substring(s2, 5, 2), month)) {
            return false;
        }
        return month[0] >= 1 && month[0] <= 12;
    }
}

