/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font;

import com.aspose.font.CffFontMetrics;
import com.aspose.font.FontType;
import com.aspose.font.Glyph;
import com.aspose.font.GlyphId;
import com.aspose.font.GlyphUInt32Id;
import com.aspose.font.IFont;
import com.aspose.font.IGlyphPainter;
import com.aspose.font.IGlyphRenderer;
import com.aspose.font.TransformationMatrix;

public abstract class GlyphRendererBase
implements IGlyphRenderer {
    private IGlyphPainter lif;

    GlyphRendererBase(IGlyphPainter painter) {
        this.lif = painter;
    }

    @Override
    public void renderGlyph(IFont font, long glyphIndex) {
        this.renderGlyph(font, glyphIndex, new TransformationMatrix());
    }

    @Override
    public void renderGlyph(IFont font, long glyphIndex, TransformationMatrix glyphPlacementMatrix) {
        this.renderGlyph(font, new GlyphUInt32Id(glyphIndex), glyphPlacementMatrix);
    }

    @Override
    public void renderGlyph(IFont font, GlyphId glyphId) {
        this.renderGlyph(font, glyphId, new TransformationMatrix());
    }

    @Override
    public void renderGlyph(IFont font, GlyphId glyphId, TransformationMatrix glyphPlacementMatrix) {
        TransformationMatrix transformationMatrix = this.lif(font, glyphId, glyphPlacementMatrix);
        Glyph glyph = this.ll(font, glyphId, transformationMatrix);
        if (glyph == null) {
            return;
        }
        this.lif(transformationMatrix, glyph, this.lif);
    }

    @Override
    public void renderGlyph(IFont font, GlyphId glyphId, Glyph glyph, TransformationMatrix glyphPlacementMatrix) {
        TransformationMatrix transformationMatrix = this.lif(font, glyphId, glyphPlacementMatrix);
        if (glyph == null) {
            return;
        }
        this.lif(transformationMatrix, glyph, this.lif);
    }

    @Override
    public void renderIndependentGlyphPath(IFont font, GlyphId glyphId, Glyph glyph, TransformationMatrix glyphPlacementMatrix) {
        TransformationMatrix transformationMatrix = this.lif(font, glyphId, glyphPlacementMatrix);
        if (glyph == null) {
            return;
        }
        this.ll(transformationMatrix, glyph, this.lif);
    }

    private TransformationMatrix lif(IFont iFont, GlyphId glyphId, TransformationMatrix transformationMatrix) {
        TransformationMatrix transformationMatrix2 = new TransformationMatrix();
        transformationMatrix2.setA(transformationMatrix.getA());
        transformationMatrix2.setB(transformationMatrix.getB());
        transformationMatrix2.setC(transformationMatrix.getC());
        transformationMatrix2.setD(transformationMatrix.getD());
        transformationMatrix2.setTX(transformationMatrix.getTX());
        transformationMatrix2.setTY(transformationMatrix.getTY());
        transformationMatrix2 = iFont.getFontType() == FontType.CFF ? ((CffFontMetrics)iFont.getMetrics()).getFontMatrixForGlyph(glyphId).multiply(transformationMatrix2) : iFont.getMetrics().getFontMatrix().multiply(transformationMatrix2);
        return transformationMatrix2;
    }

    private Glyph ll(IFont iFont, GlyphId glyphId, TransformationMatrix transformationMatrix) {
        return iFont.getGlyphAccessor().getGlyphById(glyphId);
    }

    abstract void lif(TransformationMatrix var1, Glyph var2, IGlyphPainter var3);

    abstract void ll(TransformationMatrix var1, Glyph var2, IGlyphPainter var3);
}

