/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.font.internal.l34I;

import com.aspose.font.internal.l227.I07;
import com.aspose.font.internal.l227.I2l;
import com.aspose.font.internal.l29I.I34;
import com.aspose.font.internal.l29I.I71;
import com.aspose.font.internal.l29I.Il;
import com.aspose.font.internal.l334.I21;
import com.aspose.font.internal.l334.I2I;
import com.aspose.font.internal.l34I.I12l;
import com.aspose.font.internal.l34I.I1391;
import com.aspose.font.internal.l34I.I41;
import com.aspose.font.internal.l34I.II;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.CertPathValidatorSpi;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class I127
extends CertPathValidatorSpi {
    private final Provider lif;

    I127(Provider provider) {
        this.lif = provider;
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        HashSet hashSet;
        PublicKey publicKey;
        X500Principal x500Principal;
        TrustAnchor trustAnchor;
        I21 i21;
        if (certPathParameters instanceof I21) {
            i21 = (I21)certPathParameters;
        } else if (certPathParameters instanceof I2I) {
            i21 = ((I2I)certPathParameters).lif();
        } else if (certPathParameters instanceof PKIXParameters) {
            i21 = new I21.I7((PKIXParameters)certPathParameters).lif();
        } else {
            throw new InvalidAlgorithmParameterException("Parameters must be " + PKIXParameters.class.getName() + " or " + I21.class.getName() + " instance.");
        }
        if (i21.lf() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for certification path validation.");
        }
        List<? extends Certificate> list = certPath.getCertificates();
        int n = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("Certification path is empty.", null, certPath, -1);
        }
        Set set = i21.l0if();
        try {
            trustAnchor = I41.lif((X509Certificate)list.get(list.size() - 1), i21.lf(), i21.l0l());
        }
        catch (II iI) {
            throw new CertPathValidatorException(iI.getMessage(), (Throwable)iI, certPath, list.size() - 1);
        }
        if (trustAnchor == null) {
            throw new CertPathValidatorException("Trust anchor for certification path not found.", null, certPath, -1);
        }
        i21 = new I21.I7(i21).lif(trustAnchor).lif();
        int n2 = 0;
        List[] listArray = new ArrayList[n + 1];
        for (int i = 0; i < listArray.length; ++i) {
            listArray[i] = new ArrayList();
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        hashSet2.add("2.5.29.32.0");
        I12l i12l = new I12l(new ArrayList(), 0, hashSet2, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(i12l);
        I71 i71 = new I71();
        HashSet hashSet3 = new HashSet();
        int n3 = i21.l0I() ? 0 : n + 1;
        int n4 = i21.l01() ? 0 : n + 1;
        int n5 = i21.l0IF() ? 0 : n + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x500Principal = I41.ll(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x500Principal = new X500Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("Subject of trust anchor could not be (re)encoded.", (Throwable)illegalArgumentException, certPath, -1);
        }
        Il il = null;
        try {
            il = I41.lif(publicKey);
        }
        catch (CertPathValidatorException certPathValidatorException) {
            throw new CertPathValidatorException("Algorithm identifier of public key of trust anchor could not be read.", (Throwable)certPathValidatorException, certPath, -1);
        }
        I2l i2l = il.lif();
        I07 i07 = il.ll();
        int n6 = n;
        if (i21.lIf() != null && !i21.lIf().lif((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("Target certificate in certification path does not match targetConstraints.", null, certPath, 0);
        }
        List list2 = i21.l0lf();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ((PKIXCertPathChecker)iterator.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            boolean bl;
            int n7 = n - n2;
            x509Certificate2 = (X509Certificate)list.get(n2);
            boolean bl2 = bl = n2 == list.size() - 1;
            if (x509Certificate2 == null) {
                throw new CertPathValidatorException("NULL certificate found", null, certPath, n2);
            }
            I1391.lif(certPath, i21, n2, publicKey, bl, x500Principal, x509Certificate, this.lif);
            I1391.lif(certPath, n2, i71);
            i12l = I1391.lif(certPath, n2, hashSet3, i12l, listArray, n4);
            i12l = I1391.lif(certPath, n2, i12l);
            I1391.lif(certPath, n2, i12l, n3);
            if (n7 == n) continue;
            if (x509Certificate2.getVersion() == 1) {
                throw new CertPathValidatorException("Version 1 certificates can't be used as CA ones.", null, certPath, n2);
            }
            I1391.lif(certPath, n2);
            i12l = I1391.lif(certPath, n2, listArray, i12l, n5);
            I1391.ll(certPath, n2, i71);
            n3 = I1391.llf(certPath, n2, n3);
            n5 = I1391.liF(certPath, n2, n5);
            n4 = I1391.lIf(certPath, n2, n4);
            n3 = I1391.lif(certPath, n2, n3);
            n5 = I1391.ll(certPath, n2, n5);
            n4 = I1391.lI(certPath, n2, n4);
            I1391.ll(certPath, n2);
            n6 = I1391.l1(certPath, n2, n6);
            n6 = I1391.lIF(certPath, n2, n6);
            I1391.lI(certPath, n2);
            hashSet = x509Certificate2.getCriticalExtensionOIDs();
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.removeAll(I1391.l0f);
            } else {
                hashSet = new HashSet();
            }
            I1391.lif(certPath, n2, hashSet, list2);
            x509Certificate = x509Certificate2;
            x500Principal = I41.ll(x509Certificate);
            try {
                publicKey = I41.lif(certPath.getCertificates(), n2, this.lif);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException("Next working key could not be retrieved.", (Throwable)certPathValidatorException, certPath, n2);
            }
            il = I41.lif(publicKey);
            i2l = il.lif();
            i07 = il.ll();
        }
        n3 = I1391.lif(n3, x509Certificate2);
        n3 = I1391.lf(certPath, n2 + 1, n3);
        Set<String> set2 = x509Certificate2.getCriticalExtensionOIDs();
        if (set2 != null) {
            set2 = new HashSet<String>(set2);
            set2.removeAll(I1391.l0f);
            set2.remove(I34.l1I.ll());
        } else {
            set2 = new HashSet<String>();
        }
        I1391.lif(certPath, n2 + 1, list2, set2);
        hashSet = I1391.lif(certPath, i21, set, n2 + 1, listArray, i12l, hashSet3);
        if (n3 > 0 || hashSet != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)((Object)hashSet), x509Certificate2.getPublicKey());
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n2);
    }
}

