/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.PalCryptographyBC;
import com.aspose.email.zbnu;
import com.aspose.email.zdy;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;

public class SmimeKey {
    private final PrivateKey a;
    private final X509Certificate[] b;
    private List<String> c;

    public SmimeKey(PrivateKey privateKey, X509Certificate ... certificateChain) {
        this.a = privateKey;
        this.b = certificateChain;
    }

    public SmimeKey(X509Certificate ... certificateChain) {
        this.a = null;
        this.b = certificateChain;
    }

    public static SmimeKey loadPrivateKey(InputStream stream) {
        try {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            Object object2 = new BufferedReader(new InputStreamReader(stream));
            Object object3 = null;
            try {
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    if (((String)object).startsWith(zbnu.a(new byte[]{-94, -43, 31, 95, -109}))) continue;
                    stringBuilder.append(((String)object).trim());
                }
            }
            catch (Throwable throwable) {
                object3 = throwable;
                throw throwable;
            }
            finally {
                if (object2 != null) {
                    if (object3 != null) {
                        try {
                            ((BufferedReader)object2).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)object2).close();
                    }
                }
            }
            object2 = zdy.a(stringBuilder.toString());
            object3 = new PKCS8EncodedKeySpec((byte[])object2);
            object = KeyFactory.getInstance(zbnu.a(new byte[]{-35, -85, 115}));
            PrivateKey privateKey = ((KeyFactory)object).generatePrivate((KeySpec)object3);
            return new SmimeKey(privateKey, new X509Certificate[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmimeKey loadPrivateKey(String keyPath) {
        try (FileInputStream fileInputStream = new FileInputStream(keyPath);){
            SmimeKey smimeKey = SmimeKey.loadPrivateKey(fileInputStream);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SmimeKey loadCertificate(InputStream stream) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance(zbnu.a(new byte[]{-41, -42, 7, 66, -121}));
            return new SmimeKey((X509Certificate)certificateFactory.generateCertificate(stream));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmimeKey loadCertificate(String crtPath) {
        try (FileInputStream fileInputStream = new FileInputStream(crtPath);){
            SmimeKey smimeKey = SmimeKey.loadCertificate(fileInputStream);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SmimeKey loadPFX(String pfxPath, char[] password) {
        return SmimeKey.loadPFX(pfxPath, null, password);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SmimeKey loadPFX(String pfxPath, String alias, char[] password) {
        try (FileInputStream fileInputStream = new FileInputStream(pfxPath);){
            SmimeKey smimeKey = SmimeKey.loadPFX(fileInputStream, alias, password);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static SmimeKey loadPFX(InputStream stream, char[] password) {
        return SmimeKey.loadPFX(stream, null, password);
    }

    public static SmimeKey loadPFX(InputStream stream, String alias, char[] password) {
        try {
            KeyStore keyStore = KeyStore.getInstance(zbnu.a(new byte[]{-33, -77, 113, 33, -113, -90}), PalCryptographyBC.b());
            keyStore.load(stream, password);
            if (alias == null || alias.isEmpty()) {
                SmimeKey smimeKey = SmimeKey.a(keyStore, password);
                return smimeKey;
            }
            SmimeKey smimeKey = SmimeKey.a(keyStore, alias, password);
            return smimeKey;
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnu.a(new byte[]{-52, -105, 71, 30, -38, -6, -124, -88, -13, -26, -70, 68, -128, 70, -75, 47, 14, -79, 30, -107, -60, -99, 75, 33, -54, -5, -47, -71}), exception);
        }
        finally {
            SmimeKey.a(password);
        }
    }

    private static SmimeKey a(KeyStore keyStore, char[] cArray) {
        X509Certificate x509Certificate = null;
        PrivateKey privateKey = null;
        try {
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string)) continue;
                KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, new KeyStore.PasswordProtection(cArray));
                privateKey = privateKeyEntry.getPrivateKey();
                Certificate certificate = keyStore.getCertificate(string);
                if (!(certificate instanceof X509Certificate)) continue;
                x509Certificate = (X509Certificate)certificate;
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnu.a(new byte[]{-52, -105, 71, 30, -38, -6, -124, -88, -13, -3, -79, 78, -101, 89, -79, 49, 71, -104, 22, -36, -30, -99, 121, 23, -57, -76, -59, -82, -68, -30, -12, 102, -111, 86, -121, 55, 8, -71, 30}), exception);
        }
        if (x509Certificate == null) {
            throw new RuntimeException(zbnu.a(new byte[]{-63, -105, 18, 17, -37, -26, -41, -75, -75, -26, -73, 76, -128, 74, -12, 37, 8, -66, 21, -47, -81, -111, 92, 82, -43, -15, -38, -81, -89, -32, -90, 72}));
        }
        return new SmimeKey(privateKey, x509Certificate);
    }

    private static SmimeKey a(KeyStore keyStore, String string, char[] cArray) {
        try {
            if (SmimeKey.a(keyStore, string)) {
                PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, cArray);
                Certificate[] certificateArray = keyStore.getCertificateChain(string);
                return new SmimeKey(privateKey, SmimeKey.a(certificateArray));
            }
            return null;
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnu.a(new byte[]{-52, -105, 71, 30, -38, -6, -124, -88, -13, -3, -79, 78, -101, 89, -79, 49, 71, -104, 22, -36, -30, -99, 121, 23, -57, -76, -59, -82, -68, -30, -12, 102, -111, 86, -121, 55, 8, -71, 30}), exception);
        }
    }

    private static X509Certificate[] a(Certificate[] certificateArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        int n = certificateArray.length;
        for (int i = 0; i < n; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        return x509CertificateArray;
    }

    private static boolean a(KeyStore keyStore, String string) {
        try {
            return keyStore.isKeyEntry(string);
        }
        catch (Exception exception) {
            throw new RuntimeException(zbnu.a(new byte[]{-52, -105, 71, 30, -38, -6, -124, -88, -13, -3, -79, 78, -101, 89, -79, 49, 71, -86, 23, -36, -18, -117, 87, 1, -98, -14, -47, -77, -66, -81, -97, 72, -115, 124, -96, 44, 21, -82}), exception);
        }
    }

    private static void a(char[] cArray) {
        if (null != cArray) {
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                cArray[i] = '\u0000';
            }
        }
    }

    public PrivateKey getPrivateKey() {
        return this.a;
    }

    public X509Certificate getCertificate() {
        return this.b[0];
    }

    public X509Certificate[] getCertificateChain() {
        return this.b != null ? (X509Certificate[])this.b.clone() : null;
    }

    public List<String> getAssociatedAddresses() {
        if (this.c == null) {
            this.a();
        }
        return this.c;
    }

    private void a() {
        Principal principal;
        ArrayList<String> arrayList = new ArrayList<String>();
        X509Certificate x509Certificate = this.getCertificate();
        if (null != x509Certificate && null != (principal = x509Certificate.getSubjectDN())) {
            String string = principal.getName();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!string2.startsWith("E=")) continue;
                arrayList.add(string2.substring(2));
            }
        }
        this.c = Collections.unmodifiableList(arrayList);
    }
}

