/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.SmimeKey;
import com.aspose.email.zbnu;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataStreamGenerator;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JcaAlgorithmParametersConverter;
import org.bouncycastle.util.Selector;
import org.bouncycastle.util.Store;

class PalCryptographyBC {
    private static final String d = zbnu.a(new byte[]{-51, -69, 116, 59, -18, -57});
    private static final String[] e = new String[]{d, "BC"};
    public static final String a = zbnu.a(new byte[]{-36, -80, 115, 64, -117, -94, -44, -75, -89, -25, -122, 126, -75});
    public static final KeyEncapsulationAlgorithm b = KeyEncapsulationAlgorithm.RSA;
    public static final ASN1ObjectIdentifier c = CMSAlgorithm.DES_EDE3_CBC;

    private static JcaCertStore a(X509Certificate[] x509CertificateArray) {
        Certificate[] certificateArray = (Certificate[])x509CertificateArray.clone();
        List<Object> list = certificateArray != null && certificateArray.length > 0 ? Arrays.asList(certificateArray) : new ArrayList();
        try {
            return new JcaCertStore(list);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new RuntimeException(certificateEncodingException);
        }
    }

    private static SignerInfoGenerator a(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        try {
            JcaSimpleSignerInfoGeneratorBuilder jcaSimpleSignerInfoGeneratorBuilder = new JcaSimpleSignerInfoGeneratorBuilder();
            jcaSimpleSignerInfoGeneratorBuilder.setSignedAttributeGenerator(new AttributeTable(PalCryptographyBC.b(x509CertificateArray)));
            jcaSimpleSignerInfoGeneratorBuilder.setProvider(PalCryptographyBC.b());
            X509Certificate x509Certificate = x509CertificateArray[0];
            return jcaSimpleSignerInfoGeneratorBuilder.build(a, privateKey, x509Certificate);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static ASN1EncodableVector b(X509Certificate[] x509CertificateArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        IssuerAndSerialNumber issuerAndSerialNumber = PalCryptographyBC.c(x509CertificateArray);
        aSN1EncodableVector.add((ASN1Encodable)new SMIMEEncryptionKeyPreferenceAttribute(issuerAndSerialNumber));
        aSN1EncodableVector.add((ASN1Encodable)new SMIMECapabilitiesAttribute(PalCryptographyBC.c()));
        return aSN1EncodableVector;
    }

    private static SMIMECapabilityVector c() {
        SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_EDE3_CBC);
        sMIMECapabilityVector.addCapability(SMIMECapability.rC2_CBC, 128);
        sMIMECapabilityVector.addCapability(SMIMECapability.dES_CBC);
        return sMIMECapabilityVector;
    }

    private static IssuerAndSerialNumber c(X509Certificate[] x509CertificateArray) {
        X509Certificate x509Certificate = x509CertificateArray[0];
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        X500Name x500Name = new X500Name(x509Certificate.getIssuerX500Principal().getName());
        return new IssuerAndSerialNumber(x500Name, bigInteger);
    }

    private static CMSSignedDataStreamGenerator a(JcaCertStore jcaCertStore, SignerInfoGenerator signerInfoGenerator) {
        try {
            CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = new CMSSignedDataStreamGenerator();
            cMSSignedDataStreamGenerator.addCertificates((Store)jcaCertStore);
            cMSSignedDataStreamGenerator.addSignerInfoGenerator(signerInfoGenerator);
            return cMSSignedDataStreamGenerator;
        }
        catch (CMSException cMSException) {
            throw new RuntimeException(cMSException);
        }
    }

    public static byte[] a(byte[] byArray, PrivateKey privateKey, X509Certificate[] x509CertificateArray, boolean bl) {
        CMSSignedDataStreamGenerator cMSSignedDataStreamGenerator = PalCryptographyBC.a(PalCryptographyBC.a(x509CertificateArray), PalCryptographyBC.a(privateKey, x509CertificateArray));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = cMSSignedDataStreamGenerator.open((OutputStream)byteArrayOutputStream, !bl);
            outputStream.write(byArray);
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static X509Certificate a(Store store, SignerId signerId) throws CertificateException {
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)store.getMatches((Selector)signerId).iterator().next();
        JcaX509CertificateConverter jcaX509CertificateConverter = new JcaX509CertificateConverter();
        jcaX509CertificateConverter.setProvider(PalCryptographyBC.b());
        return jcaX509CertificateConverter.getCertificate(x509CertificateHolder);
    }

    private static SignerInformationVerifier a(X509Certificate x509Certificate) throws OperatorCreationException {
        JcaSimpleSignerInfoVerifierBuilder jcaSimpleSignerInfoVerifierBuilder = new JcaSimpleSignerInfoVerifierBuilder();
        jcaSimpleSignerInfoVerifierBuilder.setProvider(PalCryptographyBC.b());
        return jcaSimpleSignerInfoVerifierBuilder.build(x509Certificate);
    }

    public static byte[] a(byte[] byArray) {
        try {
            CMSSignedData cMSSignedData = new CMSSignedData(byArray);
            return (byte[])cMSSignedData.getSignedContent().getContent();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Collection<X509Certificate> a(byte[] byArray, byte[] byArray2) {
        try {
            CMSProcessableByteArray cMSProcessableByteArray;
            CMSSignedData cMSSignedData;
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
            if (byArray2 == null) {
                cMSSignedData = new CMSSignedData(byArray);
            } else {
                cMSProcessableByteArray = new CMSProcessableByteArray(byArray2);
                cMSSignedData = new CMSSignedData((CMSProcessable)cMSProcessableByteArray, byArray);
            }
            cMSProcessableByteArray = cMSSignedData.getCertificates();
            for (SignerInformation signerInformation : cMSSignedData.getSignerInfos().getSigners()) {
                X509Certificate x509Certificate;
                SignerInformationVerifier signerInformationVerifier;
                if (!signerInformation.verify(signerInformationVerifier = PalCryptographyBC.a(x509Certificate = PalCryptographyBC.a((Store)cMSProcessableByteArray, signerInformation.getSID())))) {
                    throw new RuntimeException(zbnu.a(new byte[]{-36, -111, 85, 28, -33, -32, -42, -82, -74, -81, -94, 72, -122, 70, -78, 42, 4, -86, 15, -36, -32, -106, 18, 20, -33, -3, -49, -71, -73}));
                }
                hashSet.add(x509Certificate);
            }
            return hashSet;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] a(byte[] byArray, Collection<X509Certificate> collection) {
        return PalCryptographyBC.a(byArray, collection, b, c);
    }

    public static byte[] a(byte[] byArray, Collection<X509Certificate> collection, KeyEncapsulationAlgorithm keyEncapsulationAlgorithm, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        try {
            CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = PalCryptographyBC.a(collection, keyEncapsulationAlgorithm);
            OutputEncryptor outputEncryptor = PalCryptographyBC.a(aSN1ObjectIdentifier);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStream outputStream = cMSEnvelopedDataStreamGenerator.open((OutputStream)byteArrayOutputStream, outputEncryptor);
            outputStream.write(byArray);
            outputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static CMSEnvelopedDataStreamGenerator a(Collection<X509Certificate> collection, KeyEncapsulationAlgorithm keyEncapsulationAlgorithm) throws CertificateEncodingException, InvalidAlgorithmParameterException {
        CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        for (X509Certificate x509Certificate : collection) {
            JceKeyTransRecipientInfoGenerator jceKeyTransRecipientInfoGenerator;
            if (keyEncapsulationAlgorithm == KeyEncapsulationAlgorithm.RSA) {
                jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(x509Certificate);
            } else {
                String string = PalCryptographyBC.a(keyEncapsulationAlgorithm);
                AlgorithmIdentifier algorithmIdentifier = new JcaAlgorithmParametersConverter().getAlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (AlgorithmParameterSpec)new OAEPParameterSpec(string, zbnu.a(new byte[]{-62, -65, 116, 67}), new MGF1ParameterSpec(string), PSource.PSpecified.DEFAULT));
                jceKeyTransRecipientInfoGenerator = new JceKeyTransRecipientInfoGenerator(x509Certificate, algorithmIdentifier);
            }
            jceKeyTransRecipientInfoGenerator.setProvider(PalCryptographyBC.b());
            cMSEnvelopedDataStreamGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)jceKeyTransRecipientInfoGenerator);
        }
        return cMSEnvelopedDataStreamGenerator;
    }

    private static String a(KeyEncapsulationAlgorithm keyEncapsulationAlgorithm) throws InvalidAlgorithmParameterException {
        if (keyEncapsulationAlgorithm == KeyEncapsulationAlgorithm.RSA_OAEP_SHA224) {
            return zbnu.a(new byte[]{-36, -80, 115, 95, -116, -89, -105});
        }
        if (keyEncapsulationAlgorithm == KeyEncapsulationAlgorithm.RSA_OAEP_SHA256) {
            return zbnu.a(new byte[]{-36, -80, 115, 95, -116, -95, -107});
        }
        if (keyEncapsulationAlgorithm == KeyEncapsulationAlgorithm.RSA_OAEP_SHA384) {
            return zbnu.a(new byte[]{-36, -80, 115, 95, -115, -84, -105});
        }
        if (keyEncapsulationAlgorithm == KeyEncapsulationAlgorithm.RSA_OAEP_SHA512) {
            return zbnu.a(new byte[]{-36, -80, 115, 95, -117, -91, -111});
        }
        throw new InvalidAlgorithmParameterException(zbnu.a(new byte[]{-38, -106, 89, 28, -47, -29, -51, -4, -128, -96, -103, 100, -71, 106, -12, 40, 2, -78, 91, -48, -31, -101, 83, 2, -51, -31, -49, -67, -89, -26, -69, 67, -44, 78, -72, 36, 8, -71, 18, -63, -25, -107, 8, 82}) + keyEncapsulationAlgorithm.name());
    }

    private static OutputEncryptor a(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws CMSException {
        return new JceCMSContentEncryptorBuilder(aSN1ObjectIdentifier).setProvider(PalCryptographyBC.b()).build();
    }

    public static Collection<X509Certificate> a(byte[] byArray, SmimeKey smimeKey) {
        try {
            HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
            if (smimeKey.getCertificateChain().length == 0) {
                return hashSet;
            }
            CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(byArray);
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            for (RecipientInformation recipientInformation : recipientInformationStore.getRecipients()) {
                for (X509Certificate x509Certificate : smimeKey.getCertificateChain()) {
                }
            }
            return hashSet;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static byte[] b(byte[] byArray, SmimeKey smimeKey) {
        try {
            X509Certificate x509Certificate = smimeKey.getCertificate();
            PrivateKey privateKey = smimeKey.getPrivateKey();
            CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(byArray);
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            RecipientInformation recipientInformation = recipientInformationStore.get((RecipientId)new JceKeyTransRecipientId(x509Certificate));
            if (null == recipientInformation) {
                throw new RuntimeException(zbnu.a(new byte[]{-31, -105, 18, 0, -37, -9, -54, -84, -70, -22, -70, 89}));
            }
            JceKeyTransEnvelopedRecipient jceKeyTransEnvelopedRecipient = new JceKeyTransEnvelopedRecipient(privateKey);
            jceKeyTransEnvelopedRecipient.setProvider(PalCryptographyBC.b());
            return recipientInformation.getContent((Recipient)jceKeyTransEnvelopedRecipient);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static String[] a() {
        return e;
    }

    public static String b() {
        for (String string : PalCryptographyBC.a()) {
            if (Security.getProvider(string) == null) continue;
            return string;
        }
        return "BC";
    }

    public static enum KeyEncapsulationAlgorithm {
        RSA,
        RSA_OAEP_SHA224,
        RSA_OAEP_SHA256,
        RSA_OAEP_SHA384,
        RSA_OAEP_SHA512;

    }
}

