/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email;

import com.aspose.email.EmlLoadOptions;
import com.aspose.email.FolderInfo;
import com.aspose.email.MailMessage;
import com.aspose.email.MapiConversionOptions;
import com.aspose.email.MapiMessage;
import com.aspose.email.MboxLoadOptions;
import com.aspose.email.MboxStorageReader;
import com.aspose.email.MboxToPstConversionOptions;
import com.aspose.email.MboxrdStorageReader;
import com.aspose.email.PersonalStorage;
import com.aspose.email.internal.b.zar;
import com.aspose.email.internal.ev.za;
import com.aspose.email.system.AsyncCallback;
import com.aspose.email.system.IAsyncResult;
import com.aspose.email.system.MulticastDelegate;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.io.FileStream;
import com.aspose.email.system.io.Stream;
import com.aspose.email.zako;
import com.aspose.email.zboa;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MailStorageConverter {
    private static EmlLoadOptions a = new EmlLoadOptions();

    public static EmlLoadOptions getMboxMessageOptions() {
        return a;
    }

    public static void setMboxMessageOptions(EmlLoadOptions value) {
        a = value;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstFileName, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MailHandler mailHandler) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zboa.a(new byte[]{-70, -18, 59, 33, -66, 112, 121, 108, -58, 63, 54, 92, 27, -12, 55, -73, 86, 62, 122, 81, -41, -18, 49, 121, -16, 99, 124, 108, -125, 112, 42, 29, 19, -4, 103, -96, 78}), zboa.a(new byte[]{-102, -18, 59, 33, -40, 127, 124, 101, -19, 126, 53, 88}));
        }
        return MailStorageConverter.a(new FileStream(mboxFileName, 3, 1), pstFileName, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName);
    }

    static PersonalStorage a(Stream stream, String string) {
        return MailStorageConverter.a(stream, string, null);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, String pstFileName, MailHandler mailHandler) {
        return MailStorageConverter.a(Stream.fromJava(mboxrdDataStream), pstFileName, mailHandler);
    }

    static PersonalStorage a(Stream stream, String string, MailHandler mailHandler) {
        if (zar.a(string)) {
            throw new ArgumentException(zboa.a(new byte[]{-89, -1, 32, 121, -8, 127, 124, 101, -125, 113, 57, 80, 19, -79, 116, -75, 89, 119, 41, 5, -107, -23, 116, 55, -21, 122, 124, 32, -52, 109, 120, 88, 27, -31, 99, -83}), zboa.a(new byte[]{-121, -1, 32, 31, -9, 122, 117, 78, -62, 114, 61}));
        }
        return MailStorageConverter.mboxToPst(stream, (Stream)new FileStream(string, 2, 3), mailHandler);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxFileName, pstDataStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(String mboxFileName, OutputStream pstDataStream, MailHandler mailHandler) {
        PersonalStorage personalStorage;
        FileInputStream fileInputStream = new FileInputStream(mboxFileName);
        try {
            personalStorage = MailStorageConverter.mboxToPst((InputStream)fileInputStream, pstDataStream, mailHandler);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
        ((InputStream)fileInputStream).close();
        return personalStorage;
    }

    public static PersonalStorage mboxToPst(String mboxFileName, Stream pstDataStream, MailHandler mailHandler) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zboa.a(new byte[]{-70, -18, 59, 33, -66, 112, 121, 108, -58, 63, 54, 92, 27, -12, 55, -73, 86, 62, 122, 81, -41, -18, 49, 121, -16, 99, 124, 108, -125, 112, 42, 29, 19, -4, 103, -96, 78}), zboa.a(new byte[]{-102, -18, 59, 33, -40, 127, 124, 101, -19, 126, 53, 88}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), pstDataStream, mailHandler);
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream) {
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, new MboxToPstConversionOptions());
    }

    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        return MailStorageConverter.mboxToPst(mboxrdDataStream, pstDataStream, mboxToPstConversionOptions);
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MailHandler mailHandler) {
        MboxToPstConversionOptions mboxToPstConversionOptions = new MboxToPstConversionOptions();
        mboxToPstConversionOptions.setMessageHandler(mailHandler);
        MailStorageConverter.mboxToPst(mboxStorageReader, pst, pstFolderName, mboxToPstConversionOptions);
    }

    public static PersonalStorage mboxToPst(String mboxFileName, String pstFileName, MboxToPstConversionOptions options) {
        if (zar.a(mboxFileName)) {
            throw new ArgumentException(zboa.a(new byte[]{-70, -18, 59, 33, -66, 112, 121, 108, -58, 63, 54, 92, 27, -12, 55, -73, 86, 62, 122, 81, -41, -18, 49, 121, -16, 99, 124, 108, -125, 112, 42, 29, 19, -4, 103, -96, 78}), zboa.a(new byte[]{-102, -18, 59, 33, -40, 127, 124, 101, -19, 126, 53, 88}));
        }
        if (zar.a(pstFileName)) {
            throw new ArgumentException(zboa.a(new byte[]{-89, -1, 32, 121, -8, 127, 124, 101, -125, 113, 57, 80, 19, -79, 116, -75, 89, 119, 41, 5, -107, -23, 116, 55, -21, 122, 124, 32, -52, 109, 120, 88, 27, -31, 99, -83}), zboa.a(new byte[]{-121, -1, 32, 31, -9, 122, 117, 78, -62, 114, 61}));
        }
        return MailStorageConverter.mboxToPst((Stream)new FileStream(mboxFileName, 3, 1), (Stream)new FileStream(pstFileName, 2, 3), options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(InputStream mboxrdDataStream, OutputStream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zboa.a(new byte[]{-102, -18, 59, 33, -20, 114, 84, 97, -41, 126, 11, 73, 4, -12, 118, -71}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zboa.a(new byte[]{-121, -1, 32, 29, -1, 98, 113, 83, -41, 109, 61, 92, 27}));
        }
        PersonalStorage personalStorage = PersonalStorage.create(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zboa.a(new byte[]{-66, -30, 54, 54, -26}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersonalStorage mboxToPst(Stream mboxrdDataStream, Stream pstDataStream, MboxToPstConversionOptions options) {
        if (mboxrdDataStream == null) {
            throw new ArgumentNullException(zboa.a(new byte[]{-102, -18, 59, 33, -20, 114, 84, 97, -41, 126, 11, 73, 4, -12, 118, -71}));
        }
        if (pstDataStream == null) {
            throw new ArgumentNullException(zboa.a(new byte[]{-121, -1, 32, 29, -1, 98, 113, 83, -41, 109, 61, 92, 27}));
        }
        PersonalStorage personalStorage = PersonalStorage.a(pstDataStream, 0);
        MboxLoadOptions mboxLoadOptions = new MboxLoadOptions();
        mboxLoadOptions.setLeaveOpen(false);
        MboxrdStorageReader mboxrdStorageReader = new MboxrdStorageReader(mboxrdDataStream, mboxLoadOptions);
        try {
            MailStorageConverter.mboxToPst((MboxStorageReader)mboxrdStorageReader, personalStorage, zboa.a(new byte[]{-66, -30, 54, 54, -26}), options);
        }
        finally {
            if (mboxrdStorageReader != null) {
                mboxrdStorageReader.dispose();
            }
        }
        return personalStorage;
    }

    public static void mboxToPst(MboxStorageReader mboxStorageReader, PersonalStorage pst, String pstFolderName, MboxToPstConversionOptions options) {
        MailMessage mailMessage;
        if (mboxStorageReader == null) {
            throw new ArgumentNullException(zboa.a(new byte[]{-102, -18, 59, 33, -51, 98, 127, 114, -62, 120, 61, 111, 19, -16, 115, -79, 69}));
        }
        if (pst == null) {
            throw new ArgumentNullException(zboa.a(new byte[]{-121, -1, 32}));
        }
        FolderInfo folderInfo = pst.getRootFolder().getSubFolder(pstFolderName);
        if (folderInfo == null) {
            folderInfo = pst.getRootFolder().addSubFolder(pstFolderName);
        }
        while ((mailMessage = mboxStorageReader.readNextMessage(MailStorageConverter.getMboxMessageOptions())) != null) {
            if (options.getMessageHandler() != null) {
                options.getMessageHandler().invoke(mailMessage);
            }
            MapiConversionOptions mapiConversionOptions = MapiConversionOptions.getUnicodeFormat();
            mapiConversionOptions.setRemoveSignature(options != null ? options.getRemoveSignature() : false);
            folderInfo.addMessage(MapiMessage.fromMailMessage(mailMessage, mapiConversionOptions));
        }
    }

    public static abstract class MailHandler
    extends MulticastDelegate {
        public abstract void invoke(MailMessage var1);

        public final IAsyncResult beginInvoke(MailMessage message, AsyncCallback callback, Object state) {
            return za.a(new zako(this, this, callback, state, message));
        }

        public final void endInvoke(IAsyncResult result) {
            za.a(this, result);
        }
    }
}

