/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.email.system;

import com.aspose.email.internal.b.zaf;
import com.aspose.email.internal.b.zar;
import com.aspose.email.internal.b.zat;
import com.aspose.email.internal.b.zbd;
import com.aspose.email.internal.b.zv;
import com.aspose.email.internal.d.zb;
import com.aspose.email.system.Action;
import com.aspose.email.system.Comparison;
import com.aspose.email.system.Converter;
import com.aspose.email.system.Predicate;
import com.aspose.email.system.Struct;
import com.aspose.email.system.collections.ICollection;
import com.aspose.email.system.collections.IEnumerable;
import com.aspose.email.system.collections.IEnumerator;
import com.aspose.email.system.collections.IList;
import com.aspose.email.system.collections.generic.IGenericEnumerator;
import com.aspose.email.system.collections.generic.IGenericList;
import com.aspose.email.system.collections.generic.List;
import com.aspose.email.system.exceptions.ArgumentException;
import com.aspose.email.system.exceptions.ArgumentNullException;
import com.aspose.email.system.exceptions.ArgumentOutOfRangeException;
import com.aspose.email.system.exceptions.ArrayTypeMismatchException;
import com.aspose.email.system.exceptions.Exception;
import com.aspose.email.system.exceptions.IndexOutOfRangeException;
import com.aspose.email.system.exceptions.InvalidCastException;
import com.aspose.email.system.exceptions.InvalidOperationException;
import com.aspose.email.system.exceptions.NotImplementedException;
import com.aspose.email.system.exceptions.NotSupportedException;
import com.aspose.email.system.exceptions.RankException;
import com.aspose.email.system.exceptions.TypeLoadException;
import java.util.Comparator;

public abstract class Array
implements zv,
ICollection,
IEnumerable,
IList {
    private Array() {
    }

    protected abstract Object getInternalObject();

    protected abstract zd getArrayInfo();

    protected abstract com.aspose.email.internal.ak.zc getArrayHelper();

    protected abstract za createEnumerator(int var1, int var2);

    public static Array boxing(Object javaArray) {
        return Array.a(javaArray, 1, false);
    }

    public static Array boxing(Object javaArray, int rank) {
        return Array.a(javaArray, rank, false);
    }

    public static Array boxing(Object javaArray, int rank, boolean isJagged) {
        return Array.a(javaArray, rank, isJagged);
    }

    private static zb a(Object object, int n, boolean bl) {
        if (object == null) {
            return null;
        }
        if (n < 1) {
            throw new ArgumentException("Incorrect dimension of array", "rank");
        }
        switch (n) {
            case 1: {
                return new zg(object, bl, null);
            }
        }
        return new ze(object, n, bl, null);
    }

    public static Object unboxing(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array is null");
        }
        return array.getInternalObject();
    }

    public static <T> IGenericList<T> toGenericList(T[] array) {
        Array array2 = Array.boxing(array);
        if (array2 == null) {
            return null;
        }
        return Array.toGenericList(array2);
    }

    public static <T> IGenericList<T> toGenericList(Array array) {
        return new zc(array, null);
    }

    public static <T> com.aspose.email.internal.e.zb<T> asReadOnly(T[] array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return new com.aspose.email.internal.e.zb<T>(Array.toGenericList(array));
    }

    public static int binarySearch(Array array, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (value == null) {
            return -1;
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (!(value instanceof Comparable)) {
            throw new InvalidOperationException("Failed to compare two elements in the array.");
        }
        return Array.a(array, array.getLowerBound(0), array.getLength(0), value, null);
    }

    public static int binarySearch(Array array, Object value, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (comparer == null && value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return Array.a(array, array.getLowerBound(0), array.getLength(0), value, comparer);
    }

    public static int binarySearch(Array array, int index, int length, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < array.getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (index > array.getLowerBound(0) + array.getLength(0) - length) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("value does not support IComparable");
        }
        return Array.a(array, index, length, value, null);
    }

    public static int binarySearch(Array array, int index, int length, Object value, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < array.getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("index", "index is less than the lower bound of array.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (index > array.getLowerBound(0) + array.getLength(0) - length) {
            throw new ArgumentException("index and length do not specify a valid range in array.");
        }
        if (array.getLength() == 0) {
            return -1;
        }
        if (comparer == null && value != null && !(value instanceof Comparable)) {
            throw new ArgumentException("comparer is null and value does not support IComparable.");
        }
        return Array.a(array, index, length, value, comparer);
    }

    static int a(Array array, int n, int n2, Object object, Comparator comparator) {
        if (comparator == null) {
            comparator = com.aspose.email.internal.c.ze.a;
        }
        int n3 = n;
        int n4 = n + n2 - 1;
        int n5 = 0;
        while (n3 <= n4) {
            int n6 = n3 + (n4 - n3) / 2;
            Object object2 = array.getValueImpl(n6);
            try {
                n5 = comparator.compare(object2, object);
            }
            catch (java.lang.Exception exception) {
                throw new ArgumentException("value is not of the same type", exception);
            }
            if (n5 == 0) {
                return n6;
            }
            if (n5 > 0) {
                n4 = n6 - 1;
                continue;
            }
            n3 = n6 + 1;
        }
        return ~n3;
    }

    public static <T> int binarySearch(T[] array, T value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.binarySearch(array, 0, Array.boxing(array).getLength(), value, null);
    }

    public static <T> int binarySearch(T[] array, T value, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.binarySearch(array, 0, Array.boxing(array).getLength(), value, comparer);
    }

    public static <T> int binarySearch(T[] array, int index, int length, T value) {
        return Array.binarySearch(array, index, length, value, null);
    }

    public static <T> int binarySearch(T[] array, int index, int length, T value, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "Non-negative number required.");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (index > Array.boxing(array).getLength() - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (comparer == null) {
            comparer = com.aspose.email.internal.d.za.a();
        }
        int n = index;
        int n2 = index + length - 1;
        int n3 = 0;
        try {
            while (n <= n2) {
                int n4 = n + (n2 - n) / 2;
                n3 = comparer.compare(value, array[n4]);
                if (n3 == 0) {
                    return n4;
                }
                if (n3 < 0) {
                    n2 = n4 - 1;
                    continue;
                }
                n = n4 + 1;
            }
        }
        catch (Exception exception) {
            throw new InvalidOperationException("Comparer threw an exception.", exception);
        }
        return ~n;
    }

    public static void clear(Array array, int index, int length) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (length < 0) {
            throw new IndexOutOfRangeException("Non-negative number required.");
        }
        int n = array.getLowerBound(0);
        if (index < n) {
            throw new IndexOutOfRangeException("index < lower bound");
        }
        if ((index -= n) > array.getLength() - length) {
            throw new IndexOutOfRangeException("index + length > size");
        }
        za za2 = array.createEnumerator(index, length);
        Class clazz = array.getArrayInfo().b;
        while (za2.hasNext()) {
            za2.a(com.aspose.email.internal.hu.zb.b(clazz));
        }
    }

    @Override
    public Object deepClone() {
        if (this.getRank() > 1) {
            throw new NotImplementedException();
        }
        zd zd2 = this.getArrayInfo();
        Array array = Array.createInstance(com.aspose.email.internal.hu.zb.a(zd2.b), (int)zd2.e);
        this.copyTo(array, 0);
        return array;
    }

    public static void constrainedCopy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length) {
        Array.copy(sourceArray, sourceIndex, destinationArray, destinationIndex, length);
    }

    public static void copy(Array sourceArray, Array destinationArray, int length) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        Array.copy(sourceArray, sourceArray.getLowerBound(0), destinationArray, destinationArray.getLowerBound(0), length);
    }

    public static void copy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (sourceIndex < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Non-negative number required.");
        }
        if (destinationIndex < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Non-negative number required.");
        }
        if (sourceIndex > sourceArray.getLength() - length) {
            throw new ArgumentException("length");
        }
        if (destinationIndex > destinationArray.getLength() - length) {
            String string = zar.a(new String[]{"Destination array was not long enough. Check ", "destIndex and length, and the array's lower bounds"});
            throw new ArgumentException(string, zar.a);
        }
        if (sourceArray.getRank() != destinationArray.getRank()) {
            throw new RankException("Arrays must be of same size.");
        }
        Class clazz = sourceArray.getArrayInfo().b;
        Class clazz2 = destinationArray.getArrayInfo().b;
        boolean bl = Struct.class.isAssignableFrom(clazz);
        if (!bl && sourceArray.getRank() == 1 && Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length)) {
            return;
        }
        if (zaf.b(Array.unboxing(sourceArray), Array.unboxing(destinationArray)) && Array.a(sourceIndex, destinationIndex, length)) {
            zat zat2 = com.aspose.email.internal.hu.zb.a(clazz);
            Array array = Array.createInstance(zat2, length);
            Array.a(sourceArray, sourceIndex, array, 0, length, bl);
            Array.a(array, 0, destinationArray, destinationIndex, length, false);
        } else {
            Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length, bl);
        }
    }

    public static <T> void copyInternal(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length, ElementInitializer<T> elementInitializer) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (length < 0) {
            throw new ArgumentOutOfRangeException("length", "Non-negative number required.");
        }
        if (sourceIndex < 0) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Non-negative number required.");
        }
        if (destinationIndex < 0) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Non-negative number required.");
        }
        if (sourceIndex > sourceArray.getLength() - length) {
            throw new ArgumentException("length");
        }
        if (destinationIndex > destinationArray.getLength() - length) {
            String string = zar.a(new String[]{"Destination array was not long enough. Check ", "destIndex and length, and the array's lower bounds"});
            throw new ArgumentException(string, zar.a);
        }
        if (sourceArray.getRank() != destinationArray.getRank()) {
            throw new RankException("Arrays must be of same size.");
        }
        Class clazz = sourceArray.getArrayInfo().b;
        Class clazz2 = destinationArray.getArrayInfo().b;
        boolean bl = Struct.class.isAssignableFrom(clazz);
        if (!bl && sourceArray.getRank() == 1 && Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length)) {
            return;
        }
        if (zaf.b(Array.unboxing(sourceArray), Array.unboxing(destinationArray)) && Array.a(sourceIndex, destinationIndex, length)) {
            zat zat2 = com.aspose.email.internal.hu.zb.a(clazz);
            Array array = Array.createInstanceInternal(zat2.o(), length, elementInitializer);
            Array.a(sourceArray, sourceIndex, array, 0, length, bl);
            Array.a(array, 0, destinationArray, destinationIndex, length, false);
        } else {
            Array.a(sourceArray, sourceIndex, destinationArray, destinationIndex, length, bl);
        }
    }

    private static boolean a(int n, int n2, int n3) {
        return n < n2 && n + n3 > n2 || n2 < n && n2 + n3 > n;
    }

    private static void a(Array array, int n, Array array2, int n2, int n3, boolean bl) {
        try {
            if (!bl) {
                for (int i = 0; i < n3; ++i) {
                    Object object = array.getValueImpl(n + i);
                    array2.setValueImpl(object, n2 + i);
                }
            } else {
                for (int i = 0; i < n3; ++i) {
                    Object t = ((Struct)array.getValueImpl(n + i)).Clone();
                    array2.setValueImpl(t, n2 + i);
                }
            }
        }
        catch (java.lang.Exception exception) {
            Class clazz = array.getArrayInfo().b;
            Class clazz2 = array2.getArrayInfo().b;
            if (clazz.equals(Object.class)) {
                throw new InvalidCastException();
            }
            zat zat2 = com.aspose.email.internal.hu.zb.a(clazz);
            zat zat3 = com.aspose.email.internal.hu.zb.a(clazz2);
            throw new ArrayTypeMismatchException(zar.a("sourceArray and destinationArray are of incompatible types (Types: source={0};  target={1})", new Object[]{zat2.q(), zat3.q()}));
        }
    }

    public static void copy(Array sourceArray, long sourceIndex, Array destinationArray, long destinationIndex, long length) {
        if (sourceArray == null) {
            throw new ArgumentNullException("sourceArray");
        }
        if (destinationArray == null) {
            throw new ArgumentNullException("destinationArray");
        }
        if (sourceIndex < Integer.MIN_VALUE || sourceIndex > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("sourceIndex", "Must be in the Int32 range.");
        }
        if (destinationIndex < Integer.MIN_VALUE || destinationIndex > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("destinationIndex", "Must be in the Int32 range.");
        }
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        Array.copy(sourceArray, (int)sourceIndex, destinationArray, (int)destinationIndex, (int)length);
    }

    public static void copy(Array sourceArray, Array destinationArray, long length) {
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("length", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        Array.copy(sourceArray, destinationArray, (int)length);
    }

    private static boolean a(Array array, int n, Array array2, int n2, int n3) {
        if (com.aspose.email.internal.aj.za.c(array.getArrayInfo().b, array2.getArrayInfo().b)) {
            System.arraycopy(Array.unboxing(array), n, Array.unboxing(array2), n2, n3);
            return true;
        }
        return false;
    }

    @Override
    public void copyTo(Array array, int index) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index + this.getLength(0) > array.getLowerBound(0) + array.getLength(0)) {
            throw new ArgumentException(zar.a(new String[]{"Destination array was not long ", "enough. Check destIndex and length, and the array's ", "lower bounds."}));
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < 0) {
            throw new ArgumentOutOfRangeException("index", "Non-negative number required.");
        }
        Array.copy(this, this.getLowerBound(0), array, index, this.getLength(0));
    }

    public void copyTo(Array array, long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        this.copyTo(array, (int)index);
    }

    public static int indexOf(Array array, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, 0, array.getLength());
    }

    public static int indexOf(Array array, Object value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, startIndex, array.getLength() - startIndex);
    }

    public static int indexOf(Array array, Object value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (count < 0 || startIndex < array.getLowerBound(0) || startIndex - 1 > array.getUpperBound(0) - count) {
            throw new ArgumentOutOfRangeException(count < 0 ? "count" : "startIndex", count < 0 ? "Count must be positive and count must refer to a location within the string/array/collection." : "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        int n = startIndex + count;
        for (int i = startIndex; i < n; ++i) {
            if (!zaf.a(array.getValueImpl(i), value)) continue;
            return i;
        }
        return array.getLowerBound(0) - 1;
    }

    public static <T> int indexOf(T[] array, T value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, 0, Array.boxing(array).getLength());
    }

    public static <T> int indexOf(T[] array, T value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.indexOf(array, value, startIndex, Array.boxing(array).getLength() - startIndex);
    }

    public static <T> int indexOf(T[] array, T value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (count < 0 || startIndex < Array.boxing(array).getLowerBound(0) || startIndex - 1 > Array.boxing(array).getUpperBound(0) - count) {
            throw new ArgumentOutOfRangeException(count < 0 ? "count" : "startIndex", count < 0 ? "Count must be positive and count must refer to a location within the string/array/collection." : "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        int n = startIndex + count;
        zb.za<T> za2 = new zb.za<T>();
        for (int i = startIndex; i < n; ++i) {
            if (!((com.aspose.email.internal.d.zb)za2).equalsT(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(Array array, Object value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getLength() == 0) {
            return array.getLowerBound(0) - 1;
        }
        return Array.lastIndexOf(array, value, array.getLength() - 1);
    }

    public static int lastIndexOf(Array array, Object value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.lastIndexOf(array, value, startIndex, startIndex - array.getLowerBound(0) + 1);
    }

    public static int lastIndexOf(Array array, Object value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n = array.getLowerBound(0);
        if (array.getLength() == 0) {
            return n - 1;
        }
        if (startIndex < n || startIndex > array.getUpperBound(0)) {
            throw new ArgumentOutOfRangeException("startIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (count < 0 || startIndex - count + 1 < n) {
            throw new ArgumentOutOfRangeException("count", "Count must be positive and count must refer to a location within the string/array/collection.");
        }
        for (int i = startIndex; i >= startIndex - count + 1; --i) {
            if (!zaf.a(array.getValueImpl(i), value)) continue;
            return i;
        }
        return n - 1;
    }

    public static <T> int lastIndexOf(T[] array, T value) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (Array.boxing(array).getLength() == 0) {
            return -1;
        }
        return Array.lastIndexOf(array, value, Array.boxing(array).getLength() - 1);
    }

    public static <T> int lastIndexOf(T[] array, T value, int startIndex) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        return Array.lastIndexOf(array, value, startIndex, startIndex + 1);
    }

    public static <T> int lastIndexOf(T[] array, T value, int startIndex, int count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (startIndex < Array.boxing(array).getLowerBound(0) || startIndex > Array.boxing(array).getUpperBound(0)) {
            throw new ArgumentOutOfRangeException("startIndex", "Index was out of range. Must be non-negative and less than the size of the collection.");
        }
        if (count < 0 || startIndex - count + 1 < Array.boxing(array).getLowerBound(0)) {
            throw new ArgumentOutOfRangeException("count", "Count must be positive and count must refer to a location within the string/array/collection.");
        }
        zb.za<T> za2 = new zb.za<T>();
        for (int i = startIndex; i >= startIndex - count + 1; --i) {
            if (!((com.aspose.email.internal.d.zb)za2).equalsT(array[i], value)) continue;
            return i;
        }
        return -1;
    }

    static zi a(Array array) {
        Object object = Array.unboxing(array);
        if (object instanceof Object[]) {
            return new com.aspose.email.system.zb(array);
        }
        return new com.aspose.email.system.zc(array);
    }

    private void a(int n, int n2) {
        Object object = Array.unboxing(this);
        Object[] objectArray = object instanceof Object[] ? (Object[])object : null;
        Object object2 = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object2;
    }

    private void b(int n, int n2) {
        Object object = this.getValueImpl(n);
        this.setValueImpl(this.getValue(n2), n);
        this.setValueImpl(object, n2);
    }

    public static void reverse(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.reverse(array, array.getLowerBound(0), array.getLength(0));
    }

    public static void reverse(Array array, int index, int length) {
        int n;
        Object[] objectArray;
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (array.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        if (index < array.getLowerBound(0) || length < 0) {
            throw new ArgumentOutOfRangeException(index < 0 ? "index" : "length", "Non-negative number required.");
        }
        if (index > array.getUpperBound(0) + 1 - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        Object object = Array.unboxing(array);
        Object[] objectArray2 = objectArray = object instanceof Object[] ? (Object[])object : null;
        if (objectArray != null) {
            for (n = index + length - 1; index < n; ++index, --n) {
                Object object2 = objectArray[index];
                objectArray[index] = objectArray[n];
                objectArray[n] = object2;
            }
            return;
        }
        zi zi2 = Array.a(array);
        while (index < n) {
            zi2.a(index, n);
            ++index;
            --n;
        }
    }

    private void a() {
        block6: {
            Class clazz = this.getArrayInfo().b;
            if (clazz.isPrimitive()) {
                return;
            }
            za za2 = this.createEnumerator(0, this.getLength());
            Object object = com.aspose.email.internal.hu.zb.b(clazz);
            if (object == null) break block6;
            if (com.aspose.email.internal.aj.za.b(clazz) != null) {
                while (za2.hasNext()) {
                    za2.a(object);
                }
            } else {
                if (za2.hasNext()) {
                    za2.a(object);
                }
                while (za2.hasNext()) {
                    za2.a(com.aspose.email.internal.hu.zb.b(clazz));
                }
            }
        }
    }

    public void initialize() {
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Object get_Item(int index) {
        if (index >= this.getLength() || index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (this.getRank() > 1) {
            throw new ArgumentException("Only single dimension arrays are supported.");
        }
        return this.getValueImpl(index);
    }

    @Override
    public void set_Item(int index, Object value) {
        if (index >= this.getLength() || index < 0) {
            throw new ArgumentOutOfRangeException("index");
        }
        if (this.getRank() > 1) {
            throw new ArgumentException("Only single dimension arrays are supported.");
        }
        this.setValueImpl(value, index);
    }

    @Override
    public int addItem(Object value) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void removeItem(Object value) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void insertItem(int index, Object value) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void removeAt(int index) {
        throw new NotSupportedException("Collection was of a fixed size.");
    }

    @Override
    public void clear() {
        Array.clear(this, this.getLowerBound(0), this.getLength());
    }

    @Override
    public boolean contains(Object value) {
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (!zaf.a(this.getValueImpl(i), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object value) {
        if (this.getRank() > 1) {
            throw new RankException("Only single dimension arrays are supported.");
        }
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (!zaf.a(this.getValueImpl(i), value)) continue;
            return i + this.getLowerBound(0);
        }
        return this.getLowerBound(0) - 1;
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public boolean isSynchronized() {
        return false;
    }

    @Override
    public Object getSyncRoot() {
        return this.getInternalObject();
    }

    @Override
    public IEnumerator iterator() {
        return this.createEnumerator(0, this.getLength());
    }

    public static <TInput, TOutput> TOutput[] convertAll(Class<TOutput> classOfTOutput, TInput[] array, Converter<TInput, TOutput> converter) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        Object[] objectArray = com.aspose.email.internal.hu.zb.a(classOfTOutput, new int[]{array.length});
        for (int i = 0; i < array.length; ++i) {
            objectArray[i] = converter.invoke(array[i]);
        }
        return objectArray;
    }

    public static <TInput, TOutput> TOutput[] convertAll(Class<TOutput> classOfTOutput, Array array, Converter<TInput, TOutput> converter) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (converter == null) {
            throw new ArgumentNullException("converter");
        }
        Object[] objectArray = com.aspose.email.internal.hu.zb.a(classOfTOutput, new int[]{array.size()});
        for (int i = 0; i < array.size(); ++i) {
            objectArray[i] = converter.invoke(array.get_Item(i));
        }
        return objectArray;
    }

    public static <T> boolean exists(T[] array, Predicate<T> match) {
        if (match == null) {
            throw new ArgumentNullException("array");
        }
        return Array.findIndex(array, match) != -1;
    }

    public static <T> boolean exists(Array array, Predicate<T> match) {
        if (match == null) {
            throw new ArgumentNullException("array");
        }
        return Array.findIndex(array, match) != -1;
    }

    public static <T> T[] findAll(Class<T> classOfT, T[] array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        List<T> list = new List<T>();
        for (int i = 0; i < array.length; ++i) {
            if (!match.invoke(array[i])) continue;
            list.addItem(array[i]);
        }
        Object[] objectArray = com.aspose.email.internal.hu.zb.a(classOfT, new int[]{list.size()});
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get_Item(i);
        }
        return objectArray;
    }

    public static <T> T[] findAll(Class<T> classOfT, Array array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        List<Object> list = new List<Object>();
        for (int i = 0; i < array.size(); ++i) {
            Object object = array.get_Item(i);
            if (!match.invoke(object)) continue;
            list.addItem(object);
        }
        Object[] objectArray = com.aspose.email.internal.hu.zb.a(classOfT, new int[]{list.size()});
        for (int i = 0; i < list.size(); ++i) {
            objectArray[i] = list.get_Item(i);
        }
        return objectArray;
    }

    public static <T> T find(Class<T> typeOfT, T[] array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        for (int i = 0; i < array.length; ++i) {
            if (!match.invoke(array[i])) continue;
            return array[i];
        }
        return (T)com.aspose.email.internal.hu.zb.b(typeOfT);
    }

    public static <T> T find(Class<T> typeOfT, Array array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        for (int i = 0; i < array.size(); ++i) {
            Object object = array.get_Item(i);
            if (!match.invoke(object)) continue;
            return (T)object;
        }
        return (T)com.aspose.email.internal.hu.zb.b(typeOfT);
    }

    public static <T> int findIndex(T[] array, Predicate<T> match) {
        return Array.findIndex(array, 0, array.length, match);
    }

    public static <T> int findIndex(T[] array, int startIndex, Predicate<T> match) {
        return Array.findIndex(array, startIndex, array.length - startIndex, match);
    }

    public static <T> int findIndex(T[] array, int startIndex, int count, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (startIndex < 0 || startIndex > array.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || startIndex > array.length - count) {
            throw new ArgumentOutOfRangeException("count", "index and count exceed length of list");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        int n = startIndex + count;
        for (int i = startIndex; i < n; ++i) {
            if (!match.invoke(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int findIndex(Array array, Predicate<T> match) {
        return Array.findIndex(array, 0, array.size(), match);
    }

    public static <T> int findIndex(Array array, int startIndex, Predicate<T> match) {
        return Array.findIndex(array, startIndex, array.size() - startIndex, match);
    }

    public static <T> int findIndex(Array array, int startIndex, int count, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (startIndex < 0 || startIndex > array.size()) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || startIndex > array.size() - count) {
            throw new ArgumentOutOfRangeException("count", "index and count exceed length of list");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        int n = startIndex + count;
        for (int i = startIndex; i < n; ++i) {
            if (!match.invoke(array.get_Item(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> T findLast(Class<T> typeOfT, T[] array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (!match.invoke(array[i])) continue;
            return array[i];
        }
        return (T)com.aspose.email.internal.hu.zb.b(typeOfT);
    }

    public static <T> T findLast(Class<T> typeOfT, Array array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        for (int i = array.size() - 1; i >= 0; --i) {
            Object object = array.get_Item(i);
            if (!match.invoke(object)) continue;
            return (T)object;
        }
        return (T)com.aspose.email.internal.hu.zb.b(typeOfT);
    }

    public static <T> int findLastIndex(T[] array, Predicate<T> match) {
        return Array.findLastIndex(array, array.length - 1, match);
    }

    public static <T> int findLastIndex(T[] array, int startIndex, Predicate<T> match) {
        return Array.findLastIndex(array, startIndex, startIndex + 1, match);
    }

    public static <T> int findLastIndex(T[] array, int startIndex, int count, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        if (array.length == 0 ? startIndex != -1 : startIndex < 0 || startIndex >= array.length) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || startIndex - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("count", "index and count exceed length of list");
        }
        int n = startIndex - count;
        for (int i = startIndex; i > n; --i) {
            if (!match.invoke(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int findLastIndex(Array array, Predicate<T> match) {
        return Array.findLastIndex(array, array.size() - 1, match);
    }

    public static <T> int findLastIndex(Array array, int startIndex, Predicate<T> match) {
        return Array.findLastIndex(array, startIndex, startIndex + 1, match);
    }

    public static <T> int findLastIndex(Array array, int startIndex, int count, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        if (array.size() == 0 ? startIndex != -1 : startIndex < 0 || startIndex >= array.size()) {
            throw new ArgumentOutOfRangeException("startIndex");
        }
        if (count < 0 || startIndex - count + 1 < 0) {
            throw new ArgumentOutOfRangeException("count", "index and count exceed length of list");
        }
        int n = startIndex - count;
        for (int i = startIndex; i > n; --i) {
            if (!match.invoke(array.get_Item(i))) continue;
            return i;
        }
        return -1;
    }

    public static <T> void forEach(T[] array, Action<T> action) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < array.length; ++i) {
            action.invoke(array[i]);
        }
    }

    public static <T> void forEach(Array array, Action<T> action) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (action == null) {
            throw new ArgumentNullException("action");
        }
        for (int i = 0; i < array.size(); ++i) {
            action.invoke(array.get_Item(i));
        }
    }

    public static <T> boolean trueForAll(T[] array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        for (int i = 0; i < array.length; ++i) {
            if (match.invoke(array[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean trueForAll(Array array, Predicate<T> match) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (match == null) {
            throw new ArgumentNullException("match");
        }
        for (int i = 0; i < array.size(); ++i) {
            if (match.invoke(array.get_Item(i))) continue;
            return false;
        }
        return true;
    }

    private static void b(com.aspose.email.internal.ak.zc zc2, Object object, int n, Object object2) {
        try {
            zc2.a(object, n, object2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArgumentOutOfRangeException("index is outside the range of valid indexes for the current Array", arrayIndexOutOfBoundsException);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new InvalidCastException(arrayStoreException.getMessage());
        }
    }

    private static Object b(com.aspose.email.internal.ak.zc zc2, Object object, int n) {
        try {
            return zc2.a(object, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array", arrayIndexOutOfBoundsException);
        }
    }

    protected Object getValueImpl(int pos) {
        return Array.b(this.getArrayHelper(), this.getInternalObject(), pos);
    }

    protected void setValueImpl(Object value, int pos) {
        throw new InvalidOperationException("Array was not a one-dimensional array.");
    }

    protected Object getValueImpl(int ... indices) {
        Object object = this.getInternalObject();
        int n = indices.length - 1;
        for (int i = 0; i < n; ++i) {
            object = Array.b(com.aspose.email.internal.ak.zc.a(), object, indices[i]);
        }
        return Array.b(this.getArrayHelper(), object, indices[n]);
    }

    protected void setValueImpl(Object value, int ... indices) {
        Class clazz = this.getArrayInfo().b;
        if (value == null && clazz.isPrimitive()) {
            value = com.aspose.email.internal.hu.zb.b(clazz);
        }
        if (value != null && !com.aspose.email.internal.aj.za.a(value.getClass(), clazz) && (clazz.isPrimitive() || com.aspose.email.internal.aj.za.b(clazz) != null)) {
            throw new ArgumentException("Cannot widen from source type to target type either because the source type is a not a primitive type or the conversion cannot be accomplished");
        }
        Object object = this.getInternalObject();
        int n = indices.length - 1;
        for (int i = 0; i < n; ++i) {
            object = Array.b(com.aspose.email.internal.ak.zc.a(), object, indices[i]);
        }
        try {
            Array.b(this.getArrayHelper(), object, indices[n], value);
        }
        catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
            throw argumentOutOfRangeException;
        }
        catch (java.lang.Exception exception) {
            throw new InvalidCastException("Cannot save value in this array");
        }
    }

    public Object getValue(int ... indices) {
        if (indices == null) {
            throw new ArgumentNullException("indices");
        }
        if (this.getRank() != indices.length) {
            throw new ArgumentException("The number of dimensions in the current Array is not equal to the number of elements in indices");
        }
        return this.getValueImpl(indices);
    }

    public void setValue(Object value, int ... indices) {
        if (indices == null) {
            throw new ArgumentNullException("indices");
        }
        if (this.getRank() != indices.length) {
            throw new ArgumentException("The number of dimensions in the current Array is not equal to the number of elements in indices");
        }
        this.setValueImpl(value, indices);
    }

    public int getRank() {
        return this.getArrayInfo().a;
    }

    public int getLowerBound(int dimension) {
        if (dimension < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (dimension >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return 0;
    }

    public static <T> Array createInstanceInternal(Class<T> cls, int length, ElementInitializer<T> elementInitializer) {
        Object object = java.lang.reflect.Array.newInstance(cls, length);
        Array array = Array.boxing(object);
        za za2 = array.createEnumerator(0, length);
        while (za2.hasNext()) {
            if (za2.next() != null) continue;
            za2.a(elementInitializer.createInstance());
        }
        return array;
    }

    public static Array createInstance(zat elementType, int length) {
        int[] nArray = new int[]{length};
        return Array.createInstance(elementType, nArray);
    }

    public static Array createInstance(zat elementType, int length1, int length2) {
        int[] nArray = new int[]{length1, length2};
        return Array.createInstance(elementType, nArray);
    }

    public static Array createInstance(zat elementType, int length1, int length2, int length3) {
        int[] nArray = new int[]{length1, length2, length3};
        return Array.createInstance(elementType, nArray);
    }

    public static Array createInstance(zat elementType, int ... lengths) {
        if (elementType == null) {
            throw new ArgumentNullException("elementType");
        }
        if (lengths == null) {
            throw new ArgumentNullException("lengths");
        }
        if (lengths.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        int[] nArray = null;
        if (elementType.c(com.aspose.email.internal.hu.zb.a(Void.TYPE))) {
            throw new NotSupportedException("Array type can not be void");
        }
        return Array.a(elementType, lengths, nArray);
    }

    public static Array createInstance(zat elementType, int[] lengths, int[] lowerBounds) {
        if (elementType == null) {
            throw new ArgumentNullException("elementType");
        }
        if (lengths == null) {
            throw new ArgumentNullException("lengths");
        }
        if (lowerBounds == null) {
            throw new ArgumentNullException("lowerBounds");
        }
        if (elementType.c(com.aspose.email.internal.hu.zb.a(Void.TYPE))) {
            throw new NotSupportedException("Array type can not be void");
        }
        if (lengths.length < 1) {
            throw new ArgumentException("Must provide at least one rank.");
        }
        if (lengths.length != lowerBounds.length) {
            throw new ArgumentException("Number of lengths and lowerBounds must match.");
        }
        for (int i = 0; i < lowerBounds.length; ++i) {
            if (lengths[i] < 0) {
                throw new ArgumentOutOfRangeException("lengths[" + i + "]", "Non-negative number required.");
            }
            if ((long)lowerBounds[i] + (long)lengths[i] <= Integer.MAX_VALUE) continue;
            throw new ArgumentOutOfRangeException("lengths", "Length + bound must not exceed Int32.MaxValue.");
        }
        if (lengths.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        return Array.a(elementType, lengths, lowerBounds);
    }

    private static Array a(zat zat2, int[] nArray, int[] nArray2) {
        int n;
        if (nArray2 != null) {
            throw new NotImplementedException("Not implemented yet");
        }
        if (nArray == null) {
            throw new ArgumentNullException("lengths");
        }
        if (nArray.length < 1) {
            throw new ArgumentException("Arrays must contain >= 1 elements.");
        }
        if (nArray.length > 32) {
            throw new TypeLoadException("Array has too many dimensions.");
        }
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 0) continue;
            throw new ArgumentOutOfRangeException("lengths[" + n + ']', "Non-negative number required.");
        }
        n = 0;
        Class clazz = zat2.o();
        for (Class<?> clazz2 = clazz.getComponentType(); clazz2 != null; clazz2 = clazz2.getComponentType()) {
            ++n;
        }
        Object object = null;
        object = nArray.length > 1 ? java.lang.reflect.Array.newInstance(clazz, nArray) : java.lang.reflect.Array.newInstance(clazz, nArray[0]);
        Array array = Array.boxing(object, nArray.length, n > 0);
        array.a();
        return array;
    }

    public static <T> void resize(T[][] refToArray, int newSize) {
        if (newSize < 0) {
            throw new ArgumentOutOfRangeException("Non-negative number required.");
        }
        if (refToArray[0] == null) {
            Array array = Array.createInstance(com.aspose.email.internal.hu.zb.a(refToArray.getClass().getComponentType().getComponentType()), newSize);
            refToArray[0] = (Object[])Array.unboxing(array);
            return;
        }
        int n = refToArray[0].length;
        if (n == newSize) {
            return;
        }
        int n2 = 0;
        Class<?> clazz = refToArray[0].getClass();
        for (Class<?> clazz2 = clazz.getComponentType(); clazz2 != null; clazz2 = clazz2.getComponentType()) {
            ++n2;
        }
        Array array = Array.createInstance(com.aspose.email.internal.hu.zb.a(clazz.getComponentType()), newSize);
        if (n != 0) {
            Array.a(Array.boxing(refToArray[0], 1, n2 > 0), 0, array, 0, zbd.b(newSize, n));
        }
        refToArray[0] = (Object[])Array.unboxing(array);
    }

    public int getLength() {
        return (int)this.getArrayInfo().e;
    }

    public long getLongLength() {
        return this.getArrayInfo().e;
    }

    public Object getValue(int index) {
        if (this.getRank() != 1) {
            throw new ArgumentException("Array was not a one-dimensional array.");
        }
        if (index < this.getLowerBound(0) || index > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array");
        }
        return this.getValueImpl(index);
    }

    public Object getValue(int index1, int index2) {
        if (this.getRank() != 2) {
            throw new ArgumentException("The current Array does not have exactly two dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2};
        return this.getValueImpl(nArray);
    }

    public Object getValue(int index1, int index2, int index3) {
        if (this.getRank() != 3) {
            throw new ArgumentException("The current Array does not have exactly three dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index3 < this.getLowerBound(2) || index3 > this.getUpperBound(2)) {
            throw new IndexOutOfRangeException("Index3 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2, index3};
        return this.getValueImpl(nArray);
    }

    public Object getValue(long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)index);
    }

    public Object getValue(long index1, long index2) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)index1, (int)index2);
    }

    public Object getValue(long index1, long index2, long index3) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index3 < 0L || index3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index3", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        return this.getValue((int)index1, (int)index2, (int)index3);
    }

    public void setValue(Object value, int index) {
        if (this.getRank() != 1) {
            throw new ArgumentException("Array was not a one-dimensional array.");
        }
        if (index < this.getLowerBound(0) || index > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("index is outside the range of valid indexes for the current Array");
        }
        this.setValueImpl(value, index - this.getLowerBound(0));
    }

    public void setValue(Object value, int index1, int index2) {
        if (this.getRank() != 2) {
            throw new ArgumentException("The current Array does not have exactly two dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2};
        this.setValueImpl(value, nArray);
    }

    public void setValue(Object value, int index1, int index2, int index3) {
        if (this.getRank() != 3) {
            throw new ArgumentException("The current Array does not have exactly three dimensions.");
        }
        if (index1 < this.getLowerBound(0) || index1 > this.getUpperBound(0)) {
            throw new IndexOutOfRangeException("Index1 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index2 < this.getLowerBound(1) || index2 > this.getUpperBound(1)) {
            throw new IndexOutOfRangeException("Index2 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        if (index3 < this.getLowerBound(2) || index3 > this.getUpperBound(2)) {
            throw new IndexOutOfRangeException("Index3 is outside the range of valid indexes for the corresponding dimension of the current Array");
        }
        int[] nArray = new int[]{index1, index2, index3};
        this.setValueImpl(value, nArray);
    }

    public void setValue(Object value, long index) {
        if (index < 0L || index > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        this.setValue(value, (int)index);
    }

    public void setValue(Object value, long index1, long index2) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        int[] nArray = new int[]{(int)index1, (int)index2};
        this.setValue(value, nArray);
    }

    public void setValue(Object value, long index1, long index2, long index3) {
        if (index1 < 0L || index1 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index1", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index2 < 0L || index2 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index2", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        if (index3 < 0L || index3 > Integer.MAX_VALUE) {
            throw new ArgumentOutOfRangeException("index3", "Value must be >= 0 and <= Int32.MaxValue.");
        }
        int[] nArray = new int[]{(int)index1, (int)index2, (int)index3};
        this.setValue(value, nArray);
    }

    public int getUpperBound(int dimension) {
        if (dimension < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (dimension >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return this.getArrayInfo().c[dimension];
    }

    public int getLength(int dimension) {
        if (dimension < 0) {
            throw new IndexOutOfRangeException("dimension is less than zero");
        }
        if (dimension >= this.getRank()) {
            throw new IndexOutOfRangeException("dimension is equal to or greater than Rank");
        }
        return this.getArrayInfo().c[dimension] + 1;
    }

    public static void sort(Array array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, null, array.getLowerBound(0), array.getLength(), null);
    }

    public static <T> void sort(T[] array) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, Array.boxing(array).getLowerBound(0), array.length, null);
    }

    public static <T> void sort(T[] array, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, 0, array.length, comparer);
    }

    public static <T> void sort(T[] array, Comparison<T> comparison) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (comparison == null) {
            throw new ArgumentNullException("comparison");
        }
        FunctorComparer<T> functorComparer = new FunctorComparer<T>(comparison);
        Array.sort(array, functorComparer);
    }

    public static void sort(Array keys, Array items) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, keys.getLowerBound(0), keys.getLength(), null);
    }

    public static void sort(Array array, Comparator comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        Array.sort(array, null, array.getLowerBound(0), array.getLength(), comparer);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, 0, keys.length, null);
    }

    public static <T> void sort(T[] array, int index, int length) {
        Array.sort(array, index, length, null);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items, Comparator<TKey> comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, 0, keys.length, comparer);
    }

    public static void sort(Array keys, Array items, Comparator comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        Array.sort(keys, items, keys.getLowerBound(0), keys.getLength(), comparer);
    }

    public static void sort(Array array, int index, int length) {
        Array.sort(array, null, index, length, null);
    }

    public static void sort(Array array, int index, int length, Comparator comparer) {
        Array.sort(array, null, index, length, comparer);
    }

    public static <T> void sort(T[] array, int index, int length, Comparator<T> comparer) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(length < 0 ? "length" : "index", "Non-negative number required");
        }
        if (array.length - index < length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (length > 1) {
            if (comparer != null && comparer != com.aspose.email.internal.d.za.a()) {
                Array.sort(array, null, index, length, comparer);
            } else {
                Array.sort(array, null, index, length, com.aspose.email.internal.d.za.a());
            }
        }
    }

    public static void sort(Array keys, Array items, int index, int length) {
        Array.sort(keys, items, index, length, null);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items, int index, int length) {
        Array.sort(keys, items, index, length, null);
    }

    public static <TKey, TValue> void sort(TKey[] keys, TValue[] items, int index, int length, Comparator<TKey> comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        if (index < 0 || length < 0) {
            throw new ArgumentOutOfRangeException(length < 0 ? "length" : "index", "Non-negative number required");
        }
        if (keys.length - index < length || items != null && index > items.length - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (comparer == null) {
            comparer = com.aspose.email.internal.d.za.a();
        }
        if (length > 1) {
            if (comparer != null && comparer != com.aspose.email.internal.d.za.a()) {
                Array.a(keys, items, index, index + length - 1, comparer);
            } else {
                Array.a(keys, items, index, index + length - 1, com.aspose.email.internal.d.za.a());
            }
        }
    }

    private static <TKey, TValue> void a(TKey[] TKeyArray, TValue[] TValueArray, int n, int n2, Comparator<TKey> comparator) {
        int n3 = n;
        int n4 = n2;
        int n5 = (n3 + n4) / 2;
        TKey TKey = TKeyArray[n5];
        while (true) {
            if (comparator.compare(TKeyArray[n3], TKey) < 0) {
                ++n3;
                continue;
            }
            while (comparator.compare(TKeyArray[n4], TKey) > 0) {
                --n4;
            }
            if (n3 <= n4) {
                TKey TKey2 = TKeyArray[n3];
                TKeyArray[n3] = TKeyArray[n4];
                TKeyArray[n4] = TKey2;
                if (TValueArray != null) {
                    TValue TValue = TValueArray[n3];
                    TValueArray[n3] = TValueArray[n4];
                    TValueArray[n4] = TValue;
                }
                ++n3;
                --n4;
            }
            if (n3 >= n4) break;
        }
        if (n < n4) {
            Array.a(TKeyArray, TValueArray, n, n4, comparator);
        }
        if (n3 < n2) {
            Array.a(TKeyArray, TValueArray, n3, n2, comparator);
        }
    }

    public static void sort(Array keys, Array items, int index, int length, Comparator comparer) {
        if (keys == null) {
            throw new ArgumentNullException("keys");
        }
        if (keys.getRank() != 1 || items != null && items.getRank() != 1) {
            throw new RankException("Only single dimension arrays are supported");
        }
        if (items != null && keys.getLowerBound(0) != items.getLowerBound(0)) {
            throw new ArgumentException("Lower bounds must match");
        }
        if (index < keys.getLowerBound(0) || length < 0) {
            throw new ArgumentOutOfRangeException(length < 0 ? "length" : "index", "Non-negative number required");
        }
        if (keys.getLength() - (index - keys.getLowerBound(0)) < length || items != null && index - items.getLowerBound(0) > items.getLength() - length) {
            throw new ArgumentException("Offset and length were out of bounds for the array or count is greater than the number of elements from index to the end of the source collection.");
        }
        if (length > 1) {
            Object object = Array.unboxing(keys);
            Object object2 = items != null ? Array.unboxing(items) : null;
            Object[] objectArray = object instanceof Object[] ? (Object[])object : null;
            Object[] objectArray2 = null;
            if (objectArray != null) {
                Object[] objectArray3 = objectArray2 = object2 instanceof Object[] ? (Object[])object2 : null;
            }
            if (comparer == null) {
                comparer = com.aspose.email.internal.d.za.a();
            }
            if (objectArray != null && (items == null || objectArray2 != null)) {
                Array.b(objectArray, objectArray2, comparer, index, index + length - 1);
            } else {
                Array.b(keys, items, comparer, index, index + length - 1);
            }
        }
    }

    private static int c(int n, int n2) {
        return n + (n2 - n >> 1);
    }

    private static void a(Object[] objectArray, Object[] objectArray2, Comparator comparator, int n, int n2) {
        if (n != n2) {
            try {
                if (comparator.compare(objectArray[n], objectArray[n2]) > 0) {
                    Object object = objectArray[n];
                    objectArray[n] = objectArray[n2];
                    objectArray[n2] = object;
                    if (objectArray2 != null) {
                        Object object2 = objectArray2[n];
                        objectArray2[n] = objectArray2[n2];
                        objectArray2[n2] = object2;
                    }
                }
            }
            catch (IndexOutOfRangeException indexOutOfRangeException) {
                throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
            }
            catch (Exception exception) {
                throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
            }
        }
    }

    private static void a(Array array, Array array2, Comparator comparator, int n, int n2) {
        if (n != n2) {
            try {
                if (comparator.compare(array.getValue(n), array.getValue(n2)) > 0) {
                    Object object = array.getValue(n);
                    array.setValue(array.getValue(n2), n);
                    array.setValue(object, n2);
                    if (array2 != null) {
                        Object object2 = array2.getValue(n);
                        array2.setValue(array2.getValue(n2), n);
                        array2.setValue(object2, n2);
                    }
                }
            }
            catch (IndexOutOfRangeException indexOutOfRangeException) {
                throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
            }
            catch (Exception exception) {
                throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
            }
        }
    }

    private static void b(Object[] objectArray, Object[] objectArray2, Comparator comparator, int n, int n2) {
        do {
            int n3 = n;
            int n4 = n2;
            int n5 = Array.c(n3, n4);
            Array.a(objectArray, objectArray2, comparator, n3, n5);
            Array.a(objectArray, objectArray2, comparator, n3, n4);
            Array.a(objectArray, objectArray2, comparator, n5, n4);
            Object object = objectArray[n5];
            do {
                try {
                    while (comparator.compare(objectArray[n3], object) < 0) {
                        ++n3;
                    }
                    while (comparator.compare(object, objectArray[n4]) < 0) {
                        --n4;
                    }
                }
                catch (IndexOutOfRangeException indexOutOfRangeException) {
                    throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
                }
                if (n3 > n4) break;
                if (n3 >= n4) continue;
                Object object2 = objectArray[n3];
                objectArray[n3] = objectArray[n4];
                objectArray[n4] = object2;
                if (objectArray2 == null) continue;
                Object object3 = objectArray2[n3];
                objectArray2[n3] = objectArray2[n4];
                objectArray2[n4] = object3;
            } while (++n3 <= --n4);
            if (n4 - n <= n2 - n3) {
                if (n < n4) {
                    Array.b(objectArray, objectArray2, comparator, n, n4);
                }
                n = n3;
                continue;
            }
            if (n3 < n2) {
                Array.b(objectArray, objectArray2, comparator, n3, n2);
            }
            n2 = n4;
        } while (n < n2);
    }

    private static <T> void b(Array array, Array array2, Comparator comparator, int n, int n2) {
        do {
            int n3 = n;
            int n4 = n2;
            int n5 = Array.c(n3, n4);
            Array.a(array, array2, comparator, n3, n5);
            Array.a(array, array2, comparator, n3, n4);
            Array.a(array, array2, comparator, n5, n4);
            Object object = array.getValue(n5);
            do {
                try {
                    while (comparator.compare(array.getValue(n3), object) < 0) {
                        ++n3;
                    }
                    while (comparator.compare(object, array.getValue(n4)) < 0) {
                        --n4;
                    }
                }
                catch (IndexOutOfRangeException indexOutOfRangeException) {
                    throw new ArgumentOutOfRangeException("index is outside the range of valid indexes during the sorting operation", indexOutOfRangeException);
                }
                catch (Exception exception) {
                    throw new InvalidOperationException("Unexpected exception during the sorting operation", exception);
                }
                if (n3 > n4) break;
                if (n3 < n4) {
                    Object object2 = array.getValue(n3);
                    array.setValue(array.getValue(n4), n3);
                    array.setValue(object2, n4);
                    if (array2 != null) {
                        Object object3 = array2.getValue(n3);
                        array2.setValue(array2.getValue(n4), n3);
                        array2.setValue(object3, n4);
                    }
                }
                if (n3 != Integer.MAX_VALUE) {
                    ++n3;
                }
                if (n4 == Integer.MIN_VALUE) continue;
                --n4;
            } while (n3 <= n4);
            if (n4 - n <= n2 - n3) {
                if (n < n4) {
                    Array.b(array, array2, comparator, n, n4);
                }
                n = n3;
                continue;
            }
            if (n3 < n2) {
                Array.b(array, array2, comparator, n3, n2);
            }
            n2 = n4;
        } while (n < n2);
    }

    public int hashCode() {
        return this.getInternalObject().hashCode();
    }

    protected final boolean equals(Array other) {
        return zaf.a(this.getInternalObject(), other.getInternalObject());
    }

    public boolean equals(Object obj) {
        if (zaf.b(null, obj)) {
            return false;
        }
        if (zaf.b(this, obj)) {
            return true;
        }
        if (zaf.a(obj) != zaf.a(this)) {
            return false;
        }
        if (obj instanceof Array) {
            return this.equals((Array)obj);
        }
        return this.equals(Array.boxing(obj));
    }

    /* synthetic */ Array(com.aspose.email.system.zb x0) {
        this();
    }

    static /* synthetic */ void a(Array array, int n, int n2) {
        array.a(n, n2);
    }

    static /* synthetic */ void b(Array array, int n, int n2) {
        array.b(n, n2);
    }

    public static class FunctorComparer<T>
    implements Comparator<T> {
        private final Comparison<T> a;

        public FunctorComparer(Comparison<T> comparison) {
            this.a = comparison;
        }

        @Override
        public int compare(T x, T y) {
            return this.a.invoke(x, y);
        }
    }

    public static abstract class ElementInitializer<T> {
        public abstract T createInstance();
    }

    private static class zf
    implements zv,
    za,
    IEnumerator,
    Cloneable {
        private final Array a;
        private int b;
        private int c;
        private int d;
        private boolean e;
        private int[] f;

        private zf(zf zf2) {
            this.a = zf2.a;
            this.b = zf2.b;
            this.c = zf2.c;
            this.d = zf2.d;
            this.e = zf2.e;
            this.f = (int[])zf2.f.clone();
        }

        zf(Array array, int n, int n2) {
            this.a = array;
            this.d = n;
            this.b = n + n2 - 1;
            this.f = new int[array.getRank()];
            this.reset();
        }

        private void b() {
            if (this.c < this.d) {
                throw new InvalidOperationException("Enumeration has not started");
            }
            if (this.e) {
                throw new InvalidOperationException("Enumeration has already ended");
            }
        }

        @Override
        public Object next() {
            this.b();
            return this.a.getValueImpl(this.f);
        }

        @Override
        public void a(Object object) {
            this.b();
            this.a.setValueImpl(object, this.f);
        }

        private void c() {
            ++this.c;
            if (this.c > this.b) {
                this.e = true;
                return;
            }
            int n = this.a.getRank();
            int n2 = n - 1;
            this.f[n2] = this.f[n2] + 1;
            for (int i = n - 1; i >= 0; --i) {
                if (this.f[i] <= this.a.getUpperBound(i)) continue;
                if (i == 0) {
                    this.e = true;
                    this.f[0] = this.a.getLowerBound(0);
                    return;
                }
                for (int j = i; j < n; ++j) {
                    this.f[j] = this.a.getLowerBound(j);
                }
                int n3 = i - 1;
                this.f[n3] = this.f[n3] + 1;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.e) {
                return false;
            }
            this.c();
            return !this.e;
        }

        @Override
        public void reset() {
            int n;
            this.c = this.d - 1;
            int[] nArray = new int[]{this.d};
            int n2 = 1;
            for (n = 0; n < this.a.getRank(); ++n) {
                int n3 = this.a.getLength(n);
                this.f[n] = zbd.a(nArray[0], n3, nArray);
                n2 *= n3;
            }
            n = this.a.getLength(this.f.length - 1);
            this.f[this.f.length - 1] = nArray[0] - 1;
            this.e = (n2 *= n) == 0 || this.d > this.b;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return new zf(this);
        }

        @Override
        public void remove() {
            throw new NotSupportedException("Collection was of a fixed size.");
        }
    }

    private static class zh
    implements za {
        private final Array a;
        private int b;
        private int c;
        private int d;
        private boolean e;

        private zh(zh zh2) {
            this.a = zh2.a;
            this.b = zh2.b;
            this.c = zh2.c;
            this.d = zh2.d;
            this.e = zh2.e;
        }

        public zh(Array array, int n, int n2) {
            this.a = array;
            this.b = n;
            this.d = n + n2 - 1;
            this.reset();
        }

        private void b() {
            if (this.c < this.b) {
                throw new InvalidOperationException("Enumeration has not started.");
            }
            if (this.e) {
                throw new InvalidOperationException("Enumeration has already ended");
            }
        }

        @Override
        public Object next() {
            this.b();
            return this.a.getValueImpl(this.c);
        }

        @Override
        public void a(Object object) {
            this.b();
            this.a.setValueImpl(object, this.c);
        }

        private void c() {
            ++this.c;
            this.e = this.c > this.d;
        }

        @Override
        public boolean hasNext() {
            if (this.e) {
                return false;
            }
            this.c();
            return !this.e;
        }

        @Override
        public void reset() {
            this.c = this.b - 1;
            this.e = this.b > this.d;
        }

        @Override
        public Object deepClone() {
            return this.a();
        }

        protected Object a() {
            try {
                return this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new IllegalStateException(cloneNotSupportedException);
            }
        }

        protected Object clone() throws CloneNotSupportedException {
            return new zh(this);
        }

        @Override
        public void remove() {
            throw new NotSupportedException("Collection was of a fixed size.");
        }
    }

    private static interface za
    extends zv,
    IEnumerator,
    Cloneable {
        public void a(Object var1);
    }

    private static class zc<T>
    implements IGenericList<T> {
        private Array a;

        private zc(Array array) {
            this.a = array;
        }

        @Override
        public int indexOfItem(T item) {
            return this.a.indexOf(item);
        }

        @Override
        public void insertItem(int index, T item) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public void removeAt(int index) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public T get_Item(int index) {
            return (T)this.a.get_Item(index);
        }

        @Override
        public void set_Item(int index, T value) {
            this.a.set_Item(index, value);
        }

        @Override
        public int size() {
            return this.a.getLength();
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        public void addItem(T item) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public void clear() {
            throw new NotSupportedException("Collection is read-only");
        }

        @Override
        public boolean containsItem(T item) {
            return this.a.contains(item);
        }

        @Override
        public void copyToTArray(T[] array, int arrayIndex) {
            this.a.copyTo(Array.boxing(array), arrayIndex);
        }

        @Override
        public boolean removeItem(T item) {
            throw new NotSupportedException("Collection is of a fixed size");
        }

        @Override
        public IGenericEnumerator<T> iterator() {
            return new za(null);
        }

        /* synthetic */ zc(Array array, com.aspose.email.system.zb zb2) {
            this(array);
        }

        private class za<T>
        implements IGenericEnumerator<T> {
            IEnumerator a;

            private za() {
                this.a = zc.this.a.iterator();
            }

            @Override
            public T next() {
                return this.a.next();
            }

            @Override
            public void remove() {
                this.a.remove();
            }

            @Override
            public boolean hasNext() {
                return this.a.hasNext();
            }

            @Override
            public void reset() {
                this.a.reset();
            }

            @Override
            public void dispose() {
            }

            /* synthetic */ za(com.aspose.email.system.zb zb2) {
                this();
            }
        }
    }

    static interface zi {
        public void a(int var1, int var2);
    }

    private static final class ze
    extends zb {
        private ze(Object object, int n, boolean bl) {
            super(object, n, bl);
        }

        @Override
        protected za createEnumerator(int index, int count) {
            return new zf(this, index, count);
        }

        @Override
        protected Object getValueImpl(int index) {
            int[] nArray = this.a(index);
            return this.getValueImpl(nArray);
        }

        private int[] a(int n) {
            zd zd2 = this.getArrayInfo();
            int[] nArray = new int[zd2.a];
            for (int i = zd2.a - 1; i >= 0; --i) {
                int n2 = this.getLength(i);
                nArray[i] = n % n2;
                n /= n2;
            }
            return nArray;
        }

        @Override
        protected Object getValueImpl(int ... indices) {
            if (this.getArrayInfo().a != indices.length) {
                throw new ArgumentException("Indices length does not match the array rank.");
            }
            Object object = this.getInternalObject();
            for (int i = 0; i < indices.length; ++i) {
                com.aspose.email.internal.ak.zc zc2 = i == indices.length - 1 ? this.getArrayHelper() : com.aspose.email.internal.ak.zc.a();
                object = Array.b(zc2, object, indices[i]);
            }
            return object;
        }

        @Override
        protected void setValueImpl(Object value, int index) {
            int[] nArray = this.a(index);
            this.setValueImpl(value, nArray);
        }

        /* synthetic */ ze(Object object, int n, boolean bl, com.aspose.email.system.zb zb2) {
            this(object, n, bl);
        }
    }

    private static final class zg
    extends zb {
        private zg(Object object, boolean bl) {
            super(object, 1, bl);
        }

        @Override
        protected za createEnumerator(int startIndex, int count) {
            return new zh(this, startIndex, count);
        }

        @Override
        protected Object getValueImpl(int index) {
            return this.getValueImpl(new int[]{index});
        }

        @Override
        protected Object getValueImpl(int ... indices) {
            int n = indices[0];
            return Array.b(this.getArrayHelper(), this.getInternalObject(), n);
        }

        @Override
        protected void setValueImpl(Object value, int index) {
            this.setValueImpl(value, new int[]{index});
        }

        @Override
        protected void setValueImpl(Object value, int ... indices) {
            int n = indices[0];
            Class clazz = this.getArrayInfo().b;
            if (value == null && clazz.isPrimitive()) {
                value = com.aspose.email.internal.hu.zb.b(clazz);
            }
            if (value != null && !com.aspose.email.internal.aj.za.a(value.getClass(), clazz) && (clazz.isPrimitive() || com.aspose.email.internal.aj.za.b(clazz) != null)) {
                throw new ArgumentException("Cannot widen from source type to target type either because the source type is a not a primitive type or the conversion cannot be accomplished");
            }
            try {
                Array.b(this.getArrayHelper(), this.getInternalObject(), n, value);
            }
            catch (ArgumentOutOfRangeException argumentOutOfRangeException) {
                throw argumentOutOfRangeException;
            }
            catch (java.lang.Exception exception) {
                throw new InvalidCastException("Cannot save value in this array");
            }
        }

        /* synthetic */ zg(Object object, boolean bl, com.aspose.email.system.zb zb2) {
            this(object, bl);
        }
    }

    private static abstract class zb
    extends Array {
        private final Object a;
        private final zd b;
        private final com.aspose.email.internal.ak.zc c;

        zb(Object object, zd zd2) {
            super(null);
            this.a = object;
            this.b = zd2;
            this.c = com.aspose.email.internal.ak.zc.a(zd2.b);
        }

        zb(Object object, int n, boolean bl) {
            this(object, new zd(object, n, bl, null));
        }

        @Override
        protected Object getInternalObject() {
            return this.a;
        }

        @Override
        protected zd getArrayInfo() {
            return this.b;
        }

        @Override
        protected com.aspose.email.internal.ak.zc getArrayHelper() {
            return this.c;
        }
    }

    private static final class zd {
        private final int a;
        private final Class<?> b;
        private final int[] c;
        private final boolean d;
        private final long e;

        private zd(Object object, int n, boolean bl) {
            int n2 = 0;
            Class<?> clazz = null;
            Class<?> clazz2 = object.getClass().getComponentType();
            while (clazz2 != null) {
                clazz = clazz2;
                clazz2 = clazz.getComponentType();
                if (!bl || ++n2 != n) continue;
            }
            if (n2 == 0) {
                throw new ArgumentException("Array required");
            }
            if (n > n2) {
                throw new ArgumentException("Required arrays dimension doesn't match to actual", "rank");
            }
            this.a = n;
            this.b = clazz;
            this.c = new int[this.a];
            for (int i = 0; i < n; ++i) {
                this.c[i] = -1;
            }
            this.d = bl;
            Object object2 = object;
            int n3 = 0;
            int n4 = 1;
            com.aspose.email.internal.ak.zc zc2 = com.aspose.email.internal.ak.zc.a();
            com.aspose.email.internal.ak.zc zc3 = com.aspose.email.internal.ak.zc.a(this.b);
            while (true) {
                int n5;
                if (object2 == null && !bl) {
                    throw new ArgumentException("Jagged array not expected", "array");
                }
                boolean bl2 = n3 < n - 1;
                int n6 = n5 = bl2 ? zc2.a(object2) : zc3.a(object2);
                if ((n4 *= n5) == 0) break;
                this.c[n3] = n5 - 1;
                if (!bl2) break;
                object2 = Array.b(zc2, object2, 0);
                ++n3;
            }
            this.e = n4;
        }

        /* synthetic */ zd(Object object, int n, boolean bl, com.aspose.email.system.zb zb2) {
            this(object, n, bl);
        }
    }
}

