/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.jcajce.provider.digest;

import com.aspose.cad.internal.bouncycastle.crypto.CipherKeyGenerator;
import com.aspose.cad.internal.bouncycastle.crypto.digests.SkeinDigest;
import com.aspose.cad.internal.bouncycastle.crypto.macs.HMac;
import com.aspose.cad.internal.bouncycastle.crypto.macs.SkeinMac;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.digest.a;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.aspose.cad.internal.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class Skein {
    private Skein() {
    }

    public static class DigestSkein1024
    extends BCMessageDigest
    implements Cloneable {
        public DigestSkein1024(int n2) {
            super(new SkeinDigest(1024, n2));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            BCMessageDigest bCMessageDigest = (BCMessageDigest)super.clone();
            bCMessageDigest.digest = new SkeinDigest((SkeinDigest)this.digest);
            return bCMessageDigest;
        }
    }

    public static class DigestSkein256
    extends BCMessageDigest
    implements Cloneable {
        public DigestSkein256(int n2) {
            super(new SkeinDigest(256, n2));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            BCMessageDigest bCMessageDigest = (BCMessageDigest)super.clone();
            bCMessageDigest.digest = new SkeinDigest((SkeinDigest)this.digest);
            return bCMessageDigest;
        }
    }

    public static class DigestSkein512
    extends BCMessageDigest
    implements Cloneable {
        public DigestSkein512(int n2) {
            super(new SkeinDigest(512, n2));
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            BCMessageDigest bCMessageDigest = (BCMessageDigest)super.clone();
            bCMessageDigest.digest = new SkeinDigest((SkeinDigest)this.digest);
            return bCMessageDigest;
        }
    }

    public static class Digest_1024_1024
    extends DigestSkein1024 {
        public Digest_1024_1024() {
            super(1024);
        }
    }

    public static class Digest_1024_384
    extends DigestSkein1024 {
        public Digest_1024_384() {
            super(384);
        }
    }

    public static class Digest_1024_512
    extends DigestSkein1024 {
        public Digest_1024_512() {
            super(512);
        }
    }

    public static class Digest_256_128
    extends DigestSkein256 {
        public Digest_256_128() {
            super(128);
        }
    }

    public static class Digest_256_160
    extends DigestSkein256 {
        public Digest_256_160() {
            super(160);
        }
    }

    public static class Digest_256_224
    extends DigestSkein256 {
        public Digest_256_224() {
            super(224);
        }
    }

    public static class Digest_256_256
    extends DigestSkein256 {
        public Digest_256_256() {
            super(256);
        }
    }

    public static class Digest_512_128
    extends DigestSkein512 {
        public Digest_512_128() {
            super(128);
        }
    }

    public static class Digest_512_160
    extends DigestSkein512 {
        public Digest_512_160() {
            super(160);
        }
    }

    public static class Digest_512_224
    extends DigestSkein512 {
        public Digest_512_224() {
            super(224);
        }
    }

    public static class Digest_512_256
    extends DigestSkein512 {
        public Digest_512_256() {
            super(256);
        }
    }

    public static class Digest_512_384
    extends DigestSkein512 {
        public Digest_512_384() {
            super(384);
        }
    }

    public static class Digest_512_512
    extends DigestSkein512 {
        public Digest_512_512() {
            super(512);
        }
    }

    public static class HMacKeyGenerator_1024_1024
    extends BaseKeyGenerator {
        public HMacKeyGenerator_1024_1024() {
            super("HMACSkein-1024-1024", 1024, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_1024_384
    extends BaseKeyGenerator {
        public HMacKeyGenerator_1024_384() {
            super("HMACSkein-1024-384", 384, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_1024_512
    extends BaseKeyGenerator {
        public HMacKeyGenerator_1024_512() {
            super("HMACSkein-1024-512", 512, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_256_128
    extends BaseKeyGenerator {
        public HMacKeyGenerator_256_128() {
            super("HMACSkein-256-128", 128, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_256_160
    extends BaseKeyGenerator {
        public HMacKeyGenerator_256_160() {
            super("HMACSkein-256-160", 160, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_256_224
    extends BaseKeyGenerator {
        public HMacKeyGenerator_256_224() {
            super("HMACSkein-256-224", 224, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_256_256
    extends BaseKeyGenerator {
        public HMacKeyGenerator_256_256() {
            super("HMACSkein-256-256", 256, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_512_128
    extends BaseKeyGenerator {
        public HMacKeyGenerator_512_128() {
            super("HMACSkein-512-128", 128, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_512_160
    extends BaseKeyGenerator {
        public HMacKeyGenerator_512_160() {
            super("HMACSkein-512-160", 160, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_512_224
    extends BaseKeyGenerator {
        public HMacKeyGenerator_512_224() {
            super("HMACSkein-512-224", 224, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_512_256
    extends BaseKeyGenerator {
        public HMacKeyGenerator_512_256() {
            super("HMACSkein-512-256", 256, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_512_384
    extends BaseKeyGenerator {
        public HMacKeyGenerator_512_384() {
            super("HMACSkein-512-384", 384, new CipherKeyGenerator());
        }
    }

    public static class HMacKeyGenerator_512_512
    extends BaseKeyGenerator {
        public HMacKeyGenerator_512_512() {
            super("HMACSkein-512-512", 512, new CipherKeyGenerator());
        }
    }

    public static class HashMac_1024_1024
    extends BaseMac {
        public HashMac_1024_1024() {
            super(new HMac(new SkeinDigest(1024, 1024)));
        }
    }

    public static class HashMac_1024_384
    extends BaseMac {
        public HashMac_1024_384() {
            super(new HMac(new SkeinDigest(1024, 384)));
        }
    }

    public static class HashMac_1024_512
    extends BaseMac {
        public HashMac_1024_512() {
            super(new HMac(new SkeinDigest(1024, 512)));
        }
    }

    public static class HashMac_256_128
    extends BaseMac {
        public HashMac_256_128() {
            super(new HMac(new SkeinDigest(256, 128)));
        }
    }

    public static class HashMac_256_160
    extends BaseMac {
        public HashMac_256_160() {
            super(new HMac(new SkeinDigest(256, 160)));
        }
    }

    public static class HashMac_256_224
    extends BaseMac {
        public HashMac_256_224() {
            super(new HMac(new SkeinDigest(256, 224)));
        }
    }

    public static class HashMac_256_256
    extends BaseMac {
        public HashMac_256_256() {
            super(new HMac(new SkeinDigest(256, 256)));
        }
    }

    public static class HashMac_512_128
    extends BaseMac {
        public HashMac_512_128() {
            super(new HMac(new SkeinDigest(512, 128)));
        }
    }

    public static class HashMac_512_160
    extends BaseMac {
        public HashMac_512_160() {
            super(new HMac(new SkeinDigest(512, 160)));
        }
    }

    public static class HashMac_512_224
    extends BaseMac {
        public HashMac_512_224() {
            super(new HMac(new SkeinDigest(512, 224)));
        }
    }

    public static class HashMac_512_256
    extends BaseMac {
        public HashMac_512_256() {
            super(new HMac(new SkeinDigest(512, 256)));
        }
    }

    public static class HashMac_512_384
    extends BaseMac {
        public HashMac_512_384() {
            super(new HMac(new SkeinDigest(512, 384)));
        }
    }

    public static class HashMac_512_512
    extends BaseMac {
        public HashMac_512_512() {
            super(new HMac(new SkeinDigest(512, 512)));
        }
    }

    public static class Mappings
    extends a {
        private static final String a = Skein.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.Skein-256-128", a + "$Digest_256_128");
            configurableProvider.addAlgorithm("MessageDigest.Skein-256-160", a + "$Digest_256_160");
            configurableProvider.addAlgorithm("MessageDigest.Skein-256-224", a + "$Digest_256_224");
            configurableProvider.addAlgorithm("MessageDigest.Skein-256-256", a + "$Digest_256_256");
            configurableProvider.addAlgorithm("MessageDigest.Skein-512-128", a + "$Digest_512_128");
            configurableProvider.addAlgorithm("MessageDigest.Skein-512-160", a + "$Digest_512_160");
            configurableProvider.addAlgorithm("MessageDigest.Skein-512-224", a + "$Digest_512_224");
            configurableProvider.addAlgorithm("MessageDigest.Skein-512-256", a + "$Digest_512_256");
            configurableProvider.addAlgorithm("MessageDigest.Skein-512-384", a + "$Digest_512_384");
            configurableProvider.addAlgorithm("MessageDigest.Skein-512-512", a + "$Digest_512_512");
            configurableProvider.addAlgorithm("MessageDigest.Skein-1024-384", a + "$Digest_1024_384");
            configurableProvider.addAlgorithm("MessageDigest.Skein-1024-512", a + "$Digest_1024_512");
            configurableProvider.addAlgorithm("MessageDigest.Skein-1024-1024", a + "$Digest_1024_1024");
            this.addHMACAlgorithm(configurableProvider, "Skein-256-128", a + "$HashMac_256_128", a + "$HMacKeyGenerator_256_128");
            this.addHMACAlgorithm(configurableProvider, "Skein-256-160", a + "$HashMac_256_160", a + "$HMacKeyGenerator_256_160");
            this.addHMACAlgorithm(configurableProvider, "Skein-256-224", a + "$HashMac_256_224", a + "$HMacKeyGenerator_256_224");
            this.addHMACAlgorithm(configurableProvider, "Skein-256-256", a + "$HashMac_256_256", a + "$HMacKeyGenerator_256_256");
            this.addHMACAlgorithm(configurableProvider, "Skein-512-128", a + "$HashMac_512_128", a + "$HMacKeyGenerator_512_128");
            this.addHMACAlgorithm(configurableProvider, "Skein-512-160", a + "$HashMac_512_160", a + "$HMacKeyGenerator_512_160");
            this.addHMACAlgorithm(configurableProvider, "Skein-512-224", a + "$HashMac_512_224", a + "$HMacKeyGenerator_512_224");
            this.addHMACAlgorithm(configurableProvider, "Skein-512-256", a + "$HashMac_512_256", a + "$HMacKeyGenerator_512_256");
            this.addHMACAlgorithm(configurableProvider, "Skein-512-384", a + "$HashMac_512_384", a + "$HMacKeyGenerator_512_384");
            this.addHMACAlgorithm(configurableProvider, "Skein-512-512", a + "$HashMac_512_512", a + "$HMacKeyGenerator_512_512");
            this.addHMACAlgorithm(configurableProvider, "Skein-1024-384", a + "$HashMac_1024_384", a + "$HMacKeyGenerator_1024_384");
            this.addHMACAlgorithm(configurableProvider, "Skein-1024-512", a + "$HashMac_1024_512", a + "$HMacKeyGenerator_1024_512");
            this.addHMACAlgorithm(configurableProvider, "Skein-1024-1024", a + "$HashMac_1024_1024", a + "$HMacKeyGenerator_1024_1024");
            this.a(configurableProvider, 256, 128);
            this.a(configurableProvider, 256, 160);
            this.a(configurableProvider, 256, 224);
            this.a(configurableProvider, 256, 256);
            this.a(configurableProvider, 512, 128);
            this.a(configurableProvider, 512, 160);
            this.a(configurableProvider, 512, 224);
            this.a(configurableProvider, 512, 256);
            this.a(configurableProvider, 512, 384);
            this.a(configurableProvider, 512, 512);
            this.a(configurableProvider, 1024, 384);
            this.a(configurableProvider, 1024, 512);
            this.a(configurableProvider, 1024, 1024);
        }

        private void a(ConfigurableProvider configurableProvider, int n2, int n3) {
            String string = "Skein-MAC-" + n2 + "-" + n3;
            String string2 = a + "$SkeinMac_" + n2 + "_" + n3;
            String string3 = a + "$SkeinMacKeyGenerator_" + n2 + "_" + n3;
            configurableProvider.addAlgorithm("Mac." + string, string2);
            configurableProvider.addAlgorithm("Alg.Alias.Mac.Skein-MAC" + n2 + "/" + n3, string);
            configurableProvider.addAlgorithm("KeyGenerator." + string, string3);
            configurableProvider.addAlgorithm("Alg.Alias.KeyGenerator.Skein-MAC" + n2 + "/" + n3, string);
        }
    }

    public static class SkeinMacKeyGenerator_1024_1024
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_1024_1024() {
            super("Skein-MAC-1024-1024", 1024, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_1024_384
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_1024_384() {
            super("Skein-MAC-1024-384", 384, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_1024_512
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_1024_512() {
            super("Skein-MAC-1024-512", 512, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_256_128
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_256_128() {
            super("Skein-MAC-256-128", 128, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_256_160
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_256_160() {
            super("Skein-MAC-256-160", 160, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_256_224
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_256_224() {
            super("Skein-MAC-256-224", 224, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_256_256
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_256_256() {
            super("Skein-MAC-256-256", 256, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_512_128
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_512_128() {
            super("Skein-MAC-512-128", 128, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_512_160
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_512_160() {
            super("Skein-MAC-512-160", 160, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_512_224
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_512_224() {
            super("Skein-MAC-512-224", 224, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_512_256
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_512_256() {
            super("Skein-MAC-512-256", 256, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_512_384
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_512_384() {
            super("Skein-MAC-512-384", 384, new CipherKeyGenerator());
        }
    }

    public static class SkeinMacKeyGenerator_512_512
    extends BaseKeyGenerator {
        public SkeinMacKeyGenerator_512_512() {
            super("Skein-MAC-512-512", 512, new CipherKeyGenerator());
        }
    }

    public static class SkeinMac_1024_1024
    extends BaseMac {
        public SkeinMac_1024_1024() {
            super(new SkeinMac(1024, 1024));
        }
    }

    public static class SkeinMac_1024_384
    extends BaseMac {
        public SkeinMac_1024_384() {
            super(new SkeinMac(1024, 384));
        }
    }

    public static class SkeinMac_1024_512
    extends BaseMac {
        public SkeinMac_1024_512() {
            super(new SkeinMac(1024, 512));
        }
    }

    public static class SkeinMac_256_128
    extends BaseMac {
        public SkeinMac_256_128() {
            super(new SkeinMac(256, 128));
        }
    }

    public static class SkeinMac_256_160
    extends BaseMac {
        public SkeinMac_256_160() {
            super(new SkeinMac(256, 160));
        }
    }

    public static class SkeinMac_256_224
    extends BaseMac {
        public SkeinMac_256_224() {
            super(new SkeinMac(256, 224));
        }
    }

    public static class SkeinMac_256_256
    extends BaseMac {
        public SkeinMac_256_256() {
            super(new SkeinMac(256, 256));
        }
    }

    public static class SkeinMac_512_128
    extends BaseMac {
        public SkeinMac_512_128() {
            super(new SkeinMac(512, 128));
        }
    }

    public static class SkeinMac_512_160
    extends BaseMac {
        public SkeinMac_512_160() {
            super(new SkeinMac(512, 160));
        }
    }

    public static class SkeinMac_512_224
    extends BaseMac {
        public SkeinMac_512_224() {
            super(new SkeinMac(512, 224));
        }
    }

    public static class SkeinMac_512_256
    extends BaseMac {
        public SkeinMac_512_256() {
            super(new SkeinMac(512, 256));
        }
    }

    public static class SkeinMac_512_384
    extends BaseMac {
        public SkeinMac_512_384() {
            super(new SkeinMac(512, 384));
        }
    }

    public static class SkeinMac_512_512
    extends BaseMac {
        public SkeinMac_512_512() {
            super(new SkeinMac(512, 512));
        }
    }
}

