/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.macs;

import com.aspose.cad.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.Mac;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.engines.DSTU7624Engine;
import com.aspose.cad.internal.bouncycastle.crypto.params.KeyParameter;
import com.aspose.cad.internal.bouncycastle.util.Arrays;

public class DSTU7624Mac
implements Mac {
    private static final int a = 8;
    private byte[] b;
    private int c;
    private int d;
    private int e;
    private DSTU7624Engine f;
    private byte[] g;
    private byte[] h;
    private byte[] i;

    public DSTU7624Mac(int n2, int n3) {
        this.f = new DSTU7624Engine(n2);
        this.e = n2 / 8;
        this.d = n3 / 8;
        this.g = new byte[this.e];
        this.i = new byte[this.e];
        this.h = new byte[this.e];
        this.b = new byte[this.e];
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("Invalid parameter passed to DSTU7624Mac");
        }
        this.f.init(true, cipherParameters);
        this.f.processBlock(this.i, 0, this.i, 0);
    }

    @Override
    public String getAlgorithmName() {
        return "DSTU7624Mac";
    }

    @Override
    public int getMacSize() {
        return this.d;
    }

    @Override
    public void update(byte by2) {
        if (this.c == this.b.length) {
            this.a(this.b, 0);
            this.c = 0;
        }
        this.b[this.c++] = by2;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("can't have a negative input length!");
        }
        int n4 = this.f.getBlockSize();
        int n5 = n4 - this.c;
        if (n3 > n5) {
            System.arraycopy(byArray, n2, this.b, this.c, n5);
            this.a(this.b, 0);
            this.c = 0;
            n3 -= n5;
            n2 += n5;
            while (n3 > n4) {
                this.a(byArray, n2);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.b, this.c, n3);
        this.c += n3;
    }

    private void a(byte[] byArray, int n2) {
        this.a(this.g, 0, byArray, n2, this.h);
        this.f.processBlock(this.h, 0, this.g, 0);
    }

    @Override
    public int doFinal(byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        if (this.c % this.b.length != 0) {
            throw new DataLengthException("input must be a multiple of blocksize");
        }
        this.a(this.g, 0, this.b, 0, this.h);
        this.a(this.h, 0, this.i, 0, this.g);
        this.f.processBlock(this.g, 0, this.g, 0);
        if (this.d + n2 > byArray.length) {
            throw new OutputLengthException("output buffer too short");
        }
        System.arraycopy(this.g, 0, byArray, n2, this.d);
        return this.d;
    }

    @Override
    public void reset() {
        Arrays.fill(this.g, (byte)0);
        Arrays.fill(this.h, (byte)0);
        Arrays.fill(this.i, (byte)0);
        Arrays.fill(this.b, (byte)0);
        this.f.reset();
        this.f.processBlock(this.i, 0, this.i, 0);
        this.c = 0;
    }

    private void a(byte[] byArray, int n2, byte[] byArray2, int n3, byte[] byArray3) {
        if (byArray.length - n2 < this.e || byArray2.length - n3 < this.e || byArray3.length < this.e) {
            throw new IllegalArgumentException("some of input buffers too short");
        }
        for (int i2 = 0; i2 < this.e; ++i2) {
            byArray3[i2] = (byte)(byArray[i2 + n2] ^ byArray2[i2 + n3]);
        }
    }
}

