/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.internal.bouncycastle.crypto.agreement.kdf;

import com.aspose.cad.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.cad.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.cad.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.cad.internal.bouncycastle.asn1.DERSequence;
import com.aspose.cad.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.cad.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.DerivationFunction;
import com.aspose.cad.internal.bouncycastle.crypto.DerivationParameters;
import com.aspose.cad.internal.bouncycastle.crypto.Digest;
import com.aspose.cad.internal.bouncycastle.crypto.OutputLengthException;
import com.aspose.cad.internal.bouncycastle.crypto.agreement.kdf.DHKDFParameters;
import com.aspose.cad.internal.bouncycastle.util.Pack;
import java.io.IOException;

public class DHKEKGenerator
implements DerivationFunction {
    private final Digest a;
    private ASN1ObjectIdentifier b;
    private int c;
    private byte[] d;
    private byte[] e;

    public DHKEKGenerator(Digest digest) {
        this.a = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        DHKDFParameters dHKDFParameters = (DHKDFParameters)derivationParameters;
        this.b = dHKDFParameters.getAlgorithm();
        this.c = dHKDFParameters.getKeySize();
        this.d = dHKDFParameters.getZ();
        this.e = dHKDFParameters.getExtraInfo();
    }

    public Digest getDigest() {
        return this.a;
    }

    @Override
    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (byArray.length - n3 < n2) {
            throw new OutputLengthException("output buffer too small");
        }
        long l2 = n3;
        int n4 = this.a.getDigestSize();
        if (l2 > 0x1FFFFFFFFL) {
            throw new IllegalArgumentException("Output length too large");
        }
        int n5 = (int)((l2 + (long)n4 - 1L) / (long)n4);
        byte[] byArray2 = new byte[this.a.getDigestSize()];
        int n6 = 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            this.a.update(this.d, 0, this.d.length);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            aSN1EncodableVector2.add(this.b);
            aSN1EncodableVector2.add(new DEROctetString(Pack.intToBigEndian(n6)));
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
            if (this.e != null) {
                aSN1EncodableVector.add(new DERTaggedObject(true, 0, new DEROctetString(this.e)));
            }
            aSN1EncodableVector.add(new DERTaggedObject(true, 2, new DEROctetString(Pack.intToBigEndian(this.c))));
            try {
                byte[] byArray3 = new DERSequence(aSN1EncodableVector).getEncoded("DER");
                this.a.update(byArray3, 0, byArray3.length);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("unable to encode parameter info: " + iOException.getMessage());
            }
            this.a.doFinal(byArray2, 0);
            if (n3 > n4) {
                System.arraycopy(byArray2, 0, byArray, n2, n4);
                n2 += n4;
                n3 -= n4;
            } else {
                System.arraycopy(byArray2, 0, byArray, n2, n3);
            }
            ++n6;
        }
        this.a.reset();
        return (int)l2;
    }
}

