/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class TextPath
extends Command {
    private Type a;

    public final Type getPath() {
        return this.a;
    }

    public final void setPath(Type type) {
        this.a = type;
    }

    public TextPath(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.AttributeElements, 17, cgmFile));
    }

    public TextPath(CgmFile cgmFile, Type type) {
        this(cgmFile);
        this.setPath(type);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readEnum();
        switch (n2) {
            case 0: {
                this.setPath(Type.RIGHT);
                break;
            }
            case 1: {
                this.setPath(Type.LEFT);
                break;
            }
            case 2: {
                this.setPath(Type.UP);
                break;
            }
            case 3: {
                this.setPath(Type.DOWN);
                break;
            }
            default: {
                this.setPath(Type.RIGHT);
            }
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getPath().ordinal());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" TEXTPATH %s;", TextPath.a(this.getPath().toString())));
    }

    @Override
    public String toString() {
        return String.format("TextPath %d", new Object[]{this.getPath()});
    }

    public static enum Type {
        RIGHT,
        LEFT,
        UP,
        DOWN;

    }
}

