/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;

public class TextAlignment
extends Command {
    private HorizontalAlignmentType a;
    private VerticalAlignmentType b;
    private double c;
    private double d;

    public final HorizontalAlignmentType getHorizontalAlignment() {
        return this.a;
    }

    public final void setHorizontalAlignment(HorizontalAlignmentType horizontalAlignmentType) {
        this.a = horizontalAlignmentType;
    }

    public final VerticalAlignmentType getVerticalAlignment() {
        return this.b;
    }

    public final void setVerticalAlignment(VerticalAlignmentType verticalAlignmentType) {
        this.b = verticalAlignmentType;
    }

    public final double getContinuousHorizontalAlignment() {
        return this.c;
    }

    public final void setContinuousHorizontalAlignment(double d2) {
        this.c = d2;
    }

    public final double getContinuousVerticalAlignment() {
        return this.d;
    }

    public final void setContinuousVerticalAlignment(double d2) {
        this.d = d2;
    }

    public TextAlignment(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.AttributeElements, 18, cgmFile));
    }

    public TextAlignment(CgmFile cgmFile, HorizontalAlignmentType horizontalAlignmentType, VerticalAlignmentType verticalAlignmentType, double d2, double d3) {
        this(cgmFile);
        this.setHorizontalAlignment(horizontalAlignmentType);
        this.setVerticalAlignment(verticalAlignmentType);
        this.setContinuousHorizontalAlignment(d2);
        this.setContinuousVerticalAlignment(d3);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readEnum();
        switch (n2) {
            case 0: {
                this.setHorizontalAlignment(HorizontalAlignmentType.NORMHORIZ);
                break;
            }
            case 1: {
                this.setHorizontalAlignment(HorizontalAlignmentType.LEFT);
                break;
            }
            case 2: {
                this.setHorizontalAlignment(HorizontalAlignmentType.CTR);
                break;
            }
            case 3: {
                this.setHorizontalAlignment(HorizontalAlignmentType.RIGHT);
                break;
            }
            case 4: {
                this.setHorizontalAlignment(HorizontalAlignmentType.CONTHORIZ);
                break;
            }
            default: {
                this.setHorizontalAlignment(HorizontalAlignmentType.NORMHORIZ);
                iBinaryReader.unsupported(aX.a(new String[]{"unsupported horizontal alignment ", av.b(n2)}));
            }
        }
        int n3 = iBinaryReader.readEnum();
        switch (n3) {
            case 0: {
                this.setVerticalAlignment(VerticalAlignmentType.NORMVERT);
                break;
            }
            case 1: {
                this.setVerticalAlignment(VerticalAlignmentType.TOP);
                break;
            }
            case 2: {
                this.setVerticalAlignment(VerticalAlignmentType.CAP);
                break;
            }
            case 3: {
                this.setVerticalAlignment(VerticalAlignmentType.HALF);
                break;
            }
            case 4: {
                this.setVerticalAlignment(VerticalAlignmentType.BASE);
                break;
            }
            case 5: {
                this.setVerticalAlignment(VerticalAlignmentType.BOTTOM);
                break;
            }
            case 6: {
                this.setVerticalAlignment(VerticalAlignmentType.CONTVERT);
                break;
            }
            default: {
                this.setVerticalAlignment(VerticalAlignmentType.NORMVERT);
                iBinaryReader.unsupported(aX.a(new String[]{"unsupported vertical alignment ", av.b(n3)}));
            }
        }
        this.setContinuousHorizontalAlignment(iBinaryReader.readReal());
        this.setContinuousVerticalAlignment(iBinaryReader.readReal());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getHorizontalAlignment().ordinal());
        iBinaryWriter.writeEnum(this.getVerticalAlignment().ordinal());
        iBinaryWriter.writeReal(this.getContinuousHorizontalAlignment());
        iBinaryWriter.writeReal(this.getContinuousVerticalAlignment());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format("  textalign %s, %s, %s, %s;", TextAlignment.a(this.getHorizontalAlignment().toString()), TextAlignment.a(this.getVerticalAlignment().toString()), TextAlignment.writeDouble(this.getContinuousHorizontalAlignment()), TextAlignment.writeDouble(this.getContinuousVerticalAlignment())));
    }

    public static enum VerticalAlignmentType {
        NORMVERT,
        TOP,
        CAP,
        HALF,
        BASE,
        BOTTOM,
        CONTVERT;

    }

    public static enum HorizontalAlignmentType {
        NORMHORIZ,
        LEFT,
        CTR,
        RIGHT,
        CONTHORIZ;

    }
}

