/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.aC.A;

public class ScalingMode
extends Command {
    private Mode a;
    private double b;

    public final Mode getValue() {
        return this.a;
    }

    public final void setValue(Mode mode) {
        this.a = mode;
    }

    public final double getMetricScalingFactor() {
        return this.b;
    }

    public final void setMetricScalingFactor(double d2) {
        this.b = d2;
    }

    public ScalingMode(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.PictureDescriptorElements, 1, cgmFile));
    }

    public ScalingMode(CgmFile cgmFile, Mode mode, double d2) {
        this(cgmFile);
        this.setValue(mode);
        this.setMetricScalingFactor(d2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2;
        int n3 = n2 = iBinaryReader.getArgumentsCount() > 0 ? iBinaryReader.readEnum() : 0;
        if (n2 == 0) {
            this.setValue(Mode.ABSTRACT);
        } else if (n2 == 1) {
            this.setValue(Mode.METRIC);
        }
        if (iBinaryReader.getCurrentArg() < iBinaryReader.getArgumentsCount() - 2) {
            this.setMetricScalingFactor(iBinaryReader.readFloatingPoint());
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeEnum(this.getValue().ordinal());
        if (this.getValue() == Mode.METRIC) {
            iBinaryWriter.writeFloatingPoint(this.getMetricScalingFactor());
        }
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        if (this.getValue() == Mode.ABSTRACT) {
            iClearTextWriter.writeLine("  scalemode abstract;");
        } else {
            iClearTextWriter.writeLine(String.format("  scalemode metric, %s;", ScalingMode.writeDouble(this.getMetricScalingFactor())));
        }
    }

    @Override
    public String toString() {
        A a2 = new A();
        a2.a("ScalingMode mode=").a((Object)this.getValue());
        if (this.getValue() == Mode.METRIC) {
            a2.a(" metricScalingFactor=").a(this.getMetricScalingFactor());
        }
        return a2.toString();
    }

    public static enum Mode {
        ABSTRACT,
        METRIC;

    }
}

