/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.Precision;

public abstract class RealPrecisionBase
extends Command {
    private Precision a = Precision.Fixed_32;

    public final Precision getValue() {
        return this.a;
    }

    protected final void setValue(Precision precision) {
        this.a = precision;
    }

    protected RealPrecisionBase(CommandConstructorArguments commandConstructorArguments) {
        super(commandConstructorArguments);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readEnum();
        int n3 = iBinaryReader.readInt();
        int n4 = iBinaryReader.readInt();
        if (n2 == 0) {
            if (n3 == 9 && n4 == 23) {
                this.setValue(Precision.Floating_32);
            } else if (n3 == 12 && n4 == 52) {
                this.setValue(Precision.Floating_64);
            } else {
                iBinaryReader.unsupported("unsupported real precision");
                this.setValue(Precision.Fixed_32);
            }
        } else if (n2 == 1) {
            if (n3 == 16 && n4 == 16) {
                this.setValue(Precision.Fixed_32);
            } else if (n3 == 32 && n4 == 32) {
                this.setValue(Precision.Fixed_64);
            } else {
                iBinaryReader.unsupported("unsupported real precision");
                this.setValue(Precision.Fixed_32);
            }
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        switch (this.getValue()) {
            case Floating_32: {
                iBinaryWriter.writeInt(0);
                iBinaryWriter.writeInt(9);
                iBinaryWriter.writeInt(23);
                break;
            }
            case Floating_64: {
                iBinaryWriter.writeInt(0);
                iBinaryWriter.writeInt(12);
                iBinaryWriter.writeInt(52);
                break;
            }
            case Fixed_32: {
                iBinaryWriter.writeInt(1);
                iBinaryWriter.writeInt(16);
                iBinaryWriter.writeInt(16);
                break;
            }
            case Fixed_64: {
                iBinaryWriter.writeInt(1);
                iBinaryWriter.writeInt(32);
                iBinaryWriter.writeInt(32);
            }
        }
    }
}

