/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.k;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;
import com.aspose.cad.internal.N.g;
import com.aspose.cad.internal.tM.d;

public class Polyline
extends Command
implements Comparable<Polyline> {
    private CgmPoint[] a;

    public Polyline(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 1, cgmFile));
    }

    public Polyline(CgmFile cgmFile, CgmPoint[] cgmPointArray) {
        this(cgmFile);
        this.a(cgmPointArray);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.getArguments().length / iBinaryReader.sizeOfPoint();
        this.a(new CgmPoint[n2]);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getPoints()[i2] = iBinaryReader.readPoint();
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        for (CgmPoint cgmPoint : this.getPoints()) {
            iBinaryWriter.writePoint(cgmPoint);
        }
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  LINE");
        for (CgmPoint cgmPoint : this.getPoints()) {
            iClearTextWriter.write(String.format(" %s", this.writePoint(cgmPoint)));
        }
        iClearTextWriter.writeLine(";");
    }

    @Override
    public String toString() {
        return "Polyline " + aX.a(", ", new d<CgmPoint>(CgmPoint.class, g.a(this.getPoints())).a(new k(this), String.class).i());
    }

    public final boolean isSimpleLine() {
        return this.getPoints().length == 2;
    }

    public final CgmPoint[] getPoints() {
        return this.a;
    }

    private void a(CgmPoint[] cgmPointArray) {
        this.a = cgmPointArray;
    }

    @Override
    public final int compareTo(Polyline polyline) {
        if (this.getPoints().length == polyline.getPoints().length) {
            for (int i2 = 0; i2 < this.getPoints().length; ++i2) {
                int n2 = this.getPoints()[i2].compareTo(polyline.getPoints()[i2]);
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }
        return av.a(this.getPoints().length, polyline.getPoints().length);
    }
}

