/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class LineWidth
extends Command {
    private double a;

    public final double getWidth() {
        return this.a;
    }

    public final void setWidth(double d2) {
        this.a = d2;
    }

    public LineWidth(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.AttributeElements, 3, cgmFile));
    }

    public LineWidth(CgmFile cgmFile, double d2) {
        this(cgmFile);
        this.setWidth(d2);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setWidth(iBinaryReader.readSizeSpecification(this._container.getLineWidthSpecificationMode()));
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeSizeSpecification(this.getWidth(), this._container.getLineWidthSpecificationMode());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format("  linewidth %s;", LineWidth.writeDouble(this.getWidth())));
    }

    @Override
    public String toString() {
        return String.format("LineWidth %s", LineWidth.writeDouble(this.getWidth()));
    }
}

