/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.av;

public class HatchIndex
extends Command {
    private HatchType a = HatchType.HORIZONTAL_LINES;

    public final HatchType getType() {
        return this.a;
    }

    public final void setType(HatchType hatchType) {
        this.a = hatchType;
    }

    public HatchIndex(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.AttributeElements, 24, cgmFile));
    }

    public HatchIndex(CgmFile cgmFile, HatchType hatchType) {
        this(cgmFile);
        this.setType(hatchType);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        int n2 = iBinaryReader.readIndex();
        switch (n2) {
            case 1: {
                this.setType(HatchType.HORIZONTAL_LINES);
                break;
            }
            case 2: {
                this.setType(HatchType.VERTICAL_LINES);
                break;
            }
            case 3: {
                this.setType(HatchType.POSITIVE_SLOPE_LINES);
                break;
            }
            case 4: {
                this.setType(HatchType.NEGATIVE_SLOPE_LINES);
                break;
            }
            case 5: {
                this.setType(HatchType.HORIZONTAL_VERTICAL_CROSSHATCH);
                break;
            }
            case 6: {
                this.setType(HatchType.POSITIVE_NEGATIVE_CROSSHATCH);
                break;
            }
            default: {
                iBinaryReader.unsupported(aX.a(new String[]{"hatch style: ", av.b(n2)}));
            }
        }
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeIndex(this.getType().ordinal());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" HATCHINDEX %s;", this.writeInt(this.getType().ordinal())));
    }

    public static enum HatchType {
        HORIZONTAL_LINES,
        VERTICAL_LINES,
        POSITIVE_SLOPE_LINES,
        NEGATIVE_SLOPE_LINES,
        HORIZONTAL_VERTICAL_CROSSHATCH,
        POSITIVE_NEGATIVE_CROSSHATCH;

    }
}

