/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class Escape
extends Command {
    private int a;
    private String b;

    public final int getIdentifier() {
        return this.a;
    }

    public final void setIdentifier(int n2) {
        this.a = n2;
    }

    public final String getDataRecord() {
        return this.b;
    }

    public final void setDataRecord(String string) {
        this.b = string;
    }

    public Escape(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.EscapeElement, 0, cgmFile));
    }

    public Escape(CgmFile cgmFile, int n2, String string) {
        this(cgmFile);
        this.setIdentifier(n2);
        this.setDataRecord(string);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setIdentifier(iBinaryReader.readInt());
        this.setDataRecord(iBinaryReader.readString());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writeInt(this.getIdentifier());
        iBinaryWriter.writeString(this.getDataRecord());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.writeLine(String.format(" ESCAPE %s %s;", this.writeInt(this.getIdentifier()), this.writeString(this.getDataRecord())));
    }

    @Override
    public String toString() {
        return String.format("Escape identifer=%d", this.getIdentifier());
    }
}

