/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.EllipseElement;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class EllipticalArc
extends EllipseElement {
    private double a;
    private double b;
    private double c;
    private double d;

    public final double getStartVectorDeltaX() {
        return this.a;
    }

    public final void setStartVectorDeltaX(double d2) {
        this.a = d2;
    }

    public final double getStartVectorDeltaY() {
        return this.b;
    }

    public final void setStartVectorDeltaY(double d2) {
        this.b = d2;
    }

    public final double getEndVectorDeltaX() {
        return this.c;
    }

    public final void setEndVectorDeltaX(double d2) {
        this.c = d2;
    }

    public final double getEndVectorDeltaY() {
        return this.d;
    }

    public final void setEndVectorDeltaY(double d2) {
        this.d = d2;
    }

    public EllipticalArc(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 18, cgmFile));
    }

    public EllipticalArc(CommandConstructorArguments commandConstructorArguments) {
        super(commandConstructorArguments);
    }

    public EllipticalArc(CgmFile cgmFile, double d2, double d3, double d4, double d5, CgmPoint cgmPoint, CgmPoint cgmPoint2, CgmPoint cgmPoint3) {
        this(cgmFile);
        this.setValues(d2, d3, d4, d5, cgmPoint, cgmPoint2, cgmPoint3);
    }

    protected final void setValues(double d2, double d3, double d4, double d5, CgmPoint cgmPoint, CgmPoint cgmPoint2, CgmPoint cgmPoint3) {
        this.setValues(cgmPoint, cgmPoint2, cgmPoint3);
        this.setStartVectorDeltaX(d2);
        this.setStartVectorDeltaY(d3);
        this.setEndVectorDeltaX(d4);
        this.setEndVectorDeltaY(d5);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        super.readFromBinary(iBinaryReader);
        this.setStartVectorDeltaX(iBinaryReader.readVdc());
        this.setStartVectorDeltaY(iBinaryReader.readVdc());
        this.setEndVectorDeltaX(iBinaryReader.readVdc());
        this.setEndVectorDeltaY(iBinaryReader.readVdc());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        super.writeAsBinary(iBinaryWriter);
        iBinaryWriter.writeVdc(this.getStartVectorDeltaX());
        iBinaryWriter.writeVdc(this.getStartVectorDeltaY());
        iBinaryWriter.writeVdc(this.getEndVectorDeltaX());
        iBinaryWriter.writeVdc(this.getEndVectorDeltaY());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  ELLIPARC");
        this.writeValues(iClearTextWriter);
        iClearTextWriter.writeLine(";");
    }

    @Override
    protected void writeValues(IClearTextWriter iClearTextWriter) {
        super.writeValues(iClearTextWriter);
        iClearTextWriter.write(String.format(" %s", this.writePoint(this.getStartVectorDeltaX(), this.getStartVectorDeltaY())));
        iClearTextWriter.write(String.format(" %s", this.writePoint(this.getEndVectorDeltaX(), this.getEndVectorDeltaY())));
    }
}

