/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmColor;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.classes.StructuredDataRecord;
import com.aspose.cad.fileformats.cgm.classes.VC;
import com.aspose.cad.fileformats.cgm.classes.ViewportPoint;
import com.aspose.cad.fileformats.cgm.commands.ColourSelectionMode;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.commands.VdcType;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;
import com.aspose.cad.internal.Exceptions.InvalidOperationException;
import com.aspose.cad.internal.Exceptions.NotImplementedException;
import com.aspose.cad.internal.Exceptions.NotSupportedException;
import com.aspose.cad.internal.N.I;
import com.aspose.cad.internal.N.aE;
import com.aspose.cad.internal.N.aX;
import com.aspose.cad.internal.N.aa;
import com.aspose.cad.internal.N.aq;
import com.aspose.cad.internal.N.as;
import com.aspose.cad.internal.N.t;
import com.aspose.cad.internal.N.y;
import com.aspose.cad.internal.V.g;
import com.aspose.cad.internal.aC.A;
import com.aspose.cad.internal.ab.i;
import com.aspose.cad.internal.eT.d;
import com.aspose.cad.system.Enum;
import com.aspose.cad.system.collections.Generic.IGenericEnumerator;
import java.awt.Color;

public abstract class Command {
    protected ClassCode _elementClass;
    protected int _elementId;
    protected CgmFile _container;
    private static final String a = Command.writeDouble(0.0);

    public final ClassCode getElementClass() {
        return this._elementClass;
    }

    public final int getElementId() {
        return this._elementId;
    }

    protected Command(CommandConstructorArguments commandConstructorArguments) {
        this._elementClass = commandConstructorArguments.getElementClass();
        this._elementId = commandConstructorArguments.getElementId();
        this._container = commandConstructorArguments.getContainer();
    }

    public abstract void readFromBinary(IBinaryReader var1);

    public abstract void writeAsClearText(IClearTextWriter var1);

    public abstract void writeAsBinary(IBinaryWriter var1);

    public String toString() {
        return aE.a(this).u();
    }

    protected static String writeDouble(double d2) {
        return Command.a(d2);
    }

    public static String a(double d2) {
        return aa.a(d2, "f4", (as)i.d());
    }

    protected final String writeReal(double d2) {
        return Command.writeDouble(d2);
    }

    protected final String writeVDC(double d2) {
        if (this._container.getVDCType() == VdcType.Type.Real) {
            return Command.writeDouble(d2);
        }
        return this.writeInt(I.g(d2));
    }

    protected final String writeVC(VC vC) {
        switch (this._container.getDeviceViewportSpecificationMode()) {
            case MM: 
            case PHYDEVCOORD: {
                return this.writeInt(vC.getValueInt());
            }
        }
        return this.writeReal(vC.getValueReal());
    }

    protected final String writeViewportPoint(ViewportPoint viewportPoint) {
        return aX.a(new String[]{this.writeVC(viewportPoint.getFirstPoint()), " ", this.writeVC(viewportPoint.getSecondPoint())});
    }

    protected final String writePoint(CgmPoint cgmPoint) {
        return this.writePoint(cgmPoint.getX(), cgmPoint.getY());
    }

    protected final String writePoint(double d2, double d3) {
        String string = "";
        if (aX.e(Command.writeDouble(d3), a) && d2 < 0.0) {
            string = "-";
        }
        return String.format("(%s,%s%s)", Command.writeDouble(d2), string, Command.writeDouble(d3));
    }

    protected final String writeBool(boolean bl2) {
        return bl2 ? "on" : "off";
    }

    protected final String writeBoolYesNo(boolean bl2) {
        return bl2 ? "yes" : "no";
    }

    protected final String writeString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : string.toCharArray()) {
            if (y.d(c2) && c2 != '\r' && c2 != '\n' && c2 != '\t') continue;
            stringBuilder.append(c2);
        }
        string = stringBuilder.toString();
        return string;
    }

    protected final String writeEnum(Class<?> clazz, int n2) {
        return Command.a(clazz, n2);
    }

    public static String a(Class<?> clazz, int n2) {
        return Enum.toString(clazz, n2).toLowerCase();
    }

    public static String a(String string) {
        return string.toLowerCase();
    }

    protected final String writeName(int n2) {
        return String.format("%d", n2);
    }

    protected final String writeIndex(int n2) {
        return String.format("%d", n2);
    }

    protected final String writeInt(int n2) {
        return String.format("%d", n2);
    }

    protected final String writeColor(Color color, int n2) {
        return this.a(g.a(color), n2);
    }

    protected final String a(g g2, int n2) {
        switch (n2) {
            case 1: {
                return String.format("%d %d %d", g2.n(), g2.o(), g2.p());
            }
        }
        throw new NotImplementedException(String.format("Writing color for %d is not implemented", n2));
    }

    protected final String writeColor(CgmColor cgmColor) {
        if (this._container.getColourSelectionMode() == ColourSelectionMode.Type.INDEXED) {
            return this.writeIndex(cgmColor.getColorIndex());
        }
        return this.a(cgmColor.a().cb(), this._container.getColourModel());
    }

    protected final String writeObject(Object object, int n2) {
        switch (n2) {
            case 4: {
                return this.writeName(I.g(object));
            }
            case 5: {
                return this.writeInt(I.g(object));
            }
            case 6: {
                return this.writeInt(I.g(object));
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.writeIndex(I.g(object));
            }
            case 12: {
                return this.writeReal(I.l(object));
            }
            case 13: 
            case 14: {
                return this.writeString(object.toString());
            }
            case 15: {
                return this.writeVC((VC)object);
            }
            case 16: {
                return this.writeVDC(I.l(object));
            }
            case 18: 
            case 19: 
            case 22: {
                return this.writeInt(I.g(object));
            }
            case 20: {
                return this.writeBitStream(d.c(object, byte[].class));
            }
            case 1: 
            case 2: {
                return this.writeIndex(I.g(object));
            }
            case 3: {
                return this.a(d.d(object, g.class).cb(), this._container.getColourModel());
            }
        }
        throw new NotSupportedException(String.format("Can't write value (%s) of type %d!", object.toString(), n2));
    }

    protected final String writeBitStream(byte[] byArray) {
        A a2 = new A();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2;
            int n3 = n2 = i2 + 4 > byArray.length ? byArray.length - i2 : 4;
            if (a2.c() > 0) {
                a2.a(" ");
            }
            a2.a(aX.a(t.a(byArray, i2, n2), "-", ""));
            i2 += 3;
        }
        return a2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void writeSDR(IClearTextWriter iClearTextWriter, StructuredDataRecord structuredDataRecord) {
        IGenericEnumerator iGenericEnumerator = structuredDataRecord.a().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                StructuredDataRecord.Member member = (StructuredDataRecord.Member)iGenericEnumerator.next();
                iClearTextWriter.write(String.format(" %s %s", this.writeInt(member.getType()), this.writeInt(member.getCount())));
                IGenericEnumerator iGenericEnumerator2 = member.a().iterator();
                try {
                    while (iGenericEnumerator2.hasNext()) {
                        Object e2 = iGenericEnumerator2.next();
                        iClearTextWriter.write(String.format(" %s", this.writeObject(e2, member.getType())));
                    }
                }
                finally {
                    if (d.a(iGenericEnumerator2, aq.class) == false) continue;
                    ((aq)iGenericEnumerator2).dispose();
                }
            }
            return;
        }
        finally {
            if (d.a(iGenericEnumerator, aq.class) != false) {
                ((aq)iGenericEnumerator).dispose();
            }
        }
    }

    public static void assert_(boolean bl2, String string) {
        if (!bl2) {
            throw new InvalidOperationException(string);
        }
    }
}

