/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.cad.fileformats.cgm.commands;

import com.aspose.cad.fileformats.cgm.CgmFile;
import com.aspose.cad.fileformats.cgm.IBinaryReader;
import com.aspose.cad.fileformats.cgm.IBinaryWriter;
import com.aspose.cad.fileformats.cgm.IClearTextWriter;
import com.aspose.cad.fileformats.cgm.classes.CgmPoint;
import com.aspose.cad.fileformats.cgm.commands.Command;
import com.aspose.cad.fileformats.cgm.commands.CommandConstructorArguments;
import com.aspose.cad.fileformats.cgm.enums.ClassCode;

public class CircularArcCentre
extends Command {
    private CgmPoint a;
    private double b;
    private double c;
    private double d;
    private double e;
    private double f;

    public final CgmPoint getCenter() {
        return this.a;
    }

    protected final void setCenter(CgmPoint cgmPoint) {
        this.a = cgmPoint;
    }

    public final double getStartDeltaX() {
        return this.b;
    }

    protected final void setStartDeltaX(double d2) {
        this.b = d2;
    }

    public final double getStartDeltaY() {
        return this.c;
    }

    protected final void setStartDeltaY(double d2) {
        this.c = d2;
    }

    public final double getEndDeltaX() {
        return this.d;
    }

    protected final void setEndDeltaX(double d2) {
        this.d = d2;
    }

    public final double getEndDeltaY() {
        return this.e;
    }

    protected final void setEndDeltaY(double d2) {
        this.e = d2;
    }

    public final double getRadius() {
        return this.f;
    }

    protected final void setRadius(double d2) {
        this.f = d2;
    }

    public CircularArcCentre(CgmFile cgmFile) {
        super(new CommandConstructorArguments(ClassCode.GraphicalPrimitiveElements, 15, cgmFile));
    }

    public CircularArcCentre(CgmFile cgmFile, CgmPoint cgmPoint, double d2, double d3, double d4, double d5, double d6) {
        this(cgmFile);
        this.setValues(cgmPoint, d2, d3, d4, d5, d6);
    }

    public CircularArcCentre(CommandConstructorArguments commandConstructorArguments) {
        super(commandConstructorArguments);
    }

    protected final void setValues(CgmPoint cgmPoint, double d2, double d3, double d4, double d5, double d6) {
        this.setCenter(cgmPoint);
        this.setStartDeltaX(d2);
        this.setStartDeltaY(d3);
        this.setEndDeltaX(d4);
        this.setEndDeltaY(d5);
        this.setRadius(d6);
    }

    @Override
    public void readFromBinary(IBinaryReader iBinaryReader) {
        this.setCenter(iBinaryReader.readPoint());
        this.setStartDeltaX(iBinaryReader.readVdc());
        this.setStartDeltaY(iBinaryReader.readVdc());
        this.setEndDeltaX(iBinaryReader.readVdc());
        this.setEndDeltaY(iBinaryReader.readVdc());
        this.setRadius(iBinaryReader.readVdc());
    }

    @Override
    public void writeAsBinary(IBinaryWriter iBinaryWriter) {
        iBinaryWriter.writePoint(this.getCenter());
        iBinaryWriter.writeVdc(this.getStartDeltaX());
        iBinaryWriter.writeVdc(this.getStartDeltaY());
        iBinaryWriter.writeVdc(this.getEndDeltaX());
        iBinaryWriter.writeVdc(this.getEndDeltaY());
        iBinaryWriter.writeVdc(this.getRadius());
    }

    @Override
    public void writeAsClearText(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write("  ARCCTR");
        this.writeValues(iClearTextWriter);
        iClearTextWriter.writeLine(" ;");
    }

    protected void writeValues(IClearTextWriter iClearTextWriter) {
        iClearTextWriter.write(String.format(" %s", this.writePoint(this.getCenter())));
        iClearTextWriter.write(String.format(" %s %s", this.writePoint(this.getStartDeltaX(), this.getStartDeltaY()), this.writePoint(this.getEndDeltaX(), this.getEndDeltaY())));
        iClearTextWriter.write(String.format(" %s", this.writeVDC(this.getRadius())));
    }
}

